package drr.regulation.cftc.rewrite.labels;

import com.regnosys.rosetta.lib.labelprovider.GraphBasedLabelProvider;
import com.regnosys.rosetta.lib.labelprovider.LabelNode;
import java.util.Arrays;


public class CFTCPart45LabelProvider extends GraphBasedLabelProvider {
	public CFTCPart45LabelProvider() {
		super(new LabelNode());
		
		startNode.addLabel(Arrays.asList("actionType"), "26 Action type");
		startNode.addLabel(Arrays.asList("eventType"), "27 Event type");
		startNode.addLabel(Arrays.asList("eventIdentifier"), "29 Event identifier");
		startNode.addLabel(Arrays.asList("effectiveDate"), "94 Effective Date");
		startNode.addLabel(Arrays.asList("eventTimestamp"), "30 Event timestamp");
		startNode.addLabel(Arrays.asList("reportingTimestamp"), "97 Reporting timestamp");
		startNode.addLabel(Arrays.asList("executionTimestamp"), "96 Execution Timestamp");
		startNode.addLabel(Arrays.asList("expirationDate"), "95 Expiration date");
		startNode.addLabel(Arrays.asList("counterparty1"), "13 Counterparty 1");
		startNode.addLabel(Arrays.asList("counterparty2"), "14 Counterparty 2");
		startNode.addLabel(Arrays.asList("cleared"), "01 Cleared");
		startNode.addLabel(Arrays.asList("centralCounterparty"), "02 Central counterparty");
		startNode.addLabel(Arrays.asList("clearingMember"), "04 Clearing member");
		startNode.addLabel(Arrays.asList("callAmount"), "36 Call amount");
		startNode.addLabel(Arrays.asList("putAmount"), "38 Put Amount");
		startNode.addLabel(Arrays.asList("callCurrency"), "37 Call currency");
		startNode.addLabel(Arrays.asList("putCurrency"), "39 Put currency");
		startNode.addLabel(Arrays.asList("price"), "69 Price");
		startNode.addLabel(Arrays.asList("priceNotation"), "71 Price notation");
		startNode.addLabel(Arrays.asList("priceCurrency"), "70 Price currency");
		startNode.addLabel(Arrays.asList("packageTransactionPrice"), "47 Package Transaction Price");
		startNode.addLabel(Arrays.asList("packageTransactionPriceNotation"), "49 Package Transaction Price Notation");
		startNode.addLabel(Arrays.asList("packageTransactionPriceCurrency"), "48 Package Transaction Price Currency");
		startNode.addLabel(Arrays.asList("packageTransactionSpread"), "50 Package Transaction Spread");
		startNode.addLabel(Arrays.asList("packageTransactionSpreadNotation"), "52 Package Transaction Spread Notation");
		startNode.addLabel(Arrays.asList("packageTransactionSpreadCurrency"), "51 Package Transaction Spread Currency");
		startNode.addLabel(Arrays.asList("strikePrice"), "76 Strike Price");
		startNode.addLabel(Arrays.asList("strikePriceNotation"), "78 Strike Price notation");
		startNode.addLabel(Arrays.asList("strikePriceCurrency"), "77 Strike Price Currency");
		startNode.addLabel(Arrays.asList("priceUnitOfMeasure"), "72 Price unit of measure");
		startNode.addLabel(Arrays.asList("optionPremiumAmount"), "79 Option Premium Amount");
		startNode.addLabel(Arrays.asList("optionPremiumCurrency"), "80 Option Premium Currency");
		startNode.addLabel(Arrays.asList("optionPremiumPaymentDate"), "81 Option Premium Payment Date");
		startNode.addLabel(Arrays.asList("cdSIndexAttachmentPoint"), "83 CDS Index Attachment Point");
		startNode.addLabel(Arrays.asList("cdSIndexDetachmentPoint"), "84 CDS Index Detachment Point");
		startNode.addLabel(Arrays.asList("firstExerciseDate"), "82 First exercise date");
		startNode.addLabel(Arrays.asList("finalContractualSettlementDate"), "88 Final Contractual Settlement Date");
		startNode.addLabel(Arrays.asList("otherPayment", "paymentType"), "57/62-$ 57 Other payment type");
		startNode.addLabel(Arrays.asList("otherPayment", "amount"), "57/62-$ 58 Other payment amount");
		startNode.addLabel(Arrays.asList("otherPayment", "currency"), "57/62-$ 59 Other payment currency");
		startNode.addLabel(Arrays.asList("otherPayment", "date"), "57/62-$ 60 Other payment date");
		startNode.addLabel(Arrays.asList("otherPayment", "payer"), "57/62-$ 61 Other payment payer");
		startNode.addLabel(Arrays.asList("otherPayment", "payerFormat"), "57/62-$ 61 Other payment payer format (non-reportable)");
		startNode.addLabel(Arrays.asList("otherPayment", "receiver"), "57/62-$ 62 Other payment receiver");
		startNode.addLabel(Arrays.asList("otherPayment", "receiverFormat"), "57/62-$ 62 Other payment receiver format (non-reportable)");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmount"), "31 Notional amount-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalCurrency"), "32 Notional currency-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmountSchedule", "value"), "33/35-$ 33 Notional amount leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmountSchedule", "effectiveDate"), "33/35-$ 34 Effective date leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalAmountSchedule", "endDate"), "33/35-$ 35 End date leg 1");
		startNode.addLabel(Arrays.asList("leg1", "notionalQuantity"), "40 Notional quantity-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "quantityFrequency"), "41 Quantity frequency-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "quantityFrequencyMultiplier"), "42 Quantity frequency multiplier-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "totalNotionalQuantity"), "44 Total notional quantity-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "fixedRateDayCountConvention"), "53 Fixed rate day count convention-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateDayCountConvention"), "53 Floating rate day count convention-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateResetFrequencyPeriod"), "55 Floating rate reset frequency period-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRateResetFrequencyMultiplier"), "56 Floating rate reset frequency period multiplier-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "fixedRatePaymentFrequencyPeriod"), "63 Fixed rate payment frequency period-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRatePaymentFrequencyPeriod"), "63 Floating rate payment frequency period-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "fixedRatePaymentFrequencyPeriodMultiplier"), "64 Fixed rate payment frequency period multiplier-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "periodicPayment", "floatingRatePaymentFrequencyPeriodMultiplier"), "64 Floating rate payment frequency period multiplier-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "fixedRate"), "67 Fixed rate-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "spread"), "73 Spread-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "spreadCurrency"), "74 Spread currency-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "spreadNotation"), "75 Spread notation-Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "settlementCurrency"), "89 Settlement Currency Leg 1");
		startNode.addLabel(Arrays.asList("leg1", "fixingDate"), "54 Fixing date-Leg 1");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmount"), "31 Notional amount-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalCurrency"), "32 Notional currency-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmountSchedule", "value"), "33/35-$ 33 Notional amount leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmountSchedule", "effectiveDate"), "33/35-$ 34 Effective date leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalAmountSchedule", "endDate"), "33/35-$ 35 End date leg 2");
		startNode.addLabel(Arrays.asList("leg2", "notionalQuantity"), "40 Notional quantity-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "quantityFrequency"), "41 Quantity frequency-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "quantityFrequencyMultiplier"), "42 Quantity frequency multiplier-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "totalNotionalQuantity"), "44 Total notional quantity-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "fixedRateDayCountConvention"), "53 Fixed rate day count convention-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateDayCountConvention"), "53 Floating rate day count convention-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateResetFrequencyPeriod"), "55 Floating rate reset frequency period-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRateResetFrequencyMultiplier"), "56 Floating rate reset frequency period multiplier-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "fixedRatePaymentFrequencyPeriod"), "63 Fixed rate payment frequency period-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRatePaymentFrequencyPeriod"), "63 Floating rate payment frequency period-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "fixedRatePaymentFrequencyPeriodMultiplier"), "64 Fixed rate payment frequency period multiplier-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "periodicPayment", "floatingRatePaymentFrequencyPeriodMultiplier"), "64 Floating rate payment frequency period multiplier-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "fixedRate"), "67 Fixed rate-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "spread"), "73 Spread-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "spreadCurrency"), "74 Spread currency-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "spreadNotation"), "75 Spread notation-Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "settlementCurrency"), "89 Settlement Currency Leg 2");
		startNode.addLabel(Arrays.asList("leg2", "fixingDate"), "54 Fixing date-Leg 2");
		startNode.addLabel(Arrays.asList("reportSubmittingEntityID"), "22 Submitter identifier");
		startNode.addLabel(Arrays.asList("uniqueTransactionIdentifier"), "103 Unique Transaction Identifier (UTI)");
		startNode.addLabel(Arrays.asList("priorUTI"), "101 Prior UTI");
		startNode.addLabel(Arrays.asList("uniqueProductIdentifier"), "87 Unique product identifier");
		startNode.addLabel(Arrays.asList("platformIdentifier"), "98 Platform Identifier");
		startNode.addLabel(Arrays.asList("packageIdentifier"), "46 Package Identifier");
		startNode.addLabel(Arrays.asList("exchangeRate"), "65 Exchange rate-Leg 1");
		startNode.addLabel(Arrays.asList("exchangeRateBasis"), "66 Exchange rate basis");
		startNode.addLabel(Arrays.asList("quantityUnitOfMeasureLeg1"), "43 Quantity unit of measure-Leg 1");
		startNode.addLabel(Arrays.asList("quantityUnitOfMeasureLeg2"), "43 Quantity unit of measure-Leg 2");
		startNode.addLabel(Arrays.asList("embeddedOptionType"), "86 Embedded Option Type");
		startNode.addLabel(Arrays.asList("counterparty2IdentifierSource"), "15 Counterparty 2 identifier source");
		startNode.addLabel(Arrays.asList("customBasketIndicator"), "25 Custom basket indicator");
		startNode.addLabel(Arrays.asList("amendmentIndicator"), "28 Amendment indicator");
		startNode.addLabel(Arrays.asList("packageIndicator"), "45 Package Indicator");
		startNode.addLabel(Arrays.asList("postPricedSwapIndicator"), "68 Post-priced swap indicator");
		startNode.addLabel(Arrays.asList("settlementLocationLeg1"), "90 Settlement Location- Leg 1");
		startNode.addLabel(Arrays.asList("settlementLocationLeg2"), "90 Settlement Location- Leg 2");
		startNode.addLabel(Arrays.asList("nonStandardizedTermIndicator"), "92 Non-standardized Term Indicator");
		startNode.addLabel(Arrays.asList("blockTradeElectionIndicator"), "93 Block Trade Election Indicator");
		startNode.addLabel(Arrays.asList("primeBrokerageTransactionIndicator"), "99 Prime brokerage transaction indicator");
		startNode.addLabel(Arrays.asList("uniqueSwapIdentifier"), "102 Unique Swap Identifier (USI)");
		startNode.addLabel(Arrays.asList("cftcGuidebook", "messageType"), "TR Message Type");
		startNode.addLabel(Arrays.asList("cftcGuidebook", "optionType"), "TR Option type");
		startNode.addLabel(Arrays.asList("cftcGuidebook", "optionStyle"), "TR Option Style");
		startNode.addLabel(Arrays.asList("cftcGuidebook", "assetClass"), "TR Asset Class");
		startNode.addLabel(Arrays.asList("cftcGuidebook", "mandatoryClearingIndicator"), "TR Mandatory Clearing Indicator");
		startNode.addLabel(Arrays.asList("cftcGuidebook", "maturityDateOfTheUnderlier"), "TR Maturity Date of the Underlier");
		startNode.addLabel(Arrays.asList("cftcGuidebook", "largeNotionalOffFacilitySwapElectionIndicator"), "TR Large notional off-facility swap election indicator");
		startNode.addLabel(Arrays.asList("cftcGuidebook", "sefOrDcmIndicator"), "TR SEF or DCM indicator");
		startNode.addLabel(Arrays.asList("cftcGuidebook", "sefOrDcmAnonymousExecutionIndicator"), "TR SEF or DCM Anonymous Execution Indicator");
		startNode.addLabel(Arrays.asList("cftcGuidebook", "settlementType"), "TR Settlement Type");
		startNode.addLabel(Arrays.asList("cftcGuidebook", "sdMspIndicatorParty1"), "TR SD MSP Indicator - Counterparty 1");
		startNode.addLabel(Arrays.asList("cftcGuidebook", "sdMspIndicatorParty2"), "TR SD MSP Indicator - Counterparty 2");
		startNode.addLabel(Arrays.asList("cftcGuidebook", "physicalCommodityIndicator"), "TR Physical commodity contract indicator");
		startNode.addLabel(Arrays.asList("clearingAccountOrigin"), "03 Clearing account origin");
		startNode.addLabel(Arrays.asList("clearingSwapUSIs"), "05-$ Clearing swap USIs");
		startNode.addLabel(Arrays.asList("clearingSwapUTIs"), "06-$ Clearing swap UTIs");
		startNode.addLabel(Arrays.asList("originalSwapUSI"), "07 Original swap USI");
		startNode.addLabel(Arrays.asList("originalSwapUTI"), "08 Original swap UTI");
		startNode.addLabel(Arrays.asList("originalSwapSDRIdentifier"), "09 Original swap SDR identifier");
		startNode.addLabel(Arrays.asList("clearingReceiptTimestamp"), "10 Clearing receipt timestamp");
		startNode.addLabel(Arrays.asList("clearingExceptionsAndExemptionsCounterparty1"), "11-$ Clearing exceptions and exemptions - Counterparty 1");
		startNode.addLabel(Arrays.asList("clearingExceptionsAndExemptionsCounterparty2"), "12-$ Clearing exceptions and exemptions - Counterparty 2");
		startNode.addLabel(Arrays.asList("counterparty1FinancialEntityIndicator"), "16 Counterparty 1 financial entity indicator");
		startNode.addLabel(Arrays.asList("counterparty2FinancialEntityIndicator"), "17 Counterparty 2 financial entity indicator");
		startNode.addLabel(Arrays.asList("buyerIdentifier"), "18 Buyer identifier");
		startNode.addLabel(Arrays.asList("sellerIdentifier"), "19 Seller identifier");
		startNode.addLabel(Arrays.asList("payerIdentifierLeg1"), "20 Payer identifier - Leg 1");
		startNode.addLabel(Arrays.asList("payerIdentifierLeg2"), "20 Payer identifier - Leg 2");
		startNode.addLabel(Arrays.asList("receiverIdentifierLeg1"), "21 Receiver identifier - Leg 1");
		startNode.addLabel(Arrays.asList("receiverIdentifierLeg2"), "21 Receiver identifier - Leg 2");
		startNode.addLabel(Arrays.asList("counterparty1FederalEntityIndicator"), "23 Counterparty 1 federal entity indicator");
		startNode.addLabel(Arrays.asList("counterparty2FederalEntityIndicator"), "24 Counterparty 2 federal entity indicator");
		startNode.addLabel(Arrays.asList("allocationIndicator"), "91 Allocation Indicator");
		startNode.addLabel(Arrays.asList("priorUSI"), "100 Prior USI");
		startNode.addLabel(Arrays.asList("jurisdiction"), "104 Jurisdiction");
		startNode.addLabel(Arrays.asList("newSDRIdentifier"), "105 New SDR Identifier");
		startNode.addLabel(Arrays.asList("initialMarginCollateralPortfolioCode"), "116 Initial Margin Collateral Portfolio Code");
		startNode.addLabel(Arrays.asList("variationMarginCollateralPortfolioCode"), "124 Variation Margin Collateral Portfolio Code");
		
		LabelNode cFTCNonReportablePart45Node = new LabelNode();
		cFTCNonReportablePart45Node.addLabel(Arrays.asList("counterparty1Format"), "Counterparty1 Format (non-reportable)");
		cFTCNonReportablePart45Node.addLabel(Arrays.asList("counterparty2Format"), "Counterparty2 Format (non-reportable)");
		cFTCNonReportablePart45Node.addLabel(Arrays.asList("buyerIdentifierFormat"), "BuyerIdentifier Format (non-reportable)");
		cFTCNonReportablePart45Node.addLabel(Arrays.asList("sellerIdentifierFormat"), "SellerIdentifier Format (non-reportable)");
		cFTCNonReportablePart45Node.addLabel(Arrays.asList("payerIdentifierLeg1Format"), "PayerLeg1Identifier Format (non-reportable)");
		cFTCNonReportablePart45Node.addLabel(Arrays.asList("payerIdentifierLeg2Format"), "PayerLeg2Identifier Format (non-reportable)");
		cFTCNonReportablePart45Node.addLabel(Arrays.asList("receiverIdentifierLeg1Format"), "ReceiverLeg1Identifier Format (non-reportable)");
		cFTCNonReportablePart45Node.addLabel(Arrays.asList("receiverIdentifierLeg2Format"), "ReceiverLeg2Identifier Format (non-reportable)");
		
		startNode.addOutgoingEdge("nonReportable", cFTCNonReportablePart45Node);
	}
}
