package drr.regulation.cftc.rewrite.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.cftc.rewrite.CFTCGuidebook;
import drr.regulation.cftc.rewrite.validation.CFTCGuidebookTypeFormatValidator;
import drr.regulation.cftc.rewrite.validation.CFTCGuidebookValidator;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCGuidebookLargeNotionalOffFacilitySwapElectionIndicator;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCGuidebookPhysicalCommodityIndicator;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCGuidebookSefOrDcmAnonymousIndicator;
import drr.regulation.cftc.rewrite.validation.exists.CFTCGuidebookOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 6.0.0-dev.128
 */
@RosettaMeta(model=CFTCGuidebook.class)
public class CFTCGuidebookMeta implements RosettaMetaData<CFTCGuidebook> {

	@Override
	public List<Validator<? super CFTCGuidebook>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<CFTCGuidebook>create(CFTCGuidebookLargeNotionalOffFacilitySwapElectionIndicator.class),
			factory.<CFTCGuidebook>create(CFTCGuidebookSefOrDcmAnonymousIndicator.class),
			factory.<CFTCGuidebook>create(CFTCGuidebookPhysicalCommodityIndicator.class)
		);
	}
	
	@Override
	public List<Function<? super CFTCGuidebook, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super CFTCGuidebook> validator(ValidatorFactory factory) {
		return factory.<CFTCGuidebook>create(CFTCGuidebookValidator.class);
	}

	@Override
	public Validator<? super CFTCGuidebook> typeFormatValidator(ValidatorFactory factory) {
		return factory.<CFTCGuidebook>create(CFTCGuidebookTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super CFTCGuidebook> validator() {
		return new CFTCGuidebookValidator();
	}

	@Deprecated
	@Override
	public Validator<? super CFTCGuidebook> typeFormatValidator() {
		return new CFTCGuidebookTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super CFTCGuidebook, Set<String>> onlyExistsValidator() {
		return new CFTCGuidebookOnlyExistsValidator();
	}
}
