package drr.regulation.cftc.rewrite.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.cftc.rewrite.CFTCPart43TransactionReport;
import drr.regulation.cftc.rewrite.CFTCPart43TransactionReport.CFTCPart43TransactionReportBuilder;
import drr.regulation.cftc.rewrite.labels.CFTCPart43LabelProvider;
import drr.regulation.cftc.tr.reports.AssetClassRule;
import drr.regulation.cftc.tr.reports.LargeNotionalOffFacilitySwapElectionIndicatorRule;
import drr.regulation.cftc.tr.reports.MandatoryClearingIndicatorRule;
import drr.regulation.cftc.tr.reports.MaturityDateOfTheUnderlierRule;
import drr.regulation.cftc.tr.reports.MessageTypeRealTimeRule;
import drr.regulation.cftc.tr.reports.OptionStyleRule;
import drr.regulation.cftc.tr.reports.OptionTypeRule;
import drr.regulation.cftc.tr.reports.PhysicalCommodityIndicatorRule;
import drr.regulation.cftc.tr.reports.SdMspIndicatorParty1Rule;
import drr.regulation.cftc.tr.reports.SdMspIndicatorParty2Rule;
import drr.regulation.cftc.tr.reports.SefOrDcmAnonymousExecutionIndicatorRule;
import drr.regulation.cftc.tr.reports.SefOrDcmIndicatorRule;
import drr.regulation.cftc.tr.reports.SettlementTypeRule;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.contract.reports.EmbeddedOptionTypeRule;
import drr.regulation.common.trade.datetime.reports.ClearingTimestampRule;
import drr.regulation.common.trade.execution.reports.SettlementCurrencyLeg1Rule;
import drr.regulation.common.trade.execution.reports.SettlementCurrencyLeg2Rule;
import drr.regulation.common.trade.execution.reports.TraderLocationRule;
import drr.regulation.common.trade.execution.reports.TradingCapacityRule;
import drr.regulation.common.trade.index.reports.IndexFactorRule;
import drr.regulation.common.trade.index.reports.SeniorityRule;
import drr.regulation.common.trade.index.reports.SeriesRule;
import drr.regulation.common.trade.party.reports.Counterparty2NameRule;
import drr.regulation.common.trade.party.reports.CountryOfCounterparty2Rule;
import drr.regulation.common.trade.party.reports.ExecutionAgentCounterparty1Rule;
import drr.regulation.common.trade.party.reports.ExecutionAgentCounterparty2DTCCRule;
import drr.regulation.common.trade.party.reports.ReportSubmittingEntityRule;
import drr.regulation.common.trade.price.reports.ExchangeRateBasisRule;
import drr.regulation.common.trade.price.reports.ExchangeRateRule;
import drr.regulation.common.trade.price.reports.SingleOrUpperAndLowerBarrierRule;
import drr.regulation.common.trade.quantity.reports.NotionalQuantityLeg2Rule;
import drr.standards.iosco.cde.datetime.reports.EarlyTerminationDateRule;
import drr.standards.iosco.cde.datetime.reports.EffectiveDateRule;
import drr.standards.iosco.cde.datetime.reports.ExecutionTimestampRule;
import drr.standards.iosco.cde.datetime.reports.ReportingTimestampRule;
import drr.standards.iosco.cde.event.reports.ActionTypeRule;
import drr.standards.iosco.cde.event.reports.EventTimestampRule;
import drr.standards.iosco.cde.party.reports.Counterparty2Rule;
import drr.standards.iosco.cde.payment.reports.OtherPaymentRule;
import drr.standards.iosco.cde.price.reports.FirstExerciseDateRule;
import drr.standards.iosco.cde.price.reports.OptionPremiumAmountRule;
import drr.standards.iosco.cde.price.reports.OptionPremiumCurrencyRule;
import drr.standards.iosco.cde.price.reports.PackageTransactionPriceCurrencyRule;
import drr.standards.iosco.cde.price.reports.PackageTransactionSpreadCurrencyRule;
import drr.standards.iosco.cde.price.reports.PriceScheduleRule;
import drr.standards.iosco.cde.price.reports.PriceUnitOfMeasureRule;
import drr.standards.iosco.cde.price.reports.StrikePriceCurrencyRule;
import drr.standards.iosco.cde.price.reports.StrikePriceScheduleRule;
import drr.standards.iosco.cde.quantity.reports.CallCurrencyRule;
import drr.standards.iosco.cde.quantity.reports.NotionalAmountScheduleLeg1Rule;
import drr.standards.iosco.cde.quantity.reports.NotionalAmountScheduleLeg2Rule;
import drr.standards.iosco.cde.quantity.reports.NotionalCurrencyLeg1Rule;
import drr.standards.iosco.cde.quantity.reports.NotionalCurrencyLeg2Rule;
import drr.standards.iosco.cde.quantity.reports.PutCurrencyRule;
import drr.standards.iosco.cde.settlement.reports.ClearedRule;
import drr.standards.iosco.cde.settlement.reports.SettlementLocationLeg1Rule;
import drr.standards.iosco.cde.settlement.reports.SettlementLocationLeg2Rule;
import drr.standards.iosco.upi.reports.UniqueProductIdentifierRule;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;


@RosettaReport(namespace="drr.regulation.cftc.rewrite", body="CFTC", corpusList={"Part43"})
@RuneLabelProvider(labelProvider=CFTCPart43LabelProvider.class)
@ImplementedBy(CFTCPart43ReportFunction.CFTCPart43ReportFunctionDefault.class)
public abstract class CFTCPart43ReportFunction implements ReportFunction<TransactionReportInstruction, CFTCPart43TransactionReport> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ActionTypeRule actionTypeRule;
	@Inject protected AmendmentIndicatorRule amendmentIndicatorRule;
	@Inject protected AssetClassRule assetClassRule;
	@Inject protected BlockTradeElectionIndicatorRule blockTradeElectionIndicatorRule;
	@Inject protected CallAmountRule callAmountRule;
	@Inject protected CallCurrencyRule callCurrencyRule;
	@Inject protected ClearedRule clearedRule;
	@Inject protected ClearingTimestampRule clearingTimestampRule;
	@Inject protected Counterparty1FormatRule counterparty1FormatRule;
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected Counterparty2FormatRule counterparty2FormatRule;
	@Inject protected Counterparty2IdentifierSourceRule counterparty2IdentifierSourceRule;
	@Inject protected Counterparty2NameRule counterparty2NameRule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected CountryOfCounterparty2Rule countryOfCounterparty2Rule;
	@Inject protected CustomBasketIndicatorRule customBasketIndicatorRule;
	@Inject protected EarlyTerminationDateRule earlyTerminationDateRule;
	@Inject protected EffectiveDateRule effectiveDateRule;
	@Inject protected EmbeddedOptionTypeRule embeddedOptionTypeRule;
	@Inject protected EventTimestampRule eventTimestampRule;
	@Inject protected EventTypeRule eventTypeRule;
	@Inject protected ExchangeRateBasisRule exchangeRateBasisRule;
	@Inject protected ExchangeRateRule exchangeRateRule;
	@Inject protected ExecutionAgentCounterparty1Rule executionAgentCounterparty1Rule;
	@Inject protected ExecutionAgentCounterparty2DTCCRule executionAgentCounterparty2DTCCRule;
	@Inject protected ExecutionTimestampRule executionTimestampRule;
	@Inject protected ExpirationDateRule expirationDateRule;
	@Inject protected FirstExerciseDateRule firstExerciseDateRule;
	@Inject protected FixedRateDayCountConventionLeg1Rule fixedRateDayCountConventionLeg1Rule;
	@Inject protected FixedRateDayCountConventionLeg2Rule fixedRateDayCountConventionLeg2Rule;
	@Inject protected FixedRateLeg1Rule fixedRateLeg1Rule;
	@Inject protected FixedRateLeg2Rule fixedRateLeg2Rule;
	@Inject protected FixedRatePaymentFrequencyPeriodLeg1Rule fixedRatePaymentFrequencyPeriodLeg1Rule;
	@Inject protected FixedRatePaymentFrequencyPeriodLeg2Rule fixedRatePaymentFrequencyPeriodLeg2Rule;
	@Inject protected FixedRatePaymentFrequencyPeriodMultiplierLeg1Rule fixedRatePaymentFrequencyPeriodMultiplierLeg1Rule;
	@Inject protected FixedRatePaymentFrequencyPeriodMultiplierLeg2Rule fixedRatePaymentFrequencyPeriodMultiplierLeg2Rule;
	@Inject protected FloatingRateDayCountConventionLeg1Rule floatingRateDayCountConventionLeg1Rule;
	@Inject protected FloatingRateDayCountConventionLeg2Rule floatingRateDayCountConventionLeg2Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodLeg1Rule floatingRatePaymentFrequencyPeriodLeg1Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodLeg2Rule floatingRatePaymentFrequencyPeriodLeg2Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodMultiplierLeg1Rule floatingRatePaymentFrequencyPeriodMultiplierLeg1Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodMultiplierLeg2Rule floatingRatePaymentFrequencyPeriodMultiplierLeg2Rule;
	@Inject protected FloatingRateResetFrequencyPeriodLeg1Rule floatingRateResetFrequencyPeriodLeg1Rule;
	@Inject protected FloatingRateResetFrequencyPeriodLeg2Rule floatingRateResetFrequencyPeriodLeg2Rule;
	@Inject protected FloatingRateResetFrequencyPeriodMultiplierLeg1Rule floatingRateResetFrequencyPeriodMultiplierLeg1Rule;
	@Inject protected FloatingRateResetFrequencyPeriodMultiplierLeg2Rule floatingRateResetFrequencyPeriodMultiplierLeg2Rule;
	@Inject protected IndexFactorRule indexFactorRule;
	@Inject protected LargeNotionalOffFacilitySwapElectionIndicatorRule largeNotionalOffFacilitySwapElectionIndicatorRule;
	@Inject protected MandatoryClearingIndicatorRule mandatoryClearingIndicatorRule;
	@Inject protected MaturityDateOfTheUnderlierRule maturityDateOfTheUnderlierRule;
	@Inject protected MessageTypeRealTimeRule messageTypeRealTimeRule;
	@Inject protected NonStandardizedTermIndicatorRule nonStandardizedTermIndicatorRule;
	@Inject protected NotionalAmountLeg1Rule notionalAmountLeg1Rule;
	@Inject protected NotionalAmountLeg2Rule notionalAmountLeg2Rule;
	@Inject protected NotionalAmountScheduleLeg1Rule notionalAmountScheduleLeg1Rule;
	@Inject protected NotionalAmountScheduleLeg2Rule notionalAmountScheduleLeg2Rule;
	@Inject protected NotionalCurrencyLeg1Rule notionalCurrencyLeg1Rule;
	@Inject protected NotionalCurrencyLeg2Rule notionalCurrencyLeg2Rule;
	@Inject protected NotionalQuantityLeg1Rule notionalQuantityLeg1Rule;
	@Inject protected NotionalQuantityLeg2Rule notionalQuantityLeg2Rule;
	@Inject protected OptionPremiumAmountRule optionPremiumAmountRule;
	@Inject protected OptionPremiumCurrencyRule optionPremiumCurrencyRule;
	@Inject protected OptionStyleRule optionStyleRule;
	@Inject protected OptionTypeRule optionTypeRule;
	@Inject protected OtherPaymentRule otherPaymentRule;
	@Inject protected PackageIndicatorRule packageIndicatorRule;
	@Inject protected PackageTransactionPriceCurrencyRule packageTransactionPriceCurrencyRule;
	@Inject protected PackageTransactionPriceNotationRule packageTransactionPriceNotationRule;
	@Inject protected PackageTransactionPriceRule packageTransactionPriceRule;
	@Inject protected PackageTransactionSpreadCurrencyRule packageTransactionSpreadCurrencyRule;
	@Inject protected PackageTransactionSpreadNotationRule packageTransactionSpreadNotationRule;
	@Inject protected PackageTransactionSpreadRule packageTransactionSpreadRule;
	@Inject protected PhysicalCommodityIndicatorRule physicalCommodityIndicatorRule;
	@Inject protected PlatformIdentifierRule platformIdentifierRule;
	@Inject protected PostPricedSwapIndicatorRule postPricedSwapIndicatorRule;
	@Inject protected PriceCurrencyRule priceCurrencyRule;
	@Inject protected PriceNotationRule priceNotationRule;
	@Inject protected PriceRule priceRule;
	@Inject protected PriceScheduleRule priceScheduleRule;
	@Inject protected PriceUnitOfMeasureRule priceUnitOfMeasureRule;
	@Inject protected PrimeBrokerageTransactionIndicatorRule primeBrokerageTransactionIndicatorRule;
	@Inject protected PutAmountRule putAmountRule;
	@Inject protected PutCurrencyRule putCurrencyRule;
	@Inject protected QuantityFrequencyLeg1Rule quantityFrequencyLeg1Rule;
	@Inject protected QuantityFrequencyLeg2Rule quantityFrequencyLeg2Rule;
	@Inject protected QuantityFrequencyMultiplierLeg1Rule quantityFrequencyMultiplierLeg1Rule;
	@Inject protected QuantityFrequencyMultiplierLeg2Rule quantityFrequencyMultiplierLeg2Rule;
	@Inject protected QuantityUnitOfMeasureLeg1Rule quantityUnitOfMeasureLeg1Rule;
	@Inject protected QuantityUnitOfMeasureLeg2Rule quantityUnitOfMeasureLeg2Rule;
	@Inject protected ReportSubmittingEntityRule reportSubmittingEntityRule;
	@Inject protected ReportingTimestampRule reportingTimestampRule;
	@Inject protected SdMspIndicatorParty1Rule sdMspIndicatorParty1Rule;
	@Inject protected SdMspIndicatorParty2Rule sdMspIndicatorParty2Rule;
	@Inject protected SefOrDcmAnonymousExecutionIndicatorRule sefOrDcmAnonymousExecutionIndicatorRule;
	@Inject protected SefOrDcmIndicatorRule sefOrDcmIndicatorRule;
	@Inject protected SeniorityRule seniorityRule;
	@Inject protected SeriesRule seriesRule;
	@Inject protected SettlementCurrencyLeg1Rule settlementCurrencyLeg1Rule;
	@Inject protected SettlementCurrencyLeg2Rule settlementCurrencyLeg2Rule;
	@Inject protected SettlementLocationLeg1Rule settlementLocationLeg1Rule;
	@Inject protected SettlementLocationLeg2Rule settlementLocationLeg2Rule;
	@Inject protected SettlementTypeRule settlementTypeRule;
	@Inject protected SingleOrUpperAndLowerBarrierRule singleOrUpperAndLowerBarrierRule;
	@Inject protected SpreadCurrencyLeg1Rule spreadCurrencyLeg1Rule;
	@Inject protected SpreadCurrencyLeg2Rule spreadCurrencyLeg2Rule;
	@Inject protected SpreadLeg1Rule spreadLeg1Rule;
	@Inject protected SpreadLeg2Rule spreadLeg2Rule;
	@Inject protected SpreadNotationLeg1Rule spreadNotationLeg1Rule;
	@Inject protected SpreadNotationLeg2Rule spreadNotationLeg2Rule;
	@Inject protected StrikePriceCurrencyRule strikePriceCurrencyRule;
	@Inject protected StrikePriceNotationRule strikePriceNotationRule;
	@Inject protected StrikePriceRule strikePriceRule;
	@Inject protected StrikePriceScheduleRule strikePriceScheduleRule;
	@Inject protected TotalNotionalQuantityLeg1Rule totalNotionalQuantityLeg1Rule;
	@Inject protected TotalNotionalQuantityLeg2Rule totalNotionalQuantityLeg2Rule;
	@Inject protected TraderLocationRule traderLocationRule;
	@Inject protected TradingCapacityRule tradingCapacityRule;
	@Inject protected UniqueProductIdentifierRule uniqueProductIdentifierRule;
	@Inject protected UniqueSwapIdentifierRule uniqueSwapIdentifierRule;
	@Inject protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CFTCPart43TransactionReport evaluate(TransactionReportInstruction input) {
		CFTCPart43TransactionReport.CFTCPart43TransactionReportBuilder outputBuilder = doEvaluate(input);
		
		final CFTCPart43TransactionReport output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(CFTCPart43TransactionReport.class, output);
		}
		
		return output;
	}

	protected abstract CFTCPart43TransactionReport.CFTCPart43TransactionReportBuilder doEvaluate(TransactionReportInstruction input);

	public static class CFTCPart43ReportFunctionDefault extends CFTCPart43ReportFunction {
		@Override
		protected CFTCPart43TransactionReport.CFTCPart43TransactionReportBuilder doEvaluate(TransactionReportInstruction input) {
			CFTCPart43TransactionReport.CFTCPart43TransactionReportBuilder output = CFTCPart43TransactionReport.builder();
			return assignOutput(output, input);
		}
		
		protected CFTCPart43TransactionReport.CFTCPart43TransactionReportBuilder assignOutput(CFTCPart43TransactionReport.CFTCPart43TransactionReportBuilder output, TransactionReportInstruction input) {
			output
				.setActionType(actionTypeRule.evaluate(input));
			
			output
				.setEventType(eventTypeRule.evaluate(input));
			
			output
				.setEffectiveDate(effectiveDateRule.evaluate(input));
			
			output
				.setEarlyTerminationDate(earlyTerminationDateRule.evaluate(input));
			
			output
				.setEventTimestamp(eventTimestampRule.evaluate(input));
			
			output
				.setReportingTimestamp(reportingTimestampRule.evaluate(input));
			
			output
				.setExecutionTimestamp(executionTimestampRule.evaluate(input));
			
			output
				.setExpirationDate(expirationDateRule.evaluate(input));
			
			output
				.setCounterparty1(counterparty1Rule.evaluate(input));
			
			output
				.setCounterparty2(counterparty2Rule.evaluate(input));
			
			output
				.setCleared(clearedRule.evaluate(input));
			
			output
				.setCallAmount(callAmountRule.evaluate(input));
			
			output
				.setPutAmount(putAmountRule.evaluate(input));
			
			output
				.setCallCurrency(callCurrencyRule.evaluate(input));
			
			output
				.setPutCurrency(putCurrencyRule.evaluate(input));
			
			output
				.setPriceSchedule(priceScheduleRule.evaluate(input));
			
			output
				.setStrikePriceSchedule(strikePriceScheduleRule.evaluate(input));
			
			output
				.setPrice(priceRule.evaluate(input));
			
			output
				.setPriceNotation(priceNotationRule.evaluate(input));
			
			output
				.setPriceCurrency(priceCurrencyRule.evaluate(input));
			
			output
				.setPackageTransactionPrice(packageTransactionPriceRule.evaluate(input));
			
			output
				.setPackageTransactionPriceNotation(packageTransactionPriceNotationRule.evaluate(input));
			
			output
				.setPackageTransactionPriceCurrency(packageTransactionPriceCurrencyRule.evaluate(input));
			
			output
				.setPackageTransactionSpread(packageTransactionSpreadRule.evaluate(input));
			
			output
				.setPackageTransactionSpreadNotation(packageTransactionSpreadNotationRule.evaluate(input));
			
			output
				.setPackageTransactionSpreadCurrency(packageTransactionSpreadCurrencyRule.evaluate(input));
			
			output
				.setStrikePrice(strikePriceRule.evaluate(input));
			
			output
				.setStrikePriceNotation(strikePriceNotationRule.evaluate(input));
			
			output
				.setStrikePriceCurrency(strikePriceCurrencyRule.evaluate(input));
			
			output
				.setPriceUnitOfMeasure(priceUnitOfMeasureRule.evaluate(input));
			
			output
				.setOptionPremiumAmount(optionPremiumAmountRule.evaluate(input));
			
			output
				.setOptionPremiumCurrency(optionPremiumCurrencyRule.evaluate(input));
			
			output
				.setFirstExerciseDate(firstExerciseDateRule.evaluate(input));
			
			output
				.setOtherPayment(otherPaymentRule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFixedRateDayCountConvention(fixedRateDayCountConventionLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFloatingRateDayCountConvention(floatingRateDayCountConventionLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFixedRatePaymentFrequencyPeriod(fixedRatePaymentFrequencyPeriodLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFloatingRatePaymentFrequencyPeriod(floatingRatePaymentFrequencyPeriodLeg1Rule.evaluate(input));
			
			final BigDecimal bigDecimal0 = fixedRatePaymentFrequencyPeriodMultiplierLeg1Rule.evaluate(input);
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFixedRatePaymentFrequencyPeriodMultiplier((bigDecimal0 == null ? null : bigDecimal0.intValueExact()));
			
			final BigDecimal bigDecimal1 = floatingRatePaymentFrequencyPeriodMultiplierLeg1Rule.evaluate(input);
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFloatingRatePaymentFrequencyPeriodMultiplier((bigDecimal1 == null ? null : bigDecimal1.intValueExact()));
			
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFloatingRateResetFrequencyPeriod(floatingRateResetFrequencyPeriodLeg1Rule.evaluate(input));
			
			final BigDecimal bigDecimal2 = floatingRateResetFrequencyPeriodMultiplierLeg1Rule.evaluate(input);
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFloatingRateResetFrequencyMultiplier((bigDecimal2 == null ? null : bigDecimal2.intValueExact()));
			
			output
				.getOrCreateLeg1()
				.setNotionalAmount(notionalAmountLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setNotionalAmountSchedule(notionalAmountScheduleLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setNotionalCurrency(notionalCurrencyLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setTotalNotionalQuantity(totalNotionalQuantityLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setFixedRate(fixedRateLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setSettlementCurrency(settlementCurrencyLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setSpread(spreadLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setSpreadNotation(spreadNotationLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setSpreadCurrency(spreadCurrencyLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setNotionalQuantity(notionalQuantityLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setQuantityFrequency(quantityFrequencyLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setQuantityFrequencyMultiplier(quantityFrequencyMultiplierLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFixedRateDayCountConvention(fixedRateDayCountConventionLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFloatingRateDayCountConvention(floatingRateDayCountConventionLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFixedRatePaymentFrequencyPeriod(fixedRatePaymentFrequencyPeriodLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFloatingRatePaymentFrequencyPeriod(floatingRatePaymentFrequencyPeriodLeg2Rule.evaluate(input));
			
			final BigDecimal bigDecimal3 = fixedRatePaymentFrequencyPeriodMultiplierLeg2Rule.evaluate(input);
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFixedRatePaymentFrequencyPeriodMultiplier((bigDecimal3 == null ? null : bigDecimal3.intValueExact()));
			
			final BigDecimal bigDecimal4 = floatingRatePaymentFrequencyPeriodMultiplierLeg2Rule.evaluate(input);
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFloatingRatePaymentFrequencyPeriodMultiplier((bigDecimal4 == null ? null : bigDecimal4.intValueExact()));
			
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFloatingRateResetFrequencyPeriod(floatingRateResetFrequencyPeriodLeg2Rule.evaluate(input));
			
			final BigDecimal bigDecimal5 = floatingRateResetFrequencyPeriodMultiplierLeg2Rule.evaluate(input);
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFloatingRateResetFrequencyMultiplier((bigDecimal5 == null ? null : bigDecimal5.intValueExact()));
			
			output
				.getOrCreateLeg2()
				.setNotionalAmount(notionalAmountLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setNotionalAmountSchedule(notionalAmountScheduleLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setNotionalCurrency(notionalCurrencyLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setTotalNotionalQuantity(totalNotionalQuantityLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setFixedRate(fixedRateLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setSettlementCurrency(settlementCurrencyLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setSpread(spreadLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setSpreadNotation(spreadNotationLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setSpreadCurrency(spreadCurrencyLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setNotionalQuantity(notionalQuantityLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setQuantityFrequency(quantityFrequencyLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setQuantityFrequencyMultiplier(quantityFrequencyMultiplierLeg2Rule.evaluate(input));
			
			output
				.setCounterparty2Name(counterparty2NameRule.evaluate(input));
			
			output
				.setExecutionAgentCounterparty1(executionAgentCounterparty1Rule.evaluate(input));
			
			output
				.setExecutionAgentCounterparty2DTCC(executionAgentCounterparty2DTCCRule.evaluate(input));
			
			output
				.setReportSubmittingEntityID(reportSubmittingEntityRule.evaluate(input));
			
			output
				.setUniqueTransactionIdentifier(uniqueTransactionIdentifierRule.evaluate(input));
			
			output
				.setUniqueProductIdentifier(uniqueProductIdentifierRule.evaluate(input));
			
			output
				.setClearingTimestamp(clearingTimestampRule.evaluate(input));
			
			output
				.setPlatformIdentifier(platformIdentifierRule.evaluate(input));
			
			output
				.setBarrier(singleOrUpperAndLowerBarrierRule.evaluate(input));
			
			output
				.setExchangeRate(exchangeRateRule.evaluate(input));
			
			output
				.setExchangeRateBasis(exchangeRateBasisRule.evaluate(input));
			
			output
				.setQuantityUnitOfMeasureLeg1(quantityUnitOfMeasureLeg1Rule.evaluate(input));
			
			output
				.setQuantityUnitOfMeasureLeg2(quantityUnitOfMeasureLeg2Rule.evaluate(input));
			
			output
				.setCountryOfTheCounterparty2(countryOfCounterparty2Rule.evaluate(input));
			
			output
				.setTraderLocation(traderLocationRule.evaluate(input));
			
			output
				.setTradingCapacity(tradingCapacityRule.evaluate(input));
			
			output
				.setEmbeddedOptionType(embeddedOptionTypeRule.evaluate(input));
			
			output
				.setSeniority(seniorityRule.evaluate(input));
			
			final BigDecimal bigDecimal6 = seriesRule.evaluate(input);
			output
				.setSeries((bigDecimal6 == null ? null : bigDecimal6.intValueExact()));
			
			output
				.setIndexFactor(indexFactorRule.evaluate(input));
			
			output
				.setCounterparty2IdentifierSource(counterparty2IdentifierSourceRule.evaluate(input));
			
			output
				.setCustomBasketIndicator(customBasketIndicatorRule.evaluate(input));
			
			output
				.setAmendmentIndicator(amendmentIndicatorRule.evaluate(input));
			
			output
				.setPackageIndicator(packageIndicatorRule.evaluate(input));
			
			output
				.setPostPricedSwapIndicator(postPricedSwapIndicatorRule.evaluate(input));
			
			output
				.setSettlementLocationLeg1(settlementLocationLeg1Rule.evaluate(input));
			
			output
				.setSettlementLocationLeg2(settlementLocationLeg2Rule.evaluate(input));
			
			output
				.setNonStandardizedTermIndicator(nonStandardizedTermIndicatorRule.evaluate(input));
			
			output
				.setBlockTradeElectionIndicator(blockTradeElectionIndicatorRule.evaluate(input));
			
			output
				.setPrimeBrokerageTransactionIndicator(primeBrokerageTransactionIndicatorRule.evaluate(input));
			
			output
				.setUniqueSwapIdentifier(uniqueSwapIdentifierRule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setOptionType(optionTypeRule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setOptionStyle(optionStyleRule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setAssetClass(assetClassRule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setMandatoryClearingIndicator(mandatoryClearingIndicatorRule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setMaturityDateOfTheUnderlier(maturityDateOfTheUnderlierRule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setLargeNotionalOffFacilitySwapElectionIndicator(largeNotionalOffFacilitySwapElectionIndicatorRule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setSefOrDcmIndicator(sefOrDcmIndicatorRule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setSefOrDcmAnonymousExecutionIndicator(sefOrDcmAnonymousExecutionIndicatorRule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setMessageType(messageTypeRealTimeRule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setSettlementType(settlementTypeRule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setSdMspIndicatorParty1(sdMspIndicatorParty1Rule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setSdMspIndicatorParty2(sdMspIndicatorParty2Rule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setPhysicalCommodityIndicator(physicalCommodityIndicatorRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setCounterparty1Format(counterparty1FormatRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setCounterparty2Format(counterparty2FormatRule.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
