package drr.regulation.cftc.rewrite.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.basket.reports.CustomBasketCodeRule;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(CustomBasketIndicatorRule.CustomBasketIndicatorRuleDefault.class)
public abstract class CustomBasketIndicatorRule implements ReportFunction<TransactionReportInstruction, Boolean> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CustomBasketCodeRule customBasketCodeRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(TransactionReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction input);

	public static class CustomBasketIndicatorRuleDefault extends CustomBasketIndicatorRule {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> {
					final String string = customBasketCodeRule.evaluate(item.get());
					return string == null ? exists(MapperS.<FieldWithMetaString>ofNull()).asMapper() : exists(MapperS.of(FieldWithMetaString.builder().setValue(string).build())).asMapper();
				}).get();
			
			return output;
		}
	}
}
