package drr.regulation.cftc.rewrite.reports;

import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.InflationRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.standards.iosco.cde.payment.reports.PaymentFrequencyPeriodMultiplierRule;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(FloatingRatePaymentFrequencyPeriodMultiplierLeg2Rule.FloatingRatePaymentFrequencyPeriodMultiplierLeg2RuleDefault.class)
public abstract class FloatingRatePaymentFrequencyPeriodMultiplierLeg2Rule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected PaymentFrequencyPeriodMultiplierRule paymentFrequencyPeriodMultiplierRule;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class FloatingRatePaymentFrequencyPeriodMultiplierLeg2RuleDefault extends FloatingRatePaymentFrequencyPeriodMultiplierLeg2Rule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<Product> thenArg0 = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(productOrUnderlierProduct.evaluate(item.get())));
			final MapperS<InterestRatePayout> thenArg2 = thenArg1
				.mapSingleToItem(item -> MapperS.of(interestRateLeg2.evaluate(item.get())));
			final MapperS<InterestRatePayout> thenArg3 = thenArg2
				.filterSingleNullSafe(item -> exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).or(exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate()))).get());
			output = MapperS.of(paymentFrequencyPeriodMultiplierRule.evaluate(thenArg3.get())).get();
			
			return output;
		}
	}
}
