package drr.regulation.cftc.rewrite.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebook;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class CFTCGuidebookValidator implements Validator<CFTCGuidebook> {

	private List<ComparisonResult> getComparisonResults(CFTCGuidebook o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("optionType", (String) o.getOptionType() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionStyle", (String) o.getOptionStyle() != null ? 1 : 0, 0, 1), 
				checkCardinality("assetClass", (String) o.getAssetClass() != null ? 1 : 0, 1, 1), 
				checkCardinality("mandatoryClearingIndicator", (Boolean) o.getMandatoryClearingIndicator() != null ? 1 : 0, 1, 1), 
				checkCardinality("maturityDateOfTheUnderlier", (Date) o.getMaturityDateOfTheUnderlier() != null ? 1 : 0, 0, 1), 
				checkCardinality("largeNotionalOffFacilitySwapElectionIndicator", (Boolean) o.getLargeNotionalOffFacilitySwapElectionIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("sefOrDcmIndicator", (Boolean) o.getSefOrDcmIndicator() != null ? 1 : 0, 1, 1), 
				checkCardinality("sefOrDcmAnonymousExecutionIndicator", (Boolean) o.getSefOrDcmAnonymousExecutionIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("messageType", (String) o.getMessageType() != null ? 1 : 0, 1, 1), 
				checkCardinality("settlementType", (String) o.getSettlementType() != null ? 1 : 0, 0, 1), 
				checkCardinality("sdMspIndicatorParty1", (Boolean) o.getSdMspIndicatorParty1() != null ? 1 : 0, 1, 1), 
				checkCardinality("sdMspIndicatorParty2", (Boolean) o.getSdMspIndicatorParty2() != null ? 1 : 0, 1, 1), 
				checkCardinality("physicalCommodityIndicator", (Boolean) o.getPhysicalCommodityIndicator() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCGuidebook o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("CFTCGuidebook", ValidationType.CARDINALITY, "CFTCGuidebook", path, "", res.getError());
				}
				return success("CFTCGuidebook", ValidationType.CARDINALITY, "CFTCGuidebook", path, "");
			})
			.collect(toList());
	}

}
