package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebook;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataRule("CFTCGuidebookLargeNotionalOffFacilitySwapElectionIndicator")
@ImplementedBy(CFTCGuidebookLargeNotionalOffFacilitySwapElectionIndicator.Default.class)
public interface CFTCGuidebookLargeNotionalOffFacilitySwapElectionIndicator extends Validator<CFTCGuidebook> {
	
	String NAME = "CFTCGuidebookLargeNotionalOffFacilitySwapElectionIndicator";
	String DEFINITION = "if sefOrDcmIndicator = True then largeNotionalOffFacilitySwapElectionIndicator is absent";
	
	class Default implements CFTCGuidebookLargeNotionalOffFacilitySwapElectionIndicator {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCGuidebook cFTCGuidebook) {
			ComparisonResult result = executeDataRule(cFTCGuidebook);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCGuidebook", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "CFTCGuidebook", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCGuidebook cFTCGuidebook) {
			try {
				if (areEqual(MapperS.of(cFTCGuidebook).<Boolean>map("getSefOrDcmIndicator", _cFTCGuidebook -> _cFTCGuidebook.getSefOrDcmIndicator()), MapperS.of(true), CardinalityOperator.All).getOrDefault(false)) {
					return notExists(MapperS.of(cFTCGuidebook).<Boolean>map("getLargeNotionalOffFacilitySwapElectionIndicator", _cFTCGuidebook -> _cFTCGuidebook.getLargeNotionalOffFacilitySwapElectionIndicator()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCGuidebookLargeNotionalOffFacilitySwapElectionIndicator {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCGuidebook cFTCGuidebook) {
			return Collections.emptyList();
		}
	}
}
