package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebook;
import drr.regulation.cftc.rewrite.CFTCPart43TransactionReport;
import drr.regulation.common.trade.CommonLeg;
import drr.standards.iosco.cde.price.PriceFormat;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataRule("CFTCPart43TransactionReportSpreadNotationCondition")
@ImplementedBy(CFTCPart43TransactionReportSpreadNotationCondition.Default.class)
public interface CFTCPart43TransactionReportSpreadNotationCondition extends Validator<CFTCPart43TransactionReport> {
	
	String NAME = "CFTCPart43TransactionReportSpreadNotationCondition";
	String DEFINITION = "(if [\"Credit\", \"InterestRate\", \"Equity\", \"Commodity\"] any = cftcGuidebook -> assetClass and leg1 -> spread exists then leg1 -> spreadNotation exists else leg1 -> spreadNotation is absent) and (if [\"Credit\", \"InterestRate\", \"Equity\", \"Commodity\"] any = cftcGuidebook -> assetClass and leg2 -> spread exists then leg2 -> spreadNotation exists else leg2 -> spreadNotation is absent)";
	
	class Default implements CFTCPart43TransactionReportSpreadNotationCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart43TransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			try {
				final ComparisonResult ifThenElseResult0;
				if (areEqual(MapperC.<String>of(MapperS.of("Credit"), MapperS.of("InterestRate"), MapperS.of("Equity"), MapperS.of("Commodity")), MapperS.of(cFTCPart43TransactionReport).<CFTCGuidebook>map("getCftcGuidebook", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebook -> cFTCGuidebook.getAssetClass()), CardinalityOperator.Any).and(exists(MapperS.of(cFTCPart43TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getLeg1()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()))).getOrDefault(false)) {
					ifThenElseResult0 = exists(MapperS.of(cFTCPart43TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getLeg1()).<PriceNotationEnum>map("getSpreadNotation", commonLeg -> commonLeg.getSpreadNotation()));
				} else {
					ifThenElseResult0 = notExists(MapperS.of(cFTCPart43TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getLeg1()).<PriceNotationEnum>map("getSpreadNotation", commonLeg -> commonLeg.getSpreadNotation()));
				}
				final ComparisonResult ifThenElseResult1;
				if (areEqual(MapperC.<String>of(MapperS.of("Credit"), MapperS.of("InterestRate"), MapperS.of("Equity"), MapperS.of("Commodity")), MapperS.of(cFTCPart43TransactionReport).<CFTCGuidebook>map("getCftcGuidebook", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebook -> cFTCGuidebook.getAssetClass()), CardinalityOperator.Any).and(exists(MapperS.of(cFTCPart43TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getLeg2()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()))).getOrDefault(false)) {
					ifThenElseResult1 = exists(MapperS.of(cFTCPart43TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getLeg2()).<PriceNotationEnum>map("getSpreadNotation", commonLeg -> commonLeg.getSpreadNotation()));
				} else {
					ifThenElseResult1 = notExists(MapperS.of(cFTCPart43TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getLeg2()).<PriceNotationEnum>map("getSpreadNotation", commonLeg -> commonLeg.getSpreadNotation()));
				}
				return ifThenElseResult0.and(ifThenElseResult1);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart43TransactionReportSpreadNotationCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			return Collections.emptyList();
		}
	}
}
