package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebook;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.payment.CommonPeriodicPayment;
import drr.standards.iso.FrequencyPeriodEnum;
import drr.standards.iso.InterestComputationMethod4Code;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataRule("CFTCPart45TransactionReportDayCountConventionCondition")
@ImplementedBy(CFTCPart45TransactionReportDayCountConventionCondition.Default.class)
public interface CFTCPart45TransactionReportDayCountConventionCondition extends Validator<CFTCPart45TransactionReport> {
	
	String NAME = "CFTCPart45TransactionReportDayCountConventionCondition";
	String DEFINITION = "if [\"Credit\", \"InterestRate\"] any = cftcGuidebook -> assetClass then (leg1 -> periodicPayment -> fixedRateDayCountConvention exists or leg1 -> periodicPayment -> floatingRateDayCountConvention exists) and (leg2 -> periodicPayment -> fixedRateDayCountConvention exists or leg2 -> periodicPayment -> floatingRateDayCountConvention exists) else if [\"Commodity\", \"Equity\"] any = cftcGuidebook -> assetClass then ((if leg1 -> periodicPayment -> fixedRatePaymentFrequencyPeriod exists then leg1 -> periodicPayment -> fixedRateDayCountConvention exists else if leg1 -> periodicPayment -> floatingRatePaymentFrequencyPeriod exists then leg1 -> periodicPayment -> floatingRateDayCountConvention exists else leg1 -> periodicPayment -> fixedRateDayCountConvention is absent and leg1 -> periodicPayment -> floatingRateDayCountConvention is absent) and (if leg2 -> periodicPayment -> fixedRatePaymentFrequencyPeriod exists then leg2 -> periodicPayment -> fixedRateDayCountConvention exists else if leg2 -> periodicPayment -> floatingRatePaymentFrequencyPeriod exists then leg2 -> periodicPayment -> floatingRateDayCountConvention exists else leg2 -> periodicPayment -> fixedRateDayCountConvention is absent and leg2 -> periodicPayment -> floatingRateDayCountConvention is absent))";
	
	class Default implements CFTCPart45TransactionReportDayCountConventionCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart45TransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of("Credit"), MapperS.of("InterestRate")), MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebook>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebook -> cFTCGuidebook.getAssetClass()), CardinalityOperator.Any).getOrDefault(false)) {
					return exists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFixedRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFixedRateDayCountConvention())).or(exists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFloatingRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateDayCountConvention()))).and(exists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFixedRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFixedRateDayCountConvention())).or(exists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFloatingRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateDayCountConvention()))));
				}
				if (areEqual(MapperC.<String>of(MapperS.of("Commodity"), MapperS.of("Equity")), MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebook>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebook -> cFTCGuidebook.getAssetClass()), CardinalityOperator.Any).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult0;
					if (exists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod())).getOrDefault(false)) {
						ifThenElseResult0 = exists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFixedRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFixedRateDayCountConvention()));
					} else if (exists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFloatingRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriod())).getOrDefault(false)) {
						ifThenElseResult0 = exists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFloatingRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateDayCountConvention()));
					} else {
						ifThenElseResult0 = notExists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFixedRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFixedRateDayCountConvention())).and(notExists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFloatingRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateDayCountConvention())));
					}
					final ComparisonResult ifThenElseResult1;
					if (exists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod())).getOrDefault(false)) {
						ifThenElseResult1 = exists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFixedRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFixedRateDayCountConvention()));
					} else if (exists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFloatingRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriod())).getOrDefault(false)) {
						ifThenElseResult1 = exists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFloatingRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateDayCountConvention()));
					} else {
						ifThenElseResult1 = notExists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFixedRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFixedRateDayCountConvention())).and(notExists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFloatingRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateDayCountConvention())));
					}
					return ifThenElseResult0.and(ifThenElseResult1);
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart45TransactionReportDayCountConventionCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			return Collections.emptyList();
		}
	}
}
