package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebook;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import drr.regulation.common.trade.CommonLeg;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataRule("CFTCPart45TransactionReportNotionalAmountCondition")
@ImplementedBy(CFTCPart45TransactionReportNotionalAmountCondition.Default.class)
public interface CFTCPart45TransactionReportNotionalAmountCondition extends Validator<CFTCPart45TransactionReport> {
	
	String NAME = "CFTCPart45TransactionReportNotionalAmountCondition";
	String DEFINITION = "if cftcGuidebook -> optionStyle exists then ((if leg1 -> notionalAmount exists and (callAmount exists and putAmount exists) then leg1 -> notionalAmount = callAmount or leg1 -> notionalAmount = putAmount) and (if leg2 -> notionalAmount exists and (callAmount exists and putAmount exists) then leg2 -> notionalAmount = callAmount or leg2 -> notionalAmount = putAmount))";
	
	class Default implements CFTCPart45TransactionReportNotionalAmountCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart45TransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			try {
				if (exists(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebook>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getOptionStyle", cFTCGuidebook -> cFTCGuidebook.getOptionStyle())).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult0;
					if (exists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).<BigDecimal>map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount())).and(exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getCallAmount", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCallAmount())).and(exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getPutAmount", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPutAmount())))).getOrDefault(false)) {
						ifThenElseResult0 = areEqual(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).<BigDecimal>map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()), MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getCallAmount", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCallAmount()), CardinalityOperator.All).or(areEqual(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).<BigDecimal>map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()), MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getPutAmount", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPutAmount()), CardinalityOperator.All));
					} else {
						ifThenElseResult0 = ComparisonResult.successEmptyOperand("");
					}
					final ComparisonResult ifThenElseResult1;
					if (exists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).<BigDecimal>map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount())).and(exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getCallAmount", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCallAmount())).and(exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getPutAmount", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPutAmount())))).getOrDefault(false)) {
						ifThenElseResult1 = areEqual(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).<BigDecimal>map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()), MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getCallAmount", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCallAmount()), CardinalityOperator.All).or(areEqual(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).<BigDecimal>map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()), MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getPutAmount", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPutAmount()), CardinalityOperator.All));
					} else {
						ifThenElseResult1 = ComparisonResult.successEmptyOperand("");
					}
					return ifThenElseResult0.and(ifThenElseResult1);
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart45TransactionReportNotionalAmountCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			return Collections.emptyList();
		}
	}
}
