package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebook;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import drr.regulation.common.trade.CommonLeg;
import drr.standards.iosco.cde.price.PriceFormat;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataRule("CFTCPart45TransactionReportPriceCondition")
@ImplementedBy(CFTCPart45TransactionReportPriceCondition.Default.class)
public interface CFTCPart45TransactionReportPriceCondition extends Validator<CFTCPart45TransactionReport> {
	
	String NAME = "CFTCPart45TransactionReportPriceCondition";
	String DEFINITION = "if cftcGuidebook -> assetClass = \"Equity\" and leg1 -> spread is absent and leg2 -> spread is absent and postPricedSwapIndicator = False and cftcGuidebook -> optionStyle is absent then price exists else if cftcGuidebook -> assetClass = \"Commodity\" and ((leg1 -> fixedRate is absent and leg2 -> fixedRate is absent) or (leg1 -> spread is absent and leg2 -> spread is absent)) and postPricedSwapIndicator = False and cftcGuidebook -> optionStyle is absent then price exists else price is absent";
	
	class Default implements CFTCPart45TransactionReportPriceCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart45TransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			try {
				if (areEqual(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebook>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebook -> cFTCGuidebook.getAssetClass()), MapperS.of("Equity"), CardinalityOperator.All).and(notExists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()))).and(notExists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()))).and(areEqual(MapperS.of(cFTCPart45TransactionReport).<Boolean>map("getPostPricedSwapIndicator", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPostPricedSwapIndicator()), MapperS.of(false), CardinalityOperator.All)).and(notExists(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebook>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getOptionStyle", cFTCGuidebook -> cFTCGuidebook.getOptionStyle()))).getOrDefault(false)) {
					return exists(MapperS.of(cFTCPart45TransactionReport).<PriceFormat>map("getPrice", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPrice()));
				}
				if (areEqual(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebook>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebook -> cFTCGuidebook.getAssetClass()), MapperS.of("Commodity"), CardinalityOperator.All).and(notExists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).<BigDecimal>map("getFixedRate", commonLeg -> commonLeg.getFixedRate())).and(notExists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).<BigDecimal>map("getFixedRate", commonLeg -> commonLeg.getFixedRate()))).or(notExists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread())).and(notExists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()))))).and(areEqual(MapperS.of(cFTCPart45TransactionReport).<Boolean>map("getPostPricedSwapIndicator", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPostPricedSwapIndicator()), MapperS.of(false), CardinalityOperator.All)).and(notExists(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebook>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getOptionStyle", cFTCGuidebook -> cFTCGuidebook.getOptionStyle()))).getOrDefault(false)) {
					return exists(MapperS.of(cFTCPart45TransactionReport).<PriceFormat>map("getPrice", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPrice()));
				}
				return notExists(MapperS.of(cFTCPart45TransactionReport).<PriceFormat>map("getPrice", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPrice()));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart45TransactionReportPriceCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			return Collections.emptyList();
		}
	}
}
