package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebook;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import drr.regulation.common.trade.CommonLeg;
import drr.standards.iso.FrequencyPeriodEnum;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataRule("CFTCPart45TransactionReportQuantityFrequencyCondition")
@ImplementedBy(CFTCPart45TransactionReportQuantityFrequencyCondition.Default.class)
public interface CFTCPart45TransactionReportQuantityFrequencyCondition extends Validator<CFTCPart45TransactionReport> {
	
	String NAME = "CFTCPart45TransactionReportQuantityFrequencyCondition";
	String DEFINITION = "if cftcGuidebook -> assetClass = \"Commodity\" then ((if leg1 -> notionalQuantity exists then leg1 -> quantityFrequency exists) and (if leg1 -> notionalQuantity is absent then leg1 -> quantityFrequency is absent) and (if leg2 -> notionalQuantity exists then leg2 -> quantityFrequency exists) and (if leg2 -> notionalQuantity is absent then leg2 -> quantityFrequency is absent)) else leg1 -> quantityFrequency is absent and leg2 -> quantityFrequency is absent";
	
	class Default implements CFTCPart45TransactionReportQuantityFrequencyCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart45TransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			try {
				if (areEqual(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebook>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebook -> cFTCGuidebook.getAssetClass()), MapperS.of("Commodity"), CardinalityOperator.All).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult0;
					if (exists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).<BigDecimal>map("getNotionalQuantity", commonLeg -> commonLeg.getNotionalQuantity())).getOrDefault(false)) {
						ifThenElseResult0 = exists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).<FrequencyPeriodEnum>map("getQuantityFrequency", commonLeg -> commonLeg.getQuantityFrequency()));
					} else {
						ifThenElseResult0 = ComparisonResult.successEmptyOperand("");
					}
					final ComparisonResult ifThenElseResult1;
					if (notExists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).<BigDecimal>map("getNotionalQuantity", commonLeg -> commonLeg.getNotionalQuantity())).getOrDefault(false)) {
						ifThenElseResult1 = notExists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).<FrequencyPeriodEnum>map("getQuantityFrequency", commonLeg -> commonLeg.getQuantityFrequency()));
					} else {
						ifThenElseResult1 = ComparisonResult.successEmptyOperand("");
					}
					final ComparisonResult ifThenElseResult2;
					if (exists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).<BigDecimal>map("getNotionalQuantity", commonLeg -> commonLeg.getNotionalQuantity())).getOrDefault(false)) {
						ifThenElseResult2 = exists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).<FrequencyPeriodEnum>map("getQuantityFrequency", commonLeg -> commonLeg.getQuantityFrequency()));
					} else {
						ifThenElseResult2 = ComparisonResult.successEmptyOperand("");
					}
					final ComparisonResult ifThenElseResult3;
					if (notExists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).<BigDecimal>map("getNotionalQuantity", commonLeg -> commonLeg.getNotionalQuantity())).getOrDefault(false)) {
						ifThenElseResult3 = notExists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).<FrequencyPeriodEnum>map("getQuantityFrequency", commonLeg -> commonLeg.getQuantityFrequency()));
					} else {
						ifThenElseResult3 = ComparisonResult.successEmptyOperand("");
					}
					return ifThenElseResult0.and(ifThenElseResult1).and(ifThenElseResult2).and(ifThenElseResult3);
				}
				return notExists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).<FrequencyPeriodEnum>map("getQuantityFrequency", commonLeg -> commonLeg.getQuantityFrequency())).and(notExists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).<FrequencyPeriodEnum>map("getQuantityFrequency", commonLeg -> commonLeg.getQuantityFrequency())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart45TransactionReportQuantityFrequencyCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			return Collections.emptyList();
		}
	}
}
