package drr.regulation.cftc.rewrite.validation.datarule;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebook;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import drr.regulation.common.trade.CommonLeg;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataRule("CFTCPart45TransactionReportSpreadCurrencyCondition")
@ImplementedBy(CFTCPart45TransactionReportSpreadCurrencyCondition.Default.class)
public interface CFTCPart45TransactionReportSpreadCurrencyCondition extends Validator<CFTCPart45TransactionReport> {
	
	String NAME = "CFTCPart45TransactionReportSpreadCurrencyCondition";
	String DEFINITION = "(if [\"Credit\", \"InterestRate\", \"Equity\", \"Commodity\"] any = cftcGuidebook -> assetClass and leg1 -> spreadNotation = Monetary then leg1 -> spreadCurrency exists else leg1 -> spreadCurrency is absent) and (if [\"Credit\", \"InterestRate\", \"Equity\", \"Commodity\"] any = cftcGuidebook -> assetClass and leg2 -> spreadNotation = Monetary then leg2 -> spreadCurrency exists else leg2 -> spreadCurrency is absent)";
	
	class Default implements CFTCPart45TransactionReportSpreadCurrencyCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart45TransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			try {
				final ComparisonResult ifThenElseResult0;
				if (areEqual(MapperC.<String>of(MapperS.of("Credit"), MapperS.of("InterestRate"), MapperS.of("Equity"), MapperS.of("Commodity")), MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebook>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebook -> cFTCGuidebook.getAssetClass()), CardinalityOperator.Any).and(areEqual(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).<PriceNotationEnum>map("getSpreadNotation", commonLeg -> commonLeg.getSpreadNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All)).getOrDefault(false)) {
					ifThenElseResult0 = exists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).<ISOCurrencyCodeEnum>map("getSpreadCurrency", commonLeg -> commonLeg.getSpreadCurrency()));
				} else {
					ifThenElseResult0 = notExists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).<ISOCurrencyCodeEnum>map("getSpreadCurrency", commonLeg -> commonLeg.getSpreadCurrency()));
				}
				final ComparisonResult ifThenElseResult1;
				if (areEqual(MapperC.<String>of(MapperS.of("Credit"), MapperS.of("InterestRate"), MapperS.of("Equity"), MapperS.of("Commodity")), MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebook>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebook -> cFTCGuidebook.getAssetClass()), CardinalityOperator.Any).and(areEqual(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).<PriceNotationEnum>map("getSpreadNotation", commonLeg -> commonLeg.getSpreadNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All)).getOrDefault(false)) {
					ifThenElseResult1 = exists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).<ISOCurrencyCodeEnum>map("getSpreadCurrency", commonLeg -> commonLeg.getSpreadCurrency()));
				} else {
					ifThenElseResult1 = notExists(MapperS.of(cFTCPart45TransactionReport).<CommonLeg>map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).<ISOCurrencyCodeEnum>map("getSpreadCurrency", commonLeg -> commonLeg.getSpreadCurrency()));
				}
				return ifThenElseResult0.and(ifThenElseResult1);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart45TransactionReportSpreadCurrencyCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			return Collections.emptyList();
		}
	}
}
