package drr.regulation.cftc.rewrite.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.cftc.rewrite.CFTCNonReportablePart43;
import drr.regulation.common.PartyIdentifierFormatEnum;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class CFTCNonReportablePart43OnlyExistsValidator implements ValidatorWithArg<CFTCNonReportablePart43, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends CFTCNonReportablePart43> ValidationResult<CFTCNonReportablePart43> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("counterparty1Format", ExistenceChecker.isSet((PartyIdentifierFormatEnum) o.getCounterparty1Format()))
				.put("counterparty2Format", ExistenceChecker.isSet((PartyIdentifierFormatEnum) o.getCounterparty2Format()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("CFTCNonReportablePart43", ValidationType.ONLY_EXISTS, "CFTCNonReportablePart43", path, "");
		}
		return failure("CFTCNonReportablePart43", ValidationType.ONLY_EXISTS, "CFTCNonReportablePart43", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
