package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.CFTCEntityClassificationEnum;
import drr.regulation.common.CFTCFederalEntityClassificationEnum;
import drr.regulation.common.CFTCFinancialEntityClassificationEnum;
import drr.regulation.common.CSAPartyInformation;
import drr.regulation.common.CSAPartyInformation.CSAPartyInformationBuilder;
import drr.regulation.common.CSAPartyInformation.CSAPartyInformationBuilderImpl;
import drr.regulation.common.CSAPartyInformation.CSAPartyInformationImpl;
import drr.regulation.common.meta.CSAPartyInformationMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Enriched party information required for reporting a transaction under CSA.
 * @version 6.0.0-dev.128
 */
@RosettaDataType(value="CSAPartyInformation", builder=CSAPartyInformation.CSAPartyInformationBuilderImpl.class, version="6.0.0-dev.128")
@RuneDataType(value="CSAPartyInformation", model="drr", builder=CSAPartyInformation.CSAPartyInformationBuilderImpl.class, version="6.0.0-dev.128")
public interface CSAPartyInformation extends RosettaModelObject {

	CSAPartyInformationMeta metaData = new CSAPartyInformationMeta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Specifies the nature of the type as registered with the CFTC.
	 */
	CFTCEntityClassificationEnum getOrganizationType();
	/**
	 * Indicator of whether counterparty is a federal entity, and which type.
	 */
	CFTCFederalEntityClassificationEnum getFederalEntity();
	/**
	 * Indicator of whether counterparty is a financial entity, and which type.
	 */
	CFTCFinancialEntityClassificationEnum getFinancialEntity();
	/**
	 * Indicator of whether the contract is classified as a physical commodity by referencing one of the contracts described in P43 Appendix B. The approach is consistent with 43.4(c)(4)(ii).
	 */
	Boolean getPhysicalCommodityContractIndicator();
	Boolean getIsUSPerson();
	/**
	 * Specifies whether the portfolio contains non reported transactions.
	 */
	Boolean getNonReportedTradePortfolio();
	/**
	 * Indicator of whether the counterparty is a local counterparty for the jurisdiction.
	 */
	Boolean getLocalCounterparty();

	/*********************** Build Methods  ***********************/
	CSAPartyInformation build();
	
	CSAPartyInformation.CSAPartyInformationBuilder toBuilder();
	
	static CSAPartyInformation.CSAPartyInformationBuilder builder() {
		return new CSAPartyInformation.CSAPartyInformationBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends CSAPartyInformation> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends CSAPartyInformation> getType() {
		return CSAPartyInformation.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("organizationType"), CFTCEntityClassificationEnum.class, getOrganizationType(), this);
		processor.processBasic(path.newSubPath("federalEntity"), CFTCFederalEntityClassificationEnum.class, getFederalEntity(), this);
		processor.processBasic(path.newSubPath("financialEntity"), CFTCFinancialEntityClassificationEnum.class, getFinancialEntity(), this);
		processor.processBasic(path.newSubPath("physicalCommodityContractIndicator"), Boolean.class, getPhysicalCommodityContractIndicator(), this);
		processor.processBasic(path.newSubPath("isUSPerson"), Boolean.class, getIsUSPerson(), this);
		processor.processBasic(path.newSubPath("nonReportedTradePortfolio"), Boolean.class, getNonReportedTradePortfolio(), this);
		processor.processBasic(path.newSubPath("localCounterparty"), Boolean.class, getLocalCounterparty(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface CSAPartyInformationBuilder extends CSAPartyInformation, RosettaModelObjectBuilder {
		CSAPartyInformation.CSAPartyInformationBuilder setOrganizationType(CFTCEntityClassificationEnum organizationType);
		CSAPartyInformation.CSAPartyInformationBuilder setFederalEntity(CFTCFederalEntityClassificationEnum federalEntity);
		CSAPartyInformation.CSAPartyInformationBuilder setFinancialEntity(CFTCFinancialEntityClassificationEnum financialEntity);
		CSAPartyInformation.CSAPartyInformationBuilder setPhysicalCommodityContractIndicator(Boolean physicalCommodityContractIndicator);
		CSAPartyInformation.CSAPartyInformationBuilder setIsUSPerson(Boolean isUSPerson);
		CSAPartyInformation.CSAPartyInformationBuilder setNonReportedTradePortfolio(Boolean nonReportedTradePortfolio);
		CSAPartyInformation.CSAPartyInformationBuilder setLocalCounterparty(Boolean localCounterparty);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("organizationType"), CFTCEntityClassificationEnum.class, getOrganizationType(), this);
			processor.processBasic(path.newSubPath("federalEntity"), CFTCFederalEntityClassificationEnum.class, getFederalEntity(), this);
			processor.processBasic(path.newSubPath("financialEntity"), CFTCFinancialEntityClassificationEnum.class, getFinancialEntity(), this);
			processor.processBasic(path.newSubPath("physicalCommodityContractIndicator"), Boolean.class, getPhysicalCommodityContractIndicator(), this);
			processor.processBasic(path.newSubPath("isUSPerson"), Boolean.class, getIsUSPerson(), this);
			processor.processBasic(path.newSubPath("nonReportedTradePortfolio"), Boolean.class, getNonReportedTradePortfolio(), this);
			processor.processBasic(path.newSubPath("localCounterparty"), Boolean.class, getLocalCounterparty(), this);
		}
		

		CSAPartyInformation.CSAPartyInformationBuilder prune();
	}

	/*********************** Immutable Implementation of CSAPartyInformation  ***********************/
	class CSAPartyInformationImpl implements CSAPartyInformation {
		private final CFTCEntityClassificationEnum organizationType;
		private final CFTCFederalEntityClassificationEnum federalEntity;
		private final CFTCFinancialEntityClassificationEnum financialEntity;
		private final Boolean physicalCommodityContractIndicator;
		private final Boolean isUSPerson;
		private final Boolean nonReportedTradePortfolio;
		private final Boolean localCounterparty;
		
		protected CSAPartyInformationImpl(CSAPartyInformation.CSAPartyInformationBuilder builder) {
			this.organizationType = builder.getOrganizationType();
			this.federalEntity = builder.getFederalEntity();
			this.financialEntity = builder.getFinancialEntity();
			this.physicalCommodityContractIndicator = builder.getPhysicalCommodityContractIndicator();
			this.isUSPerson = builder.getIsUSPerson();
			this.nonReportedTradePortfolio = builder.getNonReportedTradePortfolio();
			this.localCounterparty = builder.getLocalCounterparty();
		}
		
		@Override
		@RosettaAttribute("organizationType")
		@RuneAttribute("organizationType")
		public CFTCEntityClassificationEnum getOrganizationType() {
			return organizationType;
		}
		
		@Override
		@RosettaAttribute("federalEntity")
		@RuneAttribute("federalEntity")
		public CFTCFederalEntityClassificationEnum getFederalEntity() {
			return federalEntity;
		}
		
		@Override
		@RosettaAttribute("financialEntity")
		@RuneAttribute("financialEntity")
		public CFTCFinancialEntityClassificationEnum getFinancialEntity() {
			return financialEntity;
		}
		
		@Override
		@RosettaAttribute("physicalCommodityContractIndicator")
		@RuneAttribute("physicalCommodityContractIndicator")
		public Boolean getPhysicalCommodityContractIndicator() {
			return physicalCommodityContractIndicator;
		}
		
		@Override
		@RosettaAttribute("isUSPerson")
		@RuneAttribute("isUSPerson")
		public Boolean getIsUSPerson() {
			return isUSPerson;
		}
		
		@Override
		@RosettaAttribute("nonReportedTradePortfolio")
		@RuneAttribute("nonReportedTradePortfolio")
		public Boolean getNonReportedTradePortfolio() {
			return nonReportedTradePortfolio;
		}
		
		@Override
		@RosettaAttribute("localCounterparty")
		@RuneAttribute("localCounterparty")
		public Boolean getLocalCounterparty() {
			return localCounterparty;
		}
		
		@Override
		public CSAPartyInformation build() {
			return this;
		}
		
		@Override
		public CSAPartyInformation.CSAPartyInformationBuilder toBuilder() {
			CSAPartyInformation.CSAPartyInformationBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(CSAPartyInformation.CSAPartyInformationBuilder builder) {
			ofNullable(getOrganizationType()).ifPresent(builder::setOrganizationType);
			ofNullable(getFederalEntity()).ifPresent(builder::setFederalEntity);
			ofNullable(getFinancialEntity()).ifPresent(builder::setFinancialEntity);
			ofNullable(getPhysicalCommodityContractIndicator()).ifPresent(builder::setPhysicalCommodityContractIndicator);
			ofNullable(getIsUSPerson()).ifPresent(builder::setIsUSPerson);
			ofNullable(getNonReportedTradePortfolio()).ifPresent(builder::setNonReportedTradePortfolio);
			ofNullable(getLocalCounterparty()).ifPresent(builder::setLocalCounterparty);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CSAPartyInformation _that = getType().cast(o);
		
			if (!Objects.equals(organizationType, _that.getOrganizationType())) return false;
			if (!Objects.equals(federalEntity, _that.getFederalEntity())) return false;
			if (!Objects.equals(financialEntity, _that.getFinancialEntity())) return false;
			if (!Objects.equals(physicalCommodityContractIndicator, _that.getPhysicalCommodityContractIndicator())) return false;
			if (!Objects.equals(isUSPerson, _that.getIsUSPerson())) return false;
			if (!Objects.equals(nonReportedTradePortfolio, _that.getNonReportedTradePortfolio())) return false;
			if (!Objects.equals(localCounterparty, _that.getLocalCounterparty())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (organizationType != null ? organizationType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (federalEntity != null ? federalEntity.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (financialEntity != null ? financialEntity.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (physicalCommodityContractIndicator != null ? physicalCommodityContractIndicator.hashCode() : 0);
			_result = 31 * _result + (isUSPerson != null ? isUSPerson.hashCode() : 0);
			_result = 31 * _result + (nonReportedTradePortfolio != null ? nonReportedTradePortfolio.hashCode() : 0);
			_result = 31 * _result + (localCounterparty != null ? localCounterparty.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CSAPartyInformation {" +
				"organizationType=" + this.organizationType + ", " +
				"federalEntity=" + this.federalEntity + ", " +
				"financialEntity=" + this.financialEntity + ", " +
				"physicalCommodityContractIndicator=" + this.physicalCommodityContractIndicator + ", " +
				"isUSPerson=" + this.isUSPerson + ", " +
				"nonReportedTradePortfolio=" + this.nonReportedTradePortfolio + ", " +
				"localCounterparty=" + this.localCounterparty +
			'}';
		}
	}

	/*********************** Builder Implementation of CSAPartyInformation  ***********************/
	class CSAPartyInformationBuilderImpl implements CSAPartyInformation.CSAPartyInformationBuilder {
	
		protected CFTCEntityClassificationEnum organizationType;
		protected CFTCFederalEntityClassificationEnum federalEntity;
		protected CFTCFinancialEntityClassificationEnum financialEntity;
		protected Boolean physicalCommodityContractIndicator;
		protected Boolean isUSPerson;
		protected Boolean nonReportedTradePortfolio;
		protected Boolean localCounterparty;
		
		@Override
		@RosettaAttribute("organizationType")
		@RuneAttribute("organizationType")
		public CFTCEntityClassificationEnum getOrganizationType() {
			return organizationType;
		}
		
		@Override
		@RosettaAttribute("federalEntity")
		@RuneAttribute("federalEntity")
		public CFTCFederalEntityClassificationEnum getFederalEntity() {
			return federalEntity;
		}
		
		@Override
		@RosettaAttribute("financialEntity")
		@RuneAttribute("financialEntity")
		public CFTCFinancialEntityClassificationEnum getFinancialEntity() {
			return financialEntity;
		}
		
		@Override
		@RosettaAttribute("physicalCommodityContractIndicator")
		@RuneAttribute("physicalCommodityContractIndicator")
		public Boolean getPhysicalCommodityContractIndicator() {
			return physicalCommodityContractIndicator;
		}
		
		@Override
		@RosettaAttribute("isUSPerson")
		@RuneAttribute("isUSPerson")
		public Boolean getIsUSPerson() {
			return isUSPerson;
		}
		
		@Override
		@RosettaAttribute("nonReportedTradePortfolio")
		@RuneAttribute("nonReportedTradePortfolio")
		public Boolean getNonReportedTradePortfolio() {
			return nonReportedTradePortfolio;
		}
		
		@Override
		@RosettaAttribute("localCounterparty")
		@RuneAttribute("localCounterparty")
		public Boolean getLocalCounterparty() {
			return localCounterparty;
		}
		
		@Override
		@RosettaAttribute("organizationType")
		@RuneAttribute("organizationType")
		public CSAPartyInformation.CSAPartyInformationBuilder setOrganizationType(CFTCEntityClassificationEnum _organizationType) {
			this.organizationType = _organizationType == null ? null : _organizationType;
			return this;
		}
		
		@Override
		@RosettaAttribute("federalEntity")
		@RuneAttribute("federalEntity")
		public CSAPartyInformation.CSAPartyInformationBuilder setFederalEntity(CFTCFederalEntityClassificationEnum _federalEntity) {
			this.federalEntity = _federalEntity == null ? null : _federalEntity;
			return this;
		}
		
		@Override
		@RosettaAttribute("financialEntity")
		@RuneAttribute("financialEntity")
		public CSAPartyInformation.CSAPartyInformationBuilder setFinancialEntity(CFTCFinancialEntityClassificationEnum _financialEntity) {
			this.financialEntity = _financialEntity == null ? null : _financialEntity;
			return this;
		}
		
		@Override
		@RosettaAttribute("physicalCommodityContractIndicator")
		@RuneAttribute("physicalCommodityContractIndicator")
		public CSAPartyInformation.CSAPartyInformationBuilder setPhysicalCommodityContractIndicator(Boolean _physicalCommodityContractIndicator) {
			this.physicalCommodityContractIndicator = _physicalCommodityContractIndicator == null ? null : _physicalCommodityContractIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("isUSPerson")
		@RuneAttribute("isUSPerson")
		public CSAPartyInformation.CSAPartyInformationBuilder setIsUSPerson(Boolean _isUSPerson) {
			this.isUSPerson = _isUSPerson == null ? null : _isUSPerson;
			return this;
		}
		
		@Override
		@RosettaAttribute("nonReportedTradePortfolio")
		@RuneAttribute("nonReportedTradePortfolio")
		public CSAPartyInformation.CSAPartyInformationBuilder setNonReportedTradePortfolio(Boolean _nonReportedTradePortfolio) {
			this.nonReportedTradePortfolio = _nonReportedTradePortfolio == null ? null : _nonReportedTradePortfolio;
			return this;
		}
		
		@Override
		@RosettaAttribute("localCounterparty")
		@RuneAttribute("localCounterparty")
		public CSAPartyInformation.CSAPartyInformationBuilder setLocalCounterparty(Boolean _localCounterparty) {
			this.localCounterparty = _localCounterparty == null ? null : _localCounterparty;
			return this;
		}
		
		@Override
		public CSAPartyInformation build() {
			return new CSAPartyInformation.CSAPartyInformationImpl(this);
		}
		
		@Override
		public CSAPartyInformation.CSAPartyInformationBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CSAPartyInformation.CSAPartyInformationBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getOrganizationType()!=null) return true;
			if (getFederalEntity()!=null) return true;
			if (getFinancialEntity()!=null) return true;
			if (getPhysicalCommodityContractIndicator()!=null) return true;
			if (getIsUSPerson()!=null) return true;
			if (getNonReportedTradePortfolio()!=null) return true;
			if (getLocalCounterparty()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CSAPartyInformation.CSAPartyInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			CSAPartyInformation.CSAPartyInformationBuilder o = (CSAPartyInformation.CSAPartyInformationBuilder) other;
			
			
			merger.mergeBasic(getOrganizationType(), o.getOrganizationType(), this::setOrganizationType);
			merger.mergeBasic(getFederalEntity(), o.getFederalEntity(), this::setFederalEntity);
			merger.mergeBasic(getFinancialEntity(), o.getFinancialEntity(), this::setFinancialEntity);
			merger.mergeBasic(getPhysicalCommodityContractIndicator(), o.getPhysicalCommodityContractIndicator(), this::setPhysicalCommodityContractIndicator);
			merger.mergeBasic(getIsUSPerson(), o.getIsUSPerson(), this::setIsUSPerson);
			merger.mergeBasic(getNonReportedTradePortfolio(), o.getNonReportedTradePortfolio(), this::setNonReportedTradePortfolio);
			merger.mergeBasic(getLocalCounterparty(), o.getLocalCounterparty(), this::setLocalCounterparty);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CSAPartyInformation _that = getType().cast(o);
		
			if (!Objects.equals(organizationType, _that.getOrganizationType())) return false;
			if (!Objects.equals(federalEntity, _that.getFederalEntity())) return false;
			if (!Objects.equals(financialEntity, _that.getFinancialEntity())) return false;
			if (!Objects.equals(physicalCommodityContractIndicator, _that.getPhysicalCommodityContractIndicator())) return false;
			if (!Objects.equals(isUSPerson, _that.getIsUSPerson())) return false;
			if (!Objects.equals(nonReportedTradePortfolio, _that.getNonReportedTradePortfolio())) return false;
			if (!Objects.equals(localCounterparty, _that.getLocalCounterparty())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (organizationType != null ? organizationType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (federalEntity != null ? federalEntity.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (financialEntity != null ? financialEntity.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (physicalCommodityContractIndicator != null ? physicalCommodityContractIndicator.hashCode() : 0);
			_result = 31 * _result + (isUSPerson != null ? isUSPerson.hashCode() : 0);
			_result = 31 * _result + (nonReportedTradePortfolio != null ? nonReportedTradePortfolio.hashCode() : 0);
			_result = 31 * _result + (localCounterparty != null ? localCounterparty.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CSAPartyInformationBuilder {" +
				"organizationType=" + this.organizationType + ", " +
				"federalEntity=" + this.federalEntity + ", " +
				"financialEntity=" + this.financialEntity + ", " +
				"physicalCommodityContractIndicator=" + this.physicalCommodityContractIndicator + ", " +
				"isUSPerson=" + this.isUSPerson + ", " +
				"nonReportedTradePortfolio=" + this.nonReportedTradePortfolio + ", " +
				"localCounterparty=" + this.localCounterparty +
			'}';
		}
	}
}
