package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.CommonTransactionInformation;
import drr.regulation.common.CommonTransactionInformation.CommonTransactionInformationBuilder;
import drr.regulation.common.CommonTransactionInformation.CommonTransactionInformationBuilderImpl;
import drr.regulation.common.CommonTransactionInformation.CommonTransactionInformationImpl;
import drr.regulation.common.TradableOnTradingVenueEnum;
import drr.regulation.common.meta.CommonTransactionInformationMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataType(value="CommonTransactionInformation", builder=CommonTransactionInformation.CommonTransactionInformationBuilderImpl.class, version="6.0.0-dev.128")
@RuneDataType(value="CommonTransactionInformation", model="drr", builder=CommonTransactionInformation.CommonTransactionInformationBuilderImpl.class, version="6.0.0-dev.128")
public interface CommonTransactionInformation extends RosettaModelObject {

	CommonTransactionInformationMeta metaData = new CommonTransactionInformationMeta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Whether the financial instrument is admitted to trading, or traded on a trading venue or for which a request for admission was made.
	 */
	TradableOnTradingVenueEnum getTradableOnTradingVenue();
	/**
	 * Indicator of whether the product underlier of the reportable trade is traded on a trading venue.
	 */
	Boolean getUnderlierTradedOnTradingVenue();

	/*********************** Build Methods  ***********************/
	CommonTransactionInformation build();
	
	CommonTransactionInformation.CommonTransactionInformationBuilder toBuilder();
	
	static CommonTransactionInformation.CommonTransactionInformationBuilder builder() {
		return new CommonTransactionInformation.CommonTransactionInformationBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends CommonTransactionInformation> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends CommonTransactionInformation> getType() {
		return CommonTransactionInformation.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("tradableOnTradingVenue"), TradableOnTradingVenueEnum.class, getTradableOnTradingVenue(), this);
		processor.processBasic(path.newSubPath("underlierTradedOnTradingVenue"), Boolean.class, getUnderlierTradedOnTradingVenue(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface CommonTransactionInformationBuilder extends CommonTransactionInformation, RosettaModelObjectBuilder {
		CommonTransactionInformation.CommonTransactionInformationBuilder setTradableOnTradingVenue(TradableOnTradingVenueEnum tradableOnTradingVenue);
		CommonTransactionInformation.CommonTransactionInformationBuilder setUnderlierTradedOnTradingVenue(Boolean underlierTradedOnTradingVenue);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("tradableOnTradingVenue"), TradableOnTradingVenueEnum.class, getTradableOnTradingVenue(), this);
			processor.processBasic(path.newSubPath("underlierTradedOnTradingVenue"), Boolean.class, getUnderlierTradedOnTradingVenue(), this);
		}
		

		CommonTransactionInformation.CommonTransactionInformationBuilder prune();
	}

	/*********************** Immutable Implementation of CommonTransactionInformation  ***********************/
	class CommonTransactionInformationImpl implements CommonTransactionInformation {
		private final TradableOnTradingVenueEnum tradableOnTradingVenue;
		private final Boolean underlierTradedOnTradingVenue;
		
		protected CommonTransactionInformationImpl(CommonTransactionInformation.CommonTransactionInformationBuilder builder) {
			this.tradableOnTradingVenue = builder.getTradableOnTradingVenue();
			this.underlierTradedOnTradingVenue = builder.getUnderlierTradedOnTradingVenue();
		}
		
		@Override
		@RosettaAttribute("tradableOnTradingVenue")
		@RuneAttribute("tradableOnTradingVenue")
		public TradableOnTradingVenueEnum getTradableOnTradingVenue() {
			return tradableOnTradingVenue;
		}
		
		@Override
		@RosettaAttribute("underlierTradedOnTradingVenue")
		@RuneAttribute("underlierTradedOnTradingVenue")
		public Boolean getUnderlierTradedOnTradingVenue() {
			return underlierTradedOnTradingVenue;
		}
		
		@Override
		public CommonTransactionInformation build() {
			return this;
		}
		
		@Override
		public CommonTransactionInformation.CommonTransactionInformationBuilder toBuilder() {
			CommonTransactionInformation.CommonTransactionInformationBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(CommonTransactionInformation.CommonTransactionInformationBuilder builder) {
			ofNullable(getTradableOnTradingVenue()).ifPresent(builder::setTradableOnTradingVenue);
			ofNullable(getUnderlierTradedOnTradingVenue()).ifPresent(builder::setUnderlierTradedOnTradingVenue);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CommonTransactionInformation _that = getType().cast(o);
		
			if (!Objects.equals(tradableOnTradingVenue, _that.getTradableOnTradingVenue())) return false;
			if (!Objects.equals(underlierTradedOnTradingVenue, _that.getUnderlierTradedOnTradingVenue())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (tradableOnTradingVenue != null ? tradableOnTradingVenue.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (underlierTradedOnTradingVenue != null ? underlierTradedOnTradingVenue.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CommonTransactionInformation {" +
				"tradableOnTradingVenue=" + this.tradableOnTradingVenue + ", " +
				"underlierTradedOnTradingVenue=" + this.underlierTradedOnTradingVenue +
			'}';
		}
	}

	/*********************** Builder Implementation of CommonTransactionInformation  ***********************/
	class CommonTransactionInformationBuilderImpl implements CommonTransactionInformation.CommonTransactionInformationBuilder {
	
		protected TradableOnTradingVenueEnum tradableOnTradingVenue;
		protected Boolean underlierTradedOnTradingVenue;
		
		@Override
		@RosettaAttribute("tradableOnTradingVenue")
		@RuneAttribute("tradableOnTradingVenue")
		public TradableOnTradingVenueEnum getTradableOnTradingVenue() {
			return tradableOnTradingVenue;
		}
		
		@Override
		@RosettaAttribute("underlierTradedOnTradingVenue")
		@RuneAttribute("underlierTradedOnTradingVenue")
		public Boolean getUnderlierTradedOnTradingVenue() {
			return underlierTradedOnTradingVenue;
		}
		
		@Override
		@RosettaAttribute("tradableOnTradingVenue")
		@RuneAttribute("tradableOnTradingVenue")
		public CommonTransactionInformation.CommonTransactionInformationBuilder setTradableOnTradingVenue(TradableOnTradingVenueEnum _tradableOnTradingVenue) {
			this.tradableOnTradingVenue = _tradableOnTradingVenue == null ? null : _tradableOnTradingVenue;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlierTradedOnTradingVenue")
		@RuneAttribute("underlierTradedOnTradingVenue")
		public CommonTransactionInformation.CommonTransactionInformationBuilder setUnderlierTradedOnTradingVenue(Boolean _underlierTradedOnTradingVenue) {
			this.underlierTradedOnTradingVenue = _underlierTradedOnTradingVenue == null ? null : _underlierTradedOnTradingVenue;
			return this;
		}
		
		@Override
		public CommonTransactionInformation build() {
			return new CommonTransactionInformation.CommonTransactionInformationImpl(this);
		}
		
		@Override
		public CommonTransactionInformation.CommonTransactionInformationBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CommonTransactionInformation.CommonTransactionInformationBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getTradableOnTradingVenue()!=null) return true;
			if (getUnderlierTradedOnTradingVenue()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CommonTransactionInformation.CommonTransactionInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			CommonTransactionInformation.CommonTransactionInformationBuilder o = (CommonTransactionInformation.CommonTransactionInformationBuilder) other;
			
			
			merger.mergeBasic(getTradableOnTradingVenue(), o.getTradableOnTradingVenue(), this::setTradableOnTradingVenue);
			merger.mergeBasic(getUnderlierTradedOnTradingVenue(), o.getUnderlierTradedOnTradingVenue(), this::setUnderlierTradedOnTradingVenue);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CommonTransactionInformation _that = getType().cast(o);
		
			if (!Objects.equals(tradableOnTradingVenue, _that.getTradableOnTradingVenue())) return false;
			if (!Objects.equals(underlierTradedOnTradingVenue, _that.getUnderlierTradedOnTradingVenue())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (tradableOnTradingVenue != null ? tradableOnTradingVenue.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (underlierTradedOnTradingVenue != null ? underlierTradedOnTradingVenue.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CommonTransactionInformationBuilder {" +
				"tradableOnTradingVenue=" + this.tradableOnTradingVenue + ", " +
				"underlierTradedOnTradingVenue=" + this.underlierTradedOnTradingVenue +
			'}';
		}
	}
}
