package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.HKMAPartyInformation;
import drr.regulation.common.HKMAPartyInformation.HKMAPartyInformationBuilder;
import drr.regulation.common.HKMAPartyInformation.HKMAPartyInformationBuilderImpl;
import drr.regulation.common.HKMAPartyInformation.HKMAPartyInformationImpl;
import drr.regulation.common.meta.HKMAPartyInformationMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Enriched party information required for reporting a transaction under HKMA.
 * @version 6.0.0-dev.128
 */
@RosettaDataType(value="HKMAPartyInformation", builder=HKMAPartyInformation.HKMAPartyInformationBuilderImpl.class, version="6.0.0-dev.128")
@RuneDataType(value="HKMAPartyInformation", model="drr", builder=HKMAPartyInformation.HKMAPartyInformationBuilderImpl.class, version="6.0.0-dev.128")
public interface HKMAPartyInformation extends RosettaModelObject {

	HKMAPartyInformationMeta metaData = new HKMAPartyInformationMeta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Specifies whether the portfolio contains non reported transactions.
	 */
	Boolean getNonReportedTradePortfolio();

	/*********************** Build Methods  ***********************/
	HKMAPartyInformation build();
	
	HKMAPartyInformation.HKMAPartyInformationBuilder toBuilder();
	
	static HKMAPartyInformation.HKMAPartyInformationBuilder builder() {
		return new HKMAPartyInformation.HKMAPartyInformationBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends HKMAPartyInformation> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends HKMAPartyInformation> getType() {
		return HKMAPartyInformation.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("nonReportedTradePortfolio"), Boolean.class, getNonReportedTradePortfolio(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface HKMAPartyInformationBuilder extends HKMAPartyInformation, RosettaModelObjectBuilder {
		HKMAPartyInformation.HKMAPartyInformationBuilder setNonReportedTradePortfolio(Boolean nonReportedTradePortfolio);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("nonReportedTradePortfolio"), Boolean.class, getNonReportedTradePortfolio(), this);
		}
		

		HKMAPartyInformation.HKMAPartyInformationBuilder prune();
	}

	/*********************** Immutable Implementation of HKMAPartyInformation  ***********************/
	class HKMAPartyInformationImpl implements HKMAPartyInformation {
		private final Boolean nonReportedTradePortfolio;
		
		protected HKMAPartyInformationImpl(HKMAPartyInformation.HKMAPartyInformationBuilder builder) {
			this.nonReportedTradePortfolio = builder.getNonReportedTradePortfolio();
		}
		
		@Override
		@RosettaAttribute("nonReportedTradePortfolio")
		@RuneAttribute("nonReportedTradePortfolio")
		public Boolean getNonReportedTradePortfolio() {
			return nonReportedTradePortfolio;
		}
		
		@Override
		public HKMAPartyInformation build() {
			return this;
		}
		
		@Override
		public HKMAPartyInformation.HKMAPartyInformationBuilder toBuilder() {
			HKMAPartyInformation.HKMAPartyInformationBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(HKMAPartyInformation.HKMAPartyInformationBuilder builder) {
			ofNullable(getNonReportedTradePortfolio()).ifPresent(builder::setNonReportedTradePortfolio);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			HKMAPartyInformation _that = getType().cast(o);
		
			if (!Objects.equals(nonReportedTradePortfolio, _that.getNonReportedTradePortfolio())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (nonReportedTradePortfolio != null ? nonReportedTradePortfolio.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "HKMAPartyInformation {" +
				"nonReportedTradePortfolio=" + this.nonReportedTradePortfolio +
			'}';
		}
	}

	/*********************** Builder Implementation of HKMAPartyInformation  ***********************/
	class HKMAPartyInformationBuilderImpl implements HKMAPartyInformation.HKMAPartyInformationBuilder {
	
		protected Boolean nonReportedTradePortfolio;
		
		@Override
		@RosettaAttribute("nonReportedTradePortfolio")
		@RuneAttribute("nonReportedTradePortfolio")
		public Boolean getNonReportedTradePortfolio() {
			return nonReportedTradePortfolio;
		}
		
		@Override
		@RosettaAttribute("nonReportedTradePortfolio")
		@RuneAttribute("nonReportedTradePortfolio")
		public HKMAPartyInformation.HKMAPartyInformationBuilder setNonReportedTradePortfolio(Boolean _nonReportedTradePortfolio) {
			this.nonReportedTradePortfolio = _nonReportedTradePortfolio == null ? null : _nonReportedTradePortfolio;
			return this;
		}
		
		@Override
		public HKMAPartyInformation build() {
			return new HKMAPartyInformation.HKMAPartyInformationImpl(this);
		}
		
		@Override
		public HKMAPartyInformation.HKMAPartyInformationBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public HKMAPartyInformation.HKMAPartyInformationBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getNonReportedTradePortfolio()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public HKMAPartyInformation.HKMAPartyInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			HKMAPartyInformation.HKMAPartyInformationBuilder o = (HKMAPartyInformation.HKMAPartyInformationBuilder) other;
			
			
			merger.mergeBasic(getNonReportedTradePortfolio(), o.getNonReportedTradePortfolio(), this::setNonReportedTradePortfolio);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			HKMAPartyInformation _that = getType().cast(o);
		
			if (!Objects.equals(nonReportedTradePortfolio, _that.getNonReportedTradePortfolio())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (nonReportedTradePortfolio != null ? nonReportedTradePortfolio.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "HKMAPartyInformationBuilder {" +
				"nonReportedTradePortfolio=" + this.nonReportedTradePortfolio +
			'}';
		}
	}
}
