package drr.regulation.common;

import cdm.event.common.CounterpartyPositionState;
import cdm.event.common.CounterpartyPositionState.CounterpartyPositionStateBuilder;
import cdm.event.common.TradeState;
import cdm.event.common.TradeState.TradeStateBuilder;
import cdm.event.workflow.WorkflowStep;
import cdm.event.workflow.WorkflowStep.WorkflowStepBuilder;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableEvent.ReportableEventBuilder;
import drr.regulation.common.ReportableEvent.ReportableEventBuilderImpl;
import drr.regulation.common.ReportableEvent.ReportableEventImpl;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportableInformation.ReportableInformationBuilder;
import drr.regulation.common.ReportingSide;
import drr.regulation.common.ReportingSide.ReportingSideBuilder;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.TransactionReportInstruction.TransactionReportInstructionBuilder;
import drr.regulation.common.TransactionReportInstruction.TransactionReportInstructionBuilderImpl;
import drr.regulation.common.TransactionReportInstruction.TransactionReportInstructionImpl;
import drr.regulation.common.meta.TransactionReportInstructionMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Specifies a reportable event with with a single reporting side.
 * @version 6.0.0-dev.128
 */
@RosettaDataType(value="TransactionReportInstruction", builder=TransactionReportInstruction.TransactionReportInstructionBuilderImpl.class, version="6.0.0-dev.128")
@RuneDataType(value="TransactionReportInstruction", model="drr", builder=TransactionReportInstruction.TransactionReportInstructionBuilderImpl.class, version="6.0.0-dev.128")
public interface TransactionReportInstruction extends ReportableEvent {

	TransactionReportInstructionMeta metaData = new TransactionReportInstructionMeta();

	/*********************** Getter Methods  ***********************/
	ReportingSide getReportingSide();

	/*********************** Build Methods  ***********************/
	TransactionReportInstruction build();
	
	TransactionReportInstruction.TransactionReportInstructionBuilder toBuilder();
	
	static TransactionReportInstruction.TransactionReportInstructionBuilder builder() {
		return new TransactionReportInstruction.TransactionReportInstructionBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends TransactionReportInstruction> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends TransactionReportInstruction> getType() {
		return TransactionReportInstruction.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("originatingWorkflowStep"), processor, WorkflowStep.class, getOriginatingWorkflowStep());
		processRosetta(path.newSubPath("reportableTrade"), processor, TradeState.class, getReportableTrade());
		processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.class, getReportableInformation());
		processRosetta(path.newSubPath("reportablePosition"), processor, CounterpartyPositionState.class, getReportablePosition());
		processRosetta(path.newSubPath("reportingSide"), processor, ReportingSide.class, getReportingSide());
	}
	

	/*********************** Builder Interface  ***********************/
	interface TransactionReportInstructionBuilder extends TransactionReportInstruction, ReportableEvent.ReportableEventBuilder {
		ReportingSide.ReportingSideBuilder getOrCreateReportingSide();
		@Override
		ReportingSide.ReportingSideBuilder getReportingSide();
		@Override
		TransactionReportInstruction.TransactionReportInstructionBuilder setOriginatingWorkflowStep(WorkflowStep originatingWorkflowStep);
		@Override
		TransactionReportInstruction.TransactionReportInstructionBuilder setReportableTrade(TradeState reportableTrade);
		@Override
		TransactionReportInstruction.TransactionReportInstructionBuilder setReportableInformation(ReportableInformation reportableInformation);
		@Override
		TransactionReportInstruction.TransactionReportInstructionBuilder setReportablePosition(CounterpartyPositionState reportablePosition);
		TransactionReportInstruction.TransactionReportInstructionBuilder setReportingSide(ReportingSide reportingSide);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("originatingWorkflowStep"), processor, WorkflowStep.WorkflowStepBuilder.class, getOriginatingWorkflowStep());
			processRosetta(path.newSubPath("reportableTrade"), processor, TradeState.TradeStateBuilder.class, getReportableTrade());
			processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.ReportableInformationBuilder.class, getReportableInformation());
			processRosetta(path.newSubPath("reportablePosition"), processor, CounterpartyPositionState.CounterpartyPositionStateBuilder.class, getReportablePosition());
			processRosetta(path.newSubPath("reportingSide"), processor, ReportingSide.ReportingSideBuilder.class, getReportingSide());
		}
		

		TransactionReportInstruction.TransactionReportInstructionBuilder prune();
	}

	/*********************** Immutable Implementation of TransactionReportInstruction  ***********************/
	class TransactionReportInstructionImpl extends ReportableEvent.ReportableEventImpl implements TransactionReportInstruction {
		private final ReportingSide reportingSide;
		
		protected TransactionReportInstructionImpl(TransactionReportInstruction.TransactionReportInstructionBuilder builder) {
			super(builder);
			this.reportingSide = ofNullable(builder.getReportingSide()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("reportingSide")
		@RuneAttribute("reportingSide")
		public ReportingSide getReportingSide() {
			return reportingSide;
		}
		
		@Override
		public TransactionReportInstruction build() {
			return this;
		}
		
		@Override
		public TransactionReportInstruction.TransactionReportInstructionBuilder toBuilder() {
			TransactionReportInstruction.TransactionReportInstructionBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(TransactionReportInstruction.TransactionReportInstructionBuilder builder) {
			super.setBuilderFields(builder);
			ofNullable(getReportingSide()).ifPresent(builder::setReportingSide);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			TransactionReportInstruction _that = getType().cast(o);
		
			if (!Objects.equals(reportingSide, _that.getReportingSide())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (reportingSide != null ? reportingSide.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "TransactionReportInstruction {" +
				"reportingSide=" + this.reportingSide +
			'}' + " " + super.toString();
		}
	}

	/*********************** Builder Implementation of TransactionReportInstruction  ***********************/
	class TransactionReportInstructionBuilderImpl extends ReportableEvent.ReportableEventBuilderImpl implements TransactionReportInstruction.TransactionReportInstructionBuilder {
	
		protected ReportingSide.ReportingSideBuilder reportingSide;
		
		@Override
		@RosettaAttribute("reportingSide")
		@RuneAttribute("reportingSide")
		public ReportingSide.ReportingSideBuilder getReportingSide() {
			return reportingSide;
		}
		
		@Override
		public ReportingSide.ReportingSideBuilder getOrCreateReportingSide() {
			ReportingSide.ReportingSideBuilder result;
			if (reportingSide!=null) {
				result = reportingSide;
			}
			else {
				result = reportingSide = ReportingSide.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("originatingWorkflowStep")
		@RuneAttribute("originatingWorkflowStep")
		public TransactionReportInstruction.TransactionReportInstructionBuilder setOriginatingWorkflowStep(WorkflowStep _originatingWorkflowStep) {
			this.originatingWorkflowStep = _originatingWorkflowStep == null ? null : _originatingWorkflowStep.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("reportableTrade")
		@RuneAttribute("reportableTrade")
		public TransactionReportInstruction.TransactionReportInstructionBuilder setReportableTrade(TradeState _reportableTrade) {
			this.reportableTrade = _reportableTrade == null ? null : _reportableTrade.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("reportableInformation")
		@RuneAttribute("reportableInformation")
		public TransactionReportInstruction.TransactionReportInstructionBuilder setReportableInformation(ReportableInformation _reportableInformation) {
			this.reportableInformation = _reportableInformation == null ? null : _reportableInformation.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("reportablePosition")
		@RuneAttribute("reportablePosition")
		public TransactionReportInstruction.TransactionReportInstructionBuilder setReportablePosition(CounterpartyPositionState _reportablePosition) {
			this.reportablePosition = _reportablePosition == null ? null : _reportablePosition.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("reportingSide")
		@RuneAttribute("reportingSide")
		public TransactionReportInstruction.TransactionReportInstructionBuilder setReportingSide(ReportingSide _reportingSide) {
			this.reportingSide = _reportingSide == null ? null : _reportingSide.toBuilder();
			return this;
		}
		
		@Override
		public TransactionReportInstruction build() {
			return new TransactionReportInstruction.TransactionReportInstructionImpl(this);
		}
		
		@Override
		public TransactionReportInstruction.TransactionReportInstructionBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public TransactionReportInstruction.TransactionReportInstructionBuilder prune() {
			super.prune();
			if (reportingSide!=null && !reportingSide.prune().hasData()) reportingSide = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (super.hasData()) return true;
			if (getReportingSide()!=null && getReportingSide().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public TransactionReportInstruction.TransactionReportInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			super.merge(other, merger);
			
			TransactionReportInstruction.TransactionReportInstructionBuilder o = (TransactionReportInstruction.TransactionReportInstructionBuilder) other;
			
			merger.mergeRosetta(getReportingSide(), o.getReportingSide(), this::setReportingSide);
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			TransactionReportInstruction _that = getType().cast(o);
		
			if (!Objects.equals(reportingSide, _that.getReportingSide())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (reportingSide != null ? reportingSide.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "TransactionReportInstructionBuilder {" +
				"reportingSide=" + this.reportingSide +
			'}' + " " + super.toString();
		}
	}
}
