package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.metafields.FieldWithMetaCommodity;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.observable.asset.Observable;
import cdm.product.asset.CommodityPayout;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.common.settlement.PriceQuantity.PriceQuantityBuilder;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.template.Product;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(CommodityObservablePriceQuantity.CommodityObservablePriceQuantityDefault.class)
public abstract class CommodityObservablePriceQuantity implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected GetQuantityKeys getQuantityKeys;
	@Inject protected GetQuantityReference getQuantityReference;

	/**
	* @param tradeLot 
	* @param commodityPayout 
	* @return priceQuantity 
	*/
	public PriceQuantity evaluate(TradeLot tradeLot, CommodityPayout commodityPayout) {
		PriceQuantity.PriceQuantityBuilder priceQuantityBuilder = doEvaluate(tradeLot, commodityPayout);
		
		final PriceQuantity priceQuantity;
		if (priceQuantityBuilder == null) {
			priceQuantity = null;
		} else {
			priceQuantity = priceQuantityBuilder.build();
			objectValidator.validate(PriceQuantity.class, priceQuantity);
		}
		
		return priceQuantity;
	}

	protected abstract PriceQuantity.PriceQuantityBuilder doEvaluate(TradeLot tradeLot, CommodityPayout commodityPayout);

	protected abstract MapperS<? extends PriceQuantity> priceQuantityWithMatchingObservable(TradeLot tradeLot, CommodityPayout commodityPayout);

	protected abstract MapperS<? extends PriceQuantity> priceQuantityWithMatchingKey(TradeLot tradeLot, CommodityPayout commodityPayout);

	public static class CommodityObservablePriceQuantityDefault extends CommodityObservablePriceQuantity {
		@Override
		protected PriceQuantity.PriceQuantityBuilder doEvaluate(TradeLot tradeLot, CommodityPayout commodityPayout) {
			PriceQuantity.PriceQuantityBuilder priceQuantity = PriceQuantity.builder();
			return assignOutput(priceQuantity, tradeLot, commodityPayout);
		}
		
		protected PriceQuantity.PriceQuantityBuilder assignOutput(PriceQuantity.PriceQuantityBuilder priceQuantity, TradeLot tradeLot, CommodityPayout commodityPayout) {
			if (exists(priceQuantityWithMatchingObservable(tradeLot, commodityPayout)).getOrDefault(false)) {
				priceQuantity = toBuilder(priceQuantityWithMatchingObservable(tradeLot, commodityPayout).get());
			} else {
				priceQuantity = toBuilder(priceQuantityWithMatchingKey(tradeLot, commodityPayout).get());
			}
			
			return Optional.ofNullable(priceQuantity)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperS<? extends PriceQuantity> priceQuantityWithMatchingObservable(TradeLot tradeLot, CommodityPayout commodityPayout) {
			final MapperC<PriceQuantity> thenArg0 = MapperS.of(tradeLot).<PriceQuantity>mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity());
			final MapperC<PriceQuantity> thenArg1 = thenArg0
				.filterItemNullSafe(item -> areEqual(item.<Observable>map("getObservable", priceQuantity -> priceQuantity.getObservable()).<FieldWithMetaCommodity>map("getCommodity", observable -> observable.getCommodity()).<Commodity>map("Type coercion", fieldWithMetaCommodity -> fieldWithMetaCommodity == null ? null : fieldWithMetaCommodity.getValue()), MapperS.of(commodityPayout).<Product>map("getUnderlier", _commodityPayout -> _commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", product -> product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()), CardinalityOperator.All).get());
			return MapperS.of(thenArg1.get());
		}
		
		@Override
		protected MapperS<? extends PriceQuantity> priceQuantityWithMatchingKey(TradeLot tradeLot, CommodityPayout commodityPayout) {
			final MapperC<PriceQuantity> thenArg = MapperS.of(tradeLot).<PriceQuantity>mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity())
				.filterItemNullSafe(item -> contains(MapperC.<String>of(getQuantityKeys.evaluate(item.get())), MapperS.of(getQuantityReference.evaluate(MapperS.of(commodityPayout).<ResolvablePriceQuantity>map("getPriceQuantity", _commodityPayout -> _commodityPayout.getPriceQuantity()).get()))).get());
			return MapperS.of(thenArg.get());
		}
	}
}
