package drr.regulation.common.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.product.asset.ForeignExchange;
import cdm.product.common.settlement.Cashflow;
import cdm.product.common.settlement.Cashflow.CashflowBuilder;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.template.ForwardPayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(FXSwapLeg2.FXSwapLeg2Default.class)
public abstract class FXSwapLeg2 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected FXFarLeg fXFarLeg;

	/**
	* @param product 
	* @return fxLeg2 
	*/
	public Cashflow evaluate(Product product) {
		Cashflow.CashflowBuilder fxLeg2Builder = doEvaluate(product);
		
		final Cashflow fxLeg2;
		if (fxLeg2Builder == null) {
			fxLeg2 = null;
		} else {
			fxLeg2 = fxLeg2Builder.build();
			objectValidator.validate(Cashflow.class, fxLeg2);
		}
		
		return fxLeg2;
	}

	protected abstract Cashflow.CashflowBuilder doEvaluate(Product product);

	protected abstract MapperS<? extends ForwardPayout> farLeg(Product product);

	public static class FXSwapLeg2Default extends FXSwapLeg2 {
		@Override
		protected Cashflow.CashflowBuilder doEvaluate(Product product) {
			Cashflow.CashflowBuilder fxLeg2 = Cashflow.builder();
			return assignOutput(fxLeg2, product);
		}
		
		protected Cashflow.CashflowBuilder assignOutput(Cashflow.CashflowBuilder fxLeg2, Product product) {
			fxLeg2 = toBuilder(MapperC.<Cashflow>of(farLeg(product).<Product>map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).<ForeignExchange>map("getForeignExchange", _product -> _product.getForeignExchange()).<Cashflow>map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()), farLeg(product).<Product>map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).<ForeignExchange>map("getForeignExchange", _product -> _product.getForeignExchange()).<Cashflow>map("getExchangedCurrency2", foreignExchange -> foreignExchange.getExchangedCurrency2()))
				.max(item -> item.<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString == null ? null : fieldWithMetaString.getValue())).get());
			
			return Optional.ofNullable(fxLeg2)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperS<? extends ForwardPayout> farLeg(Product product) {
			return MapperS.of(fXFarLeg.evaluate(product));
		}
	}
}
