package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.PartyInformation.PartyInformationBuilder;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(FilterPartyInformationBySupervisoryBody.FilterPartyInformationBySupervisoryBodyDefault.class)
public abstract class FilterPartyInformationBySupervisoryBody implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param partyInformation 
	* @param jurisdiction 
	* @return filteredPartyInformation 
	*/
	public List<? extends PartyInformation> evaluate(List<? extends PartyInformation> partyInformation, SupervisoryBodyEnum jurisdiction) {
		List<PartyInformation.PartyInformationBuilder> filteredPartyInformationBuilder = doEvaluate(partyInformation, jurisdiction);
		
		final List<? extends PartyInformation> filteredPartyInformation;
		if (filteredPartyInformationBuilder == null) {
			filteredPartyInformation = null;
		} else {
			filteredPartyInformation = filteredPartyInformationBuilder.stream().map(PartyInformation::build).collect(Collectors.toList());
			objectValidator.validate(PartyInformation.class, filteredPartyInformation);
		}
		
		return filteredPartyInformation;
	}

	protected abstract List<PartyInformation.PartyInformationBuilder> doEvaluate(List<? extends PartyInformation> partyInformation, SupervisoryBodyEnum jurisdiction);

	public static class FilterPartyInformationBySupervisoryBodyDefault extends FilterPartyInformationBySupervisoryBody {
		@Override
		protected List<PartyInformation.PartyInformationBuilder> doEvaluate(List<? extends PartyInformation> partyInformation, SupervisoryBodyEnum jurisdiction) {
			if (partyInformation == null) {
				partyInformation = Collections.emptyList();
			}
			List<PartyInformation.PartyInformationBuilder> filteredPartyInformation = new ArrayList<>();
			return assignOutput(filteredPartyInformation, partyInformation, jurisdiction);
		}
		
		protected List<PartyInformation.PartyInformationBuilder> assignOutput(List<PartyInformation.PartyInformationBuilder> filteredPartyInformation, List<? extends PartyInformation> partyInformation, SupervisoryBodyEnum jurisdiction) {
			filteredPartyInformation.addAll(toBuilder(MapperC.<PartyInformation>of(partyInformation)
				.filterItemNullSafe(item -> areEqual(item.<ReportingRegime>mapC("getRegimeInformation", _partyInformation -> _partyInformation.getRegimeInformation()).<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum.getValue()), MapperS.of(jurisdiction), CardinalityOperator.Any).get()).getMulti()));
			
			return Optional.ofNullable(filteredPartyInformation)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
