package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.metafields.FieldWithMetaCommodity;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.base.staticdata.asset.rates.InflationRateIndexEnum;
import cdm.base.staticdata.asset.rates.metafields.FieldWithMetaFloatingRateIndexEnum;
import cdm.base.staticdata.asset.rates.metafields.FieldWithMetaInflationRateIndexEnum;
import cdm.event.common.Reset;
import cdm.event.common.Reset.ResetBuilder;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.Observable;
import cdm.observable.asset.metafields.FieldWithMetaFloatingRateOption;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.observable.event.Observation;
import cdm.observable.event.ObservationIdentifier;
import cdm.observable.event.metafields.ReferenceWithMetaObservation;
import cdm.product.asset.CommodityPayout;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.PayoutLegWithAuxiliary;
import drr.regulation.common.ReportableEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(FilterResetHistoryByLeg.FilterResetHistoryByLegDefault.class)
public abstract class FilterResetHistoryByLeg implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected TradeStateForEvent tradeStateForEvent;

	/**
	* @param reportableEvent 
	* @param payoutLeg 
	* @return resetHistory 
	*/
	public List<? extends Reset> evaluate(ReportableEvent reportableEvent, PayoutLegWithAuxiliary payoutLeg) {
		List<Reset.ResetBuilder> resetHistoryBuilder = doEvaluate(reportableEvent, payoutLeg);
		
		final List<? extends Reset> resetHistory;
		if (resetHistoryBuilder == null) {
			resetHistory = null;
		} else {
			resetHistory = resetHistoryBuilder.stream().map(Reset::build).collect(Collectors.toList());
			objectValidator.validate(Reset.class, resetHistory);
		}
		
		return resetHistory;
	}

	protected abstract List<Reset.ResetBuilder> doEvaluate(ReportableEvent reportableEvent, PayoutLegWithAuxiliary payoutLeg);

	public static class FilterResetHistoryByLegDefault extends FilterResetHistoryByLeg {
		@Override
		protected List<Reset.ResetBuilder> doEvaluate(ReportableEvent reportableEvent, PayoutLegWithAuxiliary payoutLeg) {
			List<Reset.ResetBuilder> resetHistory = new ArrayList<>();
			return assignOutput(resetHistory, reportableEvent, payoutLeg);
		}
		
		protected List<Reset.ResetBuilder> assignOutput(List<Reset.ResetBuilder> resetHistory, ReportableEvent reportableEvent, PayoutLegWithAuxiliary payoutLeg) {
			if (exists(MapperS.of(tradeStateForEvent.evaluate(reportableEvent)).<Reset>mapC("getResetHistory", tradeState -> tradeState.getResetHistory()).<ReferenceWithMetaObservation>mapC("getObservations", reset -> reset.getObservations()).<Observation>map("Type coercion", referenceWithMetaObservation -> referenceWithMetaObservation.getValue()).<ObservationIdentifier>map("getObservationIdentifier", observation -> observation.getObservationIdentifier()).<Observable>map("getObservable", observationIdentifier -> observationIdentifier.getObservable()).<FieldWithMetaFloatingRateOption>map("getRateOption", observable -> observable.getRateOption())).getOrDefault(false)) {
				resetHistory.addAll(toBuilder(MapperS.of(tradeStateForEvent.evaluate(reportableEvent)).<Reset>mapC("getResetHistory", tradeState -> tradeState.getResetHistory())
					.filterItemNullSafe(item -> areEqual(item.<ReferenceWithMetaObservation>mapC("getObservations", reset -> reset.getObservations()).<Observation>map("Type coercion", referenceWithMetaObservation -> referenceWithMetaObservation.getValue()).<ObservationIdentifier>map("getObservationIdentifier", observation -> observation.getObservationIdentifier()).<Observable>map("getObservable", observationIdentifier -> observationIdentifier.getObservable()).<FieldWithMetaFloatingRateOption>map("getRateOption", observable -> observable.getRateOption()).<FloatingRateOption>map("Type coercion", fieldWithMetaFloatingRateOption -> fieldWithMetaFloatingRateOption.getValue()).<FieldWithMetaFloatingRateIndexEnum>map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex()).<FloatingRateIndexEnum>map("Type coercion", _fieldWithMetaFloatingRateIndexEnum -> _fieldWithMetaFloatingRateIndexEnum.getValue()), MapperS.of(payoutLeg).<InterestRatePayout>map("getInterestRatePayout", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getInterestRatePayout()).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption0 -> referenceWithMetaFloatingRateOption0 == null ? null : referenceWithMetaFloatingRateOption0.getValue()).<FieldWithMetaFloatingRateIndexEnum>map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex()).<FloatingRateIndexEnum>map("Type coercion", fieldWithMetaFloatingRateIndexEnum -> fieldWithMetaFloatingRateIndexEnum == null ? null : fieldWithMetaFloatingRateIndexEnum.getValue()), CardinalityOperator.Any).or(areEqual(item.<ReferenceWithMetaObservation>mapC("getObservations", reset -> reset.getObservations()).<Observation>map("Type coercion", referenceWithMetaObservation -> referenceWithMetaObservation.getValue()).<ObservationIdentifier>map("getObservationIdentifier", observation -> observation.getObservationIdentifier()).<Observable>map("getObservable", observationIdentifier -> observationIdentifier.getObservable()).<FieldWithMetaFloatingRateOption>map("getRateOption", observable -> observable.getRateOption()).<FloatingRateOption>map("Type coercion", fieldWithMetaFloatingRateOption -> fieldWithMetaFloatingRateOption.getValue()).<FieldWithMetaInflationRateIndexEnum>map("getInflationRateIndex", floatingRateOption -> floatingRateOption.getInflationRateIndex()).<InflationRateIndexEnum>map("Type coercion", _fieldWithMetaInflationRateIndexEnum -> _fieldWithMetaInflationRateIndexEnum.getValue()), MapperS.of(payoutLeg).<InterestRatePayout>map("getInterestRatePayout", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getInterestRatePayout()).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption1 -> referenceWithMetaFloatingRateOption1 == null ? null : referenceWithMetaFloatingRateOption1.getValue()).<FieldWithMetaInflationRateIndexEnum>map("getInflationRateIndex", floatingRateOption -> floatingRateOption.getInflationRateIndex()).<InflationRateIndexEnum>map("Type coercion", fieldWithMetaInflationRateIndexEnum -> fieldWithMetaInflationRateIndexEnum == null ? null : fieldWithMetaInflationRateIndexEnum.getValue()), CardinalityOperator.Any)).get()).getMulti()));
			} else if (exists(MapperS.of(tradeStateForEvent.evaluate(reportableEvent)).<Reset>mapC("getResetHistory", tradeState -> tradeState.getResetHistory()).<ReferenceWithMetaObservation>mapC("getObservations", reset -> reset.getObservations()).<Observation>map("Type coercion", referenceWithMetaObservation -> referenceWithMetaObservation.getValue()).<ObservationIdentifier>map("getObservationIdentifier", observation -> observation.getObservationIdentifier()).<Observable>map("getObservable", observationIdentifier -> observationIdentifier.getObservable()).<FieldWithMetaCommodity>map("getCommodity", observable -> observable.getCommodity()).<Commodity>map("Type coercion", fieldWithMetaCommodity -> fieldWithMetaCommodity.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier())).getOrDefault(false)) {
				resetHistory.addAll(toBuilder(MapperS.of(tradeStateForEvent.evaluate(reportableEvent)).<Reset>mapC("getResetHistory", tradeState -> tradeState.getResetHistory())
					.filterItemNullSafe(item -> areEqual(item.<ReferenceWithMetaObservation>mapC("getObservations", reset -> reset.getObservations()).<Observation>map("Type coercion", referenceWithMetaObservation -> referenceWithMetaObservation.getValue()).<ObservationIdentifier>map("getObservationIdentifier", observation -> observation.getObservationIdentifier()).<Observable>map("getObservable", observationIdentifier -> observationIdentifier.getObservable()).<FieldWithMetaCommodity>map("getCommodity", observable -> observable.getCommodity()).<Commodity>map("Type coercion", fieldWithMetaCommodity -> fieldWithMetaCommodity.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()), MapperS.of(payoutLeg).<CommodityPayout>map("getCommodityPayout", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getCommodityPayout()).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", product -> product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()), CardinalityOperator.All).get()).getMulti()));
			} else {
				resetHistory.addAll(toBuilder(Collections.<Reset>emptyList()));
			}
			
			return Optional.ofNullable(resetHistory)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
