package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(IsESMAThirdCountryEquivalentMarket.IsESMAThirdCountryEquivalentMarketDefault.class)
public abstract class IsESMAThirdCountryEquivalentMarket implements RosettaFunction {

	/**
	* @param mic 
	* @return result 
	*/
	public Boolean evaluate(String mic) {
		Boolean result = doEvaluate(mic);
		
		return result;
	}

	protected abstract Boolean doEvaluate(String mic);

	public static class IsESMAThirdCountryEquivalentMarketDefault extends IsESMAThirdCountryEquivalentMarket {
		@Override
		protected Boolean doEvaluate(String mic) {
			Boolean result = null;
			return assignOutput(result, mic);
		}
		
		protected Boolean assignOutput(Boolean result, String mic) {
			if (areEqual(MapperC.<String>of(MapperS.of("BTNL"), MapperS.of("XCFF"), MapperS.of("XCB"), MapperS.of("XCBT"), MapperS.of("XCME"), MapperS.of("XCEC"), MapperS.of("XELX"), MapperS.of("ERIS"), MapperS.of("IFUS"), MapperS.of("KLSH"), MapperS.of("LEDG"), MapperS.of("FREX"), MapperS.of("XMGE"), MapperS.of("XNYM"), MapperS.of("NODX"), MapperS.of("XOCH"), MapperS.of("SMFE"), MapperS.of("TRU"), MapperS.of("XASX"), MapperS.of("XSFE"), MapperS.of("CHIX"), MapperS.of("XMOD"), MapperS.of("XCNQ"), MapperS.of("IFCA"), MapperS.of("NGXC"), MapperS.of("XTSE"), MapperS.of("XTSX"), MapperS.of("XATS"), MapperS.of("NEOE"), MapperS.of("XTKS"), MapperS.of("XOSE"), MapperS.of("XNGO"), MapperS.of("XFKA"), MapperS.of("XSAP"), MapperS.of("XTFF"), MapperS.of("XKAC"), MapperS.of("XTKT"), MapperS.of("XSIM"), MapperS.of("XSES"), MapperS.of("IFSG")), MapperS.of(mic), CardinalityOperator.Any).getOrDefault(false)) {
				result = true;
			} else {
				result = false;
			}
			
			return result;
		}
	}
}
