package drr.regulation.common.functions;

import cdm.base.math.UnitType;
import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(IsPriceMonetary.IsPriceMonetaryDefault.class)
public abstract class IsPriceMonetary implements RosettaFunction {

	/**
	* @param price 
	* @return result 
	*/
	public Boolean evaluate(PriceSchedule price) {
		Boolean result = doEvaluate(price);
		
		return result;
	}

	protected abstract Boolean doEvaluate(PriceSchedule price);

	public static class IsPriceMonetaryDefault extends IsPriceMonetary {
		@Override
		protected Boolean doEvaluate(PriceSchedule price) {
			Boolean result = null;
			return assignOutput(result, price);
		}
		
		protected Boolean assignOutput(Boolean result, PriceSchedule price) {
			result = exists(MapperS.of(price).<UnitType>map("getUnit", priceSchedule -> priceSchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency())).and(notExists(MapperS.of(price).<UnitType>map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency())).or(notEqual(MapperS.of(price).<UnitType>map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).<String>map("Type coercion", fieldWithMetaString0 -> fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue()), MapperS.of(price).<UnitType>map("getUnit", priceSchedule -> priceSchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).<String>map("Type coercion", fieldWithMetaString1 -> fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue()), CardinalityOperator.Any))).get();
			
			return result;
		}
	}
}
