package drr.regulation.common.functions;

import cdm.product.qualification.functions.Qualify_BaseProduct_EquitySwap;
import cdm.product.qualification.functions.Qualify_CreditDefaultSwap_Index;
import cdm.product.qualification.functions.Qualify_EquityForward_PriceReturnBasicPerformance_SingleIndex;
import cdm.product.qualification.functions.Qualify_EquitySwap_ParameterReturnDividend_Index;
import cdm.product.qualification.functions.Qualify_EquitySwap_ParameterReturnVariance_Index;
import cdm.product.qualification.functions.Qualify_EquitySwap_ParameterReturnVolatility_Index;
import cdm.product.qualification.functions.Qualify_EquitySwap_PriceReturnBasicPerformance_Index;
import cdm.product.qualification.functions.Qualify_EquitySwap_TotalReturnBasicPerformance_Index;
import cdm.product.qualification.functions.Qualify_InterestRate_IRSwap_FixedFixed;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import javax.inject.Inject;


@ImplementedBy(IsUnderlyingAssetTypeIndex.IsUnderlyingAssetTypeIndexDefault.class)
public abstract class IsUnderlyingAssetTypeIndex implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsCommodityForward isCommodityForward;
	@Inject protected IsCommodityOption isCommodityOption;
	@Inject protected IsCommoditySwap isCommoditySwap;
	@Inject protected IsCommoditySwaption isCommoditySwaption;
	@Inject protected IsCreditTotalReturnSwap isCreditTotalReturnSwap;
	@Inject protected IsEquityOption isEquityOption;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;
	@Inject protected Qualify_BaseProduct_EquitySwap qualify_BaseProduct_EquitySwap;
	@Inject protected Qualify_CreditDefaultSwap_Index qualify_CreditDefaultSwap_Index;
	@Inject protected Qualify_EquityForward_PriceReturnBasicPerformance_SingleIndex qualify_EquityForward_PriceReturnBasicPerformance_SingleIndex;
	@Inject protected Qualify_EquitySwap_ParameterReturnDividend_Index qualify_EquitySwap_ParameterReturnDividend_Index;
	@Inject protected Qualify_EquitySwap_ParameterReturnVariance_Index qualify_EquitySwap_ParameterReturnVariance_Index;
	@Inject protected Qualify_EquitySwap_ParameterReturnVolatility_Index qualify_EquitySwap_ParameterReturnVolatility_Index;
	@Inject protected Qualify_EquitySwap_PriceReturnBasicPerformance_Index qualify_EquitySwap_PriceReturnBasicPerformance_Index;
	@Inject protected Qualify_EquitySwap_TotalReturnBasicPerformance_Index qualify_EquitySwap_TotalReturnBasicPerformance_Index;
	@Inject protected Qualify_InterestRate_IRSwap_FixedFixed qualify_InterestRate_IRSwap_FixedFixed;

	/**
	* @param reportableEvent 
	* @return result 
	*/
	public Boolean evaluate(ReportableEvent reportableEvent) {
		Boolean result = doEvaluate(reportableEvent);
		
		return result;
	}

	protected abstract Boolean doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends Product> product(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends EconomicTerms> economicTerms(ReportableEvent reportableEvent);

	public static class IsUnderlyingAssetTypeIndexDefault extends IsUnderlyingAssetTypeIndex {
		@Override
		protected Boolean doEvaluate(ReportableEvent reportableEvent) {
			Boolean result = null;
			return assignOutput(result, reportableEvent);
		}
		
		protected Boolean assignOutput(Boolean result, ReportableEvent reportableEvent) {
			result = ComparisonResult.of(MapperS.of(qualify_CreditDefaultSwap_Index.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(isCreditTotalReturnSwap.evaluate(product(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_InterestRate_IRSwap_FixedFixed.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(isCommoditySwap.evaluate(product(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(isCommodityForward.evaluate(product(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(isCommodityOption.evaluate(product(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(isCommoditySwaption.evaluate(product(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_EquitySwap_ParameterReturnDividend_Index.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_EquitySwap_ParameterReturnVariance_Index.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_EquitySwap_ParameterReturnVolatility_Index.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_EquitySwap_TotalReturnBasicPerformance_Index.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_EquitySwap_PriceReturnBasicPerformance_Index.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_EquityForward_PriceReturnBasicPerformance_SingleIndex.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_BaseProduct_EquitySwap.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(isEquityOption.evaluate(product(reportableEvent).get())))).get();
			
			return result;
		}
		
		@Override
		protected MapperS<? extends Product> product(ReportableEvent reportableEvent) {
			final MapperS<Product> thenArg = MapperS.of(productForEvent.evaluate(reportableEvent));
			return MapperS.of(productOrUnderlierProduct.evaluate(thenArg.get()));
		}
		
		@Override
		protected MapperS<? extends EconomicTerms> economicTerms(ReportableEvent reportableEvent) {
			return product(reportableEvent).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms());
		}
	}
}
