package drr.regulation.common.functions;

import cdm.event.position.CounterpartyPosition;
import cdm.event.position.CounterpartyPosition.CounterpartyPositionBuilder;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(PositionForEvent.PositionForEventDefault.class)
public abstract class PositionForEvent implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected PositionStateForEvent positionStateForEvent;

	/**
	* @param reportableEvent 
	* @return reportablePosition 
	*/
	public CounterpartyPosition evaluate(ReportableEvent reportableEvent) {
		CounterpartyPosition.CounterpartyPositionBuilder reportablePositionBuilder = doEvaluate(reportableEvent);
		
		final CounterpartyPosition reportablePosition;
		if (reportablePositionBuilder == null) {
			reportablePosition = null;
		} else {
			reportablePosition = reportablePositionBuilder.build();
			objectValidator.validate(CounterpartyPosition.class, reportablePosition);
		}
		
		return reportablePosition;
	}

	protected abstract CounterpartyPosition.CounterpartyPositionBuilder doEvaluate(ReportableEvent reportableEvent);

	public static class PositionForEventDefault extends PositionForEvent {
		@Override
		protected CounterpartyPosition.CounterpartyPositionBuilder doEvaluate(ReportableEvent reportableEvent) {
			CounterpartyPosition.CounterpartyPositionBuilder reportablePosition = CounterpartyPosition.builder();
			return assignOutput(reportablePosition, reportableEvent);
		}
		
		protected CounterpartyPosition.CounterpartyPositionBuilder assignOutput(CounterpartyPosition.CounterpartyPositionBuilder reportablePosition, ReportableEvent reportableEvent) {
			reportablePosition = toBuilder(MapperS.of(positionStateForEvent.evaluate(reportableEvent)).<CounterpartyPosition>map("getCounterpartyPosition", counterpartyPositionState -> counterpartyPositionState.getCounterpartyPosition()).get());
			
			return Optional.ofNullable(reportablePosition)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
