package drr.regulation.common.functions;

import cdm.product.template.Product;
import cdm.product.template.Product.ProductBuilder;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ProductForEvent.ProductForEventDefault.class)
public abstract class ProductForEvent implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected PositionForEvent positionForEvent;
	@Inject protected ProductForPosition productForPosition;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param reportableEvent 
	* @return product 
	*/
	public Product evaluate(ReportableEvent reportableEvent) {
		Product.ProductBuilder productBuilder = doEvaluate(reportableEvent);
		
		final Product product;
		if (productBuilder == null) {
			product = null;
		} else {
			product = productBuilder.build();
			objectValidator.validate(Product.class, product);
		}
		
		return product;
	}

	protected abstract Product.ProductBuilder doEvaluate(ReportableEvent reportableEvent);

	public static class ProductForEventDefault extends ProductForEvent {
		@Override
		protected Product.ProductBuilder doEvaluate(ReportableEvent reportableEvent) {
			Product.ProductBuilder product = Product.builder();
			return assignOutput(product, reportableEvent);
		}
		
		protected Product.ProductBuilder assignOutput(Product.ProductBuilder product, ReportableEvent reportableEvent) {
			if (exists(MapperS.of(tradeForEvent.evaluate(reportableEvent))).getOrDefault(false)) {
				product = toBuilder(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent)));
			} else if (exists(MapperS.of(positionForEvent.evaluate(reportableEvent))).getOrDefault(false)) {
				product = toBuilder(productForPosition.evaluate(positionForEvent.evaluate(reportableEvent)));
			} else {
				product = null;
			}
			
			return Optional.ofNullable(product)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
