package drr.regulation.common.functions;

import cdm.event.position.CounterpartyPosition;
import cdm.product.template.Product;
import cdm.product.template.Product.ProductBuilder;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(ProductForPosition.ProductForPositionDefault.class)
public abstract class ProductForPosition implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param position 
	* @return product 
	*/
	public Product evaluate(CounterpartyPosition position) {
		Product.ProductBuilder productBuilder = doEvaluate(position);
		
		final Product product;
		if (productBuilder == null) {
			product = null;
		} else {
			product = productBuilder.build();
			objectValidator.validate(Product.class, product);
		}
		
		return product;
	}

	protected abstract Product.ProductBuilder doEvaluate(CounterpartyPosition position);

	public static class ProductForPositionDefault extends ProductForPosition {
		@Override
		protected Product.ProductBuilder doEvaluate(CounterpartyPosition position) {
			Product.ProductBuilder product = Product.builder();
			return assignOutput(product, position);
		}
		
		protected Product.ProductBuilder assignOutput(Product.ProductBuilder product, CounterpartyPosition position) {
			product = toBuilder(MapperS.of(position).<TradableProduct>map("getPositionBase", counterpartyPosition -> counterpartyPosition.getPositionBase()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
			
			return Optional.ofNullable(product)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
