package drr.regulation.common.functions;

import cdm.event.common.Trade;
import cdm.product.template.Product;
import cdm.product.template.Product.ProductBuilder;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(ProductForTrade.ProductForTradeDefault.class)
public abstract class ProductForTrade implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param trade 
	* @return product 
	*/
	public Product evaluate(Trade trade) {
		Product.ProductBuilder productBuilder = doEvaluate(trade);
		
		final Product product;
		if (productBuilder == null) {
			product = null;
		} else {
			product = productBuilder.build();
			objectValidator.validate(Product.class, product);
		}
		
		return product;
	}

	protected abstract Product.ProductBuilder doEvaluate(Trade trade);

	public static class ProductForTradeDefault extends ProductForTrade {
		@Override
		protected Product.ProductBuilder doEvaluate(Trade trade) {
			Product.ProductBuilder product = Product.builder();
			return assignOutput(product, trade);
		}
		
		protected Product.ProductBuilder assignOutput(Product.ProductBuilder product, Trade trade) {
			product = toBuilder(MapperS.of(trade).<TradableProduct>map("getTradableProduct", _trade -> _trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
			
			return Optional.ofNullable(product)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
