package drr.regulation.common.functions;

import cdm.event.common.Trade;
import cdm.event.common.Trade.TradeBuilder;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(TradeForEvent.TradeForEventDefault.class)
public abstract class TradeForEvent implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected TradeStateForEvent tradeStateForEvent;

	/**
	* @param reportableEvent 
	* @return reportableTrade 
	*/
	public Trade evaluate(ReportableEvent reportableEvent) {
		Trade.TradeBuilder reportableTradeBuilder = doEvaluate(reportableEvent);
		
		final Trade reportableTrade;
		if (reportableTradeBuilder == null) {
			reportableTrade = null;
		} else {
			reportableTrade = reportableTradeBuilder.build();
			objectValidator.validate(Trade.class, reportableTrade);
		}
		
		return reportableTrade;
	}

	protected abstract Trade.TradeBuilder doEvaluate(ReportableEvent reportableEvent);

	public static class TradeForEventDefault extends TradeForEvent {
		@Override
		protected Trade.TradeBuilder doEvaluate(ReportableEvent reportableEvent) {
			Trade.TradeBuilder reportableTrade = Trade.builder();
			return assignOutput(reportableTrade, reportableEvent);
		}
		
		protected Trade.TradeBuilder assignOutput(Trade.TradeBuilder reportableTrade, ReportableEvent reportableEvent) {
			reportableTrade = toBuilder(MapperS.of(tradeStateForEvent.evaluate(reportableEvent)).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).get());
			
			return Optional.ofNullable(reportableTrade)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
