package drr.regulation.common.trade;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.ReportableDelivery;
import drr.regulation.common.ReportableDelivery.ReportableDeliveryBuilder;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.CommonLeg.CommonLegBuilder;
import drr.regulation.common.trade.CommonTransactionReport;
import drr.regulation.common.trade.CommonTransactionReport.CommonTransactionReportBuilder;
import drr.regulation.common.trade.CommonTransactionReport.CommonTransactionReportBuilderImpl;
import drr.regulation.common.trade.CommonTransactionReport.CommonTransactionReportImpl;
import drr.regulation.common.trade.EMIRTransactionReport;
import drr.regulation.common.trade.EMIRTransactionReport.EMIRTransactionReportBuilder;
import drr.regulation.common.trade.EMIRTransactionReport.EMIRTransactionReportBuilderImpl;
import drr.regulation.common.trade.EMIRTransactionReport.EMIRTransactionReportImpl;
import drr.regulation.common.trade.basket.BasketConstituentsReport;
import drr.regulation.common.trade.basket.BasketConstituentsReport.BasketConstituentsReportBuilder;
import drr.regulation.common.trade.contract.UnderlyingIdentifier;
import drr.regulation.common.trade.contract.UnderlyingIdentifier.UnderlyingIdentifierBuilder;
import drr.regulation.common.trade.meta.EMIRTransactionReportMeta;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder;
import drr.standards.iosco.cde.Leg;
import drr.standards.iosco.cde.payment.OtherPayment;
import drr.standards.iosco.cde.payment.OtherPayment.OtherPaymentBuilder;
import drr.standards.iosco.cde.price.PriceFormat;
import drr.standards.iosco.cde.price.PriceFormat.PriceFormatBuilder;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import drr.standards.iosco.cde.price.PricePeriod;
import drr.standards.iosco.cde.price.PricePeriod.PricePeriodBuilder;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ClearedEnum;
import drr.standards.iso.ConfirmationEnum;
import drr.standards.iso.DeliveryTypeEnum;
import drr.standards.iso.Direction1Enum;
import drr.standards.iso.Direction2Enum;
import drr.standards.iso.EmbeddedOptionTypeEnum;
import drr.standards.iso.EnergyLoadType1Code;
import drr.standards.iso.EventTypeEnum;
import drr.standards.iso.IndexEnum;
import drr.standards.iso.OptionStyleEnum;
import drr.standards.iso.OptionTypeCode;
import drr.standards.iso.ReportLevelEnum;
import drr.standards.iso.SeniorityEnum;
import drr.standards.iso.TradingCapacity7Code;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

import static java.util.Optional.ofNullable;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataType(value="EMIRTransactionReport", builder=EMIRTransactionReport.EMIRTransactionReportBuilderImpl.class, version="6.0.0-dev.128")
@RuneDataType(value="EMIRTransactionReport", model="drr", builder=EMIRTransactionReport.EMIRTransactionReportBuilderImpl.class, version="6.0.0-dev.128")
public interface EMIRTransactionReport extends CommonTransactionReport {

	EMIRTransactionReportMeta metaData = new EMIRTransactionReportMeta();

	/*********************** Getter Methods  ***********************/
	String getEntityResponsibleForReporting();
	String getNatureOfCounterparty1();
	List<String> getCorporateSectorOfTheCounterparty1();
	Boolean getClearingThresholdOfCounterparty1();
	ISOCountryCodeEnum getCountryOfTheCounterParty2();
	String getNatureOfCounterparty2();
	List<String> getCorporateSectorOfTheCounterparty2();
	Boolean getClearingThresholdOfCounterparty2();
	Boolean getReportingObligationOfTheCounterparty2();
	String getBrokerID();
	Boolean getDirectlyLinkedToCommercialActivityOrTreasuryFinancing();
	String getReportTrackingNumber();
	String getPtrrId();
	String getSubsequentPositionUTI();
	String getIsin();
	String getProductClassification();
	Boolean getIsCrypto();
	List<IndexEnum> getIndicatorOfTheUnderlyingIndex();
	String getCustomBasketCode();
	BigDecimal getValuationAmount();
	ISOCurrencyCodeEnum getValuationCurrency();
	ValuationType1Code getValuationMethod();
	BigDecimal getDelta();
	ZonedDateTime getValuationTimestamp();
	ZonedDateTime getConfirmationTimestamp();
	String getClearingObligation();
	String getMasterAgreementType();
	String getOtherMasterAgreementType();
	Integer getMasterAgreementVersion();
	Boolean getIntragroup();
	Boolean getPtrr();
	String getTypeOfPTRRTechnique();
	String getPtrrServiceProvider();
	String getVenueOfExecution();
	BigDecimal getForwardExchangeRate();
	String getBaseProduct();
	String getSubProduct();
	String getFurtherSubProduct();
	List<String> getDeliveryPoint();
	String getInterconnectionPoint();
	EnergyLoadType1Code getLoadType();
	List<? extends ReportableDelivery> getDeliveryReport();
	String getReferenceEntity();
	Integer getVersion();
	Boolean getTranche();
	String getCollateralPortfolioCode();
	Date getEventDate();
	ReportLevelEnum getLevel();

	/*********************** Build Methods  ***********************/
	EMIRTransactionReport build();
	
	EMIRTransactionReport.EMIRTransactionReportBuilder toBuilder();
	
	static EMIRTransactionReport.EMIRTransactionReportBuilder builder() {
		return new EMIRTransactionReport.EMIRTransactionReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends EMIRTransactionReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends EMIRTransactionReport> getType() {
		return EMIRTransactionReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, getActionType(), this);
		processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, getEventType(), this);
		processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
		processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
		processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, getEarlyTerminationDate(), this);
		processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
		processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
		processor.processBasic(path.newSubPath("beneficiary1"), String.class, getBeneficiary1(), this);
		processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, getBeneficiary1IdentifierTypeIndicator(), this);
		processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, getCleared(), this);
		processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
		processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
		processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, getConfirmed(), this);
		processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
		processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
		processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
		processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
		processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.class, getPriceSchedule());
		processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.class, getStrikePriceSchedule());
		processRosetta(path.newSubPath("price"), processor, PriceFormat.class, getPrice());
		processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, getPriceNotation(), this);
		processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, getPriceCurrency(), this);
		processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.class, getPackageTransactionPrice());
		processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, getPackageTransactionPriceNotation(), this);
		processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionPriceCurrency(), this);
		processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.class, getPackageTransactionSpread());
		processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, getPackageTransactionSpreadNotation(), this);
		processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionSpreadCurrency(), this);
		processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.class, getStrikePrice());
		processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, getStrikePriceNotation(), this);
		processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, getStrikePriceCurrency(), this);
		processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
		processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
		processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
		processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
		processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
		processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
		processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, getFirstExerciseDate(), this);
		processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
		processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.class, getOtherPayment());
		processRosetta(path.newSubPath("leg1"), processor, CommonLeg.class, getLeg1());
		processRosetta(path.newSubPath("leg2"), processor, CommonLeg.class, getLeg2());
		processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
		processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, getExecutionAgentCounterparty1(), this);
		processor.processBasic(path.newSubPath("executionAgentCounterparty2DTCC"), String.class, getExecutionAgentCounterparty2DTCC(), this);
		processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
		processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
		processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, getPriorUTIProprietary(), this);
		processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
		processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, getContractType(), this);
		processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, getAssetClass(), this);
		processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
		processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
		processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, getDirection1(), this);
		processor.processBasic(path.newSubPath("direction2Leg1"), Direction2Enum.class, getDirection2Leg1(), this);
		processor.processBasic(path.newSubPath("direction2Leg2"), Direction2Enum.class, getDirection2Leg2(), this);
		processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
		processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.class, getBarrier());
		processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
		processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
		processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
		processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.class, getBasketConstituents());
		processRosetta(path.newSubPath("underlying"), processor, UnderlyingIdentifier.class, getUnderlying());
		processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, getQuantityUnitOfMeasureLeg1(), this);
		processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, getQuantityUnitOfMeasureLeg2(), this);
		processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
		processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, getOptionType(), this);
		processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, getOptionStyle(), this);
		processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, getDeliveryType(), this);
		processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterparty2(), this);
		processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, getBookingLocation(), this);
		processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, getTraderLocation(), this);
		processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, getTradingCapacity(), this);
		processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, getEmbeddedOptionType(), this);
		processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, getSeniority(), this);
		processor.processBasic(path.newSubPath("series"), Integer.class, getSeries(), this);
		processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
		processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
		processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
		processor.processBasic(path.newSubPath("natureOfCounterparty1"), String.class, getNatureOfCounterparty1(), this);
		processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty1"), String.class, getCorporateSectorOfTheCounterparty1(), this);
		processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty1"), Boolean.class, getClearingThresholdOfCounterparty1(), this);
		processor.processBasic(path.newSubPath("countryOfTheCounterParty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterParty2(), this);
		processor.processBasic(path.newSubPath("natureOfCounterparty2"), String.class, getNatureOfCounterparty2(), this);
		processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty2"), String.class, getCorporateSectorOfTheCounterparty2(), this);
		processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty2"), Boolean.class, getClearingThresholdOfCounterparty2(), this);
		processor.processBasic(path.newSubPath("reportingObligationOfTheCounterparty2"), Boolean.class, getReportingObligationOfTheCounterparty2(), this);
		processor.processBasic(path.newSubPath("brokerID"), String.class, getBrokerID(), this);
		processor.processBasic(path.newSubPath("directlyLinkedToCommercialActivityOrTreasuryFinancing"), Boolean.class, getDirectlyLinkedToCommercialActivityOrTreasuryFinancing(), this);
		processor.processBasic(path.newSubPath("reportTrackingNumber"), String.class, getReportTrackingNumber(), this);
		processor.processBasic(path.newSubPath("ptrrId"), String.class, getPtrrId(), this);
		processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, getSubsequentPositionUTI(), this);
		processor.processBasic(path.newSubPath("isin"), String.class, getIsin(), this);
		processor.processBasic(path.newSubPath("productClassification"), String.class, getProductClassification(), this);
		processor.processBasic(path.newSubPath("isCrypto"), Boolean.class, getIsCrypto(), this);
		processor.processBasic(path.newSubPath("indicatorOfTheUnderlyingIndex"), IndexEnum.class, getIndicatorOfTheUnderlyingIndex(), this);
		processor.processBasic(path.newSubPath("customBasketCode"), String.class, getCustomBasketCode(), this);
		processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
		processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
		processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
		processor.processBasic(path.newSubPath("delta"), BigDecimal.class, getDelta(), this);
		processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
		processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, getConfirmationTimestamp(), this);
		processor.processBasic(path.newSubPath("clearingObligation"), String.class, getClearingObligation(), this);
		processor.processBasic(path.newSubPath("masterAgreementType"), String.class, getMasterAgreementType(), this);
		processor.processBasic(path.newSubPath("otherMasterAgreementType"), String.class, getOtherMasterAgreementType(), this);
		processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, getMasterAgreementVersion(), this);
		processor.processBasic(path.newSubPath("intragroup"), Boolean.class, getIntragroup(), this);
		processor.processBasic(path.newSubPath("ptrr"), Boolean.class, getPtrr(), this);
		processor.processBasic(path.newSubPath("typeOfPTRRTechnique"), String.class, getTypeOfPTRRTechnique(), this);
		processor.processBasic(path.newSubPath("ptrrServiceProvider"), String.class, getPtrrServiceProvider(), this);
		processor.processBasic(path.newSubPath("venueOfExecution"), String.class, getVenueOfExecution(), this);
		processor.processBasic(path.newSubPath("forwardExchangeRate"), BigDecimal.class, getForwardExchangeRate(), this);
		processor.processBasic(path.newSubPath("baseProduct"), String.class, getBaseProduct(), this);
		processor.processBasic(path.newSubPath("subProduct"), String.class, getSubProduct(), this);
		processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, getFurtherSubProduct(), this);
		processor.processBasic(path.newSubPath("deliveryPoint"), String.class, getDeliveryPoint(), this);
		processor.processBasic(path.newSubPath("interconnectionPoint"), String.class, getInterconnectionPoint(), this);
		processor.processBasic(path.newSubPath("loadType"), EnergyLoadType1Code.class, getLoadType(), this);
		processRosetta(path.newSubPath("deliveryReport"), processor, ReportableDelivery.class, getDeliveryReport());
		processor.processBasic(path.newSubPath("referenceEntity"), String.class, getReferenceEntity(), this);
		processor.processBasic(path.newSubPath("version"), Integer.class, getVersion(), this);
		processor.processBasic(path.newSubPath("tranche"), Boolean.class, getTranche(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, getCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("eventDate"), Date.class, getEventDate(), this);
		processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, getLevel(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface EMIRTransactionReportBuilder extends EMIRTransactionReport, CommonTransactionReport.CommonTransactionReportBuilder {
		ReportableDelivery.ReportableDeliveryBuilder getOrCreateDeliveryReport(int _index);
		@Override
		List<? extends ReportableDelivery.ReportableDeliveryBuilder> getDeliveryReport();
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setActionType(ActionTypeEnum actionType);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setEventType(EventTypeEnum eventType);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setEventIdentifier(String eventIdentifier);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setEffectiveDate(Date effectiveDate);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setEarlyTerminationDate(Date earlyTerminationDate);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setEventTimestamp(ZonedDateTime eventTimestamp);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setExecutionTimestamp(ZonedDateTime executionTimestamp);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setExpirationDate(Date expirationDate);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setCounterparty1(String counterparty1);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setCounterparty2(String counterparty2);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setCounterparty2IdentifierType(Boolean counterparty2IdentifierType);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setBeneficiary1(String beneficiary1);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean beneficiary1IdentifierTypeIndicator);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setCleared(ClearedEnum cleared);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setCentralCounterparty(String centralCounterparty);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setClearingMember(String clearingMember);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setConfirmed(ConfirmationEnum confirmed);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setCallAmount(BigDecimal callAmount);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setPutAmount(BigDecimal putAmount);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum callCurrency);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum putCurrency);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder addPriceSchedule(PricePeriod priceSchedule);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder addPriceSchedule(PricePeriod priceSchedule, int _idx);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedule);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedule);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder addStrikePriceSchedule(PricePeriod strikePriceSchedule);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder addStrikePriceSchedule(PricePeriod strikePriceSchedule, int _idx);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedule);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedule);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setPrice(PriceFormat price);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setPriceNotation(PriceNotationEnum priceNotation);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum priceCurrency);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setPackageTransactionPrice(PriceFormat packageTransactionPrice);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum packageTransactionPriceNotation);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum packageTransactionPriceCurrency);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setPackageTransactionSpread(PriceFormat packageTransactionSpread);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum packageTransactionSpreadNotation);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum packageTransactionSpreadCurrency);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setStrikePrice(PriceFormat strikePrice);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setStrikePriceNotation(PriceNotationEnum strikePriceNotation);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setStrikePriceCurrency(String strikePriceCurrency);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setPriceUnitOfMeasure(String priceUnitOfMeasure);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setOptionPremiumAmount(BigDecimal optionPremiumAmount);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum optionPremiumCurrency);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setOptionPremiumPaymentDate(Date optionPremiumPaymentDate);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal cdSIndexAttachmentPoint);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal cdSIndexDetachmentPoint);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setCollateralPortfolioIndicator(Boolean collateralPortfolioIndicator);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setFirstExerciseDate(Date firstExerciseDate);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setFinalContractualSettlementDate(Date finalContractualSettlementDate);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder addOtherPayment(OtherPayment otherPayment);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder addOtherPayment(OtherPayment otherPayment, int _idx);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder addOtherPayment(List<? extends OtherPayment> otherPayment);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setOtherPayment(List<? extends OtherPayment> otherPayment);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setLeg1(Leg leg1);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setLeg2(Leg leg2);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setLeg1(CommonLeg leg1);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setLeg2(CommonLeg leg2);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setCounterparty2Name(String counterparty2Name);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setExecutionAgentCounterparty1(String executionAgentCounterparty1);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setExecutionAgentCounterparty2DTCC(String executionAgentCounterparty2DTCC);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setReportSubmittingEntityID(String reportSubmittingEntityID);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setUniqueTransactionIdentifier(String uniqueTransactionIdentifier);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setUniqueTransactionIdentifierProprietary(String uniqueTransactionIdentifierProprietary);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setPriorUTI(String priorUTI);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setPriorUTIProprietary(String priorUTIProprietary);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setUniqueProductIdentifier(String uniqueProductIdentifier);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setContractType(CommonContractType contractType);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setAssetClass(CommonAssetClass assetClass);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setClearingTimestamp(ZonedDateTime clearingTimestamp);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setPlatformIdentifier(String platformIdentifier);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setDirection1(Direction1Enum direction1);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setDirection2Leg1(Direction2Enum direction2Leg1);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setDirection2Leg2(Direction2Enum direction2Leg2);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setPackageIdentifier(String packageIdentifier);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier barrier);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setExchangeRate(BigDecimal exchangeRate);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setExchangeRateBasis(String exchangeRateBasis);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setNameOfTheUnderlyingIndex(String nameOfTheUnderlyingIndex);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder addBasketConstituents(BasketConstituentsReport basketConstituents);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder addBasketConstituents(BasketConstituentsReport basketConstituents, int _idx);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituents);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituents);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setUnderlying(UnderlyingIdentifier underlying);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setQuantityUnitOfMeasureLeg1(String quantityUnitOfMeasureLeg1);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setQuantityUnitOfMeasureLeg2(String quantityUnitOfMeasureLeg2);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setMaturityDateOfTheUnderlying(Date maturityDateOfTheUnderlying);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setOptionType(OptionTypeCode optionType);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setOptionStyle(OptionStyleEnum optionStyle);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setDeliveryType(DeliveryTypeEnum deliveryType);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum countryOfTheCounterparty2);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setBookingLocation(ISOCountryCodeEnum bookingLocation);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setTraderLocation(ISOCountryCodeEnum traderLocation);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setTradingCapacity(TradingCapacity7Code tradingCapacity);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum embeddedOptionType);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setSeniority(SeniorityEnum seniority);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setSeries(Integer series);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setIndexFactor(BigDecimal indexFactor);
		@Override
		EMIRTransactionReport.EMIRTransactionReportBuilder setTechnicalRecordId(String technicalRecordId);
		EMIRTransactionReport.EMIRTransactionReportBuilder setEntityResponsibleForReporting(String entityResponsibleForReporting);
		EMIRTransactionReport.EMIRTransactionReportBuilder setNatureOfCounterparty1(String natureOfCounterparty1);
		EMIRTransactionReport.EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String corporateSectorOfTheCounterparty1);
		EMIRTransactionReport.EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String corporateSectorOfTheCounterparty1, int _idx);
		EMIRTransactionReport.EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1);
		EMIRTransactionReport.EMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1);
		EMIRTransactionReport.EMIRTransactionReportBuilder setClearingThresholdOfCounterparty1(Boolean clearingThresholdOfCounterparty1);
		EMIRTransactionReport.EMIRTransactionReportBuilder setCountryOfTheCounterParty2(ISOCountryCodeEnum countryOfTheCounterParty2);
		EMIRTransactionReport.EMIRTransactionReportBuilder setNatureOfCounterparty2(String natureOfCounterparty2);
		EMIRTransactionReport.EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String corporateSectorOfTheCounterparty2);
		EMIRTransactionReport.EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String corporateSectorOfTheCounterparty2, int _idx);
		EMIRTransactionReport.EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2);
		EMIRTransactionReport.EMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2);
		EMIRTransactionReport.EMIRTransactionReportBuilder setClearingThresholdOfCounterparty2(Boolean clearingThresholdOfCounterparty2);
		EMIRTransactionReport.EMIRTransactionReportBuilder setReportingObligationOfTheCounterparty2(Boolean reportingObligationOfTheCounterparty2);
		EMIRTransactionReport.EMIRTransactionReportBuilder setBrokerID(String brokerID);
		EMIRTransactionReport.EMIRTransactionReportBuilder setDirectlyLinkedToCommercialActivityOrTreasuryFinancing(Boolean directlyLinkedToCommercialActivityOrTreasuryFinancing);
		EMIRTransactionReport.EMIRTransactionReportBuilder setReportTrackingNumber(String reportTrackingNumber);
		EMIRTransactionReport.EMIRTransactionReportBuilder setPtrrId(String ptrrId);
		EMIRTransactionReport.EMIRTransactionReportBuilder setSubsequentPositionUTI(String subsequentPositionUTI);
		EMIRTransactionReport.EMIRTransactionReportBuilder setIsin(String isin);
		EMIRTransactionReport.EMIRTransactionReportBuilder setProductClassification(String productClassification);
		EMIRTransactionReport.EMIRTransactionReportBuilder setIsCrypto(Boolean isCrypto);
		EMIRTransactionReport.EMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(IndexEnum indicatorOfTheUnderlyingIndex);
		EMIRTransactionReport.EMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(IndexEnum indicatorOfTheUnderlyingIndex, int _idx);
		EMIRTransactionReport.EMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(List<IndexEnum> indicatorOfTheUnderlyingIndex);
		EMIRTransactionReport.EMIRTransactionReportBuilder setIndicatorOfTheUnderlyingIndex(List<IndexEnum> indicatorOfTheUnderlyingIndex);
		EMIRTransactionReport.EMIRTransactionReportBuilder setCustomBasketCode(String customBasketCode);
		EMIRTransactionReport.EMIRTransactionReportBuilder setValuationAmount(BigDecimal valuationAmount);
		EMIRTransactionReport.EMIRTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum valuationCurrency);
		EMIRTransactionReport.EMIRTransactionReportBuilder setValuationMethod(ValuationType1Code valuationMethod);
		EMIRTransactionReport.EMIRTransactionReportBuilder setDelta(BigDecimal delta);
		EMIRTransactionReport.EMIRTransactionReportBuilder setValuationTimestamp(ZonedDateTime valuationTimestamp);
		EMIRTransactionReport.EMIRTransactionReportBuilder setConfirmationTimestamp(ZonedDateTime confirmationTimestamp);
		EMIRTransactionReport.EMIRTransactionReportBuilder setClearingObligation(String clearingObligation);
		EMIRTransactionReport.EMIRTransactionReportBuilder setMasterAgreementType(String masterAgreementType);
		EMIRTransactionReport.EMIRTransactionReportBuilder setOtherMasterAgreementType(String otherMasterAgreementType);
		EMIRTransactionReport.EMIRTransactionReportBuilder setMasterAgreementVersion(Integer masterAgreementVersion);
		EMIRTransactionReport.EMIRTransactionReportBuilder setIntragroup(Boolean intragroup);
		EMIRTransactionReport.EMIRTransactionReportBuilder setPtrr(Boolean ptrr);
		EMIRTransactionReport.EMIRTransactionReportBuilder setTypeOfPTRRTechnique(String typeOfPTRRTechnique);
		EMIRTransactionReport.EMIRTransactionReportBuilder setPtrrServiceProvider(String ptrrServiceProvider);
		EMIRTransactionReport.EMIRTransactionReportBuilder setVenueOfExecution(String venueOfExecution);
		EMIRTransactionReport.EMIRTransactionReportBuilder setForwardExchangeRate(BigDecimal forwardExchangeRate);
		EMIRTransactionReport.EMIRTransactionReportBuilder setBaseProduct(String baseProduct);
		EMIRTransactionReport.EMIRTransactionReportBuilder setSubProduct(String subProduct);
		EMIRTransactionReport.EMIRTransactionReportBuilder setFurtherSubProduct(String furtherSubProduct);
		EMIRTransactionReport.EMIRTransactionReportBuilder addDeliveryPoint(String deliveryPoint);
		EMIRTransactionReport.EMIRTransactionReportBuilder addDeliveryPoint(String deliveryPoint, int _idx);
		EMIRTransactionReport.EMIRTransactionReportBuilder addDeliveryPoint(List<String> deliveryPoint);
		EMIRTransactionReport.EMIRTransactionReportBuilder setDeliveryPoint(List<String> deliveryPoint);
		EMIRTransactionReport.EMIRTransactionReportBuilder setInterconnectionPoint(String interconnectionPoint);
		EMIRTransactionReport.EMIRTransactionReportBuilder setLoadType(EnergyLoadType1Code loadType);
		EMIRTransactionReport.EMIRTransactionReportBuilder addDeliveryReport(ReportableDelivery deliveryReport);
		EMIRTransactionReport.EMIRTransactionReportBuilder addDeliveryReport(ReportableDelivery deliveryReport, int _idx);
		EMIRTransactionReport.EMIRTransactionReportBuilder addDeliveryReport(List<? extends ReportableDelivery> deliveryReport);
		EMIRTransactionReport.EMIRTransactionReportBuilder setDeliveryReport(List<? extends ReportableDelivery> deliveryReport);
		EMIRTransactionReport.EMIRTransactionReportBuilder setReferenceEntity(String referenceEntity);
		EMIRTransactionReport.EMIRTransactionReportBuilder setVersion(Integer version);
		EMIRTransactionReport.EMIRTransactionReportBuilder setTranche(Boolean tranche);
		EMIRTransactionReport.EMIRTransactionReportBuilder setCollateralPortfolioCode(String collateralPortfolioCode);
		EMIRTransactionReport.EMIRTransactionReportBuilder setEventDate(Date eventDate);
		EMIRTransactionReport.EMIRTransactionReportBuilder setLevel(ReportLevelEnum level);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, getActionType(), this);
			processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, getEventType(), this);
			processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
			processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
			processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, getEarlyTerminationDate(), this);
			processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
			processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
			processor.processBasic(path.newSubPath("beneficiary1"), String.class, getBeneficiary1(), this);
			processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, getBeneficiary1IdentifierTypeIndicator(), this);
			processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, getCleared(), this);
			processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
			processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
			processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, getConfirmed(), this);
			processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
			processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
			processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
			processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
			processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, getPriceSchedule());
			processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, getStrikePriceSchedule());
			processRosetta(path.newSubPath("price"), processor, PriceFormat.PriceFormatBuilder.class, getPrice());
			processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, getPriceNotation(), this);
			processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, getPriceCurrency(), this);
			processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.PriceFormatBuilder.class, getPackageTransactionPrice());
			processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, getPackageTransactionPriceNotation(), this);
			processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionPriceCurrency(), this);
			processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.PriceFormatBuilder.class, getPackageTransactionSpread());
			processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, getPackageTransactionSpreadNotation(), this);
			processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionSpreadCurrency(), this);
			processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.PriceFormatBuilder.class, getStrikePrice());
			processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, getStrikePriceNotation(), this);
			processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, getStrikePriceCurrency(), this);
			processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
			processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
			processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
			processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
			processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
			processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
			processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, getFirstExerciseDate(), this);
			processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
			processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.OtherPaymentBuilder.class, getOtherPayment());
			processRosetta(path.newSubPath("leg1"), processor, CommonLeg.CommonLegBuilder.class, getLeg1());
			processRosetta(path.newSubPath("leg2"), processor, CommonLeg.CommonLegBuilder.class, getLeg2());
			processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
			processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, getExecutionAgentCounterparty1(), this);
			processor.processBasic(path.newSubPath("executionAgentCounterparty2DTCC"), String.class, getExecutionAgentCounterparty2DTCC(), this);
			processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
			processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
			processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, getPriorUTIProprietary(), this);
			processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
			processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, getContractType(), this);
			processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, getAssetClass(), this);
			processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
			processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
			processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, getDirection1(), this);
			processor.processBasic(path.newSubPath("direction2Leg1"), Direction2Enum.class, getDirection2Leg1(), this);
			processor.processBasic(path.newSubPath("direction2Leg2"), Direction2Enum.class, getDirection2Leg2(), this);
			processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
			processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder.class, getBarrier());
			processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
			processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
			processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
			processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.BasketConstituentsReportBuilder.class, getBasketConstituents());
			processRosetta(path.newSubPath("underlying"), processor, UnderlyingIdentifier.UnderlyingIdentifierBuilder.class, getUnderlying());
			processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, getQuantityUnitOfMeasureLeg1(), this);
			processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, getQuantityUnitOfMeasureLeg2(), this);
			processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
			processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, getOptionType(), this);
			processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, getOptionStyle(), this);
			processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, getDeliveryType(), this);
			processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterparty2(), this);
			processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, getBookingLocation(), this);
			processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, getTraderLocation(), this);
			processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, getTradingCapacity(), this);
			processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, getEmbeddedOptionType(), this);
			processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, getSeniority(), this);
			processor.processBasic(path.newSubPath("series"), Integer.class, getSeries(), this);
			processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
			processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
			processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
			processor.processBasic(path.newSubPath("natureOfCounterparty1"), String.class, getNatureOfCounterparty1(), this);
			processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty1"), String.class, getCorporateSectorOfTheCounterparty1(), this);
			processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty1"), Boolean.class, getClearingThresholdOfCounterparty1(), this);
			processor.processBasic(path.newSubPath("countryOfTheCounterParty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterParty2(), this);
			processor.processBasic(path.newSubPath("natureOfCounterparty2"), String.class, getNatureOfCounterparty2(), this);
			processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty2"), String.class, getCorporateSectorOfTheCounterparty2(), this);
			processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty2"), Boolean.class, getClearingThresholdOfCounterparty2(), this);
			processor.processBasic(path.newSubPath("reportingObligationOfTheCounterparty2"), Boolean.class, getReportingObligationOfTheCounterparty2(), this);
			processor.processBasic(path.newSubPath("brokerID"), String.class, getBrokerID(), this);
			processor.processBasic(path.newSubPath("directlyLinkedToCommercialActivityOrTreasuryFinancing"), Boolean.class, getDirectlyLinkedToCommercialActivityOrTreasuryFinancing(), this);
			processor.processBasic(path.newSubPath("reportTrackingNumber"), String.class, getReportTrackingNumber(), this);
			processor.processBasic(path.newSubPath("ptrrId"), String.class, getPtrrId(), this);
			processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, getSubsequentPositionUTI(), this);
			processor.processBasic(path.newSubPath("isin"), String.class, getIsin(), this);
			processor.processBasic(path.newSubPath("productClassification"), String.class, getProductClassification(), this);
			processor.processBasic(path.newSubPath("isCrypto"), Boolean.class, getIsCrypto(), this);
			processor.processBasic(path.newSubPath("indicatorOfTheUnderlyingIndex"), IndexEnum.class, getIndicatorOfTheUnderlyingIndex(), this);
			processor.processBasic(path.newSubPath("customBasketCode"), String.class, getCustomBasketCode(), this);
			processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
			processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
			processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
			processor.processBasic(path.newSubPath("delta"), BigDecimal.class, getDelta(), this);
			processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
			processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, getConfirmationTimestamp(), this);
			processor.processBasic(path.newSubPath("clearingObligation"), String.class, getClearingObligation(), this);
			processor.processBasic(path.newSubPath("masterAgreementType"), String.class, getMasterAgreementType(), this);
			processor.processBasic(path.newSubPath("otherMasterAgreementType"), String.class, getOtherMasterAgreementType(), this);
			processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, getMasterAgreementVersion(), this);
			processor.processBasic(path.newSubPath("intragroup"), Boolean.class, getIntragroup(), this);
			processor.processBasic(path.newSubPath("ptrr"), Boolean.class, getPtrr(), this);
			processor.processBasic(path.newSubPath("typeOfPTRRTechnique"), String.class, getTypeOfPTRRTechnique(), this);
			processor.processBasic(path.newSubPath("ptrrServiceProvider"), String.class, getPtrrServiceProvider(), this);
			processor.processBasic(path.newSubPath("venueOfExecution"), String.class, getVenueOfExecution(), this);
			processor.processBasic(path.newSubPath("forwardExchangeRate"), BigDecimal.class, getForwardExchangeRate(), this);
			processor.processBasic(path.newSubPath("baseProduct"), String.class, getBaseProduct(), this);
			processor.processBasic(path.newSubPath("subProduct"), String.class, getSubProduct(), this);
			processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, getFurtherSubProduct(), this);
			processor.processBasic(path.newSubPath("deliveryPoint"), String.class, getDeliveryPoint(), this);
			processor.processBasic(path.newSubPath("interconnectionPoint"), String.class, getInterconnectionPoint(), this);
			processor.processBasic(path.newSubPath("loadType"), EnergyLoadType1Code.class, getLoadType(), this);
			processRosetta(path.newSubPath("deliveryReport"), processor, ReportableDelivery.ReportableDeliveryBuilder.class, getDeliveryReport());
			processor.processBasic(path.newSubPath("referenceEntity"), String.class, getReferenceEntity(), this);
			processor.processBasic(path.newSubPath("version"), Integer.class, getVersion(), this);
			processor.processBasic(path.newSubPath("tranche"), Boolean.class, getTranche(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, getCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("eventDate"), Date.class, getEventDate(), this);
			processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, getLevel(), this);
		}
		

		EMIRTransactionReport.EMIRTransactionReportBuilder prune();
	}

	/*********************** Immutable Implementation of EMIRTransactionReport  ***********************/
	class EMIRTransactionReportImpl extends CommonTransactionReport.CommonTransactionReportImpl implements EMIRTransactionReport {
		private final String entityResponsibleForReporting;
		private final String natureOfCounterparty1;
		private final List<String> corporateSectorOfTheCounterparty1;
		private final Boolean clearingThresholdOfCounterparty1;
		private final ISOCountryCodeEnum countryOfTheCounterParty2;
		private final String natureOfCounterparty2;
		private final List<String> corporateSectorOfTheCounterparty2;
		private final Boolean clearingThresholdOfCounterparty2;
		private final Boolean reportingObligationOfTheCounterparty2;
		private final String brokerID;
		private final Boolean directlyLinkedToCommercialActivityOrTreasuryFinancing;
		private final String reportTrackingNumber;
		private final String ptrrId;
		private final String subsequentPositionUTI;
		private final String isin;
		private final String productClassification;
		private final Boolean isCrypto;
		private final List<IndexEnum> indicatorOfTheUnderlyingIndex;
		private final String customBasketCode;
		private final BigDecimal valuationAmount;
		private final ISOCurrencyCodeEnum valuationCurrency;
		private final ValuationType1Code valuationMethod;
		private final BigDecimal delta;
		private final ZonedDateTime valuationTimestamp;
		private final ZonedDateTime confirmationTimestamp;
		private final String clearingObligation;
		private final String masterAgreementType;
		private final String otherMasterAgreementType;
		private final Integer masterAgreementVersion;
		private final Boolean intragroup;
		private final Boolean ptrr;
		private final String typeOfPTRRTechnique;
		private final String ptrrServiceProvider;
		private final String venueOfExecution;
		private final BigDecimal forwardExchangeRate;
		private final String baseProduct;
		private final String subProduct;
		private final String furtherSubProduct;
		private final List<String> deliveryPoint;
		private final String interconnectionPoint;
		private final EnergyLoadType1Code loadType;
		private final List<? extends ReportableDelivery> deliveryReport;
		private final String referenceEntity;
		private final Integer version;
		private final Boolean tranche;
		private final String collateralPortfolioCode;
		private final Date eventDate;
		private final ReportLevelEnum level;
		
		protected EMIRTransactionReportImpl(EMIRTransactionReport.EMIRTransactionReportBuilder builder) {
			super(builder);
			this.entityResponsibleForReporting = builder.getEntityResponsibleForReporting();
			this.natureOfCounterparty1 = builder.getNatureOfCounterparty1();
			this.corporateSectorOfTheCounterparty1 = ofNullable(builder.getCorporateSectorOfTheCounterparty1()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.clearingThresholdOfCounterparty1 = builder.getClearingThresholdOfCounterparty1();
			this.countryOfTheCounterParty2 = builder.getCountryOfTheCounterParty2();
			this.natureOfCounterparty2 = builder.getNatureOfCounterparty2();
			this.corporateSectorOfTheCounterparty2 = ofNullable(builder.getCorporateSectorOfTheCounterparty2()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.clearingThresholdOfCounterparty2 = builder.getClearingThresholdOfCounterparty2();
			this.reportingObligationOfTheCounterparty2 = builder.getReportingObligationOfTheCounterparty2();
			this.brokerID = builder.getBrokerID();
			this.directlyLinkedToCommercialActivityOrTreasuryFinancing = builder.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing();
			this.reportTrackingNumber = builder.getReportTrackingNumber();
			this.ptrrId = builder.getPtrrId();
			this.subsequentPositionUTI = builder.getSubsequentPositionUTI();
			this.isin = builder.getIsin();
			this.productClassification = builder.getProductClassification();
			this.isCrypto = builder.getIsCrypto();
			this.indicatorOfTheUnderlyingIndex = ofNullable(builder.getIndicatorOfTheUnderlyingIndex()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.customBasketCode = builder.getCustomBasketCode();
			this.valuationAmount = builder.getValuationAmount();
			this.valuationCurrency = builder.getValuationCurrency();
			this.valuationMethod = builder.getValuationMethod();
			this.delta = builder.getDelta();
			this.valuationTimestamp = builder.getValuationTimestamp();
			this.confirmationTimestamp = builder.getConfirmationTimestamp();
			this.clearingObligation = builder.getClearingObligation();
			this.masterAgreementType = builder.getMasterAgreementType();
			this.otherMasterAgreementType = builder.getOtherMasterAgreementType();
			this.masterAgreementVersion = builder.getMasterAgreementVersion();
			this.intragroup = builder.getIntragroup();
			this.ptrr = builder.getPtrr();
			this.typeOfPTRRTechnique = builder.getTypeOfPTRRTechnique();
			this.ptrrServiceProvider = builder.getPtrrServiceProvider();
			this.venueOfExecution = builder.getVenueOfExecution();
			this.forwardExchangeRate = builder.getForwardExchangeRate();
			this.baseProduct = builder.getBaseProduct();
			this.subProduct = builder.getSubProduct();
			this.furtherSubProduct = builder.getFurtherSubProduct();
			this.deliveryPoint = ofNullable(builder.getDeliveryPoint()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.interconnectionPoint = builder.getInterconnectionPoint();
			this.loadType = builder.getLoadType();
			this.deliveryReport = ofNullable(builder.getDeliveryReport()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.referenceEntity = builder.getReferenceEntity();
			this.version = builder.getVersion();
			this.tranche = builder.getTranche();
			this.collateralPortfolioCode = builder.getCollateralPortfolioCode();
			this.eventDate = builder.getEventDate();
			this.level = builder.getLevel();
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public String getEntityResponsibleForReporting() {
			return entityResponsibleForReporting;
		}
		
		@Override
		@RosettaAttribute("natureOfCounterparty1")
		@RuneAttribute("natureOfCounterparty1")
		public String getNatureOfCounterparty1() {
			return natureOfCounterparty1;
		}
		
		@Override
		@RosettaAttribute("corporateSectorOfTheCounterparty1")
		@RuneAttribute("corporateSectorOfTheCounterparty1")
		public List<String> getCorporateSectorOfTheCounterparty1() {
			return corporateSectorOfTheCounterparty1;
		}
		
		@Override
		@RosettaAttribute("clearingThresholdOfCounterparty1")
		@RuneAttribute("clearingThresholdOfCounterparty1")
		public Boolean getClearingThresholdOfCounterparty1() {
			return clearingThresholdOfCounterparty1;
		}
		
		@Override
		@RosettaAttribute("countryOfTheCounterParty2")
		@RuneAttribute("countryOfTheCounterParty2")
		public ISOCountryCodeEnum getCountryOfTheCounterParty2() {
			return countryOfTheCounterParty2;
		}
		
		@Override
		@RosettaAttribute("natureOfCounterparty2")
		@RuneAttribute("natureOfCounterparty2")
		public String getNatureOfCounterparty2() {
			return natureOfCounterparty2;
		}
		
		@Override
		@RosettaAttribute("corporateSectorOfTheCounterparty2")
		@RuneAttribute("corporateSectorOfTheCounterparty2")
		public List<String> getCorporateSectorOfTheCounterparty2() {
			return corporateSectorOfTheCounterparty2;
		}
		
		@Override
		@RosettaAttribute("clearingThresholdOfCounterparty2")
		@RuneAttribute("clearingThresholdOfCounterparty2")
		public Boolean getClearingThresholdOfCounterparty2() {
			return clearingThresholdOfCounterparty2;
		}
		
		@Override
		@RosettaAttribute("reportingObligationOfTheCounterparty2")
		@RuneAttribute("reportingObligationOfTheCounterparty2")
		public Boolean getReportingObligationOfTheCounterparty2() {
			return reportingObligationOfTheCounterparty2;
		}
		
		@Override
		@RosettaAttribute("brokerID")
		@RuneAttribute("brokerID")
		public String getBrokerID() {
			return brokerID;
		}
		
		@Override
		@RosettaAttribute("directlyLinkedToCommercialActivityOrTreasuryFinancing")
		@RuneAttribute("directlyLinkedToCommercialActivityOrTreasuryFinancing")
		public Boolean getDirectlyLinkedToCommercialActivityOrTreasuryFinancing() {
			return directlyLinkedToCommercialActivityOrTreasuryFinancing;
		}
		
		@Override
		@RosettaAttribute("reportTrackingNumber")
		@RuneAttribute("reportTrackingNumber")
		public String getReportTrackingNumber() {
			return reportTrackingNumber;
		}
		
		@Override
		@RosettaAttribute("ptrrId")
		@RuneAttribute("ptrrId")
		public String getPtrrId() {
			return ptrrId;
		}
		
		@Override
		@RosettaAttribute("subsequentPositionUTI")
		@RuneAttribute("subsequentPositionUTI")
		public String getSubsequentPositionUTI() {
			return subsequentPositionUTI;
		}
		
		@Override
		@RosettaAttribute("isin")
		@RuneAttribute("isin")
		public String getIsin() {
			return isin;
		}
		
		@Override
		@RosettaAttribute("productClassification")
		@RuneAttribute("productClassification")
		public String getProductClassification() {
			return productClassification;
		}
		
		@Override
		@RosettaAttribute("isCrypto")
		@RuneAttribute("isCrypto")
		public Boolean getIsCrypto() {
			return isCrypto;
		}
		
		@Override
		@RosettaAttribute("indicatorOfTheUnderlyingIndex")
		@RuneAttribute("indicatorOfTheUnderlyingIndex")
		public List<IndexEnum> getIndicatorOfTheUnderlyingIndex() {
			return indicatorOfTheUnderlyingIndex;
		}
		
		@Override
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		public String getCustomBasketCode() {
			return customBasketCode;
		}
		
		@Override
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		public BigDecimal getValuationAmount() {
			return valuationAmount;
		}
		
		@Override
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		public ISOCurrencyCodeEnum getValuationCurrency() {
			return valuationCurrency;
		}
		
		@Override
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		public ValuationType1Code getValuationMethod() {
			return valuationMethod;
		}
		
		@Override
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		public BigDecimal getDelta() {
			return delta;
		}
		
		@Override
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		public ZonedDateTime getValuationTimestamp() {
			return valuationTimestamp;
		}
		
		@Override
		@RosettaAttribute("confirmationTimestamp")
		@RuneAttribute("confirmationTimestamp")
		public ZonedDateTime getConfirmationTimestamp() {
			return confirmationTimestamp;
		}
		
		@Override
		@RosettaAttribute("clearingObligation")
		@RuneAttribute("clearingObligation")
		public String getClearingObligation() {
			return clearingObligation;
		}
		
		@Override
		@RosettaAttribute("masterAgreementType")
		@RuneAttribute("masterAgreementType")
		public String getMasterAgreementType() {
			return masterAgreementType;
		}
		
		@Override
		@RosettaAttribute("otherMasterAgreementType")
		@RuneAttribute("otherMasterAgreementType")
		public String getOtherMasterAgreementType() {
			return otherMasterAgreementType;
		}
		
		@Override
		@RosettaAttribute("masterAgreementVersion")
		@RuneAttribute("masterAgreementVersion")
		public Integer getMasterAgreementVersion() {
			return masterAgreementVersion;
		}
		
		@Override
		@RosettaAttribute("intragroup")
		@RuneAttribute("intragroup")
		public Boolean getIntragroup() {
			return intragroup;
		}
		
		@Override
		@RosettaAttribute("ptrr")
		@RuneAttribute("ptrr")
		public Boolean getPtrr() {
			return ptrr;
		}
		
		@Override
		@RosettaAttribute("typeOfPTRRTechnique")
		@RuneAttribute("typeOfPTRRTechnique")
		public String getTypeOfPTRRTechnique() {
			return typeOfPTRRTechnique;
		}
		
		@Override
		@RosettaAttribute("ptrrServiceProvider")
		@RuneAttribute("ptrrServiceProvider")
		public String getPtrrServiceProvider() {
			return ptrrServiceProvider;
		}
		
		@Override
		@RosettaAttribute("venueOfExecution")
		@RuneAttribute("venueOfExecution")
		public String getVenueOfExecution() {
			return venueOfExecution;
		}
		
		@Override
		@RosettaAttribute("forwardExchangeRate")
		@RuneAttribute("forwardExchangeRate")
		public BigDecimal getForwardExchangeRate() {
			return forwardExchangeRate;
		}
		
		@Override
		@RosettaAttribute("baseProduct")
		@RuneAttribute("baseProduct")
		public String getBaseProduct() {
			return baseProduct;
		}
		
		@Override
		@RosettaAttribute("subProduct")
		@RuneAttribute("subProduct")
		public String getSubProduct() {
			return subProduct;
		}
		
		@Override
		@RosettaAttribute("furtherSubProduct")
		@RuneAttribute("furtherSubProduct")
		public String getFurtherSubProduct() {
			return furtherSubProduct;
		}
		
		@Override
		@RosettaAttribute("deliveryPoint")
		@RuneAttribute("deliveryPoint")
		public List<String> getDeliveryPoint() {
			return deliveryPoint;
		}
		
		@Override
		@RosettaAttribute("interconnectionPoint")
		@RuneAttribute("interconnectionPoint")
		public String getInterconnectionPoint() {
			return interconnectionPoint;
		}
		
		@Override
		@RosettaAttribute("loadType")
		@RuneAttribute("loadType")
		public EnergyLoadType1Code getLoadType() {
			return loadType;
		}
		
		@Override
		@RosettaAttribute("deliveryReport")
		@RuneAttribute("deliveryReport")
		public List<? extends ReportableDelivery> getDeliveryReport() {
			return deliveryReport;
		}
		
		@Override
		@RosettaAttribute("referenceEntity")
		@RuneAttribute("referenceEntity")
		public String getReferenceEntity() {
			return referenceEntity;
		}
		
		@Override
		@RosettaAttribute("version")
		@RuneAttribute("version")
		public Integer getVersion() {
			return version;
		}
		
		@Override
		@RosettaAttribute("tranche")
		@RuneAttribute("tranche")
		public Boolean getTranche() {
			return tranche;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioCode")
		@RuneAttribute("collateralPortfolioCode")
		public String getCollateralPortfolioCode() {
			return collateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("eventDate")
		@RuneAttribute("eventDate")
		public Date getEventDate() {
			return eventDate;
		}
		
		@Override
		@RosettaAttribute("level")
		@RuneAttribute("level")
		public ReportLevelEnum getLevel() {
			return level;
		}
		
		@Override
		public EMIRTransactionReport build() {
			return this;
		}
		
		@Override
		public EMIRTransactionReport.EMIRTransactionReportBuilder toBuilder() {
			EMIRTransactionReport.EMIRTransactionReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(EMIRTransactionReport.EMIRTransactionReportBuilder builder) {
			super.setBuilderFields(builder);
			ofNullable(getEntityResponsibleForReporting()).ifPresent(builder::setEntityResponsibleForReporting);
			ofNullable(getNatureOfCounterparty1()).ifPresent(builder::setNatureOfCounterparty1);
			ofNullable(getCorporateSectorOfTheCounterparty1()).ifPresent(builder::setCorporateSectorOfTheCounterparty1);
			ofNullable(getClearingThresholdOfCounterparty1()).ifPresent(builder::setClearingThresholdOfCounterparty1);
			ofNullable(getCountryOfTheCounterParty2()).ifPresent(builder::setCountryOfTheCounterParty2);
			ofNullable(getNatureOfCounterparty2()).ifPresent(builder::setNatureOfCounterparty2);
			ofNullable(getCorporateSectorOfTheCounterparty2()).ifPresent(builder::setCorporateSectorOfTheCounterparty2);
			ofNullable(getClearingThresholdOfCounterparty2()).ifPresent(builder::setClearingThresholdOfCounterparty2);
			ofNullable(getReportingObligationOfTheCounterparty2()).ifPresent(builder::setReportingObligationOfTheCounterparty2);
			ofNullable(getBrokerID()).ifPresent(builder::setBrokerID);
			ofNullable(getDirectlyLinkedToCommercialActivityOrTreasuryFinancing()).ifPresent(builder::setDirectlyLinkedToCommercialActivityOrTreasuryFinancing);
			ofNullable(getReportTrackingNumber()).ifPresent(builder::setReportTrackingNumber);
			ofNullable(getPtrrId()).ifPresent(builder::setPtrrId);
			ofNullable(getSubsequentPositionUTI()).ifPresent(builder::setSubsequentPositionUTI);
			ofNullable(getIsin()).ifPresent(builder::setIsin);
			ofNullable(getProductClassification()).ifPresent(builder::setProductClassification);
			ofNullable(getIsCrypto()).ifPresent(builder::setIsCrypto);
			ofNullable(getIndicatorOfTheUnderlyingIndex()).ifPresent(builder::setIndicatorOfTheUnderlyingIndex);
			ofNullable(getCustomBasketCode()).ifPresent(builder::setCustomBasketCode);
			ofNullable(getValuationAmount()).ifPresent(builder::setValuationAmount);
			ofNullable(getValuationCurrency()).ifPresent(builder::setValuationCurrency);
			ofNullable(getValuationMethod()).ifPresent(builder::setValuationMethod);
			ofNullable(getDelta()).ifPresent(builder::setDelta);
			ofNullable(getValuationTimestamp()).ifPresent(builder::setValuationTimestamp);
			ofNullable(getConfirmationTimestamp()).ifPresent(builder::setConfirmationTimestamp);
			ofNullable(getClearingObligation()).ifPresent(builder::setClearingObligation);
			ofNullable(getMasterAgreementType()).ifPresent(builder::setMasterAgreementType);
			ofNullable(getOtherMasterAgreementType()).ifPresent(builder::setOtherMasterAgreementType);
			ofNullable(getMasterAgreementVersion()).ifPresent(builder::setMasterAgreementVersion);
			ofNullable(getIntragroup()).ifPresent(builder::setIntragroup);
			ofNullable(getPtrr()).ifPresent(builder::setPtrr);
			ofNullable(getTypeOfPTRRTechnique()).ifPresent(builder::setTypeOfPTRRTechnique);
			ofNullable(getPtrrServiceProvider()).ifPresent(builder::setPtrrServiceProvider);
			ofNullable(getVenueOfExecution()).ifPresent(builder::setVenueOfExecution);
			ofNullable(getForwardExchangeRate()).ifPresent(builder::setForwardExchangeRate);
			ofNullable(getBaseProduct()).ifPresent(builder::setBaseProduct);
			ofNullable(getSubProduct()).ifPresent(builder::setSubProduct);
			ofNullable(getFurtherSubProduct()).ifPresent(builder::setFurtherSubProduct);
			ofNullable(getDeliveryPoint()).ifPresent(builder::setDeliveryPoint);
			ofNullable(getInterconnectionPoint()).ifPresent(builder::setInterconnectionPoint);
			ofNullable(getLoadType()).ifPresent(builder::setLoadType);
			ofNullable(getDeliveryReport()).ifPresent(builder::setDeliveryReport);
			ofNullable(getReferenceEntity()).ifPresent(builder::setReferenceEntity);
			ofNullable(getVersion()).ifPresent(builder::setVersion);
			ofNullable(getTranche()).ifPresent(builder::setTranche);
			ofNullable(getCollateralPortfolioCode()).ifPresent(builder::setCollateralPortfolioCode);
			ofNullable(getEventDate()).ifPresent(builder::setEventDate);
			ofNullable(getLevel()).ifPresent(builder::setLevel);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			EMIRTransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) return false;
			if (!Objects.equals(natureOfCounterparty1, _that.getNatureOfCounterparty1())) return false;
			if (!ListEquals.listEquals(corporateSectorOfTheCounterparty1, _that.getCorporateSectorOfTheCounterparty1())) return false;
			if (!Objects.equals(clearingThresholdOfCounterparty1, _that.getClearingThresholdOfCounterparty1())) return false;
			if (!Objects.equals(countryOfTheCounterParty2, _that.getCountryOfTheCounterParty2())) return false;
			if (!Objects.equals(natureOfCounterparty2, _that.getNatureOfCounterparty2())) return false;
			if (!ListEquals.listEquals(corporateSectorOfTheCounterparty2, _that.getCorporateSectorOfTheCounterparty2())) return false;
			if (!Objects.equals(clearingThresholdOfCounterparty2, _that.getClearingThresholdOfCounterparty2())) return false;
			if (!Objects.equals(reportingObligationOfTheCounterparty2, _that.getReportingObligationOfTheCounterparty2())) return false;
			if (!Objects.equals(brokerID, _that.getBrokerID())) return false;
			if (!Objects.equals(directlyLinkedToCommercialActivityOrTreasuryFinancing, _that.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing())) return false;
			if (!Objects.equals(reportTrackingNumber, _that.getReportTrackingNumber())) return false;
			if (!Objects.equals(ptrrId, _that.getPtrrId())) return false;
			if (!Objects.equals(subsequentPositionUTI, _that.getSubsequentPositionUTI())) return false;
			if (!Objects.equals(isin, _that.getIsin())) return false;
			if (!Objects.equals(productClassification, _that.getProductClassification())) return false;
			if (!Objects.equals(isCrypto, _that.getIsCrypto())) return false;
			if (!ListEquals.listEquals(indicatorOfTheUnderlyingIndex, _that.getIndicatorOfTheUnderlyingIndex())) return false;
			if (!Objects.equals(customBasketCode, _that.getCustomBasketCode())) return false;
			if (!Objects.equals(valuationAmount, _that.getValuationAmount())) return false;
			if (!Objects.equals(valuationCurrency, _that.getValuationCurrency())) return false;
			if (!Objects.equals(valuationMethod, _that.getValuationMethod())) return false;
			if (!Objects.equals(delta, _that.getDelta())) return false;
			if (!Objects.equals(valuationTimestamp, _that.getValuationTimestamp())) return false;
			if (!Objects.equals(confirmationTimestamp, _that.getConfirmationTimestamp())) return false;
			if (!Objects.equals(clearingObligation, _that.getClearingObligation())) return false;
			if (!Objects.equals(masterAgreementType, _that.getMasterAgreementType())) return false;
			if (!Objects.equals(otherMasterAgreementType, _that.getOtherMasterAgreementType())) return false;
			if (!Objects.equals(masterAgreementVersion, _that.getMasterAgreementVersion())) return false;
			if (!Objects.equals(intragroup, _that.getIntragroup())) return false;
			if (!Objects.equals(ptrr, _that.getPtrr())) return false;
			if (!Objects.equals(typeOfPTRRTechnique, _that.getTypeOfPTRRTechnique())) return false;
			if (!Objects.equals(ptrrServiceProvider, _that.getPtrrServiceProvider())) return false;
			if (!Objects.equals(venueOfExecution, _that.getVenueOfExecution())) return false;
			if (!Objects.equals(forwardExchangeRate, _that.getForwardExchangeRate())) return false;
			if (!Objects.equals(baseProduct, _that.getBaseProduct())) return false;
			if (!Objects.equals(subProduct, _that.getSubProduct())) return false;
			if (!Objects.equals(furtherSubProduct, _that.getFurtherSubProduct())) return false;
			if (!ListEquals.listEquals(deliveryPoint, _that.getDeliveryPoint())) return false;
			if (!Objects.equals(interconnectionPoint, _that.getInterconnectionPoint())) return false;
			if (!Objects.equals(loadType, _that.getLoadType())) return false;
			if (!ListEquals.listEquals(deliveryReport, _that.getDeliveryReport())) return false;
			if (!Objects.equals(referenceEntity, _that.getReferenceEntity())) return false;
			if (!Objects.equals(version, _that.getVersion())) return false;
			if (!Objects.equals(tranche, _that.getTranche())) return false;
			if (!Objects.equals(collateralPortfolioCode, _that.getCollateralPortfolioCode())) return false;
			if (!Objects.equals(eventDate, _that.getEventDate())) return false;
			if (!Objects.equals(level, _that.getLevel())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (entityResponsibleForReporting != null ? entityResponsibleForReporting.hashCode() : 0);
			_result = 31 * _result + (natureOfCounterparty1 != null ? natureOfCounterparty1.hashCode() : 0);
			_result = 31 * _result + (corporateSectorOfTheCounterparty1 != null ? corporateSectorOfTheCounterparty1.hashCode() : 0);
			_result = 31 * _result + (clearingThresholdOfCounterparty1 != null ? clearingThresholdOfCounterparty1.hashCode() : 0);
			_result = 31 * _result + (countryOfTheCounterParty2 != null ? countryOfTheCounterParty2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (natureOfCounterparty2 != null ? natureOfCounterparty2.hashCode() : 0);
			_result = 31 * _result + (corporateSectorOfTheCounterparty2 != null ? corporateSectorOfTheCounterparty2.hashCode() : 0);
			_result = 31 * _result + (clearingThresholdOfCounterparty2 != null ? clearingThresholdOfCounterparty2.hashCode() : 0);
			_result = 31 * _result + (reportingObligationOfTheCounterparty2 != null ? reportingObligationOfTheCounterparty2.hashCode() : 0);
			_result = 31 * _result + (brokerID != null ? brokerID.hashCode() : 0);
			_result = 31 * _result + (directlyLinkedToCommercialActivityOrTreasuryFinancing != null ? directlyLinkedToCommercialActivityOrTreasuryFinancing.hashCode() : 0);
			_result = 31 * _result + (reportTrackingNumber != null ? reportTrackingNumber.hashCode() : 0);
			_result = 31 * _result + (ptrrId != null ? ptrrId.hashCode() : 0);
			_result = 31 * _result + (subsequentPositionUTI != null ? subsequentPositionUTI.hashCode() : 0);
			_result = 31 * _result + (isin != null ? isin.hashCode() : 0);
			_result = 31 * _result + (productClassification != null ? productClassification.hashCode() : 0);
			_result = 31 * _result + (isCrypto != null ? isCrypto.hashCode() : 0);
			_result = 31 * _result + (indicatorOfTheUnderlyingIndex != null ? indicatorOfTheUnderlyingIndex.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
			_result = 31 * _result + (customBasketCode != null ? customBasketCode.hashCode() : 0);
			_result = 31 * _result + (valuationAmount != null ? valuationAmount.hashCode() : 0);
			_result = 31 * _result + (valuationCurrency != null ? valuationCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationMethod != null ? valuationMethod.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (delta != null ? delta.hashCode() : 0);
			_result = 31 * _result + (valuationTimestamp != null ? valuationTimestamp.hashCode() : 0);
			_result = 31 * _result + (confirmationTimestamp != null ? confirmationTimestamp.hashCode() : 0);
			_result = 31 * _result + (clearingObligation != null ? clearingObligation.hashCode() : 0);
			_result = 31 * _result + (masterAgreementType != null ? masterAgreementType.hashCode() : 0);
			_result = 31 * _result + (otherMasterAgreementType != null ? otherMasterAgreementType.hashCode() : 0);
			_result = 31 * _result + (masterAgreementVersion != null ? masterAgreementVersion.hashCode() : 0);
			_result = 31 * _result + (intragroup != null ? intragroup.hashCode() : 0);
			_result = 31 * _result + (ptrr != null ? ptrr.hashCode() : 0);
			_result = 31 * _result + (typeOfPTRRTechnique != null ? typeOfPTRRTechnique.hashCode() : 0);
			_result = 31 * _result + (ptrrServiceProvider != null ? ptrrServiceProvider.hashCode() : 0);
			_result = 31 * _result + (venueOfExecution != null ? venueOfExecution.hashCode() : 0);
			_result = 31 * _result + (forwardExchangeRate != null ? forwardExchangeRate.hashCode() : 0);
			_result = 31 * _result + (baseProduct != null ? baseProduct.hashCode() : 0);
			_result = 31 * _result + (subProduct != null ? subProduct.hashCode() : 0);
			_result = 31 * _result + (furtherSubProduct != null ? furtherSubProduct.hashCode() : 0);
			_result = 31 * _result + (deliveryPoint != null ? deliveryPoint.hashCode() : 0);
			_result = 31 * _result + (interconnectionPoint != null ? interconnectionPoint.hashCode() : 0);
			_result = 31 * _result + (loadType != null ? loadType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (deliveryReport != null ? deliveryReport.hashCode() : 0);
			_result = 31 * _result + (referenceEntity != null ? referenceEntity.hashCode() : 0);
			_result = 31 * _result + (version != null ? version.hashCode() : 0);
			_result = 31 * _result + (tranche != null ? tranche.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioCode != null ? collateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (eventDate != null ? eventDate.hashCode() : 0);
			_result = 31 * _result + (level != null ? level.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "EMIRTransactionReport {" +
				"entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", " +
				"natureOfCounterparty1=" + this.natureOfCounterparty1 + ", " +
				"corporateSectorOfTheCounterparty1=" + this.corporateSectorOfTheCounterparty1 + ", " +
				"clearingThresholdOfCounterparty1=" + this.clearingThresholdOfCounterparty1 + ", " +
				"countryOfTheCounterParty2=" + this.countryOfTheCounterParty2 + ", " +
				"natureOfCounterparty2=" + this.natureOfCounterparty2 + ", " +
				"corporateSectorOfTheCounterparty2=" + this.corporateSectorOfTheCounterparty2 + ", " +
				"clearingThresholdOfCounterparty2=" + this.clearingThresholdOfCounterparty2 + ", " +
				"reportingObligationOfTheCounterparty2=" + this.reportingObligationOfTheCounterparty2 + ", " +
				"brokerID=" + this.brokerID + ", " +
				"directlyLinkedToCommercialActivityOrTreasuryFinancing=" + this.directlyLinkedToCommercialActivityOrTreasuryFinancing + ", " +
				"reportTrackingNumber=" + this.reportTrackingNumber + ", " +
				"ptrrId=" + this.ptrrId + ", " +
				"subsequentPositionUTI=" + this.subsequentPositionUTI + ", " +
				"isin=" + this.isin + ", " +
				"productClassification=" + this.productClassification + ", " +
				"isCrypto=" + this.isCrypto + ", " +
				"indicatorOfTheUnderlyingIndex=" + this.indicatorOfTheUnderlyingIndex + ", " +
				"customBasketCode=" + this.customBasketCode + ", " +
				"valuationAmount=" + this.valuationAmount + ", " +
				"valuationCurrency=" + this.valuationCurrency + ", " +
				"valuationMethod=" + this.valuationMethod + ", " +
				"delta=" + this.delta + ", " +
				"valuationTimestamp=" + this.valuationTimestamp + ", " +
				"confirmationTimestamp=" + this.confirmationTimestamp + ", " +
				"clearingObligation=" + this.clearingObligation + ", " +
				"masterAgreementType=" + this.masterAgreementType + ", " +
				"otherMasterAgreementType=" + this.otherMasterAgreementType + ", " +
				"masterAgreementVersion=" + this.masterAgreementVersion + ", " +
				"intragroup=" + this.intragroup + ", " +
				"ptrr=" + this.ptrr + ", " +
				"typeOfPTRRTechnique=" + this.typeOfPTRRTechnique + ", " +
				"ptrrServiceProvider=" + this.ptrrServiceProvider + ", " +
				"venueOfExecution=" + this.venueOfExecution + ", " +
				"forwardExchangeRate=" + this.forwardExchangeRate + ", " +
				"baseProduct=" + this.baseProduct + ", " +
				"subProduct=" + this.subProduct + ", " +
				"furtherSubProduct=" + this.furtherSubProduct + ", " +
				"deliveryPoint=" + this.deliveryPoint + ", " +
				"interconnectionPoint=" + this.interconnectionPoint + ", " +
				"loadType=" + this.loadType + ", " +
				"deliveryReport=" + this.deliveryReport + ", " +
				"referenceEntity=" + this.referenceEntity + ", " +
				"version=" + this.version + ", " +
				"tranche=" + this.tranche + ", " +
				"collateralPortfolioCode=" + this.collateralPortfolioCode + ", " +
				"eventDate=" + this.eventDate + ", " +
				"level=" + this.level +
			'}' + " " + super.toString();
		}
	}

	/*********************** Builder Implementation of EMIRTransactionReport  ***********************/
	class EMIRTransactionReportBuilderImpl extends CommonTransactionReport.CommonTransactionReportBuilderImpl implements EMIRTransactionReport.EMIRTransactionReportBuilder {
	
		protected String entityResponsibleForReporting;
		protected String natureOfCounterparty1;
		protected List<String> corporateSectorOfTheCounterparty1 = new ArrayList<>();
		protected Boolean clearingThresholdOfCounterparty1;
		protected ISOCountryCodeEnum countryOfTheCounterParty2;
		protected String natureOfCounterparty2;
		protected List<String> corporateSectorOfTheCounterparty2 = new ArrayList<>();
		protected Boolean clearingThresholdOfCounterparty2;
		protected Boolean reportingObligationOfTheCounterparty2;
		protected String brokerID;
		protected Boolean directlyLinkedToCommercialActivityOrTreasuryFinancing;
		protected String reportTrackingNumber;
		protected String ptrrId;
		protected String subsequentPositionUTI;
		protected String isin;
		protected String productClassification;
		protected Boolean isCrypto;
		protected List<IndexEnum> indicatorOfTheUnderlyingIndex = new ArrayList<>();
		protected String customBasketCode;
		protected BigDecimal valuationAmount;
		protected ISOCurrencyCodeEnum valuationCurrency;
		protected ValuationType1Code valuationMethod;
		protected BigDecimal delta;
		protected ZonedDateTime valuationTimestamp;
		protected ZonedDateTime confirmationTimestamp;
		protected String clearingObligation;
		protected String masterAgreementType;
		protected String otherMasterAgreementType;
		protected Integer masterAgreementVersion;
		protected Boolean intragroup;
		protected Boolean ptrr;
		protected String typeOfPTRRTechnique;
		protected String ptrrServiceProvider;
		protected String venueOfExecution;
		protected BigDecimal forwardExchangeRate;
		protected String baseProduct;
		protected String subProduct;
		protected String furtherSubProduct;
		protected List<String> deliveryPoint = new ArrayList<>();
		protected String interconnectionPoint;
		protected EnergyLoadType1Code loadType;
		protected List<ReportableDelivery.ReportableDeliveryBuilder> deliveryReport = new ArrayList<>();
		protected String referenceEntity;
		protected Integer version;
		protected Boolean tranche;
		protected String collateralPortfolioCode;
		protected Date eventDate;
		protected ReportLevelEnum level;
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public String getEntityResponsibleForReporting() {
			return entityResponsibleForReporting;
		}
		
		@Override
		@RosettaAttribute("natureOfCounterparty1")
		@RuneAttribute("natureOfCounterparty1")
		public String getNatureOfCounterparty1() {
			return natureOfCounterparty1;
		}
		
		@Override
		@RosettaAttribute("corporateSectorOfTheCounterparty1")
		@RuneAttribute("corporateSectorOfTheCounterparty1")
		public List<String> getCorporateSectorOfTheCounterparty1() {
			return corporateSectorOfTheCounterparty1;
		}
		
		@Override
		@RosettaAttribute("clearingThresholdOfCounterparty1")
		@RuneAttribute("clearingThresholdOfCounterparty1")
		public Boolean getClearingThresholdOfCounterparty1() {
			return clearingThresholdOfCounterparty1;
		}
		
		@Override
		@RosettaAttribute("countryOfTheCounterParty2")
		@RuneAttribute("countryOfTheCounterParty2")
		public ISOCountryCodeEnum getCountryOfTheCounterParty2() {
			return countryOfTheCounterParty2;
		}
		
		@Override
		@RosettaAttribute("natureOfCounterparty2")
		@RuneAttribute("natureOfCounterparty2")
		public String getNatureOfCounterparty2() {
			return natureOfCounterparty2;
		}
		
		@Override
		@RosettaAttribute("corporateSectorOfTheCounterparty2")
		@RuneAttribute("corporateSectorOfTheCounterparty2")
		public List<String> getCorporateSectorOfTheCounterparty2() {
			return corporateSectorOfTheCounterparty2;
		}
		
		@Override
		@RosettaAttribute("clearingThresholdOfCounterparty2")
		@RuneAttribute("clearingThresholdOfCounterparty2")
		public Boolean getClearingThresholdOfCounterparty2() {
			return clearingThresholdOfCounterparty2;
		}
		
		@Override
		@RosettaAttribute("reportingObligationOfTheCounterparty2")
		@RuneAttribute("reportingObligationOfTheCounterparty2")
		public Boolean getReportingObligationOfTheCounterparty2() {
			return reportingObligationOfTheCounterparty2;
		}
		
		@Override
		@RosettaAttribute("brokerID")
		@RuneAttribute("brokerID")
		public String getBrokerID() {
			return brokerID;
		}
		
		@Override
		@RosettaAttribute("directlyLinkedToCommercialActivityOrTreasuryFinancing")
		@RuneAttribute("directlyLinkedToCommercialActivityOrTreasuryFinancing")
		public Boolean getDirectlyLinkedToCommercialActivityOrTreasuryFinancing() {
			return directlyLinkedToCommercialActivityOrTreasuryFinancing;
		}
		
		@Override
		@RosettaAttribute("reportTrackingNumber")
		@RuneAttribute("reportTrackingNumber")
		public String getReportTrackingNumber() {
			return reportTrackingNumber;
		}
		
		@Override
		@RosettaAttribute("ptrrId")
		@RuneAttribute("ptrrId")
		public String getPtrrId() {
			return ptrrId;
		}
		
		@Override
		@RosettaAttribute("subsequentPositionUTI")
		@RuneAttribute("subsequentPositionUTI")
		public String getSubsequentPositionUTI() {
			return subsequentPositionUTI;
		}
		
		@Override
		@RosettaAttribute("isin")
		@RuneAttribute("isin")
		public String getIsin() {
			return isin;
		}
		
		@Override
		@RosettaAttribute("productClassification")
		@RuneAttribute("productClassification")
		public String getProductClassification() {
			return productClassification;
		}
		
		@Override
		@RosettaAttribute("isCrypto")
		@RuneAttribute("isCrypto")
		public Boolean getIsCrypto() {
			return isCrypto;
		}
		
		@Override
		@RosettaAttribute("indicatorOfTheUnderlyingIndex")
		@RuneAttribute("indicatorOfTheUnderlyingIndex")
		public List<IndexEnum> getIndicatorOfTheUnderlyingIndex() {
			return indicatorOfTheUnderlyingIndex;
		}
		
		@Override
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		public String getCustomBasketCode() {
			return customBasketCode;
		}
		
		@Override
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		public BigDecimal getValuationAmount() {
			return valuationAmount;
		}
		
		@Override
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		public ISOCurrencyCodeEnum getValuationCurrency() {
			return valuationCurrency;
		}
		
		@Override
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		public ValuationType1Code getValuationMethod() {
			return valuationMethod;
		}
		
		@Override
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		public BigDecimal getDelta() {
			return delta;
		}
		
		@Override
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		public ZonedDateTime getValuationTimestamp() {
			return valuationTimestamp;
		}
		
		@Override
		@RosettaAttribute("confirmationTimestamp")
		@RuneAttribute("confirmationTimestamp")
		public ZonedDateTime getConfirmationTimestamp() {
			return confirmationTimestamp;
		}
		
		@Override
		@RosettaAttribute("clearingObligation")
		@RuneAttribute("clearingObligation")
		public String getClearingObligation() {
			return clearingObligation;
		}
		
		@Override
		@RosettaAttribute("masterAgreementType")
		@RuneAttribute("masterAgreementType")
		public String getMasterAgreementType() {
			return masterAgreementType;
		}
		
		@Override
		@RosettaAttribute("otherMasterAgreementType")
		@RuneAttribute("otherMasterAgreementType")
		public String getOtherMasterAgreementType() {
			return otherMasterAgreementType;
		}
		
		@Override
		@RosettaAttribute("masterAgreementVersion")
		@RuneAttribute("masterAgreementVersion")
		public Integer getMasterAgreementVersion() {
			return masterAgreementVersion;
		}
		
		@Override
		@RosettaAttribute("intragroup")
		@RuneAttribute("intragroup")
		public Boolean getIntragroup() {
			return intragroup;
		}
		
		@Override
		@RosettaAttribute("ptrr")
		@RuneAttribute("ptrr")
		public Boolean getPtrr() {
			return ptrr;
		}
		
		@Override
		@RosettaAttribute("typeOfPTRRTechnique")
		@RuneAttribute("typeOfPTRRTechnique")
		public String getTypeOfPTRRTechnique() {
			return typeOfPTRRTechnique;
		}
		
		@Override
		@RosettaAttribute("ptrrServiceProvider")
		@RuneAttribute("ptrrServiceProvider")
		public String getPtrrServiceProvider() {
			return ptrrServiceProvider;
		}
		
		@Override
		@RosettaAttribute("venueOfExecution")
		@RuneAttribute("venueOfExecution")
		public String getVenueOfExecution() {
			return venueOfExecution;
		}
		
		@Override
		@RosettaAttribute("forwardExchangeRate")
		@RuneAttribute("forwardExchangeRate")
		public BigDecimal getForwardExchangeRate() {
			return forwardExchangeRate;
		}
		
		@Override
		@RosettaAttribute("baseProduct")
		@RuneAttribute("baseProduct")
		public String getBaseProduct() {
			return baseProduct;
		}
		
		@Override
		@RosettaAttribute("subProduct")
		@RuneAttribute("subProduct")
		public String getSubProduct() {
			return subProduct;
		}
		
		@Override
		@RosettaAttribute("furtherSubProduct")
		@RuneAttribute("furtherSubProduct")
		public String getFurtherSubProduct() {
			return furtherSubProduct;
		}
		
		@Override
		@RosettaAttribute("deliveryPoint")
		@RuneAttribute("deliveryPoint")
		public List<String> getDeliveryPoint() {
			return deliveryPoint;
		}
		
		@Override
		@RosettaAttribute("interconnectionPoint")
		@RuneAttribute("interconnectionPoint")
		public String getInterconnectionPoint() {
			return interconnectionPoint;
		}
		
		@Override
		@RosettaAttribute("loadType")
		@RuneAttribute("loadType")
		public EnergyLoadType1Code getLoadType() {
			return loadType;
		}
		
		@Override
		@RosettaAttribute("deliveryReport")
		@RuneAttribute("deliveryReport")
		public List<? extends ReportableDelivery.ReportableDeliveryBuilder> getDeliveryReport() {
			return deliveryReport;
		}
		
		@Override
		public ReportableDelivery.ReportableDeliveryBuilder getOrCreateDeliveryReport(int _index) {
		
			if (deliveryReport==null) {
				this.deliveryReport = new ArrayList<>();
			}
			ReportableDelivery.ReportableDeliveryBuilder result;
			return getIndex(deliveryReport, _index, () -> {
						ReportableDelivery.ReportableDeliveryBuilder newDeliveryReport = ReportableDelivery.builder();
						return newDeliveryReport;
					});
		}
		
		@Override
		@RosettaAttribute("referenceEntity")
		@RuneAttribute("referenceEntity")
		public String getReferenceEntity() {
			return referenceEntity;
		}
		
		@Override
		@RosettaAttribute("version")
		@RuneAttribute("version")
		public Integer getVersion() {
			return version;
		}
		
		@Override
		@RosettaAttribute("tranche")
		@RuneAttribute("tranche")
		public Boolean getTranche() {
			return tranche;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioCode")
		@RuneAttribute("collateralPortfolioCode")
		public String getCollateralPortfolioCode() {
			return collateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("eventDate")
		@RuneAttribute("eventDate")
		public Date getEventDate() {
			return eventDate;
		}
		
		@Override
		@RosettaAttribute("level")
		@RuneAttribute("level")
		public ReportLevelEnum getLevel() {
			return level;
		}
		
		@Override
		@RosettaAttribute("actionType")
		@RuneAttribute("actionType")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setActionType(ActionTypeEnum _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setEventType(EventTypeEnum _eventType) {
			this.eventType = _eventType == null ? null : _eventType;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventIdentifier")
		@RuneAttribute("eventIdentifier")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setEventIdentifier(String _eventIdentifier) {
			this.eventIdentifier = _eventIdentifier == null ? null : _eventIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
			this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("earlyTerminationDate")
		@RuneAttribute("earlyTerminationDate")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setEarlyTerminationDate(Date _earlyTerminationDate) {
			this.earlyTerminationDate = _earlyTerminationDate == null ? null : _earlyTerminationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventTimestamp")
		@RuneAttribute("eventTimestamp")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
			this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("reportingTimestamp")
		@RuneAttribute("reportingTimestamp")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionTimestamp")
		@RuneAttribute("executionTimestamp")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
			this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setExpirationDate(Date _expirationDate) {
			this.expirationDate = _expirationDate == null ? null : _expirationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty1")
		@RuneAttribute("counterparty1")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierType")
		@RuneAttribute("counterparty2IdentifierType")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
			this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
			return this;
		}
		
		@Override
		@RosettaAttribute("beneficiary1")
		@RuneAttribute("beneficiary1")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setBeneficiary1(String _beneficiary1) {
			this.beneficiary1 = _beneficiary1 == null ? null : _beneficiary1;
			return this;
		}
		
		@Override
		@RosettaAttribute("beneficiary1IdentifierTypeIndicator")
		@RuneAttribute("beneficiary1IdentifierTypeIndicator")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean _beneficiary1IdentifierTypeIndicator) {
			this.beneficiary1IdentifierTypeIndicator = _beneficiary1IdentifierTypeIndicator == null ? null : _beneficiary1IdentifierTypeIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("cleared")
		@RuneAttribute("cleared")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setCleared(ClearedEnum _cleared) {
			this.cleared = _cleared == null ? null : _cleared;
			return this;
		}
		
		@Override
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
			this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setClearingMember(String _clearingMember) {
			this.clearingMember = _clearingMember == null ? null : _clearingMember;
			return this;
		}
		
		@Override
		@RosettaAttribute("confirmed")
		@RuneAttribute("confirmed")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setConfirmed(ConfirmationEnum _confirmed) {
			this.confirmed = _confirmed == null ? null : _confirmed;
			return this;
		}
		
		@Override
		@RosettaAttribute("callAmount")
		@RuneAttribute("callAmount")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setCallAmount(BigDecimal _callAmount) {
			this.callAmount = _callAmount == null ? null : _callAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("putAmount")
		@RuneAttribute("putAmount")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setPutAmount(BigDecimal _putAmount) {
			this.putAmount = _putAmount == null ? null : _putAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("callCurrency")
		@RuneAttribute("callCurrency")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
			this.callCurrency = _callCurrency == null ? null : _callCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("putCurrency")
		@RuneAttribute("putCurrency")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
			this.putCurrency = _putCurrency == null ? null : _putCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("priceSchedule")
		@RuneAttribute("priceSchedule")
		public EMIRTransactionReport.EMIRTransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule) {
			if (_priceSchedule != null) {
				this.priceSchedule.add(_priceSchedule.toBuilder());
			}
			return this;
		}
		
		@Override
		public EMIRTransactionReport.EMIRTransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule, int _idx) {
			getIndex(this.priceSchedule, _idx, () -> _priceSchedule.toBuilder());
			return this;
		}
		
		@Override 
		public EMIRTransactionReport.EMIRTransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedules) {
			if (priceSchedules != null) {
				for (final PricePeriod toAdd : priceSchedules) {
					this.priceSchedule.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("priceSchedule")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedules) {
			if (priceSchedules == null) {
				this.priceSchedule = new ArrayList<>();
			} else {
				this.priceSchedule = priceSchedules.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceSchedule")
		@RuneAttribute("strikePriceSchedule")
		public EMIRTransactionReport.EMIRTransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule) {
			if (_strikePriceSchedule != null) {
				this.strikePriceSchedule.add(_strikePriceSchedule.toBuilder());
			}
			return this;
		}
		
		@Override
		public EMIRTransactionReport.EMIRTransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule, int _idx) {
			getIndex(this.strikePriceSchedule, _idx, () -> _strikePriceSchedule.toBuilder());
			return this;
		}
		
		@Override 
		public EMIRTransactionReport.EMIRTransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
			if (strikePriceSchedules != null) {
				for (final PricePeriod toAdd : strikePriceSchedules) {
					this.strikePriceSchedule.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("strikePriceSchedule")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
			if (strikePriceSchedules == null) {
				this.strikePriceSchedule = new ArrayList<>();
			} else {
				this.strikePriceSchedule = strikePriceSchedules.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("price")
		@RuneAttribute("price")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setPrice(PriceFormat _price) {
			this.price = _price == null ? null : _price.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("priceNotation")
		@RuneAttribute("priceNotation")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setPriceNotation(PriceNotationEnum _priceNotation) {
			this.priceNotation = _priceNotation == null ? null : _priceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("priceCurrency")
		@RuneAttribute("priceCurrency")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum _priceCurrency) {
			this.priceCurrency = _priceCurrency == null ? null : _priceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPrice")
		@RuneAttribute("packageTransactionPrice")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setPackageTransactionPrice(PriceFormat _packageTransactionPrice) {
			this.packageTransactionPrice = _packageTransactionPrice == null ? null : _packageTransactionPrice.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceNotation")
		@RuneAttribute("packageTransactionPriceNotation")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum _packageTransactionPriceNotation) {
			this.packageTransactionPriceNotation = _packageTransactionPriceNotation == null ? null : _packageTransactionPriceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceCurrency")
		@RuneAttribute("packageTransactionPriceCurrency")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum _packageTransactionPriceCurrency) {
			this.packageTransactionPriceCurrency = _packageTransactionPriceCurrency == null ? null : _packageTransactionPriceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpread")
		@RuneAttribute("packageTransactionSpread")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setPackageTransactionSpread(PriceFormat _packageTransactionSpread) {
			this.packageTransactionSpread = _packageTransactionSpread == null ? null : _packageTransactionSpread.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadNotation")
		@RuneAttribute("packageTransactionSpreadNotation")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum _packageTransactionSpreadNotation) {
			this.packageTransactionSpreadNotation = _packageTransactionSpreadNotation == null ? null : _packageTransactionSpreadNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadCurrency")
		@RuneAttribute("packageTransactionSpreadCurrency")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum _packageTransactionSpreadCurrency) {
			this.packageTransactionSpreadCurrency = _packageTransactionSpreadCurrency == null ? null : _packageTransactionSpreadCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setStrikePrice(PriceFormat _strikePrice) {
			this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceNotation")
		@RuneAttribute("strikePriceNotation")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setStrikePriceNotation(PriceNotationEnum _strikePriceNotation) {
			this.strikePriceNotation = _strikePriceNotation == null ? null : _strikePriceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceCurrency")
		@RuneAttribute("strikePriceCurrency")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setStrikePriceCurrency(String _strikePriceCurrency) {
			this.strikePriceCurrency = _strikePriceCurrency == null ? null : _strikePriceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("priceUnitOfMeasure")
		@RuneAttribute("priceUnitOfMeasure")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
			this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
			this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
			this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
			this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdSIndexAttachmentPoint")
		@RuneAttribute("cdSIndexAttachmentPoint")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal _cdSIndexAttachmentPoint) {
			this.cdSIndexAttachmentPoint = _cdSIndexAttachmentPoint == null ? null : _cdSIndexAttachmentPoint;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdSIndexDetachmentPoint")
		@RuneAttribute("cdSIndexDetachmentPoint")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal _cdSIndexDetachmentPoint) {
			this.cdSIndexDetachmentPoint = _cdSIndexDetachmentPoint == null ? null : _cdSIndexDetachmentPoint;
			return this;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
			this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("firstExerciseDate")
		@RuneAttribute("firstExerciseDate")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setFirstExerciseDate(Date _firstExerciseDate) {
			this.firstExerciseDate = _firstExerciseDate == null ? null : _firstExerciseDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
			this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		public EMIRTransactionReport.EMIRTransactionReportBuilder addOtherPayment(OtherPayment _otherPayment) {
			if (_otherPayment != null) {
				this.otherPayment.add(_otherPayment.toBuilder());
			}
			return this;
		}
		
		@Override
		public EMIRTransactionReport.EMIRTransactionReportBuilder addOtherPayment(OtherPayment _otherPayment, int _idx) {
			getIndex(this.otherPayment, _idx, () -> _otherPayment.toBuilder());
			return this;
		}
		
		@Override 
		public EMIRTransactionReport.EMIRTransactionReportBuilder addOtherPayment(List<? extends OtherPayment> otherPayments) {
			if (otherPayments != null) {
				for (final OtherPayment toAdd : otherPayments) {
					this.otherPayment.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("otherPayment")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setOtherPayment(List<? extends OtherPayment> otherPayments) {
			if (otherPayments == null) {
				this.otherPayment = new ArrayList<>();
			} else {
				this.otherPayment = otherPayments.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1")
		@RuneAttribute("leg1")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setLeg1(CommonLeg _leg1) {
			this.leg1 = _leg1 == null ? null : _leg1.toBuilder();
			return this;
		}
		
		@Override
		@RosettaIgnore
		public EMIRTransactionReport.EMIRTransactionReportBuilder setLeg1(Leg _leg1) {
			final CommonLeg ifThenElseResult;
			if (_leg1 == null) {
				ifThenElseResult = null;
			} else {
				ifThenElseResult = _leg1 instanceof CommonLeg ? CommonLeg.class.cast(_leg1) : null;
			}
			return setLeg1(ifThenElseResult);
		}
		
		@Override
		@RosettaAttribute("leg2")
		@RuneAttribute("leg2")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setLeg2(CommonLeg _leg2) {
			this.leg2 = _leg2 == null ? null : _leg2.toBuilder();
			return this;
		}
		
		@Override
		@RosettaIgnore
		public EMIRTransactionReport.EMIRTransactionReportBuilder setLeg2(Leg _leg2) {
			final CommonLeg ifThenElseResult;
			if (_leg2 == null) {
				ifThenElseResult = null;
			} else {
				ifThenElseResult = _leg2 instanceof CommonLeg ? CommonLeg.class.cast(_leg2) : null;
			}
			return setLeg2(ifThenElseResult);
		}
		
		@Override
		@RosettaAttribute("counterparty2Name")
		@RuneAttribute("counterparty2Name")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setCounterparty2Name(String _counterparty2Name) {
			this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionAgentCounterparty1")
		@RuneAttribute("executionAgentCounterparty1")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setExecutionAgentCounterparty1(String _executionAgentCounterparty1) {
			this.executionAgentCounterparty1 = _executionAgentCounterparty1 == null ? null : _executionAgentCounterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionAgentCounterparty2DTCC")
		@RuneAttribute("executionAgentCounterparty2DTCC")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setExecutionAgentCounterparty2DTCC(String _executionAgentCounterparty2DTCC) {
			this.executionAgentCounterparty2DTCC = _executionAgentCounterparty2DTCC == null ? null : _executionAgentCounterparty2DTCC;
			return this;
		}
		
		@Override
		@RosettaAttribute("reportSubmittingEntityID")
		@RuneAttribute("reportSubmittingEntityID")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
			this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
			this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifierProprietary")
		@RuneAttribute("uniqueTransactionIdentifierProprietary")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
			this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setPriorUTI(String _priorUTI) {
			this.priorUTI = _priorUTI == null ? null : _priorUTI;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUTIProprietary")
		@RuneAttribute("priorUTIProprietary")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setPriorUTIProprietary(String _priorUTIProprietary) {
			this.priorUTIProprietary = _priorUTIProprietary == null ? null : _priorUTIProprietary;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueProductIdentifier")
		@RuneAttribute("uniqueProductIdentifier")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setUniqueProductIdentifier(String _uniqueProductIdentifier) {
			this.uniqueProductIdentifier = _uniqueProductIdentifier == null ? null : _uniqueProductIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("contractType")
		@RuneAttribute("contractType")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setContractType(CommonContractType _contractType) {
			this.contractType = _contractType == null ? null : _contractType;
			return this;
		}
		
		@Override
		@RosettaAttribute("assetClass")
		@RuneAttribute("assetClass")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setAssetClass(CommonAssetClass _assetClass) {
			this.assetClass = _assetClass == null ? null : _assetClass;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingTimestamp")
		@RuneAttribute("clearingTimestamp")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setClearingTimestamp(ZonedDateTime _clearingTimestamp) {
			this.clearingTimestamp = _clearingTimestamp == null ? null : _clearingTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("platformIdentifier")
		@RuneAttribute("platformIdentifier")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setPlatformIdentifier(String _platformIdentifier) {
			this.platformIdentifier = _platformIdentifier == null ? null : _platformIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("direction1")
		@RuneAttribute("direction1")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setDirection1(Direction1Enum _direction1) {
			this.direction1 = _direction1 == null ? null : _direction1;
			return this;
		}
		
		@Override
		@RosettaAttribute("direction2Leg1")
		@RuneAttribute("direction2Leg1")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setDirection2Leg1(Direction2Enum _direction2Leg1) {
			this.direction2Leg1 = _direction2Leg1 == null ? null : _direction2Leg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("direction2Leg2")
		@RuneAttribute("direction2Leg2")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setDirection2Leg2(Direction2Enum _direction2Leg2) {
			this.direction2Leg2 = _direction2Leg2 == null ? null : _direction2Leg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
			this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("barrier")
		@RuneAttribute("barrier")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier _barrier) {
			this.barrier = _barrier == null ? null : _barrier.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setExchangeRate(BigDecimal _exchangeRate) {
			this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
			return this;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
			this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
			return this;
		}
		
		@Override
		@RosettaAttribute("nameOfTheUnderlyingIndex")
		@RuneAttribute("nameOfTheUnderlyingIndex")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setNameOfTheUnderlyingIndex(String _nameOfTheUnderlyingIndex) {
			this.nameOfTheUnderlyingIndex = _nameOfTheUnderlyingIndex == null ? null : _nameOfTheUnderlyingIndex;
			return this;
		}
		
		@Override
		@RosettaAttribute("basketConstituents")
		@RuneAttribute("basketConstituents")
		public EMIRTransactionReport.EMIRTransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents) {
			if (_basketConstituents != null) {
				this.basketConstituents.add(_basketConstituents.toBuilder());
			}
			return this;
		}
		
		@Override
		public EMIRTransactionReport.EMIRTransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents, int _idx) {
			getIndex(this.basketConstituents, _idx, () -> _basketConstituents.toBuilder());
			return this;
		}
		
		@Override 
		public EMIRTransactionReport.EMIRTransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
			if (basketConstituentss != null) {
				for (final BasketConstituentsReport toAdd : basketConstituentss) {
					this.basketConstituents.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("basketConstituents")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
			if (basketConstituentss == null) {
				this.basketConstituents = new ArrayList<>();
			} else {
				this.basketConstituents = basketConstituentss.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("underlying")
		@RuneAttribute("underlying")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setUnderlying(UnderlyingIdentifier _underlying) {
			this.underlying = _underlying == null ? null : _underlying.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg1")
		@RuneAttribute("quantityUnitOfMeasureLeg1")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setQuantityUnitOfMeasureLeg1(String _quantityUnitOfMeasureLeg1) {
			this.quantityUnitOfMeasureLeg1 = _quantityUnitOfMeasureLeg1 == null ? null : _quantityUnitOfMeasureLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg2")
		@RuneAttribute("quantityUnitOfMeasureLeg2")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setQuantityUnitOfMeasureLeg2(String _quantityUnitOfMeasureLeg2) {
			this.quantityUnitOfMeasureLeg2 = _quantityUnitOfMeasureLeg2 == null ? null : _quantityUnitOfMeasureLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
			this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setOptionType(OptionTypeCode _optionType) {
			this.optionType = _optionType == null ? null : _optionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setOptionStyle(OptionStyleEnum _optionStyle) {
			this.optionStyle = _optionStyle == null ? null : _optionStyle;
			return this;
		}
		
		@Override
		@RosettaAttribute("deliveryType")
		@RuneAttribute("deliveryType")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setDeliveryType(DeliveryTypeEnum _deliveryType) {
			this.deliveryType = _deliveryType == null ? null : _deliveryType;
			return this;
		}
		
		@Override
		@RosettaAttribute("countryOfTheCounterparty2")
		@RuneAttribute("countryOfTheCounterparty2")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum _countryOfTheCounterparty2) {
			this.countryOfTheCounterparty2 = _countryOfTheCounterparty2 == null ? null : _countryOfTheCounterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("bookingLocation")
		@RuneAttribute("bookingLocation")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setBookingLocation(ISOCountryCodeEnum _bookingLocation) {
			this.bookingLocation = _bookingLocation == null ? null : _bookingLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("traderLocation")
		@RuneAttribute("traderLocation")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setTraderLocation(ISOCountryCodeEnum _traderLocation) {
			this.traderLocation = _traderLocation == null ? null : _traderLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradingCapacity")
		@RuneAttribute("tradingCapacity")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setTradingCapacity(TradingCapacity7Code _tradingCapacity) {
			this.tradingCapacity = _tradingCapacity == null ? null : _tradingCapacity;
			return this;
		}
		
		@Override
		@RosettaAttribute("embeddedOptionType")
		@RuneAttribute("embeddedOptionType")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum _embeddedOptionType) {
			this.embeddedOptionType = _embeddedOptionType == null ? null : _embeddedOptionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("seniority")
		@RuneAttribute("seniority")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setSeniority(SeniorityEnum _seniority) {
			this.seniority = _seniority == null ? null : _seniority;
			return this;
		}
		
		@Override
		@RosettaAttribute("series")
		@RuneAttribute("series")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setSeries(Integer _series) {
			this.series = _series == null ? null : _series;
			return this;
		}
		
		@Override
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setIndexFactor(BigDecimal _indexFactor) {
			this.indexFactor = _indexFactor == null ? null : _indexFactor;
			return this;
		}
		
		@Override
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setTechnicalRecordId(String _technicalRecordId) {
			this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
			return this;
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
			this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
			return this;
		}
		
		@Override
		@RosettaAttribute("natureOfCounterparty1")
		@RuneAttribute("natureOfCounterparty1")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setNatureOfCounterparty1(String _natureOfCounterparty1) {
			this.natureOfCounterparty1 = _natureOfCounterparty1 == null ? null : _natureOfCounterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("corporateSectorOfTheCounterparty1")
		@RuneAttribute("corporateSectorOfTheCounterparty1")
		public EMIRTransactionReport.EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String _corporateSectorOfTheCounterparty1) {
			if (_corporateSectorOfTheCounterparty1 != null) {
				this.corporateSectorOfTheCounterparty1.add(_corporateSectorOfTheCounterparty1);
			}
			return this;
		}
		
		@Override
		public EMIRTransactionReport.EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String _corporateSectorOfTheCounterparty1, int _idx) {
			getIndex(this.corporateSectorOfTheCounterparty1, _idx, () -> _corporateSectorOfTheCounterparty1);
			return this;
		}
		
		@Override 
		public EMIRTransactionReport.EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1s) {
			if (corporateSectorOfTheCounterparty1s != null) {
				for (final String toAdd : corporateSectorOfTheCounterparty1s) {
					this.corporateSectorOfTheCounterparty1.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("corporateSectorOfTheCounterparty1")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1s) {
			if (corporateSectorOfTheCounterparty1s == null) {
				this.corporateSectorOfTheCounterparty1 = new ArrayList<>();
			} else {
				this.corporateSectorOfTheCounterparty1 = corporateSectorOfTheCounterparty1s.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingThresholdOfCounterparty1")
		@RuneAttribute("clearingThresholdOfCounterparty1")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setClearingThresholdOfCounterparty1(Boolean _clearingThresholdOfCounterparty1) {
			this.clearingThresholdOfCounterparty1 = _clearingThresholdOfCounterparty1 == null ? null : _clearingThresholdOfCounterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("countryOfTheCounterParty2")
		@RuneAttribute("countryOfTheCounterParty2")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setCountryOfTheCounterParty2(ISOCountryCodeEnum _countryOfTheCounterParty2) {
			this.countryOfTheCounterParty2 = _countryOfTheCounterParty2 == null ? null : _countryOfTheCounterParty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("natureOfCounterparty2")
		@RuneAttribute("natureOfCounterparty2")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setNatureOfCounterparty2(String _natureOfCounterparty2) {
			this.natureOfCounterparty2 = _natureOfCounterparty2 == null ? null : _natureOfCounterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("corporateSectorOfTheCounterparty2")
		@RuneAttribute("corporateSectorOfTheCounterparty2")
		public EMIRTransactionReport.EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String _corporateSectorOfTheCounterparty2) {
			if (_corporateSectorOfTheCounterparty2 != null) {
				this.corporateSectorOfTheCounterparty2.add(_corporateSectorOfTheCounterparty2);
			}
			return this;
		}
		
		@Override
		public EMIRTransactionReport.EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String _corporateSectorOfTheCounterparty2, int _idx) {
			getIndex(this.corporateSectorOfTheCounterparty2, _idx, () -> _corporateSectorOfTheCounterparty2);
			return this;
		}
		
		@Override 
		public EMIRTransactionReport.EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2s) {
			if (corporateSectorOfTheCounterparty2s != null) {
				for (final String toAdd : corporateSectorOfTheCounterparty2s) {
					this.corporateSectorOfTheCounterparty2.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("corporateSectorOfTheCounterparty2")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2s) {
			if (corporateSectorOfTheCounterparty2s == null) {
				this.corporateSectorOfTheCounterparty2 = new ArrayList<>();
			} else {
				this.corporateSectorOfTheCounterparty2 = corporateSectorOfTheCounterparty2s.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingThresholdOfCounterparty2")
		@RuneAttribute("clearingThresholdOfCounterparty2")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setClearingThresholdOfCounterparty2(Boolean _clearingThresholdOfCounterparty2) {
			this.clearingThresholdOfCounterparty2 = _clearingThresholdOfCounterparty2 == null ? null : _clearingThresholdOfCounterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("reportingObligationOfTheCounterparty2")
		@RuneAttribute("reportingObligationOfTheCounterparty2")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setReportingObligationOfTheCounterparty2(Boolean _reportingObligationOfTheCounterparty2) {
			this.reportingObligationOfTheCounterparty2 = _reportingObligationOfTheCounterparty2 == null ? null : _reportingObligationOfTheCounterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("brokerID")
		@RuneAttribute("brokerID")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setBrokerID(String _brokerID) {
			this.brokerID = _brokerID == null ? null : _brokerID;
			return this;
		}
		
		@Override
		@RosettaAttribute("directlyLinkedToCommercialActivityOrTreasuryFinancing")
		@RuneAttribute("directlyLinkedToCommercialActivityOrTreasuryFinancing")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setDirectlyLinkedToCommercialActivityOrTreasuryFinancing(Boolean _directlyLinkedToCommercialActivityOrTreasuryFinancing) {
			this.directlyLinkedToCommercialActivityOrTreasuryFinancing = _directlyLinkedToCommercialActivityOrTreasuryFinancing == null ? null : _directlyLinkedToCommercialActivityOrTreasuryFinancing;
			return this;
		}
		
		@Override
		@RosettaAttribute("reportTrackingNumber")
		@RuneAttribute("reportTrackingNumber")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setReportTrackingNumber(String _reportTrackingNumber) {
			this.reportTrackingNumber = _reportTrackingNumber == null ? null : _reportTrackingNumber;
			return this;
		}
		
		@Override
		@RosettaAttribute("ptrrId")
		@RuneAttribute("ptrrId")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setPtrrId(String _ptrrId) {
			this.ptrrId = _ptrrId == null ? null : _ptrrId;
			return this;
		}
		
		@Override
		@RosettaAttribute("subsequentPositionUTI")
		@RuneAttribute("subsequentPositionUTI")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setSubsequentPositionUTI(String _subsequentPositionUTI) {
			this.subsequentPositionUTI = _subsequentPositionUTI == null ? null : _subsequentPositionUTI;
			return this;
		}
		
		@Override
		@RosettaAttribute("isin")
		@RuneAttribute("isin")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setIsin(String _isin) {
			this.isin = _isin == null ? null : _isin;
			return this;
		}
		
		@Override
		@RosettaAttribute("productClassification")
		@RuneAttribute("productClassification")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setProductClassification(String _productClassification) {
			this.productClassification = _productClassification == null ? null : _productClassification;
			return this;
		}
		
		@Override
		@RosettaAttribute("isCrypto")
		@RuneAttribute("isCrypto")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setIsCrypto(Boolean _isCrypto) {
			this.isCrypto = _isCrypto == null ? null : _isCrypto;
			return this;
		}
		
		@Override
		@RosettaAttribute("indicatorOfTheUnderlyingIndex")
		@RuneAttribute("indicatorOfTheUnderlyingIndex")
		public EMIRTransactionReport.EMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(IndexEnum _indicatorOfTheUnderlyingIndex) {
			if (_indicatorOfTheUnderlyingIndex != null) {
				this.indicatorOfTheUnderlyingIndex.add(_indicatorOfTheUnderlyingIndex);
			}
			return this;
		}
		
		@Override
		public EMIRTransactionReport.EMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(IndexEnum _indicatorOfTheUnderlyingIndex, int _idx) {
			getIndex(this.indicatorOfTheUnderlyingIndex, _idx, () -> _indicatorOfTheUnderlyingIndex);
			return this;
		}
		
		@Override 
		public EMIRTransactionReport.EMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(List<IndexEnum> indicatorOfTheUnderlyingIndexs) {
			if (indicatorOfTheUnderlyingIndexs != null) {
				for (final IndexEnum toAdd : indicatorOfTheUnderlyingIndexs) {
					this.indicatorOfTheUnderlyingIndex.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("indicatorOfTheUnderlyingIndex")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setIndicatorOfTheUnderlyingIndex(List<IndexEnum> indicatorOfTheUnderlyingIndexs) {
			if (indicatorOfTheUnderlyingIndexs == null) {
				this.indicatorOfTheUnderlyingIndex = new ArrayList<>();
			} else {
				this.indicatorOfTheUnderlyingIndex = indicatorOfTheUnderlyingIndexs.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setCustomBasketCode(String _customBasketCode) {
			this.customBasketCode = _customBasketCode == null ? null : _customBasketCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
			this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
			this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
			this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
			return this;
		}
		
		@Override
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setDelta(BigDecimal _delta) {
			this.delta = _delta == null ? null : _delta;
			return this;
		}
		
		@Override
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
			this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("confirmationTimestamp")
		@RuneAttribute("confirmationTimestamp")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setConfirmationTimestamp(ZonedDateTime _confirmationTimestamp) {
			this.confirmationTimestamp = _confirmationTimestamp == null ? null : _confirmationTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingObligation")
		@RuneAttribute("clearingObligation")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setClearingObligation(String _clearingObligation) {
			this.clearingObligation = _clearingObligation == null ? null : _clearingObligation;
			return this;
		}
		
		@Override
		@RosettaAttribute("masterAgreementType")
		@RuneAttribute("masterAgreementType")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setMasterAgreementType(String _masterAgreementType) {
			this.masterAgreementType = _masterAgreementType == null ? null : _masterAgreementType;
			return this;
		}
		
		@Override
		@RosettaAttribute("otherMasterAgreementType")
		@RuneAttribute("otherMasterAgreementType")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setOtherMasterAgreementType(String _otherMasterAgreementType) {
			this.otherMasterAgreementType = _otherMasterAgreementType == null ? null : _otherMasterAgreementType;
			return this;
		}
		
		@Override
		@RosettaAttribute("masterAgreementVersion")
		@RuneAttribute("masterAgreementVersion")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setMasterAgreementVersion(Integer _masterAgreementVersion) {
			this.masterAgreementVersion = _masterAgreementVersion == null ? null : _masterAgreementVersion;
			return this;
		}
		
		@Override
		@RosettaAttribute("intragroup")
		@RuneAttribute("intragroup")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setIntragroup(Boolean _intragroup) {
			this.intragroup = _intragroup == null ? null : _intragroup;
			return this;
		}
		
		@Override
		@RosettaAttribute("ptrr")
		@RuneAttribute("ptrr")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setPtrr(Boolean _ptrr) {
			this.ptrr = _ptrr == null ? null : _ptrr;
			return this;
		}
		
		@Override
		@RosettaAttribute("typeOfPTRRTechnique")
		@RuneAttribute("typeOfPTRRTechnique")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setTypeOfPTRRTechnique(String _typeOfPTRRTechnique) {
			this.typeOfPTRRTechnique = _typeOfPTRRTechnique == null ? null : _typeOfPTRRTechnique;
			return this;
		}
		
		@Override
		@RosettaAttribute("ptrrServiceProvider")
		@RuneAttribute("ptrrServiceProvider")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setPtrrServiceProvider(String _ptrrServiceProvider) {
			this.ptrrServiceProvider = _ptrrServiceProvider == null ? null : _ptrrServiceProvider;
			return this;
		}
		
		@Override
		@RosettaAttribute("venueOfExecution")
		@RuneAttribute("venueOfExecution")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setVenueOfExecution(String _venueOfExecution) {
			this.venueOfExecution = _venueOfExecution == null ? null : _venueOfExecution;
			return this;
		}
		
		@Override
		@RosettaAttribute("forwardExchangeRate")
		@RuneAttribute("forwardExchangeRate")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setForwardExchangeRate(BigDecimal _forwardExchangeRate) {
			this.forwardExchangeRate = _forwardExchangeRate == null ? null : _forwardExchangeRate;
			return this;
		}
		
		@Override
		@RosettaAttribute("baseProduct")
		@RuneAttribute("baseProduct")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setBaseProduct(String _baseProduct) {
			this.baseProduct = _baseProduct == null ? null : _baseProduct;
			return this;
		}
		
		@Override
		@RosettaAttribute("subProduct")
		@RuneAttribute("subProduct")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setSubProduct(String _subProduct) {
			this.subProduct = _subProduct == null ? null : _subProduct;
			return this;
		}
		
		@Override
		@RosettaAttribute("furtherSubProduct")
		@RuneAttribute("furtherSubProduct")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setFurtherSubProduct(String _furtherSubProduct) {
			this.furtherSubProduct = _furtherSubProduct == null ? null : _furtherSubProduct;
			return this;
		}
		
		@Override
		@RosettaAttribute("deliveryPoint")
		@RuneAttribute("deliveryPoint")
		public EMIRTransactionReport.EMIRTransactionReportBuilder addDeliveryPoint(String _deliveryPoint) {
			if (_deliveryPoint != null) {
				this.deliveryPoint.add(_deliveryPoint);
			}
			return this;
		}
		
		@Override
		public EMIRTransactionReport.EMIRTransactionReportBuilder addDeliveryPoint(String _deliveryPoint, int _idx) {
			getIndex(this.deliveryPoint, _idx, () -> _deliveryPoint);
			return this;
		}
		
		@Override 
		public EMIRTransactionReport.EMIRTransactionReportBuilder addDeliveryPoint(List<String> deliveryPoints) {
			if (deliveryPoints != null) {
				for (final String toAdd : deliveryPoints) {
					this.deliveryPoint.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("deliveryPoint")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setDeliveryPoint(List<String> deliveryPoints) {
			if (deliveryPoints == null) {
				this.deliveryPoint = new ArrayList<>();
			} else {
				this.deliveryPoint = deliveryPoints.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("interconnectionPoint")
		@RuneAttribute("interconnectionPoint")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setInterconnectionPoint(String _interconnectionPoint) {
			this.interconnectionPoint = _interconnectionPoint == null ? null : _interconnectionPoint;
			return this;
		}
		
		@Override
		@RosettaAttribute("loadType")
		@RuneAttribute("loadType")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setLoadType(EnergyLoadType1Code _loadType) {
			this.loadType = _loadType == null ? null : _loadType;
			return this;
		}
		
		@Override
		@RosettaAttribute("deliveryReport")
		@RuneAttribute("deliveryReport")
		public EMIRTransactionReport.EMIRTransactionReportBuilder addDeliveryReport(ReportableDelivery _deliveryReport) {
			if (_deliveryReport != null) {
				this.deliveryReport.add(_deliveryReport.toBuilder());
			}
			return this;
		}
		
		@Override
		public EMIRTransactionReport.EMIRTransactionReportBuilder addDeliveryReport(ReportableDelivery _deliveryReport, int _idx) {
			getIndex(this.deliveryReport, _idx, () -> _deliveryReport.toBuilder());
			return this;
		}
		
		@Override 
		public EMIRTransactionReport.EMIRTransactionReportBuilder addDeliveryReport(List<? extends ReportableDelivery> deliveryReports) {
			if (deliveryReports != null) {
				for (final ReportableDelivery toAdd : deliveryReports) {
					this.deliveryReport.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("deliveryReport")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setDeliveryReport(List<? extends ReportableDelivery> deliveryReports) {
			if (deliveryReports == null) {
				this.deliveryReport = new ArrayList<>();
			} else {
				this.deliveryReport = deliveryReports.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("referenceEntity")
		@RuneAttribute("referenceEntity")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setReferenceEntity(String _referenceEntity) {
			this.referenceEntity = _referenceEntity == null ? null : _referenceEntity;
			return this;
		}
		
		@Override
		@RosettaAttribute("version")
		@RuneAttribute("version")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setVersion(Integer _version) {
			this.version = _version == null ? null : _version;
			return this;
		}
		
		@Override
		@RosettaAttribute("tranche")
		@RuneAttribute("tranche")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setTranche(Boolean _tranche) {
			this.tranche = _tranche == null ? null : _tranche;
			return this;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioCode")
		@RuneAttribute("collateralPortfolioCode")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setCollateralPortfolioCode(String _collateralPortfolioCode) {
			this.collateralPortfolioCode = _collateralPortfolioCode == null ? null : _collateralPortfolioCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventDate")
		@RuneAttribute("eventDate")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setEventDate(Date _eventDate) {
			this.eventDate = _eventDate == null ? null : _eventDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("level")
		@RuneAttribute("level")
		public EMIRTransactionReport.EMIRTransactionReportBuilder setLevel(ReportLevelEnum _level) {
			this.level = _level == null ? null : _level;
			return this;
		}
		
		@Override
		public EMIRTransactionReport build() {
			return new EMIRTransactionReport.EMIRTransactionReportImpl(this);
		}
		
		@Override
		public EMIRTransactionReport.EMIRTransactionReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public EMIRTransactionReport.EMIRTransactionReportBuilder prune() {
			super.prune();
			deliveryReport = deliveryReport.stream().filter(b->b!=null).<ReportableDelivery.ReportableDeliveryBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (super.hasData()) return true;
			if (getEntityResponsibleForReporting()!=null) return true;
			if (getNatureOfCounterparty1()!=null) return true;
			if (getCorporateSectorOfTheCounterparty1()!=null && !getCorporateSectorOfTheCounterparty1().isEmpty()) return true;
			if (getClearingThresholdOfCounterparty1()!=null) return true;
			if (getCountryOfTheCounterParty2()!=null) return true;
			if (getNatureOfCounterparty2()!=null) return true;
			if (getCorporateSectorOfTheCounterparty2()!=null && !getCorporateSectorOfTheCounterparty2().isEmpty()) return true;
			if (getClearingThresholdOfCounterparty2()!=null) return true;
			if (getReportingObligationOfTheCounterparty2()!=null) return true;
			if (getBrokerID()!=null) return true;
			if (getDirectlyLinkedToCommercialActivityOrTreasuryFinancing()!=null) return true;
			if (getReportTrackingNumber()!=null) return true;
			if (getPtrrId()!=null) return true;
			if (getSubsequentPositionUTI()!=null) return true;
			if (getIsin()!=null) return true;
			if (getProductClassification()!=null) return true;
			if (getIsCrypto()!=null) return true;
			if (getIndicatorOfTheUnderlyingIndex()!=null && !getIndicatorOfTheUnderlyingIndex().isEmpty()) return true;
			if (getCustomBasketCode()!=null) return true;
			if (getValuationAmount()!=null) return true;
			if (getValuationCurrency()!=null) return true;
			if (getValuationMethod()!=null) return true;
			if (getDelta()!=null) return true;
			if (getValuationTimestamp()!=null) return true;
			if (getConfirmationTimestamp()!=null) return true;
			if (getClearingObligation()!=null) return true;
			if (getMasterAgreementType()!=null) return true;
			if (getOtherMasterAgreementType()!=null) return true;
			if (getMasterAgreementVersion()!=null) return true;
			if (getIntragroup()!=null) return true;
			if (getPtrr()!=null) return true;
			if (getTypeOfPTRRTechnique()!=null) return true;
			if (getPtrrServiceProvider()!=null) return true;
			if (getVenueOfExecution()!=null) return true;
			if (getForwardExchangeRate()!=null) return true;
			if (getBaseProduct()!=null) return true;
			if (getSubProduct()!=null) return true;
			if (getFurtherSubProduct()!=null) return true;
			if (getDeliveryPoint()!=null && !getDeliveryPoint().isEmpty()) return true;
			if (getInterconnectionPoint()!=null) return true;
			if (getLoadType()!=null) return true;
			if (getDeliveryReport()!=null && getDeliveryReport().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getReferenceEntity()!=null) return true;
			if (getVersion()!=null) return true;
			if (getTranche()!=null) return true;
			if (getCollateralPortfolioCode()!=null) return true;
			if (getEventDate()!=null) return true;
			if (getLevel()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public EMIRTransactionReport.EMIRTransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			super.merge(other, merger);
			
			EMIRTransactionReport.EMIRTransactionReportBuilder o = (EMIRTransactionReport.EMIRTransactionReportBuilder) other;
			
			merger.mergeRosetta(getDeliveryReport(), o.getDeliveryReport(), this::getOrCreateDeliveryReport);
			
			merger.mergeBasic(getEntityResponsibleForReporting(), o.getEntityResponsibleForReporting(), this::setEntityResponsibleForReporting);
			merger.mergeBasic(getNatureOfCounterparty1(), o.getNatureOfCounterparty1(), this::setNatureOfCounterparty1);
			merger.mergeBasic(getCorporateSectorOfTheCounterparty1(), o.getCorporateSectorOfTheCounterparty1(), (Consumer<String>) this::addCorporateSectorOfTheCounterparty1);
			merger.mergeBasic(getClearingThresholdOfCounterparty1(), o.getClearingThresholdOfCounterparty1(), this::setClearingThresholdOfCounterparty1);
			merger.mergeBasic(getCountryOfTheCounterParty2(), o.getCountryOfTheCounterParty2(), this::setCountryOfTheCounterParty2);
			merger.mergeBasic(getNatureOfCounterparty2(), o.getNatureOfCounterparty2(), this::setNatureOfCounterparty2);
			merger.mergeBasic(getCorporateSectorOfTheCounterparty2(), o.getCorporateSectorOfTheCounterparty2(), (Consumer<String>) this::addCorporateSectorOfTheCounterparty2);
			merger.mergeBasic(getClearingThresholdOfCounterparty2(), o.getClearingThresholdOfCounterparty2(), this::setClearingThresholdOfCounterparty2);
			merger.mergeBasic(getReportingObligationOfTheCounterparty2(), o.getReportingObligationOfTheCounterparty2(), this::setReportingObligationOfTheCounterparty2);
			merger.mergeBasic(getBrokerID(), o.getBrokerID(), this::setBrokerID);
			merger.mergeBasic(getDirectlyLinkedToCommercialActivityOrTreasuryFinancing(), o.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing(), this::setDirectlyLinkedToCommercialActivityOrTreasuryFinancing);
			merger.mergeBasic(getReportTrackingNumber(), o.getReportTrackingNumber(), this::setReportTrackingNumber);
			merger.mergeBasic(getPtrrId(), o.getPtrrId(), this::setPtrrId);
			merger.mergeBasic(getSubsequentPositionUTI(), o.getSubsequentPositionUTI(), this::setSubsequentPositionUTI);
			merger.mergeBasic(getIsin(), o.getIsin(), this::setIsin);
			merger.mergeBasic(getProductClassification(), o.getProductClassification(), this::setProductClassification);
			merger.mergeBasic(getIsCrypto(), o.getIsCrypto(), this::setIsCrypto);
			merger.mergeBasic(getIndicatorOfTheUnderlyingIndex(), o.getIndicatorOfTheUnderlyingIndex(), (Consumer<IndexEnum>) this::addIndicatorOfTheUnderlyingIndex);
			merger.mergeBasic(getCustomBasketCode(), o.getCustomBasketCode(), this::setCustomBasketCode);
			merger.mergeBasic(getValuationAmount(), o.getValuationAmount(), this::setValuationAmount);
			merger.mergeBasic(getValuationCurrency(), o.getValuationCurrency(), this::setValuationCurrency);
			merger.mergeBasic(getValuationMethod(), o.getValuationMethod(), this::setValuationMethod);
			merger.mergeBasic(getDelta(), o.getDelta(), this::setDelta);
			merger.mergeBasic(getValuationTimestamp(), o.getValuationTimestamp(), this::setValuationTimestamp);
			merger.mergeBasic(getConfirmationTimestamp(), o.getConfirmationTimestamp(), this::setConfirmationTimestamp);
			merger.mergeBasic(getClearingObligation(), o.getClearingObligation(), this::setClearingObligation);
			merger.mergeBasic(getMasterAgreementType(), o.getMasterAgreementType(), this::setMasterAgreementType);
			merger.mergeBasic(getOtherMasterAgreementType(), o.getOtherMasterAgreementType(), this::setOtherMasterAgreementType);
			merger.mergeBasic(getMasterAgreementVersion(), o.getMasterAgreementVersion(), this::setMasterAgreementVersion);
			merger.mergeBasic(getIntragroup(), o.getIntragroup(), this::setIntragroup);
			merger.mergeBasic(getPtrr(), o.getPtrr(), this::setPtrr);
			merger.mergeBasic(getTypeOfPTRRTechnique(), o.getTypeOfPTRRTechnique(), this::setTypeOfPTRRTechnique);
			merger.mergeBasic(getPtrrServiceProvider(), o.getPtrrServiceProvider(), this::setPtrrServiceProvider);
			merger.mergeBasic(getVenueOfExecution(), o.getVenueOfExecution(), this::setVenueOfExecution);
			merger.mergeBasic(getForwardExchangeRate(), o.getForwardExchangeRate(), this::setForwardExchangeRate);
			merger.mergeBasic(getBaseProduct(), o.getBaseProduct(), this::setBaseProduct);
			merger.mergeBasic(getSubProduct(), o.getSubProduct(), this::setSubProduct);
			merger.mergeBasic(getFurtherSubProduct(), o.getFurtherSubProduct(), this::setFurtherSubProduct);
			merger.mergeBasic(getDeliveryPoint(), o.getDeliveryPoint(), (Consumer<String>) this::addDeliveryPoint);
			merger.mergeBasic(getInterconnectionPoint(), o.getInterconnectionPoint(), this::setInterconnectionPoint);
			merger.mergeBasic(getLoadType(), o.getLoadType(), this::setLoadType);
			merger.mergeBasic(getReferenceEntity(), o.getReferenceEntity(), this::setReferenceEntity);
			merger.mergeBasic(getVersion(), o.getVersion(), this::setVersion);
			merger.mergeBasic(getTranche(), o.getTranche(), this::setTranche);
			merger.mergeBasic(getCollateralPortfolioCode(), o.getCollateralPortfolioCode(), this::setCollateralPortfolioCode);
			merger.mergeBasic(getEventDate(), o.getEventDate(), this::setEventDate);
			merger.mergeBasic(getLevel(), o.getLevel(), this::setLevel);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			EMIRTransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) return false;
			if (!Objects.equals(natureOfCounterparty1, _that.getNatureOfCounterparty1())) return false;
			if (!ListEquals.listEquals(corporateSectorOfTheCounterparty1, _that.getCorporateSectorOfTheCounterparty1())) return false;
			if (!Objects.equals(clearingThresholdOfCounterparty1, _that.getClearingThresholdOfCounterparty1())) return false;
			if (!Objects.equals(countryOfTheCounterParty2, _that.getCountryOfTheCounterParty2())) return false;
			if (!Objects.equals(natureOfCounterparty2, _that.getNatureOfCounterparty2())) return false;
			if (!ListEquals.listEquals(corporateSectorOfTheCounterparty2, _that.getCorporateSectorOfTheCounterparty2())) return false;
			if (!Objects.equals(clearingThresholdOfCounterparty2, _that.getClearingThresholdOfCounterparty2())) return false;
			if (!Objects.equals(reportingObligationOfTheCounterparty2, _that.getReportingObligationOfTheCounterparty2())) return false;
			if (!Objects.equals(brokerID, _that.getBrokerID())) return false;
			if (!Objects.equals(directlyLinkedToCommercialActivityOrTreasuryFinancing, _that.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing())) return false;
			if (!Objects.equals(reportTrackingNumber, _that.getReportTrackingNumber())) return false;
			if (!Objects.equals(ptrrId, _that.getPtrrId())) return false;
			if (!Objects.equals(subsequentPositionUTI, _that.getSubsequentPositionUTI())) return false;
			if (!Objects.equals(isin, _that.getIsin())) return false;
			if (!Objects.equals(productClassification, _that.getProductClassification())) return false;
			if (!Objects.equals(isCrypto, _that.getIsCrypto())) return false;
			if (!ListEquals.listEquals(indicatorOfTheUnderlyingIndex, _that.getIndicatorOfTheUnderlyingIndex())) return false;
			if (!Objects.equals(customBasketCode, _that.getCustomBasketCode())) return false;
			if (!Objects.equals(valuationAmount, _that.getValuationAmount())) return false;
			if (!Objects.equals(valuationCurrency, _that.getValuationCurrency())) return false;
			if (!Objects.equals(valuationMethod, _that.getValuationMethod())) return false;
			if (!Objects.equals(delta, _that.getDelta())) return false;
			if (!Objects.equals(valuationTimestamp, _that.getValuationTimestamp())) return false;
			if (!Objects.equals(confirmationTimestamp, _that.getConfirmationTimestamp())) return false;
			if (!Objects.equals(clearingObligation, _that.getClearingObligation())) return false;
			if (!Objects.equals(masterAgreementType, _that.getMasterAgreementType())) return false;
			if (!Objects.equals(otherMasterAgreementType, _that.getOtherMasterAgreementType())) return false;
			if (!Objects.equals(masterAgreementVersion, _that.getMasterAgreementVersion())) return false;
			if (!Objects.equals(intragroup, _that.getIntragroup())) return false;
			if (!Objects.equals(ptrr, _that.getPtrr())) return false;
			if (!Objects.equals(typeOfPTRRTechnique, _that.getTypeOfPTRRTechnique())) return false;
			if (!Objects.equals(ptrrServiceProvider, _that.getPtrrServiceProvider())) return false;
			if (!Objects.equals(venueOfExecution, _that.getVenueOfExecution())) return false;
			if (!Objects.equals(forwardExchangeRate, _that.getForwardExchangeRate())) return false;
			if (!Objects.equals(baseProduct, _that.getBaseProduct())) return false;
			if (!Objects.equals(subProduct, _that.getSubProduct())) return false;
			if (!Objects.equals(furtherSubProduct, _that.getFurtherSubProduct())) return false;
			if (!ListEquals.listEquals(deliveryPoint, _that.getDeliveryPoint())) return false;
			if (!Objects.equals(interconnectionPoint, _that.getInterconnectionPoint())) return false;
			if (!Objects.equals(loadType, _that.getLoadType())) return false;
			if (!ListEquals.listEquals(deliveryReport, _that.getDeliveryReport())) return false;
			if (!Objects.equals(referenceEntity, _that.getReferenceEntity())) return false;
			if (!Objects.equals(version, _that.getVersion())) return false;
			if (!Objects.equals(tranche, _that.getTranche())) return false;
			if (!Objects.equals(collateralPortfolioCode, _that.getCollateralPortfolioCode())) return false;
			if (!Objects.equals(eventDate, _that.getEventDate())) return false;
			if (!Objects.equals(level, _that.getLevel())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (entityResponsibleForReporting != null ? entityResponsibleForReporting.hashCode() : 0);
			_result = 31 * _result + (natureOfCounterparty1 != null ? natureOfCounterparty1.hashCode() : 0);
			_result = 31 * _result + (corporateSectorOfTheCounterparty1 != null ? corporateSectorOfTheCounterparty1.hashCode() : 0);
			_result = 31 * _result + (clearingThresholdOfCounterparty1 != null ? clearingThresholdOfCounterparty1.hashCode() : 0);
			_result = 31 * _result + (countryOfTheCounterParty2 != null ? countryOfTheCounterParty2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (natureOfCounterparty2 != null ? natureOfCounterparty2.hashCode() : 0);
			_result = 31 * _result + (corporateSectorOfTheCounterparty2 != null ? corporateSectorOfTheCounterparty2.hashCode() : 0);
			_result = 31 * _result + (clearingThresholdOfCounterparty2 != null ? clearingThresholdOfCounterparty2.hashCode() : 0);
			_result = 31 * _result + (reportingObligationOfTheCounterparty2 != null ? reportingObligationOfTheCounterparty2.hashCode() : 0);
			_result = 31 * _result + (brokerID != null ? brokerID.hashCode() : 0);
			_result = 31 * _result + (directlyLinkedToCommercialActivityOrTreasuryFinancing != null ? directlyLinkedToCommercialActivityOrTreasuryFinancing.hashCode() : 0);
			_result = 31 * _result + (reportTrackingNumber != null ? reportTrackingNumber.hashCode() : 0);
			_result = 31 * _result + (ptrrId != null ? ptrrId.hashCode() : 0);
			_result = 31 * _result + (subsequentPositionUTI != null ? subsequentPositionUTI.hashCode() : 0);
			_result = 31 * _result + (isin != null ? isin.hashCode() : 0);
			_result = 31 * _result + (productClassification != null ? productClassification.hashCode() : 0);
			_result = 31 * _result + (isCrypto != null ? isCrypto.hashCode() : 0);
			_result = 31 * _result + (indicatorOfTheUnderlyingIndex != null ? indicatorOfTheUnderlyingIndex.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
			_result = 31 * _result + (customBasketCode != null ? customBasketCode.hashCode() : 0);
			_result = 31 * _result + (valuationAmount != null ? valuationAmount.hashCode() : 0);
			_result = 31 * _result + (valuationCurrency != null ? valuationCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationMethod != null ? valuationMethod.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (delta != null ? delta.hashCode() : 0);
			_result = 31 * _result + (valuationTimestamp != null ? valuationTimestamp.hashCode() : 0);
			_result = 31 * _result + (confirmationTimestamp != null ? confirmationTimestamp.hashCode() : 0);
			_result = 31 * _result + (clearingObligation != null ? clearingObligation.hashCode() : 0);
			_result = 31 * _result + (masterAgreementType != null ? masterAgreementType.hashCode() : 0);
			_result = 31 * _result + (otherMasterAgreementType != null ? otherMasterAgreementType.hashCode() : 0);
			_result = 31 * _result + (masterAgreementVersion != null ? masterAgreementVersion.hashCode() : 0);
			_result = 31 * _result + (intragroup != null ? intragroup.hashCode() : 0);
			_result = 31 * _result + (ptrr != null ? ptrr.hashCode() : 0);
			_result = 31 * _result + (typeOfPTRRTechnique != null ? typeOfPTRRTechnique.hashCode() : 0);
			_result = 31 * _result + (ptrrServiceProvider != null ? ptrrServiceProvider.hashCode() : 0);
			_result = 31 * _result + (venueOfExecution != null ? venueOfExecution.hashCode() : 0);
			_result = 31 * _result + (forwardExchangeRate != null ? forwardExchangeRate.hashCode() : 0);
			_result = 31 * _result + (baseProduct != null ? baseProduct.hashCode() : 0);
			_result = 31 * _result + (subProduct != null ? subProduct.hashCode() : 0);
			_result = 31 * _result + (furtherSubProduct != null ? furtherSubProduct.hashCode() : 0);
			_result = 31 * _result + (deliveryPoint != null ? deliveryPoint.hashCode() : 0);
			_result = 31 * _result + (interconnectionPoint != null ? interconnectionPoint.hashCode() : 0);
			_result = 31 * _result + (loadType != null ? loadType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (deliveryReport != null ? deliveryReport.hashCode() : 0);
			_result = 31 * _result + (referenceEntity != null ? referenceEntity.hashCode() : 0);
			_result = 31 * _result + (version != null ? version.hashCode() : 0);
			_result = 31 * _result + (tranche != null ? tranche.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioCode != null ? collateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (eventDate != null ? eventDate.hashCode() : 0);
			_result = 31 * _result + (level != null ? level.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "EMIRTransactionReportBuilder {" +
				"entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", " +
				"natureOfCounterparty1=" + this.natureOfCounterparty1 + ", " +
				"corporateSectorOfTheCounterparty1=" + this.corporateSectorOfTheCounterparty1 + ", " +
				"clearingThresholdOfCounterparty1=" + this.clearingThresholdOfCounterparty1 + ", " +
				"countryOfTheCounterParty2=" + this.countryOfTheCounterParty2 + ", " +
				"natureOfCounterparty2=" + this.natureOfCounterparty2 + ", " +
				"corporateSectorOfTheCounterparty2=" + this.corporateSectorOfTheCounterparty2 + ", " +
				"clearingThresholdOfCounterparty2=" + this.clearingThresholdOfCounterparty2 + ", " +
				"reportingObligationOfTheCounterparty2=" + this.reportingObligationOfTheCounterparty2 + ", " +
				"brokerID=" + this.brokerID + ", " +
				"directlyLinkedToCommercialActivityOrTreasuryFinancing=" + this.directlyLinkedToCommercialActivityOrTreasuryFinancing + ", " +
				"reportTrackingNumber=" + this.reportTrackingNumber + ", " +
				"ptrrId=" + this.ptrrId + ", " +
				"subsequentPositionUTI=" + this.subsequentPositionUTI + ", " +
				"isin=" + this.isin + ", " +
				"productClassification=" + this.productClassification + ", " +
				"isCrypto=" + this.isCrypto + ", " +
				"indicatorOfTheUnderlyingIndex=" + this.indicatorOfTheUnderlyingIndex + ", " +
				"customBasketCode=" + this.customBasketCode + ", " +
				"valuationAmount=" + this.valuationAmount + ", " +
				"valuationCurrency=" + this.valuationCurrency + ", " +
				"valuationMethod=" + this.valuationMethod + ", " +
				"delta=" + this.delta + ", " +
				"valuationTimestamp=" + this.valuationTimestamp + ", " +
				"confirmationTimestamp=" + this.confirmationTimestamp + ", " +
				"clearingObligation=" + this.clearingObligation + ", " +
				"masterAgreementType=" + this.masterAgreementType + ", " +
				"otherMasterAgreementType=" + this.otherMasterAgreementType + ", " +
				"masterAgreementVersion=" + this.masterAgreementVersion + ", " +
				"intragroup=" + this.intragroup + ", " +
				"ptrr=" + this.ptrr + ", " +
				"typeOfPTRRTechnique=" + this.typeOfPTRRTechnique + ", " +
				"ptrrServiceProvider=" + this.ptrrServiceProvider + ", " +
				"venueOfExecution=" + this.venueOfExecution + ", " +
				"forwardExchangeRate=" + this.forwardExchangeRate + ", " +
				"baseProduct=" + this.baseProduct + ", " +
				"subProduct=" + this.subProduct + ", " +
				"furtherSubProduct=" + this.furtherSubProduct + ", " +
				"deliveryPoint=" + this.deliveryPoint + ", " +
				"interconnectionPoint=" + this.interconnectionPoint + ", " +
				"loadType=" + this.loadType + ", " +
				"deliveryReport=" + this.deliveryReport + ", " +
				"referenceEntity=" + this.referenceEntity + ", " +
				"version=" + this.version + ", " +
				"tranche=" + this.tranche + ", " +
				"collateralPortfolioCode=" + this.collateralPortfolioCode + ", " +
				"eventDate=" + this.eventDate + ", " +
				"level=" + this.level +
			'}' + " " + super.toString();
		}
	}
}
