package drr.regulation.common.trade.contract;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.trade.contract.UnderlyingIdentifier;
import drr.regulation.common.trade.contract.UnderlyingIdentifier.UnderlyingIdentifierBuilder;
import drr.regulation.common.trade.contract.UnderlyingIdentifier.UnderlyingIdentifierBuilderImpl;
import drr.regulation.common.trade.contract.UnderlyingIdentifier.UnderlyingIdentifierImpl;
import drr.regulation.common.trade.contract.meta.UnderlyingIdentifierMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataType(value="UnderlyingIdentifier", builder=UnderlyingIdentifier.UnderlyingIdentifierBuilderImpl.class, version="6.0.0-dev.128")
@RuneDataType(value="UnderlyingIdentifier", model="drr", builder=UnderlyingIdentifier.UnderlyingIdentifierBuilderImpl.class, version="6.0.0-dev.128")
public interface UnderlyingIdentifier extends RosettaModelObject {

	UnderlyingIdentifierMeta metaData = new UnderlyingIdentifierMeta();

	/*********************** Getter Methods  ***********************/
	String getUnderlyingIdentification();
	String getUnderlyingIdentificationType();
	String getUnderlyingIdOther();
	String getUnderlyingIdOtherSource();

	/*********************** Build Methods  ***********************/
	UnderlyingIdentifier build();
	
	UnderlyingIdentifier.UnderlyingIdentifierBuilder toBuilder();
	
	static UnderlyingIdentifier.UnderlyingIdentifierBuilder builder() {
		return new UnderlyingIdentifier.UnderlyingIdentifierBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends UnderlyingIdentifier> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends UnderlyingIdentifier> getType() {
		return UnderlyingIdentifier.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, getUnderlyingIdentification(), this);
		processor.processBasic(path.newSubPath("underlyingIdentificationType"), String.class, getUnderlyingIdentificationType(), this);
		processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, getUnderlyingIdOther(), this);
		processor.processBasic(path.newSubPath("underlyingIdOtherSource"), String.class, getUnderlyingIdOtherSource(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface UnderlyingIdentifierBuilder extends UnderlyingIdentifier, RosettaModelObjectBuilder {
		UnderlyingIdentifier.UnderlyingIdentifierBuilder setUnderlyingIdentification(String underlyingIdentification);
		UnderlyingIdentifier.UnderlyingIdentifierBuilder setUnderlyingIdentificationType(String underlyingIdentificationType);
		UnderlyingIdentifier.UnderlyingIdentifierBuilder setUnderlyingIdOther(String underlyingIdOther);
		UnderlyingIdentifier.UnderlyingIdentifierBuilder setUnderlyingIdOtherSource(String underlyingIdOtherSource);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, getUnderlyingIdentification(), this);
			processor.processBasic(path.newSubPath("underlyingIdentificationType"), String.class, getUnderlyingIdentificationType(), this);
			processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, getUnderlyingIdOther(), this);
			processor.processBasic(path.newSubPath("underlyingIdOtherSource"), String.class, getUnderlyingIdOtherSource(), this);
		}
		

		UnderlyingIdentifier.UnderlyingIdentifierBuilder prune();
	}

	/*********************** Immutable Implementation of UnderlyingIdentifier  ***********************/
	class UnderlyingIdentifierImpl implements UnderlyingIdentifier {
		private final String underlyingIdentification;
		private final String underlyingIdentificationType;
		private final String underlyingIdOther;
		private final String underlyingIdOtherSource;
		
		protected UnderlyingIdentifierImpl(UnderlyingIdentifier.UnderlyingIdentifierBuilder builder) {
			this.underlyingIdentification = builder.getUnderlyingIdentification();
			this.underlyingIdentificationType = builder.getUnderlyingIdentificationType();
			this.underlyingIdOther = builder.getUnderlyingIdOther();
			this.underlyingIdOtherSource = builder.getUnderlyingIdOtherSource();
		}
		
		@Override
		@RosettaAttribute("underlyingIdentification")
		@RuneAttribute("underlyingIdentification")
		public String getUnderlyingIdentification() {
			return underlyingIdentification;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentificationType")
		@RuneAttribute("underlyingIdentificationType")
		public String getUnderlyingIdentificationType() {
			return underlyingIdentificationType;
		}
		
		@Override
		@RosettaAttribute("underlyingIdOther")
		@RuneAttribute("underlyingIdOther")
		public String getUnderlyingIdOther() {
			return underlyingIdOther;
		}
		
		@Override
		@RosettaAttribute("underlyingIdOtherSource")
		@RuneAttribute("underlyingIdOtherSource")
		public String getUnderlyingIdOtherSource() {
			return underlyingIdOtherSource;
		}
		
		@Override
		public UnderlyingIdentifier build() {
			return this;
		}
		
		@Override
		public UnderlyingIdentifier.UnderlyingIdentifierBuilder toBuilder() {
			UnderlyingIdentifier.UnderlyingIdentifierBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(UnderlyingIdentifier.UnderlyingIdentifierBuilder builder) {
			ofNullable(getUnderlyingIdentification()).ifPresent(builder::setUnderlyingIdentification);
			ofNullable(getUnderlyingIdentificationType()).ifPresent(builder::setUnderlyingIdentificationType);
			ofNullable(getUnderlyingIdOther()).ifPresent(builder::setUnderlyingIdOther);
			ofNullable(getUnderlyingIdOtherSource()).ifPresent(builder::setUnderlyingIdOtherSource);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			UnderlyingIdentifier _that = getType().cast(o);
		
			if (!Objects.equals(underlyingIdentification, _that.getUnderlyingIdentification())) return false;
			if (!Objects.equals(underlyingIdentificationType, _that.getUnderlyingIdentificationType())) return false;
			if (!Objects.equals(underlyingIdOther, _that.getUnderlyingIdOther())) return false;
			if (!Objects.equals(underlyingIdOtherSource, _that.getUnderlyingIdOtherSource())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (underlyingIdentification != null ? underlyingIdentification.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentificationType != null ? underlyingIdentificationType.hashCode() : 0);
			_result = 31 * _result + (underlyingIdOther != null ? underlyingIdOther.hashCode() : 0);
			_result = 31 * _result + (underlyingIdOtherSource != null ? underlyingIdOtherSource.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "UnderlyingIdentifier {" +
				"underlyingIdentification=" + this.underlyingIdentification + ", " +
				"underlyingIdentificationType=" + this.underlyingIdentificationType + ", " +
				"underlyingIdOther=" + this.underlyingIdOther + ", " +
				"underlyingIdOtherSource=" + this.underlyingIdOtherSource +
			'}';
		}
	}

	/*********************** Builder Implementation of UnderlyingIdentifier  ***********************/
	class UnderlyingIdentifierBuilderImpl implements UnderlyingIdentifier.UnderlyingIdentifierBuilder {
	
		protected String underlyingIdentification;
		protected String underlyingIdentificationType;
		protected String underlyingIdOther;
		protected String underlyingIdOtherSource;
		
		@Override
		@RosettaAttribute("underlyingIdentification")
		@RuneAttribute("underlyingIdentification")
		public String getUnderlyingIdentification() {
			return underlyingIdentification;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentificationType")
		@RuneAttribute("underlyingIdentificationType")
		public String getUnderlyingIdentificationType() {
			return underlyingIdentificationType;
		}
		
		@Override
		@RosettaAttribute("underlyingIdOther")
		@RuneAttribute("underlyingIdOther")
		public String getUnderlyingIdOther() {
			return underlyingIdOther;
		}
		
		@Override
		@RosettaAttribute("underlyingIdOtherSource")
		@RuneAttribute("underlyingIdOtherSource")
		public String getUnderlyingIdOtherSource() {
			return underlyingIdOtherSource;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentification")
		@RuneAttribute("underlyingIdentification")
		public UnderlyingIdentifier.UnderlyingIdentifierBuilder setUnderlyingIdentification(String _underlyingIdentification) {
			this.underlyingIdentification = _underlyingIdentification == null ? null : _underlyingIdentification;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentificationType")
		@RuneAttribute("underlyingIdentificationType")
		public UnderlyingIdentifier.UnderlyingIdentifierBuilder setUnderlyingIdentificationType(String _underlyingIdentificationType) {
			this.underlyingIdentificationType = _underlyingIdentificationType == null ? null : _underlyingIdentificationType;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingIdOther")
		@RuneAttribute("underlyingIdOther")
		public UnderlyingIdentifier.UnderlyingIdentifierBuilder setUnderlyingIdOther(String _underlyingIdOther) {
			this.underlyingIdOther = _underlyingIdOther == null ? null : _underlyingIdOther;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingIdOtherSource")
		@RuneAttribute("underlyingIdOtherSource")
		public UnderlyingIdentifier.UnderlyingIdentifierBuilder setUnderlyingIdOtherSource(String _underlyingIdOtherSource) {
			this.underlyingIdOtherSource = _underlyingIdOtherSource == null ? null : _underlyingIdOtherSource;
			return this;
		}
		
		@Override
		public UnderlyingIdentifier build() {
			return new UnderlyingIdentifier.UnderlyingIdentifierImpl(this);
		}
		
		@Override
		public UnderlyingIdentifier.UnderlyingIdentifierBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public UnderlyingIdentifier.UnderlyingIdentifierBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getUnderlyingIdentification()!=null) return true;
			if (getUnderlyingIdentificationType()!=null) return true;
			if (getUnderlyingIdOther()!=null) return true;
			if (getUnderlyingIdOtherSource()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public UnderlyingIdentifier.UnderlyingIdentifierBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			UnderlyingIdentifier.UnderlyingIdentifierBuilder o = (UnderlyingIdentifier.UnderlyingIdentifierBuilder) other;
			
			
			merger.mergeBasic(getUnderlyingIdentification(), o.getUnderlyingIdentification(), this::setUnderlyingIdentification);
			merger.mergeBasic(getUnderlyingIdentificationType(), o.getUnderlyingIdentificationType(), this::setUnderlyingIdentificationType);
			merger.mergeBasic(getUnderlyingIdOther(), o.getUnderlyingIdOther(), this::setUnderlyingIdOther);
			merger.mergeBasic(getUnderlyingIdOtherSource(), o.getUnderlyingIdOtherSource(), this::setUnderlyingIdOtherSource);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			UnderlyingIdentifier _that = getType().cast(o);
		
			if (!Objects.equals(underlyingIdentification, _that.getUnderlyingIdentification())) return false;
			if (!Objects.equals(underlyingIdentificationType, _that.getUnderlyingIdentificationType())) return false;
			if (!Objects.equals(underlyingIdOther, _that.getUnderlyingIdOther())) return false;
			if (!Objects.equals(underlyingIdOtherSource, _that.getUnderlyingIdOtherSource())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (underlyingIdentification != null ? underlyingIdentification.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentificationType != null ? underlyingIdentificationType.hashCode() : 0);
			_result = 31 * _result + (underlyingIdOther != null ? underlyingIdOther.hashCode() : 0);
			_result = 31 * _result + (underlyingIdOtherSource != null ? underlyingIdOtherSource.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "UnderlyingIdentifierBuilder {" +
				"underlyingIdentification=" + this.underlyingIdentification + ", " +
				"underlyingIdentificationType=" + this.underlyingIdentificationType + ", " +
				"underlyingIdOther=" + this.underlyingIdOther + ", " +
				"underlyingIdOtherSource=" + this.underlyingIdOtherSource +
			'}';
		}
	}
}
