package drr.regulation.common.trade.contract.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.common.trade.contract.UnderlyingIdentifier;
import drr.regulation.common.trade.contract.validation.UnderlyingIdentifierTypeFormatValidator;
import drr.regulation.common.trade.contract.validation.UnderlyingIdentifierValidator;
import drr.regulation.common.trade.contract.validation.exists.UnderlyingIdentifierOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 6.0.0-dev.128
 */
@RosettaMeta(model=UnderlyingIdentifier.class)
public class UnderlyingIdentifierMeta implements RosettaMetaData<UnderlyingIdentifier> {

	@Override
	public List<Validator<? super UnderlyingIdentifier>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super UnderlyingIdentifier, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super UnderlyingIdentifier> validator(ValidatorFactory factory) {
		return factory.<UnderlyingIdentifier>create(UnderlyingIdentifierValidator.class);
	}

	@Override
	public Validator<? super UnderlyingIdentifier> typeFormatValidator(ValidatorFactory factory) {
		return factory.<UnderlyingIdentifier>create(UnderlyingIdentifierTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super UnderlyingIdentifier> validator() {
		return new UnderlyingIdentifierValidator();
	}

	@Deprecated
	@Override
	public Validator<? super UnderlyingIdentifier> typeFormatValidator() {
		return new UnderlyingIdentifierTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super UnderlyingIdentifier, Set<String>> onlyExistsValidator() {
		return new UnderlyingIdentifierOnlyExistsValidator();
	}
}
