package drr.regulation.common.trade.contract.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.trade.contract.UnderlyingIdentifier;
import java.util.List;
import java.util.regex.Pattern;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkString;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class UnderlyingIdentifierTypeFormatValidator implements Validator<UnderlyingIdentifier> {

	private List<ComparisonResult> getComparisonResults(UnderlyingIdentifier o) {
		return Lists.<ComparisonResult>newArrayList(
				checkString("underlyingIdentification", o.getUnderlyingIdentification(), 0, empty(), of(Pattern.compile("[A-Z]{2,2}[A-Z0-9]{9,9}[0-9]{1,1}"))), 
				checkString("underlyingIdentificationType", o.getUnderlyingIdentificationType(), 1, of(1), of(Pattern.compile("[a-zA-Z]"))), 
				checkString("underlyingIdOther", o.getUnderlyingIdOther(), 1, of(210), empty())
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, UnderlyingIdentifier o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("UnderlyingIdentifier", ValidationType.TYPE_FORMAT, "UnderlyingIdentifier", path, "", res.getError());
				}
				return success("UnderlyingIdentifier", ValidationType.TYPE_FORMAT, "UnderlyingIdentifier", path, "");
			})
			.collect(toList());
	}

}
