package drr.regulation.common.trade.contract.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.trade.contract.UnderlyingIdentifier;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class UnderlyingIdentifierValidator implements Validator<UnderlyingIdentifier> {

	private List<ComparisonResult> getComparisonResults(UnderlyingIdentifier o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("underlyingIdentification", (String) o.getUnderlyingIdentification() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingIdentificationType", (String) o.getUnderlyingIdentificationType() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingIdOther", (String) o.getUnderlyingIdOther() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingIdOtherSource", (String) o.getUnderlyingIdOtherSource() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, UnderlyingIdentifier o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("UnderlyingIdentifier", ValidationType.CARDINALITY, "UnderlyingIdentifier", path, "", res.getError());
				}
				return success("UnderlyingIdentifier", ValidationType.CARDINALITY, "UnderlyingIdentifier", path, "");
			})
			.collect(toList());
	}

}
