package drr.regulation.common.trade.execution.reports;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.ReportingRoleEnum;
import drr.regulation.common.ReportingSide;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import drr.standards.iso.TradingCapacity7Code;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(TradingCapacityRule.TradingCapacityRuleDefault.class)
public abstract class TradingCapacityRule implements ReportFunction<TransactionReportInstruction, TradingCapacity7Code> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public TradingCapacity7Code evaluate(TransactionReportInstruction input) {
		TradingCapacity7Code output = doEvaluate(input);
		
		return output;
	}

	protected abstract TradingCapacity7Code doEvaluate(TransactionReportInstruction input);

	public static class TradingCapacityRuleDefault extends TradingCapacityRule {
		@Override
		protected TradingCapacity7Code doEvaluate(TransactionReportInstruction input) {
			TradingCapacity7Code output = null;
			return assignOutput(output, input);
		}
		
		protected TradingCapacity7Code assignOutput(TradingCapacity7Code output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(reportInstruction -> {
					final MapperC<PartyInformation> thenArg0 = MapperS.of(input).<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation());
					final MapperC<PartyInformation> thenArg1 = thenArg0
						.filterItemNullSafe(item -> areEqual(item.<ReferenceWithMetaParty>map("getPartyReference", partyInformation -> partyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty0 -> referenceWithMetaParty0 == null ? null : referenceWithMetaParty0.getValue()), reportInstruction.<ReportingSide>map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingParty", reportingSide -> reportingSide.getReportingParty()).<Party>map("Type coercion", referenceWithMetaParty1 -> referenceWithMetaParty1 == null ? null : referenceWithMetaParty1.getValue()), CardinalityOperator.All).get());
					final MapperListOfLists<ReportingRegime> thenArg2 = thenArg1
						.mapItemToList(item -> item.<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()));
					final MapperC<ReportingRegime> thenArg3 = thenArg2
						.flattenList();
					final MapperC<ReportingRegime> thenArg4 = thenArg3
						.filterItemNullSafe(item -> areEqual(item.<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum == null ? null : fieldWithMetaSupervisoryBodyEnum.getValue()), MapperS.of(SupervisoryBodyEnum.MAS), CardinalityOperator.All).get());
					final MapperS<ReportingRegime> thenArg5 = MapperS.of(thenArg4.get());
					return thenArg5
						.mapSingleToItem(item -> {
							if (areEqual(item.<ReportingRoleEnum>map("getTradingCapacity", reportingRegime -> reportingRegime.getTradingCapacity()), MapperS.of(ReportingRoleEnum.AGENT), CardinalityOperator.All).getOrDefault(false)) {
								return MapperS.of(TradingCapacity7Code.AGEN);
							}
							if (areEqual(item.<ReportingRoleEnum>map("getTradingCapacity", reportingRegime -> reportingRegime.getTradingCapacity()), MapperS.of(ReportingRoleEnum.PRINCIPAL), CardinalityOperator.All).getOrDefault(false)) {
								return MapperS.of(TradingCapacity7Code.PRIN);
							}
							return MapperS.<TradingCapacity7Code>ofNull();
						});
				}).get();
			
			return output;
		}
	}
}
