package drr.regulation.common.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.CommonLeg.CommonLegBuilder;
import drr.standards.iosco.cde.Leg;
import drr.standards.iosco.cde.quantity.NotionalPeriod;
import drr.standards.iso.FrequencyPeriodEnum;
import drr.standards.iso.IndexEnum;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(LegEnrichment.LegEnrichmentDefault.class)
public abstract class LegEnrichment implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected LegToCommonLeg legToCommonLeg;

	/**
	* @param leg 
	* @param notionalAmountSchedule 
	* @param notionalQuantitySchedule 
	* @param notionalQuantity 
	* @param floatingRateResetFrequencyPeriod 
	* @param floatingRateResetFrequencyMultiplier 
	* @param fixingDate 
	* @param quantityFrequency 
	* @param quantityFrequencyMultiplier 
	* @param floatingRateIndicator 
	* @param floatingRateIdentifier 
	* @param floatingRateReferencePeriod 
	* @param floatingRateReferencePeriodMultiplier 
	* @param nameOfTheFloatingRate 
	* @return enrichedLeg 
	*/
	public CommonLeg evaluate(Leg leg, List<? extends NotionalPeriod> notionalAmountSchedule, List<? extends NotionalPeriod> notionalQuantitySchedule, BigDecimal notionalQuantity, FrequencyPeriodEnum floatingRateResetFrequencyPeriod, Integer floatingRateResetFrequencyMultiplier, ZonedDateTime fixingDate, FrequencyPeriodEnum quantityFrequency, Integer quantityFrequencyMultiplier, IndexEnum floatingRateIndicator, String floatingRateIdentifier, FrequencyPeriodEnum floatingRateReferencePeriod, Integer floatingRateReferencePeriodMultiplier, String nameOfTheFloatingRate) {
		CommonLeg.CommonLegBuilder enrichedLegBuilder = doEvaluate(leg, notionalAmountSchedule, notionalQuantitySchedule, notionalQuantity, floatingRateResetFrequencyPeriod, floatingRateResetFrequencyMultiplier, fixingDate, quantityFrequency, quantityFrequencyMultiplier, floatingRateIndicator, floatingRateIdentifier, floatingRateReferencePeriod, floatingRateReferencePeriodMultiplier, nameOfTheFloatingRate);
		
		final CommonLeg enrichedLeg;
		if (enrichedLegBuilder == null) {
			enrichedLeg = null;
		} else {
			enrichedLeg = enrichedLegBuilder.build();
			objectValidator.validate(CommonLeg.class, enrichedLeg);
		}
		
		return enrichedLeg;
	}

	protected abstract CommonLeg.CommonLegBuilder doEvaluate(Leg leg, List<? extends NotionalPeriod> notionalAmountSchedule, List<? extends NotionalPeriod> notionalQuantitySchedule, BigDecimal notionalQuantity, FrequencyPeriodEnum floatingRateResetFrequencyPeriod, Integer floatingRateResetFrequencyMultiplier, ZonedDateTime fixingDate, FrequencyPeriodEnum quantityFrequency, Integer quantityFrequencyMultiplier, IndexEnum floatingRateIndicator, String floatingRateIdentifier, FrequencyPeriodEnum floatingRateReferencePeriod, Integer floatingRateReferencePeriodMultiplier, String nameOfTheFloatingRate);

	public static class LegEnrichmentDefault extends LegEnrichment {
		@Override
		protected CommonLeg.CommonLegBuilder doEvaluate(Leg leg, List<? extends NotionalPeriod> notionalAmountSchedule, List<? extends NotionalPeriod> notionalQuantitySchedule, BigDecimal notionalQuantity, FrequencyPeriodEnum floatingRateResetFrequencyPeriod, Integer floatingRateResetFrequencyMultiplier, ZonedDateTime fixingDate, FrequencyPeriodEnum quantityFrequency, Integer quantityFrequencyMultiplier, IndexEnum floatingRateIndicator, String floatingRateIdentifier, FrequencyPeriodEnum floatingRateReferencePeriod, Integer floatingRateReferencePeriodMultiplier, String nameOfTheFloatingRate) {
			if (notionalAmountSchedule == null) {
				notionalAmountSchedule = Collections.emptyList();
			}
			if (notionalQuantitySchedule == null) {
				notionalQuantitySchedule = Collections.emptyList();
			}
			CommonLeg.CommonLegBuilder enrichedLeg = CommonLeg.builder();
			return assignOutput(enrichedLeg, leg, notionalAmountSchedule, notionalQuantitySchedule, notionalQuantity, floatingRateResetFrequencyPeriod, floatingRateResetFrequencyMultiplier, fixingDate, quantityFrequency, quantityFrequencyMultiplier, floatingRateIndicator, floatingRateIdentifier, floatingRateReferencePeriod, floatingRateReferencePeriodMultiplier, nameOfTheFloatingRate);
		}
		
		protected CommonLeg.CommonLegBuilder assignOutput(CommonLeg.CommonLegBuilder enrichedLeg, Leg leg, List<? extends NotionalPeriod> notionalAmountSchedule, List<? extends NotionalPeriod> notionalQuantitySchedule, BigDecimal notionalQuantity, FrequencyPeriodEnum floatingRateResetFrequencyPeriod, Integer floatingRateResetFrequencyMultiplier, ZonedDateTime fixingDate, FrequencyPeriodEnum quantityFrequency, Integer quantityFrequencyMultiplier, IndexEnum floatingRateIndicator, String floatingRateIdentifier, FrequencyPeriodEnum floatingRateReferencePeriod, Integer floatingRateReferencePeriodMultiplier, String nameOfTheFloatingRate) {
			enrichedLeg = toBuilder(legToCommonLeg.evaluate(leg));
			
			enrichedLeg
				.setNotionalAmountSchedule(notionalAmountSchedule);
			
			enrichedLeg
				.setNotionalQuantitySchedule(notionalQuantitySchedule);
			
			enrichedLeg
				.setNotionalQuantity(notionalQuantity);
			
			enrichedLeg
				.setFixingDate(fixingDate);
			
			enrichedLeg
				.setQuantityFrequency(quantityFrequency);
			
			enrichedLeg
				.setQuantityFrequencyMultiplier(quantityFrequencyMultiplier);
			
			enrichedLeg
				.getOrCreatePeriodicPayment()
				.setFloatingRateResetFrequencyPeriod(floatingRateResetFrequencyPeriod);
			
			enrichedLeg
				.getOrCreatePeriodicPayment()
				.setFloatingRateResetFrequencyMultiplier(floatingRateResetFrequencyMultiplier);
			
			enrichedLeg
				.getOrCreatePeriodicPayment()
				.setFloatingRateIndicator(floatingRateIndicator);
			
			enrichedLeg
				.getOrCreatePeriodicPayment()
				.setFloatingRateIdentifier(floatingRateIdentifier);
			
			enrichedLeg
				.getOrCreatePeriodicPayment()
				.setFloatingRateReferencePeriod(floatingRateReferencePeriod);
			
			enrichedLeg
				.getOrCreatePeriodicPayment()
				.setFloatingRateReferencePeriodMultiplier(floatingRateReferencePeriodMultiplier);
			
			enrichedLeg
				.getOrCreatePeriodicPayment()
				.setNameOfTheFloatingRate(nameOfTheFloatingRate);
			
			return Optional.ofNullable(enrichedLeg)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
