package drr.regulation.common.trade.payment.reports;

import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.InflationRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.common.schedule.ResetDates;
import cdm.product.common.schedule.ResetFrequency;
import cdm.product.common.schedule.ResetFrequency.ResetFrequencyBuilder;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(FloatingRateResetFrequencyLeg1Rule.FloatingRateResetFrequencyLeg1RuleDefault.class)
public abstract class FloatingRateResetFrequencyLeg1Rule implements ReportFunction<TransactionReportInstruction, ResetFrequency> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ResetFrequency evaluate(TransactionReportInstruction input) {
		ResetFrequency.ResetFrequencyBuilder outputBuilder = doEvaluate(input);
		
		final ResetFrequency output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(ResetFrequency.class, output);
		}
		
		return output;
	}

	protected abstract ResetFrequency.ResetFrequencyBuilder doEvaluate(TransactionReportInstruction input);

	public static class FloatingRateResetFrequencyLeg1RuleDefault extends FloatingRateResetFrequencyLeg1Rule {
		@Override
		protected ResetFrequency.ResetFrequencyBuilder doEvaluate(TransactionReportInstruction input) {
			ResetFrequency.ResetFrequencyBuilder output = ResetFrequency.builder();
			return assignOutput(output, input);
		}
		
		protected ResetFrequency.ResetFrequencyBuilder assignOutput(ResetFrequency.ResetFrequencyBuilder output, TransactionReportInstruction input) {
			final MapperS<Product> thenArg0 = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(productOrUnderlierProduct.evaluate(item.get())));
			final MapperS<InterestRatePayout> thenArg2 = thenArg1
				.mapSingleToItem(item -> MapperS.of(interestRateLeg1.evaluate(item.get())));
			final MapperS<InterestRatePayout> thenArg3 = thenArg2
				.filterSingleNullSafe(item -> exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).or(exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate()))).get());
			output = toBuilder(thenArg3
				.mapSingleToItem(item -> item.<ResetDates>map("getResetDates", interestRatePayout -> interestRatePayout.getResetDates()).<ResetFrequency>map("getResetFrequency", resetDates -> resetDates.getResetFrequency())).get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
