package drr.regulation.common.trade.payment.reports;

import cdm.base.datetime.PeriodExtendedEnum;
import cdm.product.common.schedule.ResetFrequency;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.payment.functions.MapCDEFrequencyPeriod;
import drr.standards.iso.FrequencyPeriodEnum;
import javax.inject.Inject;


@ImplementedBy(FloatingRateResetFrequencyPeriodLeg1Rule.FloatingRateResetFrequencyPeriodLeg1RuleDefault.class)
public abstract class FloatingRateResetFrequencyPeriodLeg1Rule implements ReportFunction<TransactionReportInstruction, FrequencyPeriodEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected FloatingRateResetFrequencyLeg1Rule floatingRateResetFrequencyLeg1Rule;
	@Inject protected MapCDEFrequencyPeriod mapCDEFrequencyPeriod;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public FrequencyPeriodEnum evaluate(TransactionReportInstruction input) {
		FrequencyPeriodEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract FrequencyPeriodEnum doEvaluate(TransactionReportInstruction input);

	public static class FloatingRateResetFrequencyPeriodLeg1RuleDefault extends FloatingRateResetFrequencyPeriodLeg1Rule {
		@Override
		protected FrequencyPeriodEnum doEvaluate(TransactionReportInstruction input) {
			FrequencyPeriodEnum output = null;
			return assignOutput(output, input);
		}
		
		protected FrequencyPeriodEnum assignOutput(FrequencyPeriodEnum output, TransactionReportInstruction input) {
			final MapperS<ResetFrequency> thenArg = MapperS.of(floatingRateResetFrequencyLeg1Rule.evaluate(input));
			output = thenArg
				.mapSingleToItem(item -> MapperS.of(mapCDEFrequencyPeriod.evaluate(item.<PeriodExtendedEnum>map("getPeriod", resetFrequency -> resetFrequency.getPeriod()).get()))).get();
			
			return output;
		}
	}
}
