package drr.regulation.common.trade.price.reports;

import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.price.functions.FormatToBaseOne18Rate;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(ExchangeRateRule.ExchangeRateRuleDefault.class)
public abstract class ExchangeRateRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.standards.iosco.cde.price.reports.ExchangeRateRule exchangeRateRule;
	@Inject protected FormatToBaseOne18Rate formatToBaseOne18Rate;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class ExchangeRateRuleDefault extends ExchangeRateRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<PriceSchedule> thenArg0 = MapperS.of(exchangeRateRule.evaluate(input));
			final MapperS<BigDecimal> thenArg1 = thenArg0
				.mapSingleToItem(item -> item.<BigDecimal>map("getValue", priceSchedule -> priceSchedule.getValue()));
			output = MapperS.of(formatToBaseOne18Rate.evaluate(thenArg1.get())).get();
			
			return output;
		}
	}
}
