package drr.regulation.common.trade.price.reports;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.standards.iosco.cde.price.reports.InterestRateFixedRateRule;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(FixedRateLeg2Rule.FixedRateLeg2RuleDefault.class)
public abstract class FixedRateLeg2Rule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected InterestRateFixedRateRule interestRateFixedRateRule;
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class FixedRateLeg2RuleDefault extends FixedRateLeg2Rule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<Product> thenArg0 = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(productOrUnderlierProduct.evaluate(item.get())));
			output = MapperS.of(interestRateFixedRateRule.evaluate(interestRateLeg2.evaluate(thenArg1.get()))).get();
			
			return output;
		}
	}
}
