package drr.regulation.common.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.CFTCPartyInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataRule("ReportingRegimeCFTCReportingRegime")
@ImplementedBy(ReportingRegimeCFTCReportingRegime.Default.class)
public interface ReportingRegimeCFTCReportingRegime extends Validator<ReportingRegime> {
	
	String NAME = "ReportingRegimeCFTCReportingRegime";
	String DEFINITION = "if supervisoryBody = SupervisoryBodyEnum -> CFTC then cftcPartyInformation exists else cftcPartyInformation is absent";
	
	class Default implements ReportingRegimeCFTCReportingRegime {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReportingRegime reportingRegime) {
			ComparisonResult result = executeDataRule(reportingRegime);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ReportingRegime", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "ReportingRegime", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ReportingRegime reportingRegime) {
			try {
				if (areEqual(MapperS.of(reportingRegime).<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", _reportingRegime -> _reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum == null ? null : fieldWithMetaSupervisoryBodyEnum.getValue()), MapperS.of(SupervisoryBodyEnum.CFTC), CardinalityOperator.All).getOrDefault(false)) {
					return exists(MapperS.of(reportingRegime).<CFTCPartyInformation>map("getCftcPartyInformation", _reportingRegime -> _reportingRegime.getCftcPartyInformation()));
				}
				return notExists(MapperS.of(reportingRegime).<CFTCPartyInformation>map("getCftcPartyInformation", _reportingRegime -> _reportingRegime.getCftcPartyInformation()));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ReportingRegimeCFTCReportingRegime {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReportingRegime reportingRegime) {
			return Collections.emptyList();
		}
	}
}
