package drr.regulation.common.validation.exists;

import cdm.event.common.PositionIdentifier;
import cdm.observable.asset.PriceSchedule;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.enrichment.common.EnrichmentData;
import drr.regulation.common.ConfirmationMethodEnum;
import drr.regulation.common.CustomBasket;
import drr.regulation.common.ExecutionVenueTypeEnum;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableActionEnum;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportablePriceSource;
import drr.regulation.common.TransactionInformation;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class ReportableInformationOnlyExistsValidator implements ValidatorWithArg<ReportableInformation, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends ReportableInformation> ValidationResult<ReportableInformation> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("confirmationMethod", ExistenceChecker.isSet((ConfirmationMethodEnum) o.getConfirmationMethod()))
				.put("executionVenueType", ExistenceChecker.isSet((ExecutionVenueTypeEnum) o.getExecutionVenueType()))
				.put("intragroup", ExistenceChecker.isSet((Boolean) o.getIntragroup()))
				.put("affiliated", ExistenceChecker.isSet((Boolean) o.getAffiliated()))
				.put("largeSizeTrade", ExistenceChecker.isSet((Boolean) o.getLargeSizeTrade()))
				.put("partyInformation", ExistenceChecker.isSet((List<? extends PartyInformation>) o.getPartyInformation()))
				.put("sefOrDcmAnonymousIndicator", ExistenceChecker.isSet((Boolean) o.getSefOrDcmAnonymousIndicator()))
				.put("originalExecutionTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getOriginalExecutionTimestamp()))
				.put("enrichment", ExistenceChecker.isSet((EnrichmentData) o.getEnrichment()))
				.put("cryptoBased", ExistenceChecker.isSet((Boolean) o.getCryptoBased()))
				.put("underlyingAssetLastAvailableSpotPrice", ExistenceChecker.isSet((PriceSchedule) o.getUnderlyingAssetLastAvailableSpotPrice()))
				.put("underlyingAssetPriceSource", ExistenceChecker.isSet((List<? extends ReportablePriceSource>) o.getUnderlyingAssetPriceSource()))
				.put("transactionInformation", ExistenceChecker.isSet((List<? extends TransactionInformation>) o.getTransactionInformation()))
				.put("reportableAction", ExistenceChecker.isSet((ReportableActionEnum) o.getReportableAction()))
				.put("subsequentPositionUTI", ExistenceChecker.isSet((PositionIdentifier) o.getSubsequentPositionUTI()))
				.put("counterpartyPositionPriorUTI", ExistenceChecker.isSet((PositionIdentifier) o.getCounterpartyPositionPriorUTI()))
				.put("customBasket", ExistenceChecker.isSet((CustomBasket) o.getCustomBasket()))
				.put("finalContractualSettlementDate", ExistenceChecker.isSet((Date) o.getFinalContractualSettlementDate()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("ReportableInformation", ValidationType.ONLY_EXISTS, "ReportableInformation", path, "");
		}
		return failure("ReportableInformation", ValidationType.ONLY_EXISTS, "ReportableInformation", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
