package drr.regulation.csa.rewrite.dtcc;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.csa.rewrite.dtcc.DTCCAdditionalFields;
import drr.regulation.csa.rewrite.dtcc.DTCCAdditionalFields.DTCCAdditionalFieldsBuilder;
import drr.regulation.csa.rewrite.dtcc.DTCCAdditionalFields.DTCCAdditionalFieldsBuilderImpl;
import drr.regulation.csa.rewrite.dtcc.DTCCAdditionalFields.DTCCAdditionalFieldsImpl;
import drr.regulation.csa.rewrite.dtcc.UnderlyingAssetNameReport;
import drr.regulation.csa.rewrite.dtcc.UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder;
import drr.regulation.csa.rewrite.dtcc.UnderlyingAssetReport;
import drr.regulation.csa.rewrite.dtcc.UnderlyingAssetReport.UnderlyingAssetReportBuilder;
import drr.regulation.csa.rewrite.dtcc.meta.DTCCAdditionalFieldsMeta;
import drr.standards.iso.OptionStyleEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

import static java.util.Optional.ofNullable;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataType(value="DTCCAdditionalFields", builder=DTCCAdditionalFields.DTCCAdditionalFieldsBuilderImpl.class, version="6.0.0-dev.128")
@RuneDataType(value="DTCCAdditionalFields", model="drr", builder=DTCCAdditionalFields.DTCCAdditionalFieldsBuilderImpl.class, version="6.0.0-dev.128")
public interface DTCCAdditionalFields extends RosettaModelObject {

	DTCCAdditionalFieldsMeta metaData = new DTCCAdditionalFieldsMeta();

	/*********************** Getter Methods  ***********************/
	PartyIdentifierTypeEnum getClearingVenueIDType();
	PartyIdentifierTypeEnum getTradeParty1ClearingBrokerIDType();
	PartyIdentifierTypeEnum getTradeParty1IDType();
	PartyIdentifierTypeEnum getSubmittingPartyIDType();
	String getAllocationType();
	String getUsiID();
	String getUsiIDPrefix();
	String getNewSDRIdentifier();
	String getSubmittedForParty();
	String getTradeLegTypes();
	List<SupervisoryBodyEnum> getTradeParty1ReportingDestination();
	List<SupervisoryBodyEnum> getTradeParty2ReportingDestination();
	AssetClassEnum getPrimaryAssetClass();
	AssetClassEnum getSecondaryAssetClass();
	String getComment1();
	String getMessageID();
	String getMessageTypeTransaction();
	String getMessageTypePPD();
	OptionStyleEnum getOptionStyle();
	String getOptionType();
	String getProductID();
	String getTradeParty2ExecutionAgentID();
	PartyIdentifierTypeEnum getTradeParty2ExecutionAgentIDType();
	String getTradeParty1ExecutionAgentID();
	PartyIdentifierTypeEnum getTradeParty1ExecutionAgentIDType();
	String getTradeParty1TransactionID();
	String getVersionTransaction();
	String getVersionPPD();
	String getLeg1CommodityUnderlyerID();
	String getLeg2CommodityUnderlyerID();
	String getLeg1FloatingRateIndex();
	String getLeg2FloatingRateIndex();
	List<? extends UnderlyingAssetReport> getUnderlyingAsset();
	UnderlyingAssetNameReport getUnderlyingAssetName();
	String getSettlementType();
	String getExecutionVenueID();
	PartyIdentifierTypeEnum getExecutionVenueIDType();
	List<String> getProductGrade();
	String getDeliveryLocation();
	String getLeg1SettlementPeriod();
	String getLoadType();
	PartyIdentifierTypeEnum getTradeParty1BrokerIDType();
	String getLeg1CommodityInstrumentID();
	String getLeg2CommodityInstrumentID();
	PartyIdentifierTypeEnum getResponsibleDataSubmitterIDType();
	String getResponsibleDataSubmitterID();
	Date getMaturityDateOfTheUnderlying();
	String getCorporateActionNewTradeParty1Lei();
	List<String> getOtherPaymentPayerIDType();
	List<String> getOtherPaymentReceiverIDType();

	/*********************** Build Methods  ***********************/
	DTCCAdditionalFields build();
	
	DTCCAdditionalFields.DTCCAdditionalFieldsBuilder toBuilder();
	
	static DTCCAdditionalFields.DTCCAdditionalFieldsBuilder builder() {
		return new DTCCAdditionalFields.DTCCAdditionalFieldsBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends DTCCAdditionalFields> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends DTCCAdditionalFields> getType() {
		return DTCCAdditionalFields.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("clearingVenueIDType"), PartyIdentifierTypeEnum.class, getClearingVenueIDType(), this);
		processor.processBasic(path.newSubPath("tradeParty1ClearingBrokerIDType"), PartyIdentifierTypeEnum.class, getTradeParty1ClearingBrokerIDType(), this);
		processor.processBasic(path.newSubPath("tradeParty1IDType"), PartyIdentifierTypeEnum.class, getTradeParty1IDType(), this);
		processor.processBasic(path.newSubPath("submittingPartyIDType"), PartyIdentifierTypeEnum.class, getSubmittingPartyIDType(), this);
		processor.processBasic(path.newSubPath("allocationType"), String.class, getAllocationType(), this);
		processor.processBasic(path.newSubPath("usiID"), String.class, getUsiID(), this);
		processor.processBasic(path.newSubPath("usiIDPrefix"), String.class, getUsiIDPrefix(), this);
		processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, getNewSDRIdentifier(), this);
		processor.processBasic(path.newSubPath("submittedForParty"), String.class, getSubmittedForParty(), this);
		processor.processBasic(path.newSubPath("tradeLegTypes"), String.class, getTradeLegTypes(), this);
		processor.processBasic(path.newSubPath("tradeParty1ReportingDestination"), SupervisoryBodyEnum.class, getTradeParty1ReportingDestination(), this);
		processor.processBasic(path.newSubPath("tradeParty2ReportingDestination"), SupervisoryBodyEnum.class, getTradeParty2ReportingDestination(), this);
		processor.processBasic(path.newSubPath("primaryAssetClass"), AssetClassEnum.class, getPrimaryAssetClass(), this);
		processor.processBasic(path.newSubPath("secondaryAssetClass"), AssetClassEnum.class, getSecondaryAssetClass(), this);
		processor.processBasic(path.newSubPath("comment1"), String.class, getComment1(), this);
		processor.processBasic(path.newSubPath("messageID"), String.class, getMessageID(), this);
		processor.processBasic(path.newSubPath("messageTypeTransaction"), String.class, getMessageTypeTransaction(), this);
		processor.processBasic(path.newSubPath("messageTypePPD"), String.class, getMessageTypePPD(), this);
		processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, getOptionStyle(), this);
		processor.processBasic(path.newSubPath("optionType"), String.class, getOptionType(), this);
		processor.processBasic(path.newSubPath("productID"), String.class, getProductID(), this);
		processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentID"), String.class, getTradeParty2ExecutionAgentID(), this);
		processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, getTradeParty2ExecutionAgentIDType(), this);
		processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentID"), String.class, getTradeParty1ExecutionAgentID(), this);
		processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, getTradeParty1ExecutionAgentIDType(), this);
		processor.processBasic(path.newSubPath("tradeParty1TransactionID"), String.class, getTradeParty1TransactionID(), this);
		processor.processBasic(path.newSubPath("versionTransaction"), String.class, getVersionTransaction(), this);
		processor.processBasic(path.newSubPath("versionPPD"), String.class, getVersionPPD(), this);
		processor.processBasic(path.newSubPath("leg1CommodityUnderlyerID"), String.class, getLeg1CommodityUnderlyerID(), this);
		processor.processBasic(path.newSubPath("leg2CommodityUnderlyerID"), String.class, getLeg2CommodityUnderlyerID(), this);
		processor.processBasic(path.newSubPath("leg1FloatingRateIndex"), String.class, getLeg1FloatingRateIndex(), this);
		processor.processBasic(path.newSubPath("leg2FloatingRateIndex"), String.class, getLeg2FloatingRateIndex(), this);
		processRosetta(path.newSubPath("underlyingAsset"), processor, UnderlyingAssetReport.class, getUnderlyingAsset());
		processRosetta(path.newSubPath("underlyingAssetName"), processor, UnderlyingAssetNameReport.class, getUnderlyingAssetName());
		processor.processBasic(path.newSubPath("settlementType"), String.class, getSettlementType(), this);
		processor.processBasic(path.newSubPath("executionVenueID"), String.class, getExecutionVenueID(), this);
		processor.processBasic(path.newSubPath("executionVenueIDType"), PartyIdentifierTypeEnum.class, getExecutionVenueIDType(), this);
		processor.processBasic(path.newSubPath("productGrade"), String.class, getProductGrade(), this);
		processor.processBasic(path.newSubPath("deliveryLocation"), String.class, getDeliveryLocation(), this);
		processor.processBasic(path.newSubPath("leg1SettlementPeriod"), String.class, getLeg1SettlementPeriod(), this);
		processor.processBasic(path.newSubPath("loadType"), String.class, getLoadType(), this);
		processor.processBasic(path.newSubPath("tradeParty1BrokerIDType"), PartyIdentifierTypeEnum.class, getTradeParty1BrokerIDType(), this);
		processor.processBasic(path.newSubPath("leg1CommodityInstrumentID"), String.class, getLeg1CommodityInstrumentID(), this);
		processor.processBasic(path.newSubPath("leg2CommodityInstrumentID"), String.class, getLeg2CommodityInstrumentID(), this);
		processor.processBasic(path.newSubPath("responsibleDataSubmitterIDType"), PartyIdentifierTypeEnum.class, getResponsibleDataSubmitterIDType(), this);
		processor.processBasic(path.newSubPath("responsibleDataSubmitterID"), String.class, getResponsibleDataSubmitterID(), this);
		processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
		processor.processBasic(path.newSubPath("corporateActionNewTradeParty1Lei"), String.class, getCorporateActionNewTradeParty1Lei(), this);
		processor.processBasic(path.newSubPath("otherPaymentPayerIDType"), String.class, getOtherPaymentPayerIDType(), this);
		processor.processBasic(path.newSubPath("otherPaymentReceiverIDType"), String.class, getOtherPaymentReceiverIDType(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface DTCCAdditionalFieldsBuilder extends DTCCAdditionalFields, RosettaModelObjectBuilder {
		UnderlyingAssetReport.UnderlyingAssetReportBuilder getOrCreateUnderlyingAsset(int _index);
		@Override
		List<? extends UnderlyingAssetReport.UnderlyingAssetReportBuilder> getUnderlyingAsset();
		UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder getOrCreateUnderlyingAssetName();
		@Override
		UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder getUnderlyingAssetName();
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setClearingVenueIDType(PartyIdentifierTypeEnum clearingVenueIDType);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setTradeParty1ClearingBrokerIDType(PartyIdentifierTypeEnum tradeParty1ClearingBrokerIDType);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setTradeParty1IDType(PartyIdentifierTypeEnum tradeParty1IDType);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setSubmittingPartyIDType(PartyIdentifierTypeEnum submittingPartyIDType);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setAllocationType(String allocationType);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setUsiID(String usiID);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setUsiIDPrefix(String usiIDPrefix);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setNewSDRIdentifier(String newSDRIdentifier);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setSubmittedForParty(String submittedForParty);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setTradeLegTypes(String tradeLegTypes);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum tradeParty1ReportingDestination);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum tradeParty1ReportingDestination, int _idx);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(List<SupervisoryBodyEnum> tradeParty1ReportingDestination);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setTradeParty1ReportingDestination(List<SupervisoryBodyEnum> tradeParty1ReportingDestination);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum tradeParty2ReportingDestination);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum tradeParty2ReportingDestination, int _idx);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(List<SupervisoryBodyEnum> tradeParty2ReportingDestination);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setTradeParty2ReportingDestination(List<SupervisoryBodyEnum> tradeParty2ReportingDestination);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setPrimaryAssetClass(AssetClassEnum primaryAssetClass);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setSecondaryAssetClass(AssetClassEnum secondaryAssetClass);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setComment1(String comment1);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setMessageID(String messageID);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setMessageTypeTransaction(String messageTypeTransaction);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setMessageTypePPD(String messageTypePPD);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setOptionStyle(OptionStyleEnum optionStyle);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setOptionType(String optionType);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setProductID(String productID);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setTradeParty2ExecutionAgentID(String tradeParty2ExecutionAgentID);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setTradeParty2ExecutionAgentIDType(PartyIdentifierTypeEnum tradeParty2ExecutionAgentIDType);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setTradeParty1ExecutionAgentID(String tradeParty1ExecutionAgentID);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setTradeParty1ExecutionAgentIDType(PartyIdentifierTypeEnum tradeParty1ExecutionAgentIDType);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setTradeParty1TransactionID(String tradeParty1TransactionID);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setVersionTransaction(String versionTransaction);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setVersionPPD(String versionPPD);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setLeg1CommodityUnderlyerID(String leg1CommodityUnderlyerID);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setLeg2CommodityUnderlyerID(String leg2CommodityUnderlyerID);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setLeg1FloatingRateIndex(String leg1FloatingRateIndex);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setLeg2FloatingRateIndex(String leg2FloatingRateIndex);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addUnderlyingAsset(UnderlyingAssetReport underlyingAsset);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addUnderlyingAsset(UnderlyingAssetReport underlyingAsset, int _idx);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addUnderlyingAsset(List<? extends UnderlyingAssetReport> underlyingAsset);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setUnderlyingAsset(List<? extends UnderlyingAssetReport> underlyingAsset);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setUnderlyingAssetName(UnderlyingAssetNameReport underlyingAssetName);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setSettlementType(String settlementType);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setExecutionVenueID(String executionVenueID);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setExecutionVenueIDType(PartyIdentifierTypeEnum executionVenueIDType);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addProductGrade(String productGrade);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addProductGrade(String productGrade, int _idx);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addProductGrade(List<String> productGrade);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setProductGrade(List<String> productGrade);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setDeliveryLocation(String deliveryLocation);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setLeg1SettlementPeriod(String leg1SettlementPeriod);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setLoadType(String loadType);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setTradeParty1BrokerIDType(PartyIdentifierTypeEnum tradeParty1BrokerIDType);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setLeg1CommodityInstrumentID(String leg1CommodityInstrumentID);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setLeg2CommodityInstrumentID(String leg2CommodityInstrumentID);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setResponsibleDataSubmitterIDType(PartyIdentifierTypeEnum responsibleDataSubmitterIDType);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setResponsibleDataSubmitterID(String responsibleDataSubmitterID);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setMaturityDateOfTheUnderlying(Date maturityDateOfTheUnderlying);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setCorporateActionNewTradeParty1Lei(String corporateActionNewTradeParty1Lei);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(String otherPaymentPayerIDType);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(String otherPaymentPayerIDType, int _idx);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(List<String> otherPaymentPayerIDType);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setOtherPaymentPayerIDType(List<String> otherPaymentPayerIDType);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(String otherPaymentReceiverIDType);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(String otherPaymentReceiverIDType, int _idx);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(List<String> otherPaymentReceiverIDType);
		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setOtherPaymentReceiverIDType(List<String> otherPaymentReceiverIDType);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("clearingVenueIDType"), PartyIdentifierTypeEnum.class, getClearingVenueIDType(), this);
			processor.processBasic(path.newSubPath("tradeParty1ClearingBrokerIDType"), PartyIdentifierTypeEnum.class, getTradeParty1ClearingBrokerIDType(), this);
			processor.processBasic(path.newSubPath("tradeParty1IDType"), PartyIdentifierTypeEnum.class, getTradeParty1IDType(), this);
			processor.processBasic(path.newSubPath("submittingPartyIDType"), PartyIdentifierTypeEnum.class, getSubmittingPartyIDType(), this);
			processor.processBasic(path.newSubPath("allocationType"), String.class, getAllocationType(), this);
			processor.processBasic(path.newSubPath("usiID"), String.class, getUsiID(), this);
			processor.processBasic(path.newSubPath("usiIDPrefix"), String.class, getUsiIDPrefix(), this);
			processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, getNewSDRIdentifier(), this);
			processor.processBasic(path.newSubPath("submittedForParty"), String.class, getSubmittedForParty(), this);
			processor.processBasic(path.newSubPath("tradeLegTypes"), String.class, getTradeLegTypes(), this);
			processor.processBasic(path.newSubPath("tradeParty1ReportingDestination"), SupervisoryBodyEnum.class, getTradeParty1ReportingDestination(), this);
			processor.processBasic(path.newSubPath("tradeParty2ReportingDestination"), SupervisoryBodyEnum.class, getTradeParty2ReportingDestination(), this);
			processor.processBasic(path.newSubPath("primaryAssetClass"), AssetClassEnum.class, getPrimaryAssetClass(), this);
			processor.processBasic(path.newSubPath("secondaryAssetClass"), AssetClassEnum.class, getSecondaryAssetClass(), this);
			processor.processBasic(path.newSubPath("comment1"), String.class, getComment1(), this);
			processor.processBasic(path.newSubPath("messageID"), String.class, getMessageID(), this);
			processor.processBasic(path.newSubPath("messageTypeTransaction"), String.class, getMessageTypeTransaction(), this);
			processor.processBasic(path.newSubPath("messageTypePPD"), String.class, getMessageTypePPD(), this);
			processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, getOptionStyle(), this);
			processor.processBasic(path.newSubPath("optionType"), String.class, getOptionType(), this);
			processor.processBasic(path.newSubPath("productID"), String.class, getProductID(), this);
			processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentID"), String.class, getTradeParty2ExecutionAgentID(), this);
			processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, getTradeParty2ExecutionAgentIDType(), this);
			processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentID"), String.class, getTradeParty1ExecutionAgentID(), this);
			processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, getTradeParty1ExecutionAgentIDType(), this);
			processor.processBasic(path.newSubPath("tradeParty1TransactionID"), String.class, getTradeParty1TransactionID(), this);
			processor.processBasic(path.newSubPath("versionTransaction"), String.class, getVersionTransaction(), this);
			processor.processBasic(path.newSubPath("versionPPD"), String.class, getVersionPPD(), this);
			processor.processBasic(path.newSubPath("leg1CommodityUnderlyerID"), String.class, getLeg1CommodityUnderlyerID(), this);
			processor.processBasic(path.newSubPath("leg2CommodityUnderlyerID"), String.class, getLeg2CommodityUnderlyerID(), this);
			processor.processBasic(path.newSubPath("leg1FloatingRateIndex"), String.class, getLeg1FloatingRateIndex(), this);
			processor.processBasic(path.newSubPath("leg2FloatingRateIndex"), String.class, getLeg2FloatingRateIndex(), this);
			processRosetta(path.newSubPath("underlyingAsset"), processor, UnderlyingAssetReport.UnderlyingAssetReportBuilder.class, getUnderlyingAsset());
			processRosetta(path.newSubPath("underlyingAssetName"), processor, UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder.class, getUnderlyingAssetName());
			processor.processBasic(path.newSubPath("settlementType"), String.class, getSettlementType(), this);
			processor.processBasic(path.newSubPath("executionVenueID"), String.class, getExecutionVenueID(), this);
			processor.processBasic(path.newSubPath("executionVenueIDType"), PartyIdentifierTypeEnum.class, getExecutionVenueIDType(), this);
			processor.processBasic(path.newSubPath("productGrade"), String.class, getProductGrade(), this);
			processor.processBasic(path.newSubPath("deliveryLocation"), String.class, getDeliveryLocation(), this);
			processor.processBasic(path.newSubPath("leg1SettlementPeriod"), String.class, getLeg1SettlementPeriod(), this);
			processor.processBasic(path.newSubPath("loadType"), String.class, getLoadType(), this);
			processor.processBasic(path.newSubPath("tradeParty1BrokerIDType"), PartyIdentifierTypeEnum.class, getTradeParty1BrokerIDType(), this);
			processor.processBasic(path.newSubPath("leg1CommodityInstrumentID"), String.class, getLeg1CommodityInstrumentID(), this);
			processor.processBasic(path.newSubPath("leg2CommodityInstrumentID"), String.class, getLeg2CommodityInstrumentID(), this);
			processor.processBasic(path.newSubPath("responsibleDataSubmitterIDType"), PartyIdentifierTypeEnum.class, getResponsibleDataSubmitterIDType(), this);
			processor.processBasic(path.newSubPath("responsibleDataSubmitterID"), String.class, getResponsibleDataSubmitterID(), this);
			processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
			processor.processBasic(path.newSubPath("corporateActionNewTradeParty1Lei"), String.class, getCorporateActionNewTradeParty1Lei(), this);
			processor.processBasic(path.newSubPath("otherPaymentPayerIDType"), String.class, getOtherPaymentPayerIDType(), this);
			processor.processBasic(path.newSubPath("otherPaymentReceiverIDType"), String.class, getOtherPaymentReceiverIDType(), this);
		}
		

		DTCCAdditionalFields.DTCCAdditionalFieldsBuilder prune();
	}

	/*********************** Immutable Implementation of DTCCAdditionalFields  ***********************/
	class DTCCAdditionalFieldsImpl implements DTCCAdditionalFields {
		private final PartyIdentifierTypeEnum clearingVenueIDType;
		private final PartyIdentifierTypeEnum tradeParty1ClearingBrokerIDType;
		private final PartyIdentifierTypeEnum tradeParty1IDType;
		private final PartyIdentifierTypeEnum submittingPartyIDType;
		private final String allocationType;
		private final String usiID;
		private final String usiIDPrefix;
		private final String newSDRIdentifier;
		private final String submittedForParty;
		private final String tradeLegTypes;
		private final List<SupervisoryBodyEnum> tradeParty1ReportingDestination;
		private final List<SupervisoryBodyEnum> tradeParty2ReportingDestination;
		private final AssetClassEnum primaryAssetClass;
		private final AssetClassEnum secondaryAssetClass;
		private final String comment1;
		private final String messageID;
		private final String messageTypeTransaction;
		private final String messageTypePPD;
		private final OptionStyleEnum optionStyle;
		private final String optionType;
		private final String productID;
		private final String tradeParty2ExecutionAgentID;
		private final PartyIdentifierTypeEnum tradeParty2ExecutionAgentIDType;
		private final String tradeParty1ExecutionAgentID;
		private final PartyIdentifierTypeEnum tradeParty1ExecutionAgentIDType;
		private final String tradeParty1TransactionID;
		private final String versionTransaction;
		private final String versionPPD;
		private final String leg1CommodityUnderlyerID;
		private final String leg2CommodityUnderlyerID;
		private final String leg1FloatingRateIndex;
		private final String leg2FloatingRateIndex;
		private final List<? extends UnderlyingAssetReport> underlyingAsset;
		private final UnderlyingAssetNameReport underlyingAssetName;
		private final String settlementType;
		private final String executionVenueID;
		private final PartyIdentifierTypeEnum executionVenueIDType;
		private final List<String> productGrade;
		private final String deliveryLocation;
		private final String leg1SettlementPeriod;
		private final String loadType;
		private final PartyIdentifierTypeEnum tradeParty1BrokerIDType;
		private final String leg1CommodityInstrumentID;
		private final String leg2CommodityInstrumentID;
		private final PartyIdentifierTypeEnum responsibleDataSubmitterIDType;
		private final String responsibleDataSubmitterID;
		private final Date maturityDateOfTheUnderlying;
		private final String corporateActionNewTradeParty1Lei;
		private final List<String> otherPaymentPayerIDType;
		private final List<String> otherPaymentReceiverIDType;
		
		protected DTCCAdditionalFieldsImpl(DTCCAdditionalFields.DTCCAdditionalFieldsBuilder builder) {
			this.clearingVenueIDType = builder.getClearingVenueIDType();
			this.tradeParty1ClearingBrokerIDType = builder.getTradeParty1ClearingBrokerIDType();
			this.tradeParty1IDType = builder.getTradeParty1IDType();
			this.submittingPartyIDType = builder.getSubmittingPartyIDType();
			this.allocationType = builder.getAllocationType();
			this.usiID = builder.getUsiID();
			this.usiIDPrefix = builder.getUsiIDPrefix();
			this.newSDRIdentifier = builder.getNewSDRIdentifier();
			this.submittedForParty = builder.getSubmittedForParty();
			this.tradeLegTypes = builder.getTradeLegTypes();
			this.tradeParty1ReportingDestination = ofNullable(builder.getTradeParty1ReportingDestination()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.tradeParty2ReportingDestination = ofNullable(builder.getTradeParty2ReportingDestination()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.primaryAssetClass = builder.getPrimaryAssetClass();
			this.secondaryAssetClass = builder.getSecondaryAssetClass();
			this.comment1 = builder.getComment1();
			this.messageID = builder.getMessageID();
			this.messageTypeTransaction = builder.getMessageTypeTransaction();
			this.messageTypePPD = builder.getMessageTypePPD();
			this.optionStyle = builder.getOptionStyle();
			this.optionType = builder.getOptionType();
			this.productID = builder.getProductID();
			this.tradeParty2ExecutionAgentID = builder.getTradeParty2ExecutionAgentID();
			this.tradeParty2ExecutionAgentIDType = builder.getTradeParty2ExecutionAgentIDType();
			this.tradeParty1ExecutionAgentID = builder.getTradeParty1ExecutionAgentID();
			this.tradeParty1ExecutionAgentIDType = builder.getTradeParty1ExecutionAgentIDType();
			this.tradeParty1TransactionID = builder.getTradeParty1TransactionID();
			this.versionTransaction = builder.getVersionTransaction();
			this.versionPPD = builder.getVersionPPD();
			this.leg1CommodityUnderlyerID = builder.getLeg1CommodityUnderlyerID();
			this.leg2CommodityUnderlyerID = builder.getLeg2CommodityUnderlyerID();
			this.leg1FloatingRateIndex = builder.getLeg1FloatingRateIndex();
			this.leg2FloatingRateIndex = builder.getLeg2FloatingRateIndex();
			this.underlyingAsset = ofNullable(builder.getUnderlyingAsset()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.underlyingAssetName = ofNullable(builder.getUnderlyingAssetName()).map(f->f.build()).orElse(null);
			this.settlementType = builder.getSettlementType();
			this.executionVenueID = builder.getExecutionVenueID();
			this.executionVenueIDType = builder.getExecutionVenueIDType();
			this.productGrade = ofNullable(builder.getProductGrade()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.deliveryLocation = builder.getDeliveryLocation();
			this.leg1SettlementPeriod = builder.getLeg1SettlementPeriod();
			this.loadType = builder.getLoadType();
			this.tradeParty1BrokerIDType = builder.getTradeParty1BrokerIDType();
			this.leg1CommodityInstrumentID = builder.getLeg1CommodityInstrumentID();
			this.leg2CommodityInstrumentID = builder.getLeg2CommodityInstrumentID();
			this.responsibleDataSubmitterIDType = builder.getResponsibleDataSubmitterIDType();
			this.responsibleDataSubmitterID = builder.getResponsibleDataSubmitterID();
			this.maturityDateOfTheUnderlying = builder.getMaturityDateOfTheUnderlying();
			this.corporateActionNewTradeParty1Lei = builder.getCorporateActionNewTradeParty1Lei();
			this.otherPaymentPayerIDType = ofNullable(builder.getOtherPaymentPayerIDType()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.otherPaymentReceiverIDType = ofNullable(builder.getOtherPaymentReceiverIDType()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
		}
		
		@Override
		@RosettaAttribute("clearingVenueIDType")
		@RuneAttribute("clearingVenueIDType")
		public PartyIdentifierTypeEnum getClearingVenueIDType() {
			return clearingVenueIDType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ClearingBrokerIDType")
		@RuneAttribute("tradeParty1ClearingBrokerIDType")
		public PartyIdentifierTypeEnum getTradeParty1ClearingBrokerIDType() {
			return tradeParty1ClearingBrokerIDType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1IDType")
		@RuneAttribute("tradeParty1IDType")
		public PartyIdentifierTypeEnum getTradeParty1IDType() {
			return tradeParty1IDType;
		}
		
		@Override
		@RosettaAttribute("submittingPartyIDType")
		@RuneAttribute("submittingPartyIDType")
		public PartyIdentifierTypeEnum getSubmittingPartyIDType() {
			return submittingPartyIDType;
		}
		
		@Override
		@RosettaAttribute("allocationType")
		@RuneAttribute("allocationType")
		public String getAllocationType() {
			return allocationType;
		}
		
		@Override
		@RosettaAttribute("usiID")
		@RuneAttribute("usiID")
		public String getUsiID() {
			return usiID;
		}
		
		@Override
		@RosettaAttribute("usiIDPrefix")
		@RuneAttribute("usiIDPrefix")
		public String getUsiIDPrefix() {
			return usiIDPrefix;
		}
		
		@Override
		@RosettaAttribute("newSDRIdentifier")
		@RuneAttribute("newSDRIdentifier")
		public String getNewSDRIdentifier() {
			return newSDRIdentifier;
		}
		
		@Override
		@RosettaAttribute("submittedForParty")
		@RuneAttribute("submittedForParty")
		public String getSubmittedForParty() {
			return submittedForParty;
		}
		
		@Override
		@RosettaAttribute("tradeLegTypes")
		@RuneAttribute("tradeLegTypes")
		public String getTradeLegTypes() {
			return tradeLegTypes;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ReportingDestination")
		@RuneAttribute("tradeParty1ReportingDestination")
		public List<SupervisoryBodyEnum> getTradeParty1ReportingDestination() {
			return tradeParty1ReportingDestination;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ReportingDestination")
		@RuneAttribute("tradeParty2ReportingDestination")
		public List<SupervisoryBodyEnum> getTradeParty2ReportingDestination() {
			return tradeParty2ReportingDestination;
		}
		
		@Override
		@RosettaAttribute("primaryAssetClass")
		@RuneAttribute("primaryAssetClass")
		public AssetClassEnum getPrimaryAssetClass() {
			return primaryAssetClass;
		}
		
		@Override
		@RosettaAttribute("secondaryAssetClass")
		@RuneAttribute("secondaryAssetClass")
		public AssetClassEnum getSecondaryAssetClass() {
			return secondaryAssetClass;
		}
		
		@Override
		@RosettaAttribute("comment1")
		@RuneAttribute("comment1")
		public String getComment1() {
			return comment1;
		}
		
		@Override
		@RosettaAttribute("messageID")
		@RuneAttribute("messageID")
		public String getMessageID() {
			return messageID;
		}
		
		@Override
		@RosettaAttribute("messageTypeTransaction")
		@RuneAttribute("messageTypeTransaction")
		public String getMessageTypeTransaction() {
			return messageTypeTransaction;
		}
		
		@Override
		@RosettaAttribute("messageTypePPD")
		@RuneAttribute("messageTypePPD")
		public String getMessageTypePPD() {
			return messageTypePPD;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public OptionStyleEnum getOptionStyle() {
			return optionStyle;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public String getOptionType() {
			return optionType;
		}
		
		@Override
		@RosettaAttribute("productID")
		@RuneAttribute("productID")
		public String getProductID() {
			return productID;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ExecutionAgentID")
		@RuneAttribute("tradeParty2ExecutionAgentID")
		public String getTradeParty2ExecutionAgentID() {
			return tradeParty2ExecutionAgentID;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ExecutionAgentIDType")
		@RuneAttribute("tradeParty2ExecutionAgentIDType")
		public PartyIdentifierTypeEnum getTradeParty2ExecutionAgentIDType() {
			return tradeParty2ExecutionAgentIDType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ExecutionAgentID")
		@RuneAttribute("tradeParty1ExecutionAgentID")
		public String getTradeParty1ExecutionAgentID() {
			return tradeParty1ExecutionAgentID;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ExecutionAgentIDType")
		@RuneAttribute("tradeParty1ExecutionAgentIDType")
		public PartyIdentifierTypeEnum getTradeParty1ExecutionAgentIDType() {
			return tradeParty1ExecutionAgentIDType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1TransactionID")
		@RuneAttribute("tradeParty1TransactionID")
		public String getTradeParty1TransactionID() {
			return tradeParty1TransactionID;
		}
		
		@Override
		@RosettaAttribute("versionTransaction")
		@RuneAttribute("versionTransaction")
		public String getVersionTransaction() {
			return versionTransaction;
		}
		
		@Override
		@RosettaAttribute("versionPPD")
		@RuneAttribute("versionPPD")
		public String getVersionPPD() {
			return versionPPD;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityUnderlyerID")
		@RuneAttribute("leg1CommodityUnderlyerID")
		public String getLeg1CommodityUnderlyerID() {
			return leg1CommodityUnderlyerID;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityUnderlyerID")
		@RuneAttribute("leg2CommodityUnderlyerID")
		public String getLeg2CommodityUnderlyerID() {
			return leg2CommodityUnderlyerID;
		}
		
		@Override
		@RosettaAttribute("leg1FloatingRateIndex")
		@RuneAttribute("leg1FloatingRateIndex")
		public String getLeg1FloatingRateIndex() {
			return leg1FloatingRateIndex;
		}
		
		@Override
		@RosettaAttribute("leg2FloatingRateIndex")
		@RuneAttribute("leg2FloatingRateIndex")
		public String getLeg2FloatingRateIndex() {
			return leg2FloatingRateIndex;
		}
		
		@Override
		@RosettaAttribute("underlyingAsset")
		@RuneAttribute("underlyingAsset")
		public List<? extends UnderlyingAssetReport> getUnderlyingAsset() {
			return underlyingAsset;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetName")
		@RuneAttribute("underlyingAssetName")
		public UnderlyingAssetNameReport getUnderlyingAssetName() {
			return underlyingAssetName;
		}
		
		@Override
		@RosettaAttribute("settlementType")
		@RuneAttribute("settlementType")
		public String getSettlementType() {
			return settlementType;
		}
		
		@Override
		@RosettaAttribute("executionVenueID")
		@RuneAttribute("executionVenueID")
		public String getExecutionVenueID() {
			return executionVenueID;
		}
		
		@Override
		@RosettaAttribute("executionVenueIDType")
		@RuneAttribute("executionVenueIDType")
		public PartyIdentifierTypeEnum getExecutionVenueIDType() {
			return executionVenueIDType;
		}
		
		@Override
		@RosettaAttribute("productGrade")
		@RuneAttribute("productGrade")
		public List<String> getProductGrade() {
			return productGrade;
		}
		
		@Override
		@RosettaAttribute("deliveryLocation")
		@RuneAttribute("deliveryLocation")
		public String getDeliveryLocation() {
			return deliveryLocation;
		}
		
		@Override
		@RosettaAttribute("leg1SettlementPeriod")
		@RuneAttribute("leg1SettlementPeriod")
		public String getLeg1SettlementPeriod() {
			return leg1SettlementPeriod;
		}
		
		@Override
		@RosettaAttribute("loadType")
		@RuneAttribute("loadType")
		public String getLoadType() {
			return loadType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1BrokerIDType")
		@RuneAttribute("tradeParty1BrokerIDType")
		public PartyIdentifierTypeEnum getTradeParty1BrokerIDType() {
			return tradeParty1BrokerIDType;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityInstrumentID")
		@RuneAttribute("leg1CommodityInstrumentID")
		public String getLeg1CommodityInstrumentID() {
			return leg1CommodityInstrumentID;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityInstrumentID")
		@RuneAttribute("leg2CommodityInstrumentID")
		public String getLeg2CommodityInstrumentID() {
			return leg2CommodityInstrumentID;
		}
		
		@Override
		@RosettaAttribute("responsibleDataSubmitterIDType")
		@RuneAttribute("responsibleDataSubmitterIDType")
		public PartyIdentifierTypeEnum getResponsibleDataSubmitterIDType() {
			return responsibleDataSubmitterIDType;
		}
		
		@Override
		@RosettaAttribute("responsibleDataSubmitterID")
		@RuneAttribute("responsibleDataSubmitterID")
		public String getResponsibleDataSubmitterID() {
			return responsibleDataSubmitterID;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		public Date getMaturityDateOfTheUnderlying() {
			return maturityDateOfTheUnderlying;
		}
		
		@Override
		@RosettaAttribute("corporateActionNewTradeParty1Lei")
		@RuneAttribute("corporateActionNewTradeParty1Lei")
		public String getCorporateActionNewTradeParty1Lei() {
			return corporateActionNewTradeParty1Lei;
		}
		
		@Override
		@RosettaAttribute("otherPaymentPayerIDType")
		@RuneAttribute("otherPaymentPayerIDType")
		public List<String> getOtherPaymentPayerIDType() {
			return otherPaymentPayerIDType;
		}
		
		@Override
		@RosettaAttribute("otherPaymentReceiverIDType")
		@RuneAttribute("otherPaymentReceiverIDType")
		public List<String> getOtherPaymentReceiverIDType() {
			return otherPaymentReceiverIDType;
		}
		
		@Override
		public DTCCAdditionalFields build() {
			return this;
		}
		
		@Override
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder toBuilder() {
			DTCCAdditionalFields.DTCCAdditionalFieldsBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(DTCCAdditionalFields.DTCCAdditionalFieldsBuilder builder) {
			ofNullable(getClearingVenueIDType()).ifPresent(builder::setClearingVenueIDType);
			ofNullable(getTradeParty1ClearingBrokerIDType()).ifPresent(builder::setTradeParty1ClearingBrokerIDType);
			ofNullable(getTradeParty1IDType()).ifPresent(builder::setTradeParty1IDType);
			ofNullable(getSubmittingPartyIDType()).ifPresent(builder::setSubmittingPartyIDType);
			ofNullable(getAllocationType()).ifPresent(builder::setAllocationType);
			ofNullable(getUsiID()).ifPresent(builder::setUsiID);
			ofNullable(getUsiIDPrefix()).ifPresent(builder::setUsiIDPrefix);
			ofNullable(getNewSDRIdentifier()).ifPresent(builder::setNewSDRIdentifier);
			ofNullable(getSubmittedForParty()).ifPresent(builder::setSubmittedForParty);
			ofNullable(getTradeLegTypes()).ifPresent(builder::setTradeLegTypes);
			ofNullable(getTradeParty1ReportingDestination()).ifPresent(builder::setTradeParty1ReportingDestination);
			ofNullable(getTradeParty2ReportingDestination()).ifPresent(builder::setTradeParty2ReportingDestination);
			ofNullable(getPrimaryAssetClass()).ifPresent(builder::setPrimaryAssetClass);
			ofNullable(getSecondaryAssetClass()).ifPresent(builder::setSecondaryAssetClass);
			ofNullable(getComment1()).ifPresent(builder::setComment1);
			ofNullable(getMessageID()).ifPresent(builder::setMessageID);
			ofNullable(getMessageTypeTransaction()).ifPresent(builder::setMessageTypeTransaction);
			ofNullable(getMessageTypePPD()).ifPresent(builder::setMessageTypePPD);
			ofNullable(getOptionStyle()).ifPresent(builder::setOptionStyle);
			ofNullable(getOptionType()).ifPresent(builder::setOptionType);
			ofNullable(getProductID()).ifPresent(builder::setProductID);
			ofNullable(getTradeParty2ExecutionAgentID()).ifPresent(builder::setTradeParty2ExecutionAgentID);
			ofNullable(getTradeParty2ExecutionAgentIDType()).ifPresent(builder::setTradeParty2ExecutionAgentIDType);
			ofNullable(getTradeParty1ExecutionAgentID()).ifPresent(builder::setTradeParty1ExecutionAgentID);
			ofNullable(getTradeParty1ExecutionAgentIDType()).ifPresent(builder::setTradeParty1ExecutionAgentIDType);
			ofNullable(getTradeParty1TransactionID()).ifPresent(builder::setTradeParty1TransactionID);
			ofNullable(getVersionTransaction()).ifPresent(builder::setVersionTransaction);
			ofNullable(getVersionPPD()).ifPresent(builder::setVersionPPD);
			ofNullable(getLeg1CommodityUnderlyerID()).ifPresent(builder::setLeg1CommodityUnderlyerID);
			ofNullable(getLeg2CommodityUnderlyerID()).ifPresent(builder::setLeg2CommodityUnderlyerID);
			ofNullable(getLeg1FloatingRateIndex()).ifPresent(builder::setLeg1FloatingRateIndex);
			ofNullable(getLeg2FloatingRateIndex()).ifPresent(builder::setLeg2FloatingRateIndex);
			ofNullable(getUnderlyingAsset()).ifPresent(builder::setUnderlyingAsset);
			ofNullable(getUnderlyingAssetName()).ifPresent(builder::setUnderlyingAssetName);
			ofNullable(getSettlementType()).ifPresent(builder::setSettlementType);
			ofNullable(getExecutionVenueID()).ifPresent(builder::setExecutionVenueID);
			ofNullable(getExecutionVenueIDType()).ifPresent(builder::setExecutionVenueIDType);
			ofNullable(getProductGrade()).ifPresent(builder::setProductGrade);
			ofNullable(getDeliveryLocation()).ifPresent(builder::setDeliveryLocation);
			ofNullable(getLeg1SettlementPeriod()).ifPresent(builder::setLeg1SettlementPeriod);
			ofNullable(getLoadType()).ifPresent(builder::setLoadType);
			ofNullable(getTradeParty1BrokerIDType()).ifPresent(builder::setTradeParty1BrokerIDType);
			ofNullable(getLeg1CommodityInstrumentID()).ifPresent(builder::setLeg1CommodityInstrumentID);
			ofNullable(getLeg2CommodityInstrumentID()).ifPresent(builder::setLeg2CommodityInstrumentID);
			ofNullable(getResponsibleDataSubmitterIDType()).ifPresent(builder::setResponsibleDataSubmitterIDType);
			ofNullable(getResponsibleDataSubmitterID()).ifPresent(builder::setResponsibleDataSubmitterID);
			ofNullable(getMaturityDateOfTheUnderlying()).ifPresent(builder::setMaturityDateOfTheUnderlying);
			ofNullable(getCorporateActionNewTradeParty1Lei()).ifPresent(builder::setCorporateActionNewTradeParty1Lei);
			ofNullable(getOtherPaymentPayerIDType()).ifPresent(builder::setOtherPaymentPayerIDType);
			ofNullable(getOtherPaymentReceiverIDType()).ifPresent(builder::setOtherPaymentReceiverIDType);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			DTCCAdditionalFields _that = getType().cast(o);
		
			if (!Objects.equals(clearingVenueIDType, _that.getClearingVenueIDType())) return false;
			if (!Objects.equals(tradeParty1ClearingBrokerIDType, _that.getTradeParty1ClearingBrokerIDType())) return false;
			if (!Objects.equals(tradeParty1IDType, _that.getTradeParty1IDType())) return false;
			if (!Objects.equals(submittingPartyIDType, _that.getSubmittingPartyIDType())) return false;
			if (!Objects.equals(allocationType, _that.getAllocationType())) return false;
			if (!Objects.equals(usiID, _that.getUsiID())) return false;
			if (!Objects.equals(usiIDPrefix, _that.getUsiIDPrefix())) return false;
			if (!Objects.equals(newSDRIdentifier, _that.getNewSDRIdentifier())) return false;
			if (!Objects.equals(submittedForParty, _that.getSubmittedForParty())) return false;
			if (!Objects.equals(tradeLegTypes, _that.getTradeLegTypes())) return false;
			if (!ListEquals.listEquals(tradeParty1ReportingDestination, _that.getTradeParty1ReportingDestination())) return false;
			if (!ListEquals.listEquals(tradeParty2ReportingDestination, _that.getTradeParty2ReportingDestination())) return false;
			if (!Objects.equals(primaryAssetClass, _that.getPrimaryAssetClass())) return false;
			if (!Objects.equals(secondaryAssetClass, _that.getSecondaryAssetClass())) return false;
			if (!Objects.equals(comment1, _that.getComment1())) return false;
			if (!Objects.equals(messageID, _that.getMessageID())) return false;
			if (!Objects.equals(messageTypeTransaction, _that.getMessageTypeTransaction())) return false;
			if (!Objects.equals(messageTypePPD, _that.getMessageTypePPD())) return false;
			if (!Objects.equals(optionStyle, _that.getOptionStyle())) return false;
			if (!Objects.equals(optionType, _that.getOptionType())) return false;
			if (!Objects.equals(productID, _that.getProductID())) return false;
			if (!Objects.equals(tradeParty2ExecutionAgentID, _that.getTradeParty2ExecutionAgentID())) return false;
			if (!Objects.equals(tradeParty2ExecutionAgentIDType, _that.getTradeParty2ExecutionAgentIDType())) return false;
			if (!Objects.equals(tradeParty1ExecutionAgentID, _that.getTradeParty1ExecutionAgentID())) return false;
			if (!Objects.equals(tradeParty1ExecutionAgentIDType, _that.getTradeParty1ExecutionAgentIDType())) return false;
			if (!Objects.equals(tradeParty1TransactionID, _that.getTradeParty1TransactionID())) return false;
			if (!Objects.equals(versionTransaction, _that.getVersionTransaction())) return false;
			if (!Objects.equals(versionPPD, _that.getVersionPPD())) return false;
			if (!Objects.equals(leg1CommodityUnderlyerID, _that.getLeg1CommodityUnderlyerID())) return false;
			if (!Objects.equals(leg2CommodityUnderlyerID, _that.getLeg2CommodityUnderlyerID())) return false;
			if (!Objects.equals(leg1FloatingRateIndex, _that.getLeg1FloatingRateIndex())) return false;
			if (!Objects.equals(leg2FloatingRateIndex, _that.getLeg2FloatingRateIndex())) return false;
			if (!ListEquals.listEquals(underlyingAsset, _that.getUnderlyingAsset())) return false;
			if (!Objects.equals(underlyingAssetName, _that.getUnderlyingAssetName())) return false;
			if (!Objects.equals(settlementType, _that.getSettlementType())) return false;
			if (!Objects.equals(executionVenueID, _that.getExecutionVenueID())) return false;
			if (!Objects.equals(executionVenueIDType, _that.getExecutionVenueIDType())) return false;
			if (!ListEquals.listEquals(productGrade, _that.getProductGrade())) return false;
			if (!Objects.equals(deliveryLocation, _that.getDeliveryLocation())) return false;
			if (!Objects.equals(leg1SettlementPeriod, _that.getLeg1SettlementPeriod())) return false;
			if (!Objects.equals(loadType, _that.getLoadType())) return false;
			if (!Objects.equals(tradeParty1BrokerIDType, _that.getTradeParty1BrokerIDType())) return false;
			if (!Objects.equals(leg1CommodityInstrumentID, _that.getLeg1CommodityInstrumentID())) return false;
			if (!Objects.equals(leg2CommodityInstrumentID, _that.getLeg2CommodityInstrumentID())) return false;
			if (!Objects.equals(responsibleDataSubmitterIDType, _that.getResponsibleDataSubmitterIDType())) return false;
			if (!Objects.equals(responsibleDataSubmitterID, _that.getResponsibleDataSubmitterID())) return false;
			if (!Objects.equals(maturityDateOfTheUnderlying, _that.getMaturityDateOfTheUnderlying())) return false;
			if (!Objects.equals(corporateActionNewTradeParty1Lei, _that.getCorporateActionNewTradeParty1Lei())) return false;
			if (!ListEquals.listEquals(otherPaymentPayerIDType, _that.getOtherPaymentPayerIDType())) return false;
			if (!ListEquals.listEquals(otherPaymentReceiverIDType, _that.getOtherPaymentReceiverIDType())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (clearingVenueIDType != null ? clearingVenueIDType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (tradeParty1ClearingBrokerIDType != null ? tradeParty1ClearingBrokerIDType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (tradeParty1IDType != null ? tradeParty1IDType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (submittingPartyIDType != null ? submittingPartyIDType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (allocationType != null ? allocationType.hashCode() : 0);
			_result = 31 * _result + (usiID != null ? usiID.hashCode() : 0);
			_result = 31 * _result + (usiIDPrefix != null ? usiIDPrefix.hashCode() : 0);
			_result = 31 * _result + (newSDRIdentifier != null ? newSDRIdentifier.hashCode() : 0);
			_result = 31 * _result + (submittedForParty != null ? submittedForParty.hashCode() : 0);
			_result = 31 * _result + (tradeLegTypes != null ? tradeLegTypes.hashCode() : 0);
			_result = 31 * _result + (tradeParty1ReportingDestination != null ? tradeParty1ReportingDestination.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
			_result = 31 * _result + (tradeParty2ReportingDestination != null ? tradeParty2ReportingDestination.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
			_result = 31 * _result + (primaryAssetClass != null ? primaryAssetClass.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (secondaryAssetClass != null ? secondaryAssetClass.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (comment1 != null ? comment1.hashCode() : 0);
			_result = 31 * _result + (messageID != null ? messageID.hashCode() : 0);
			_result = 31 * _result + (messageTypeTransaction != null ? messageTypeTransaction.hashCode() : 0);
			_result = 31 * _result + (messageTypePPD != null ? messageTypePPD.hashCode() : 0);
			_result = 31 * _result + (optionStyle != null ? optionStyle.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (optionType != null ? optionType.hashCode() : 0);
			_result = 31 * _result + (productID != null ? productID.hashCode() : 0);
			_result = 31 * _result + (tradeParty2ExecutionAgentID != null ? tradeParty2ExecutionAgentID.hashCode() : 0);
			_result = 31 * _result + (tradeParty2ExecutionAgentIDType != null ? tradeParty2ExecutionAgentIDType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (tradeParty1ExecutionAgentID != null ? tradeParty1ExecutionAgentID.hashCode() : 0);
			_result = 31 * _result + (tradeParty1ExecutionAgentIDType != null ? tradeParty1ExecutionAgentIDType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (tradeParty1TransactionID != null ? tradeParty1TransactionID.hashCode() : 0);
			_result = 31 * _result + (versionTransaction != null ? versionTransaction.hashCode() : 0);
			_result = 31 * _result + (versionPPD != null ? versionPPD.hashCode() : 0);
			_result = 31 * _result + (leg1CommodityUnderlyerID != null ? leg1CommodityUnderlyerID.hashCode() : 0);
			_result = 31 * _result + (leg2CommodityUnderlyerID != null ? leg2CommodityUnderlyerID.hashCode() : 0);
			_result = 31 * _result + (leg1FloatingRateIndex != null ? leg1FloatingRateIndex.hashCode() : 0);
			_result = 31 * _result + (leg2FloatingRateIndex != null ? leg2FloatingRateIndex.hashCode() : 0);
			_result = 31 * _result + (underlyingAsset != null ? underlyingAsset.hashCode() : 0);
			_result = 31 * _result + (underlyingAssetName != null ? underlyingAssetName.hashCode() : 0);
			_result = 31 * _result + (settlementType != null ? settlementType.hashCode() : 0);
			_result = 31 * _result + (executionVenueID != null ? executionVenueID.hashCode() : 0);
			_result = 31 * _result + (executionVenueIDType != null ? executionVenueIDType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (productGrade != null ? productGrade.hashCode() : 0);
			_result = 31 * _result + (deliveryLocation != null ? deliveryLocation.hashCode() : 0);
			_result = 31 * _result + (leg1SettlementPeriod != null ? leg1SettlementPeriod.hashCode() : 0);
			_result = 31 * _result + (loadType != null ? loadType.hashCode() : 0);
			_result = 31 * _result + (tradeParty1BrokerIDType != null ? tradeParty1BrokerIDType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (leg1CommodityInstrumentID != null ? leg1CommodityInstrumentID.hashCode() : 0);
			_result = 31 * _result + (leg2CommodityInstrumentID != null ? leg2CommodityInstrumentID.hashCode() : 0);
			_result = 31 * _result + (responsibleDataSubmitterIDType != null ? responsibleDataSubmitterIDType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (responsibleDataSubmitterID != null ? responsibleDataSubmitterID.hashCode() : 0);
			_result = 31 * _result + (maturityDateOfTheUnderlying != null ? maturityDateOfTheUnderlying.hashCode() : 0);
			_result = 31 * _result + (corporateActionNewTradeParty1Lei != null ? corporateActionNewTradeParty1Lei.hashCode() : 0);
			_result = 31 * _result + (otherPaymentPayerIDType != null ? otherPaymentPayerIDType.hashCode() : 0);
			_result = 31 * _result + (otherPaymentReceiverIDType != null ? otherPaymentReceiverIDType.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "DTCCAdditionalFields {" +
				"clearingVenueIDType=" + this.clearingVenueIDType + ", " +
				"tradeParty1ClearingBrokerIDType=" + this.tradeParty1ClearingBrokerIDType + ", " +
				"tradeParty1IDType=" + this.tradeParty1IDType + ", " +
				"submittingPartyIDType=" + this.submittingPartyIDType + ", " +
				"allocationType=" + this.allocationType + ", " +
				"usiID=" + this.usiID + ", " +
				"usiIDPrefix=" + this.usiIDPrefix + ", " +
				"newSDRIdentifier=" + this.newSDRIdentifier + ", " +
				"submittedForParty=" + this.submittedForParty + ", " +
				"tradeLegTypes=" + this.tradeLegTypes + ", " +
				"tradeParty1ReportingDestination=" + this.tradeParty1ReportingDestination + ", " +
				"tradeParty2ReportingDestination=" + this.tradeParty2ReportingDestination + ", " +
				"primaryAssetClass=" + this.primaryAssetClass + ", " +
				"secondaryAssetClass=" + this.secondaryAssetClass + ", " +
				"comment1=" + this.comment1 + ", " +
				"messageID=" + this.messageID + ", " +
				"messageTypeTransaction=" + this.messageTypeTransaction + ", " +
				"messageTypePPD=" + this.messageTypePPD + ", " +
				"optionStyle=" + this.optionStyle + ", " +
				"optionType=" + this.optionType + ", " +
				"productID=" + this.productID + ", " +
				"tradeParty2ExecutionAgentID=" + this.tradeParty2ExecutionAgentID + ", " +
				"tradeParty2ExecutionAgentIDType=" + this.tradeParty2ExecutionAgentIDType + ", " +
				"tradeParty1ExecutionAgentID=" + this.tradeParty1ExecutionAgentID + ", " +
				"tradeParty1ExecutionAgentIDType=" + this.tradeParty1ExecutionAgentIDType + ", " +
				"tradeParty1TransactionID=" + this.tradeParty1TransactionID + ", " +
				"versionTransaction=" + this.versionTransaction + ", " +
				"versionPPD=" + this.versionPPD + ", " +
				"leg1CommodityUnderlyerID=" + this.leg1CommodityUnderlyerID + ", " +
				"leg2CommodityUnderlyerID=" + this.leg2CommodityUnderlyerID + ", " +
				"leg1FloatingRateIndex=" + this.leg1FloatingRateIndex + ", " +
				"leg2FloatingRateIndex=" + this.leg2FloatingRateIndex + ", " +
				"underlyingAsset=" + this.underlyingAsset + ", " +
				"underlyingAssetName=" + this.underlyingAssetName + ", " +
				"settlementType=" + this.settlementType + ", " +
				"executionVenueID=" + this.executionVenueID + ", " +
				"executionVenueIDType=" + this.executionVenueIDType + ", " +
				"productGrade=" + this.productGrade + ", " +
				"deliveryLocation=" + this.deliveryLocation + ", " +
				"leg1SettlementPeriod=" + this.leg1SettlementPeriod + ", " +
				"loadType=" + this.loadType + ", " +
				"tradeParty1BrokerIDType=" + this.tradeParty1BrokerIDType + ", " +
				"leg1CommodityInstrumentID=" + this.leg1CommodityInstrumentID + ", " +
				"leg2CommodityInstrumentID=" + this.leg2CommodityInstrumentID + ", " +
				"responsibleDataSubmitterIDType=" + this.responsibleDataSubmitterIDType + ", " +
				"responsibleDataSubmitterID=" + this.responsibleDataSubmitterID + ", " +
				"maturityDateOfTheUnderlying=" + this.maturityDateOfTheUnderlying + ", " +
				"corporateActionNewTradeParty1Lei=" + this.corporateActionNewTradeParty1Lei + ", " +
				"otherPaymentPayerIDType=" + this.otherPaymentPayerIDType + ", " +
				"otherPaymentReceiverIDType=" + this.otherPaymentReceiverIDType +
			'}';
		}
	}

	/*********************** Builder Implementation of DTCCAdditionalFields  ***********************/
	class DTCCAdditionalFieldsBuilderImpl implements DTCCAdditionalFields.DTCCAdditionalFieldsBuilder {
	
		protected PartyIdentifierTypeEnum clearingVenueIDType;
		protected PartyIdentifierTypeEnum tradeParty1ClearingBrokerIDType;
		protected PartyIdentifierTypeEnum tradeParty1IDType;
		protected PartyIdentifierTypeEnum submittingPartyIDType;
		protected String allocationType;
		protected String usiID;
		protected String usiIDPrefix;
		protected String newSDRIdentifier;
		protected String submittedForParty;
		protected String tradeLegTypes;
		protected List<SupervisoryBodyEnum> tradeParty1ReportingDestination = new ArrayList<>();
		protected List<SupervisoryBodyEnum> tradeParty2ReportingDestination = new ArrayList<>();
		protected AssetClassEnum primaryAssetClass;
		protected AssetClassEnum secondaryAssetClass;
		protected String comment1;
		protected String messageID;
		protected String messageTypeTransaction;
		protected String messageTypePPD;
		protected OptionStyleEnum optionStyle;
		protected String optionType;
		protected String productID;
		protected String tradeParty2ExecutionAgentID;
		protected PartyIdentifierTypeEnum tradeParty2ExecutionAgentIDType;
		protected String tradeParty1ExecutionAgentID;
		protected PartyIdentifierTypeEnum tradeParty1ExecutionAgentIDType;
		protected String tradeParty1TransactionID;
		protected String versionTransaction;
		protected String versionPPD;
		protected String leg1CommodityUnderlyerID;
		protected String leg2CommodityUnderlyerID;
		protected String leg1FloatingRateIndex;
		protected String leg2FloatingRateIndex;
		protected List<UnderlyingAssetReport.UnderlyingAssetReportBuilder> underlyingAsset = new ArrayList<>();
		protected UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder underlyingAssetName;
		protected String settlementType;
		protected String executionVenueID;
		protected PartyIdentifierTypeEnum executionVenueIDType;
		protected List<String> productGrade = new ArrayList<>();
		protected String deliveryLocation;
		protected String leg1SettlementPeriod;
		protected String loadType;
		protected PartyIdentifierTypeEnum tradeParty1BrokerIDType;
		protected String leg1CommodityInstrumentID;
		protected String leg2CommodityInstrumentID;
		protected PartyIdentifierTypeEnum responsibleDataSubmitterIDType;
		protected String responsibleDataSubmitterID;
		protected Date maturityDateOfTheUnderlying;
		protected String corporateActionNewTradeParty1Lei;
		protected List<String> otherPaymentPayerIDType = new ArrayList<>();
		protected List<String> otherPaymentReceiverIDType = new ArrayList<>();
		
		@Override
		@RosettaAttribute("clearingVenueIDType")
		@RuneAttribute("clearingVenueIDType")
		public PartyIdentifierTypeEnum getClearingVenueIDType() {
			return clearingVenueIDType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ClearingBrokerIDType")
		@RuneAttribute("tradeParty1ClearingBrokerIDType")
		public PartyIdentifierTypeEnum getTradeParty1ClearingBrokerIDType() {
			return tradeParty1ClearingBrokerIDType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1IDType")
		@RuneAttribute("tradeParty1IDType")
		public PartyIdentifierTypeEnum getTradeParty1IDType() {
			return tradeParty1IDType;
		}
		
		@Override
		@RosettaAttribute("submittingPartyIDType")
		@RuneAttribute("submittingPartyIDType")
		public PartyIdentifierTypeEnum getSubmittingPartyIDType() {
			return submittingPartyIDType;
		}
		
		@Override
		@RosettaAttribute("allocationType")
		@RuneAttribute("allocationType")
		public String getAllocationType() {
			return allocationType;
		}
		
		@Override
		@RosettaAttribute("usiID")
		@RuneAttribute("usiID")
		public String getUsiID() {
			return usiID;
		}
		
		@Override
		@RosettaAttribute("usiIDPrefix")
		@RuneAttribute("usiIDPrefix")
		public String getUsiIDPrefix() {
			return usiIDPrefix;
		}
		
		@Override
		@RosettaAttribute("newSDRIdentifier")
		@RuneAttribute("newSDRIdentifier")
		public String getNewSDRIdentifier() {
			return newSDRIdentifier;
		}
		
		@Override
		@RosettaAttribute("submittedForParty")
		@RuneAttribute("submittedForParty")
		public String getSubmittedForParty() {
			return submittedForParty;
		}
		
		@Override
		@RosettaAttribute("tradeLegTypes")
		@RuneAttribute("tradeLegTypes")
		public String getTradeLegTypes() {
			return tradeLegTypes;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ReportingDestination")
		@RuneAttribute("tradeParty1ReportingDestination")
		public List<SupervisoryBodyEnum> getTradeParty1ReportingDestination() {
			return tradeParty1ReportingDestination;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ReportingDestination")
		@RuneAttribute("tradeParty2ReportingDestination")
		public List<SupervisoryBodyEnum> getTradeParty2ReportingDestination() {
			return tradeParty2ReportingDestination;
		}
		
		@Override
		@RosettaAttribute("primaryAssetClass")
		@RuneAttribute("primaryAssetClass")
		public AssetClassEnum getPrimaryAssetClass() {
			return primaryAssetClass;
		}
		
		@Override
		@RosettaAttribute("secondaryAssetClass")
		@RuneAttribute("secondaryAssetClass")
		public AssetClassEnum getSecondaryAssetClass() {
			return secondaryAssetClass;
		}
		
		@Override
		@RosettaAttribute("comment1")
		@RuneAttribute("comment1")
		public String getComment1() {
			return comment1;
		}
		
		@Override
		@RosettaAttribute("messageID")
		@RuneAttribute("messageID")
		public String getMessageID() {
			return messageID;
		}
		
		@Override
		@RosettaAttribute("messageTypeTransaction")
		@RuneAttribute("messageTypeTransaction")
		public String getMessageTypeTransaction() {
			return messageTypeTransaction;
		}
		
		@Override
		@RosettaAttribute("messageTypePPD")
		@RuneAttribute("messageTypePPD")
		public String getMessageTypePPD() {
			return messageTypePPD;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public OptionStyleEnum getOptionStyle() {
			return optionStyle;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public String getOptionType() {
			return optionType;
		}
		
		@Override
		@RosettaAttribute("productID")
		@RuneAttribute("productID")
		public String getProductID() {
			return productID;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ExecutionAgentID")
		@RuneAttribute("tradeParty2ExecutionAgentID")
		public String getTradeParty2ExecutionAgentID() {
			return tradeParty2ExecutionAgentID;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ExecutionAgentIDType")
		@RuneAttribute("tradeParty2ExecutionAgentIDType")
		public PartyIdentifierTypeEnum getTradeParty2ExecutionAgentIDType() {
			return tradeParty2ExecutionAgentIDType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ExecutionAgentID")
		@RuneAttribute("tradeParty1ExecutionAgentID")
		public String getTradeParty1ExecutionAgentID() {
			return tradeParty1ExecutionAgentID;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ExecutionAgentIDType")
		@RuneAttribute("tradeParty1ExecutionAgentIDType")
		public PartyIdentifierTypeEnum getTradeParty1ExecutionAgentIDType() {
			return tradeParty1ExecutionAgentIDType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1TransactionID")
		@RuneAttribute("tradeParty1TransactionID")
		public String getTradeParty1TransactionID() {
			return tradeParty1TransactionID;
		}
		
		@Override
		@RosettaAttribute("versionTransaction")
		@RuneAttribute("versionTransaction")
		public String getVersionTransaction() {
			return versionTransaction;
		}
		
		@Override
		@RosettaAttribute("versionPPD")
		@RuneAttribute("versionPPD")
		public String getVersionPPD() {
			return versionPPD;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityUnderlyerID")
		@RuneAttribute("leg1CommodityUnderlyerID")
		public String getLeg1CommodityUnderlyerID() {
			return leg1CommodityUnderlyerID;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityUnderlyerID")
		@RuneAttribute("leg2CommodityUnderlyerID")
		public String getLeg2CommodityUnderlyerID() {
			return leg2CommodityUnderlyerID;
		}
		
		@Override
		@RosettaAttribute("leg1FloatingRateIndex")
		@RuneAttribute("leg1FloatingRateIndex")
		public String getLeg1FloatingRateIndex() {
			return leg1FloatingRateIndex;
		}
		
		@Override
		@RosettaAttribute("leg2FloatingRateIndex")
		@RuneAttribute("leg2FloatingRateIndex")
		public String getLeg2FloatingRateIndex() {
			return leg2FloatingRateIndex;
		}
		
		@Override
		@RosettaAttribute("underlyingAsset")
		@RuneAttribute("underlyingAsset")
		public List<? extends UnderlyingAssetReport.UnderlyingAssetReportBuilder> getUnderlyingAsset() {
			return underlyingAsset;
		}
		
		@Override
		public UnderlyingAssetReport.UnderlyingAssetReportBuilder getOrCreateUnderlyingAsset(int _index) {
		
			if (underlyingAsset==null) {
				this.underlyingAsset = new ArrayList<>();
			}
			UnderlyingAssetReport.UnderlyingAssetReportBuilder result;
			return getIndex(underlyingAsset, _index, () -> {
						UnderlyingAssetReport.UnderlyingAssetReportBuilder newUnderlyingAsset = UnderlyingAssetReport.builder();
						return newUnderlyingAsset;
					});
		}
		
		@Override
		@RosettaAttribute("underlyingAssetName")
		@RuneAttribute("underlyingAssetName")
		public UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder getUnderlyingAssetName() {
			return underlyingAssetName;
		}
		
		@Override
		public UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder getOrCreateUnderlyingAssetName() {
			UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder result;
			if (underlyingAssetName!=null) {
				result = underlyingAssetName;
			}
			else {
				result = underlyingAssetName = UnderlyingAssetNameReport.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("settlementType")
		@RuneAttribute("settlementType")
		public String getSettlementType() {
			return settlementType;
		}
		
		@Override
		@RosettaAttribute("executionVenueID")
		@RuneAttribute("executionVenueID")
		public String getExecutionVenueID() {
			return executionVenueID;
		}
		
		@Override
		@RosettaAttribute("executionVenueIDType")
		@RuneAttribute("executionVenueIDType")
		public PartyIdentifierTypeEnum getExecutionVenueIDType() {
			return executionVenueIDType;
		}
		
		@Override
		@RosettaAttribute("productGrade")
		@RuneAttribute("productGrade")
		public List<String> getProductGrade() {
			return productGrade;
		}
		
		@Override
		@RosettaAttribute("deliveryLocation")
		@RuneAttribute("deliveryLocation")
		public String getDeliveryLocation() {
			return deliveryLocation;
		}
		
		@Override
		@RosettaAttribute("leg1SettlementPeriod")
		@RuneAttribute("leg1SettlementPeriod")
		public String getLeg1SettlementPeriod() {
			return leg1SettlementPeriod;
		}
		
		@Override
		@RosettaAttribute("loadType")
		@RuneAttribute("loadType")
		public String getLoadType() {
			return loadType;
		}
		
		@Override
		@RosettaAttribute("tradeParty1BrokerIDType")
		@RuneAttribute("tradeParty1BrokerIDType")
		public PartyIdentifierTypeEnum getTradeParty1BrokerIDType() {
			return tradeParty1BrokerIDType;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityInstrumentID")
		@RuneAttribute("leg1CommodityInstrumentID")
		public String getLeg1CommodityInstrumentID() {
			return leg1CommodityInstrumentID;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityInstrumentID")
		@RuneAttribute("leg2CommodityInstrumentID")
		public String getLeg2CommodityInstrumentID() {
			return leg2CommodityInstrumentID;
		}
		
		@Override
		@RosettaAttribute("responsibleDataSubmitterIDType")
		@RuneAttribute("responsibleDataSubmitterIDType")
		public PartyIdentifierTypeEnum getResponsibleDataSubmitterIDType() {
			return responsibleDataSubmitterIDType;
		}
		
		@Override
		@RosettaAttribute("responsibleDataSubmitterID")
		@RuneAttribute("responsibleDataSubmitterID")
		public String getResponsibleDataSubmitterID() {
			return responsibleDataSubmitterID;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		public Date getMaturityDateOfTheUnderlying() {
			return maturityDateOfTheUnderlying;
		}
		
		@Override
		@RosettaAttribute("corporateActionNewTradeParty1Lei")
		@RuneAttribute("corporateActionNewTradeParty1Lei")
		public String getCorporateActionNewTradeParty1Lei() {
			return corporateActionNewTradeParty1Lei;
		}
		
		@Override
		@RosettaAttribute("otherPaymentPayerIDType")
		@RuneAttribute("otherPaymentPayerIDType")
		public List<String> getOtherPaymentPayerIDType() {
			return otherPaymentPayerIDType;
		}
		
		@Override
		@RosettaAttribute("otherPaymentReceiverIDType")
		@RuneAttribute("otherPaymentReceiverIDType")
		public List<String> getOtherPaymentReceiverIDType() {
			return otherPaymentReceiverIDType;
		}
		
		@Override
		@RosettaAttribute("clearingVenueIDType")
		@RuneAttribute("clearingVenueIDType")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setClearingVenueIDType(PartyIdentifierTypeEnum _clearingVenueIDType) {
			this.clearingVenueIDType = _clearingVenueIDType == null ? null : _clearingVenueIDType;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ClearingBrokerIDType")
		@RuneAttribute("tradeParty1ClearingBrokerIDType")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setTradeParty1ClearingBrokerIDType(PartyIdentifierTypeEnum _tradeParty1ClearingBrokerIDType) {
			this.tradeParty1ClearingBrokerIDType = _tradeParty1ClearingBrokerIDType == null ? null : _tradeParty1ClearingBrokerIDType;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1IDType")
		@RuneAttribute("tradeParty1IDType")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setTradeParty1IDType(PartyIdentifierTypeEnum _tradeParty1IDType) {
			this.tradeParty1IDType = _tradeParty1IDType == null ? null : _tradeParty1IDType;
			return this;
		}
		
		@Override
		@RosettaAttribute("submittingPartyIDType")
		@RuneAttribute("submittingPartyIDType")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setSubmittingPartyIDType(PartyIdentifierTypeEnum _submittingPartyIDType) {
			this.submittingPartyIDType = _submittingPartyIDType == null ? null : _submittingPartyIDType;
			return this;
		}
		
		@Override
		@RosettaAttribute("allocationType")
		@RuneAttribute("allocationType")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setAllocationType(String _allocationType) {
			this.allocationType = _allocationType == null ? null : _allocationType;
			return this;
		}
		
		@Override
		@RosettaAttribute("usiID")
		@RuneAttribute("usiID")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setUsiID(String _usiID) {
			this.usiID = _usiID == null ? null : _usiID;
			return this;
		}
		
		@Override
		@RosettaAttribute("usiIDPrefix")
		@RuneAttribute("usiIDPrefix")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setUsiIDPrefix(String _usiIDPrefix) {
			this.usiIDPrefix = _usiIDPrefix == null ? null : _usiIDPrefix;
			return this;
		}
		
		@Override
		@RosettaAttribute("newSDRIdentifier")
		@RuneAttribute("newSDRIdentifier")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setNewSDRIdentifier(String _newSDRIdentifier) {
			this.newSDRIdentifier = _newSDRIdentifier == null ? null : _newSDRIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("submittedForParty")
		@RuneAttribute("submittedForParty")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setSubmittedForParty(String _submittedForParty) {
			this.submittedForParty = _submittedForParty == null ? null : _submittedForParty;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeLegTypes")
		@RuneAttribute("tradeLegTypes")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setTradeLegTypes(String _tradeLegTypes) {
			this.tradeLegTypes = _tradeLegTypes == null ? null : _tradeLegTypes;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ReportingDestination")
		@RuneAttribute("tradeParty1ReportingDestination")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum _tradeParty1ReportingDestination) {
			if (_tradeParty1ReportingDestination != null) {
				this.tradeParty1ReportingDestination.add(_tradeParty1ReportingDestination);
			}
			return this;
		}
		
		@Override
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum _tradeParty1ReportingDestination, int _idx) {
			getIndex(this.tradeParty1ReportingDestination, _idx, () -> _tradeParty1ReportingDestination);
			return this;
		}
		
		@Override 
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(List<SupervisoryBodyEnum> tradeParty1ReportingDestinations) {
			if (tradeParty1ReportingDestinations != null) {
				for (final SupervisoryBodyEnum toAdd : tradeParty1ReportingDestinations) {
					this.tradeParty1ReportingDestination.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("tradeParty1ReportingDestination")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setTradeParty1ReportingDestination(List<SupervisoryBodyEnum> tradeParty1ReportingDestinations) {
			if (tradeParty1ReportingDestinations == null) {
				this.tradeParty1ReportingDestination = new ArrayList<>();
			} else {
				this.tradeParty1ReportingDestination = tradeParty1ReportingDestinations.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ReportingDestination")
		@RuneAttribute("tradeParty2ReportingDestination")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum _tradeParty2ReportingDestination) {
			if (_tradeParty2ReportingDestination != null) {
				this.tradeParty2ReportingDestination.add(_tradeParty2ReportingDestination);
			}
			return this;
		}
		
		@Override
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum _tradeParty2ReportingDestination, int _idx) {
			getIndex(this.tradeParty2ReportingDestination, _idx, () -> _tradeParty2ReportingDestination);
			return this;
		}
		
		@Override 
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(List<SupervisoryBodyEnum> tradeParty2ReportingDestinations) {
			if (tradeParty2ReportingDestinations != null) {
				for (final SupervisoryBodyEnum toAdd : tradeParty2ReportingDestinations) {
					this.tradeParty2ReportingDestination.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("tradeParty2ReportingDestination")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setTradeParty2ReportingDestination(List<SupervisoryBodyEnum> tradeParty2ReportingDestinations) {
			if (tradeParty2ReportingDestinations == null) {
				this.tradeParty2ReportingDestination = new ArrayList<>();
			} else {
				this.tradeParty2ReportingDestination = tradeParty2ReportingDestinations.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("primaryAssetClass")
		@RuneAttribute("primaryAssetClass")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setPrimaryAssetClass(AssetClassEnum _primaryAssetClass) {
			this.primaryAssetClass = _primaryAssetClass == null ? null : _primaryAssetClass;
			return this;
		}
		
		@Override
		@RosettaAttribute("secondaryAssetClass")
		@RuneAttribute("secondaryAssetClass")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setSecondaryAssetClass(AssetClassEnum _secondaryAssetClass) {
			this.secondaryAssetClass = _secondaryAssetClass == null ? null : _secondaryAssetClass;
			return this;
		}
		
		@Override
		@RosettaAttribute("comment1")
		@RuneAttribute("comment1")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setComment1(String _comment1) {
			this.comment1 = _comment1 == null ? null : _comment1;
			return this;
		}
		
		@Override
		@RosettaAttribute("messageID")
		@RuneAttribute("messageID")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setMessageID(String _messageID) {
			this.messageID = _messageID == null ? null : _messageID;
			return this;
		}
		
		@Override
		@RosettaAttribute("messageTypeTransaction")
		@RuneAttribute("messageTypeTransaction")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setMessageTypeTransaction(String _messageTypeTransaction) {
			this.messageTypeTransaction = _messageTypeTransaction == null ? null : _messageTypeTransaction;
			return this;
		}
		
		@Override
		@RosettaAttribute("messageTypePPD")
		@RuneAttribute("messageTypePPD")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setMessageTypePPD(String _messageTypePPD) {
			this.messageTypePPD = _messageTypePPD == null ? null : _messageTypePPD;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setOptionStyle(OptionStyleEnum _optionStyle) {
			this.optionStyle = _optionStyle == null ? null : _optionStyle;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setOptionType(String _optionType) {
			this.optionType = _optionType == null ? null : _optionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("productID")
		@RuneAttribute("productID")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setProductID(String _productID) {
			this.productID = _productID == null ? null : _productID;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ExecutionAgentID")
		@RuneAttribute("tradeParty2ExecutionAgentID")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setTradeParty2ExecutionAgentID(String _tradeParty2ExecutionAgentID) {
			this.tradeParty2ExecutionAgentID = _tradeParty2ExecutionAgentID == null ? null : _tradeParty2ExecutionAgentID;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty2ExecutionAgentIDType")
		@RuneAttribute("tradeParty2ExecutionAgentIDType")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setTradeParty2ExecutionAgentIDType(PartyIdentifierTypeEnum _tradeParty2ExecutionAgentIDType) {
			this.tradeParty2ExecutionAgentIDType = _tradeParty2ExecutionAgentIDType == null ? null : _tradeParty2ExecutionAgentIDType;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ExecutionAgentID")
		@RuneAttribute("tradeParty1ExecutionAgentID")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setTradeParty1ExecutionAgentID(String _tradeParty1ExecutionAgentID) {
			this.tradeParty1ExecutionAgentID = _tradeParty1ExecutionAgentID == null ? null : _tradeParty1ExecutionAgentID;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1ExecutionAgentIDType")
		@RuneAttribute("tradeParty1ExecutionAgentIDType")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setTradeParty1ExecutionAgentIDType(PartyIdentifierTypeEnum _tradeParty1ExecutionAgentIDType) {
			this.tradeParty1ExecutionAgentIDType = _tradeParty1ExecutionAgentIDType == null ? null : _tradeParty1ExecutionAgentIDType;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1TransactionID")
		@RuneAttribute("tradeParty1TransactionID")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setTradeParty1TransactionID(String _tradeParty1TransactionID) {
			this.tradeParty1TransactionID = _tradeParty1TransactionID == null ? null : _tradeParty1TransactionID;
			return this;
		}
		
		@Override
		@RosettaAttribute("versionTransaction")
		@RuneAttribute("versionTransaction")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setVersionTransaction(String _versionTransaction) {
			this.versionTransaction = _versionTransaction == null ? null : _versionTransaction;
			return this;
		}
		
		@Override
		@RosettaAttribute("versionPPD")
		@RuneAttribute("versionPPD")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setVersionPPD(String _versionPPD) {
			this.versionPPD = _versionPPD == null ? null : _versionPPD;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityUnderlyerID")
		@RuneAttribute("leg1CommodityUnderlyerID")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setLeg1CommodityUnderlyerID(String _leg1CommodityUnderlyerID) {
			this.leg1CommodityUnderlyerID = _leg1CommodityUnderlyerID == null ? null : _leg1CommodityUnderlyerID;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityUnderlyerID")
		@RuneAttribute("leg2CommodityUnderlyerID")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setLeg2CommodityUnderlyerID(String _leg2CommodityUnderlyerID) {
			this.leg2CommodityUnderlyerID = _leg2CommodityUnderlyerID == null ? null : _leg2CommodityUnderlyerID;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1FloatingRateIndex")
		@RuneAttribute("leg1FloatingRateIndex")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setLeg1FloatingRateIndex(String _leg1FloatingRateIndex) {
			this.leg1FloatingRateIndex = _leg1FloatingRateIndex == null ? null : _leg1FloatingRateIndex;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2FloatingRateIndex")
		@RuneAttribute("leg2FloatingRateIndex")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setLeg2FloatingRateIndex(String _leg2FloatingRateIndex) {
			this.leg2FloatingRateIndex = _leg2FloatingRateIndex == null ? null : _leg2FloatingRateIndex;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingAsset")
		@RuneAttribute("underlyingAsset")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addUnderlyingAsset(UnderlyingAssetReport _underlyingAsset) {
			if (_underlyingAsset != null) {
				this.underlyingAsset.add(_underlyingAsset.toBuilder());
			}
			return this;
		}
		
		@Override
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addUnderlyingAsset(UnderlyingAssetReport _underlyingAsset, int _idx) {
			getIndex(this.underlyingAsset, _idx, () -> _underlyingAsset.toBuilder());
			return this;
		}
		
		@Override 
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addUnderlyingAsset(List<? extends UnderlyingAssetReport> underlyingAssets) {
			if (underlyingAssets != null) {
				for (final UnderlyingAssetReport toAdd : underlyingAssets) {
					this.underlyingAsset.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("underlyingAsset")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setUnderlyingAsset(List<? extends UnderlyingAssetReport> underlyingAssets) {
			if (underlyingAssets == null) {
				this.underlyingAsset = new ArrayList<>();
			} else {
				this.underlyingAsset = underlyingAssets.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetName")
		@RuneAttribute("underlyingAssetName")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setUnderlyingAssetName(UnderlyingAssetNameReport _underlyingAssetName) {
			this.underlyingAssetName = _underlyingAssetName == null ? null : _underlyingAssetName.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("settlementType")
		@RuneAttribute("settlementType")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setSettlementType(String _settlementType) {
			this.settlementType = _settlementType == null ? null : _settlementType;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionVenueID")
		@RuneAttribute("executionVenueID")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setExecutionVenueID(String _executionVenueID) {
			this.executionVenueID = _executionVenueID == null ? null : _executionVenueID;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionVenueIDType")
		@RuneAttribute("executionVenueIDType")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setExecutionVenueIDType(PartyIdentifierTypeEnum _executionVenueIDType) {
			this.executionVenueIDType = _executionVenueIDType == null ? null : _executionVenueIDType;
			return this;
		}
		
		@Override
		@RosettaAttribute("productGrade")
		@RuneAttribute("productGrade")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addProductGrade(String _productGrade) {
			if (_productGrade != null) {
				this.productGrade.add(_productGrade);
			}
			return this;
		}
		
		@Override
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addProductGrade(String _productGrade, int _idx) {
			getIndex(this.productGrade, _idx, () -> _productGrade);
			return this;
		}
		
		@Override 
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addProductGrade(List<String> productGrades) {
			if (productGrades != null) {
				for (final String toAdd : productGrades) {
					this.productGrade.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("productGrade")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setProductGrade(List<String> productGrades) {
			if (productGrades == null) {
				this.productGrade = new ArrayList<>();
			} else {
				this.productGrade = productGrades.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("deliveryLocation")
		@RuneAttribute("deliveryLocation")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setDeliveryLocation(String _deliveryLocation) {
			this.deliveryLocation = _deliveryLocation == null ? null : _deliveryLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1SettlementPeriod")
		@RuneAttribute("leg1SettlementPeriod")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setLeg1SettlementPeriod(String _leg1SettlementPeriod) {
			this.leg1SettlementPeriod = _leg1SettlementPeriod == null ? null : _leg1SettlementPeriod;
			return this;
		}
		
		@Override
		@RosettaAttribute("loadType")
		@RuneAttribute("loadType")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setLoadType(String _loadType) {
			this.loadType = _loadType == null ? null : _loadType;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradeParty1BrokerIDType")
		@RuneAttribute("tradeParty1BrokerIDType")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setTradeParty1BrokerIDType(PartyIdentifierTypeEnum _tradeParty1BrokerIDType) {
			this.tradeParty1BrokerIDType = _tradeParty1BrokerIDType == null ? null : _tradeParty1BrokerIDType;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1CommodityInstrumentID")
		@RuneAttribute("leg1CommodityInstrumentID")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setLeg1CommodityInstrumentID(String _leg1CommodityInstrumentID) {
			this.leg1CommodityInstrumentID = _leg1CommodityInstrumentID == null ? null : _leg1CommodityInstrumentID;
			return this;
		}
		
		@Override
		@RosettaAttribute("leg2CommodityInstrumentID")
		@RuneAttribute("leg2CommodityInstrumentID")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setLeg2CommodityInstrumentID(String _leg2CommodityInstrumentID) {
			this.leg2CommodityInstrumentID = _leg2CommodityInstrumentID == null ? null : _leg2CommodityInstrumentID;
			return this;
		}
		
		@Override
		@RosettaAttribute("responsibleDataSubmitterIDType")
		@RuneAttribute("responsibleDataSubmitterIDType")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setResponsibleDataSubmitterIDType(PartyIdentifierTypeEnum _responsibleDataSubmitterIDType) {
			this.responsibleDataSubmitterIDType = _responsibleDataSubmitterIDType == null ? null : _responsibleDataSubmitterIDType;
			return this;
		}
		
		@Override
		@RosettaAttribute("responsibleDataSubmitterID")
		@RuneAttribute("responsibleDataSubmitterID")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setResponsibleDataSubmitterID(String _responsibleDataSubmitterID) {
			this.responsibleDataSubmitterID = _responsibleDataSubmitterID == null ? null : _responsibleDataSubmitterID;
			return this;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
			this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
			return this;
		}
		
		@Override
		@RosettaAttribute("corporateActionNewTradeParty1Lei")
		@RuneAttribute("corporateActionNewTradeParty1Lei")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setCorporateActionNewTradeParty1Lei(String _corporateActionNewTradeParty1Lei) {
			this.corporateActionNewTradeParty1Lei = _corporateActionNewTradeParty1Lei == null ? null : _corporateActionNewTradeParty1Lei;
			return this;
		}
		
		@Override
		@RosettaAttribute("otherPaymentPayerIDType")
		@RuneAttribute("otherPaymentPayerIDType")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(String _otherPaymentPayerIDType) {
			if (_otherPaymentPayerIDType != null) {
				this.otherPaymentPayerIDType.add(_otherPaymentPayerIDType);
			}
			return this;
		}
		
		@Override
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(String _otherPaymentPayerIDType, int _idx) {
			getIndex(this.otherPaymentPayerIDType, _idx, () -> _otherPaymentPayerIDType);
			return this;
		}
		
		@Override 
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(List<String> otherPaymentPayerIDTypes) {
			if (otherPaymentPayerIDTypes != null) {
				for (final String toAdd : otherPaymentPayerIDTypes) {
					this.otherPaymentPayerIDType.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("otherPaymentPayerIDType")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setOtherPaymentPayerIDType(List<String> otherPaymentPayerIDTypes) {
			if (otherPaymentPayerIDTypes == null) {
				this.otherPaymentPayerIDType = new ArrayList<>();
			} else {
				this.otherPaymentPayerIDType = otherPaymentPayerIDTypes.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("otherPaymentReceiverIDType")
		@RuneAttribute("otherPaymentReceiverIDType")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(String _otherPaymentReceiverIDType) {
			if (_otherPaymentReceiverIDType != null) {
				this.otherPaymentReceiverIDType.add(_otherPaymentReceiverIDType);
			}
			return this;
		}
		
		@Override
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(String _otherPaymentReceiverIDType, int _idx) {
			getIndex(this.otherPaymentReceiverIDType, _idx, () -> _otherPaymentReceiverIDType);
			return this;
		}
		
		@Override 
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(List<String> otherPaymentReceiverIDTypes) {
			if (otherPaymentReceiverIDTypes != null) {
				for (final String toAdd : otherPaymentReceiverIDTypes) {
					this.otherPaymentReceiverIDType.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("otherPaymentReceiverIDType")
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder setOtherPaymentReceiverIDType(List<String> otherPaymentReceiverIDTypes) {
			if (otherPaymentReceiverIDTypes == null) {
				this.otherPaymentReceiverIDType = new ArrayList<>();
			} else {
				this.otherPaymentReceiverIDType = otherPaymentReceiverIDTypes.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		public DTCCAdditionalFields build() {
			return new DTCCAdditionalFields.DTCCAdditionalFieldsImpl(this);
		}
		
		@Override
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder prune() {
			underlyingAsset = underlyingAsset.stream().filter(b->b!=null).<UnderlyingAssetReport.UnderlyingAssetReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			if (underlyingAssetName!=null && !underlyingAssetName.prune().hasData()) underlyingAssetName = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getClearingVenueIDType()!=null) return true;
			if (getTradeParty1ClearingBrokerIDType()!=null) return true;
			if (getTradeParty1IDType()!=null) return true;
			if (getSubmittingPartyIDType()!=null) return true;
			if (getAllocationType()!=null) return true;
			if (getUsiID()!=null) return true;
			if (getUsiIDPrefix()!=null) return true;
			if (getNewSDRIdentifier()!=null) return true;
			if (getSubmittedForParty()!=null) return true;
			if (getTradeLegTypes()!=null) return true;
			if (getTradeParty1ReportingDestination()!=null && !getTradeParty1ReportingDestination().isEmpty()) return true;
			if (getTradeParty2ReportingDestination()!=null && !getTradeParty2ReportingDestination().isEmpty()) return true;
			if (getPrimaryAssetClass()!=null) return true;
			if (getSecondaryAssetClass()!=null) return true;
			if (getComment1()!=null) return true;
			if (getMessageID()!=null) return true;
			if (getMessageTypeTransaction()!=null) return true;
			if (getMessageTypePPD()!=null) return true;
			if (getOptionStyle()!=null) return true;
			if (getOptionType()!=null) return true;
			if (getProductID()!=null) return true;
			if (getTradeParty2ExecutionAgentID()!=null) return true;
			if (getTradeParty2ExecutionAgentIDType()!=null) return true;
			if (getTradeParty1ExecutionAgentID()!=null) return true;
			if (getTradeParty1ExecutionAgentIDType()!=null) return true;
			if (getTradeParty1TransactionID()!=null) return true;
			if (getVersionTransaction()!=null) return true;
			if (getVersionPPD()!=null) return true;
			if (getLeg1CommodityUnderlyerID()!=null) return true;
			if (getLeg2CommodityUnderlyerID()!=null) return true;
			if (getLeg1FloatingRateIndex()!=null) return true;
			if (getLeg2FloatingRateIndex()!=null) return true;
			if (getUnderlyingAsset()!=null && getUnderlyingAsset().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getUnderlyingAssetName()!=null && getUnderlyingAssetName().hasData()) return true;
			if (getSettlementType()!=null) return true;
			if (getExecutionVenueID()!=null) return true;
			if (getExecutionVenueIDType()!=null) return true;
			if (getProductGrade()!=null && !getProductGrade().isEmpty()) return true;
			if (getDeliveryLocation()!=null) return true;
			if (getLeg1SettlementPeriod()!=null) return true;
			if (getLoadType()!=null) return true;
			if (getTradeParty1BrokerIDType()!=null) return true;
			if (getLeg1CommodityInstrumentID()!=null) return true;
			if (getLeg2CommodityInstrumentID()!=null) return true;
			if (getResponsibleDataSubmitterIDType()!=null) return true;
			if (getResponsibleDataSubmitterID()!=null) return true;
			if (getMaturityDateOfTheUnderlying()!=null) return true;
			if (getCorporateActionNewTradeParty1Lei()!=null) return true;
			if (getOtherPaymentPayerIDType()!=null && !getOtherPaymentPayerIDType().isEmpty()) return true;
			if (getOtherPaymentReceiverIDType()!=null && !getOtherPaymentReceiverIDType().isEmpty()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			DTCCAdditionalFields.DTCCAdditionalFieldsBuilder o = (DTCCAdditionalFields.DTCCAdditionalFieldsBuilder) other;
			
			merger.mergeRosetta(getUnderlyingAsset(), o.getUnderlyingAsset(), this::getOrCreateUnderlyingAsset);
			merger.mergeRosetta(getUnderlyingAssetName(), o.getUnderlyingAssetName(), this::setUnderlyingAssetName);
			
			merger.mergeBasic(getClearingVenueIDType(), o.getClearingVenueIDType(), this::setClearingVenueIDType);
			merger.mergeBasic(getTradeParty1ClearingBrokerIDType(), o.getTradeParty1ClearingBrokerIDType(), this::setTradeParty1ClearingBrokerIDType);
			merger.mergeBasic(getTradeParty1IDType(), o.getTradeParty1IDType(), this::setTradeParty1IDType);
			merger.mergeBasic(getSubmittingPartyIDType(), o.getSubmittingPartyIDType(), this::setSubmittingPartyIDType);
			merger.mergeBasic(getAllocationType(), o.getAllocationType(), this::setAllocationType);
			merger.mergeBasic(getUsiID(), o.getUsiID(), this::setUsiID);
			merger.mergeBasic(getUsiIDPrefix(), o.getUsiIDPrefix(), this::setUsiIDPrefix);
			merger.mergeBasic(getNewSDRIdentifier(), o.getNewSDRIdentifier(), this::setNewSDRIdentifier);
			merger.mergeBasic(getSubmittedForParty(), o.getSubmittedForParty(), this::setSubmittedForParty);
			merger.mergeBasic(getTradeLegTypes(), o.getTradeLegTypes(), this::setTradeLegTypes);
			merger.mergeBasic(getTradeParty1ReportingDestination(), o.getTradeParty1ReportingDestination(), (Consumer<SupervisoryBodyEnum>) this::addTradeParty1ReportingDestination);
			merger.mergeBasic(getTradeParty2ReportingDestination(), o.getTradeParty2ReportingDestination(), (Consumer<SupervisoryBodyEnum>) this::addTradeParty2ReportingDestination);
			merger.mergeBasic(getPrimaryAssetClass(), o.getPrimaryAssetClass(), this::setPrimaryAssetClass);
			merger.mergeBasic(getSecondaryAssetClass(), o.getSecondaryAssetClass(), this::setSecondaryAssetClass);
			merger.mergeBasic(getComment1(), o.getComment1(), this::setComment1);
			merger.mergeBasic(getMessageID(), o.getMessageID(), this::setMessageID);
			merger.mergeBasic(getMessageTypeTransaction(), o.getMessageTypeTransaction(), this::setMessageTypeTransaction);
			merger.mergeBasic(getMessageTypePPD(), o.getMessageTypePPD(), this::setMessageTypePPD);
			merger.mergeBasic(getOptionStyle(), o.getOptionStyle(), this::setOptionStyle);
			merger.mergeBasic(getOptionType(), o.getOptionType(), this::setOptionType);
			merger.mergeBasic(getProductID(), o.getProductID(), this::setProductID);
			merger.mergeBasic(getTradeParty2ExecutionAgentID(), o.getTradeParty2ExecutionAgentID(), this::setTradeParty2ExecutionAgentID);
			merger.mergeBasic(getTradeParty2ExecutionAgentIDType(), o.getTradeParty2ExecutionAgentIDType(), this::setTradeParty2ExecutionAgentIDType);
			merger.mergeBasic(getTradeParty1ExecutionAgentID(), o.getTradeParty1ExecutionAgentID(), this::setTradeParty1ExecutionAgentID);
			merger.mergeBasic(getTradeParty1ExecutionAgentIDType(), o.getTradeParty1ExecutionAgentIDType(), this::setTradeParty1ExecutionAgentIDType);
			merger.mergeBasic(getTradeParty1TransactionID(), o.getTradeParty1TransactionID(), this::setTradeParty1TransactionID);
			merger.mergeBasic(getVersionTransaction(), o.getVersionTransaction(), this::setVersionTransaction);
			merger.mergeBasic(getVersionPPD(), o.getVersionPPD(), this::setVersionPPD);
			merger.mergeBasic(getLeg1CommodityUnderlyerID(), o.getLeg1CommodityUnderlyerID(), this::setLeg1CommodityUnderlyerID);
			merger.mergeBasic(getLeg2CommodityUnderlyerID(), o.getLeg2CommodityUnderlyerID(), this::setLeg2CommodityUnderlyerID);
			merger.mergeBasic(getLeg1FloatingRateIndex(), o.getLeg1FloatingRateIndex(), this::setLeg1FloatingRateIndex);
			merger.mergeBasic(getLeg2FloatingRateIndex(), o.getLeg2FloatingRateIndex(), this::setLeg2FloatingRateIndex);
			merger.mergeBasic(getSettlementType(), o.getSettlementType(), this::setSettlementType);
			merger.mergeBasic(getExecutionVenueID(), o.getExecutionVenueID(), this::setExecutionVenueID);
			merger.mergeBasic(getExecutionVenueIDType(), o.getExecutionVenueIDType(), this::setExecutionVenueIDType);
			merger.mergeBasic(getProductGrade(), o.getProductGrade(), (Consumer<String>) this::addProductGrade);
			merger.mergeBasic(getDeliveryLocation(), o.getDeliveryLocation(), this::setDeliveryLocation);
			merger.mergeBasic(getLeg1SettlementPeriod(), o.getLeg1SettlementPeriod(), this::setLeg1SettlementPeriod);
			merger.mergeBasic(getLoadType(), o.getLoadType(), this::setLoadType);
			merger.mergeBasic(getTradeParty1BrokerIDType(), o.getTradeParty1BrokerIDType(), this::setTradeParty1BrokerIDType);
			merger.mergeBasic(getLeg1CommodityInstrumentID(), o.getLeg1CommodityInstrumentID(), this::setLeg1CommodityInstrumentID);
			merger.mergeBasic(getLeg2CommodityInstrumentID(), o.getLeg2CommodityInstrumentID(), this::setLeg2CommodityInstrumentID);
			merger.mergeBasic(getResponsibleDataSubmitterIDType(), o.getResponsibleDataSubmitterIDType(), this::setResponsibleDataSubmitterIDType);
			merger.mergeBasic(getResponsibleDataSubmitterID(), o.getResponsibleDataSubmitterID(), this::setResponsibleDataSubmitterID);
			merger.mergeBasic(getMaturityDateOfTheUnderlying(), o.getMaturityDateOfTheUnderlying(), this::setMaturityDateOfTheUnderlying);
			merger.mergeBasic(getCorporateActionNewTradeParty1Lei(), o.getCorporateActionNewTradeParty1Lei(), this::setCorporateActionNewTradeParty1Lei);
			merger.mergeBasic(getOtherPaymentPayerIDType(), o.getOtherPaymentPayerIDType(), (Consumer<String>) this::addOtherPaymentPayerIDType);
			merger.mergeBasic(getOtherPaymentReceiverIDType(), o.getOtherPaymentReceiverIDType(), (Consumer<String>) this::addOtherPaymentReceiverIDType);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			DTCCAdditionalFields _that = getType().cast(o);
		
			if (!Objects.equals(clearingVenueIDType, _that.getClearingVenueIDType())) return false;
			if (!Objects.equals(tradeParty1ClearingBrokerIDType, _that.getTradeParty1ClearingBrokerIDType())) return false;
			if (!Objects.equals(tradeParty1IDType, _that.getTradeParty1IDType())) return false;
			if (!Objects.equals(submittingPartyIDType, _that.getSubmittingPartyIDType())) return false;
			if (!Objects.equals(allocationType, _that.getAllocationType())) return false;
			if (!Objects.equals(usiID, _that.getUsiID())) return false;
			if (!Objects.equals(usiIDPrefix, _that.getUsiIDPrefix())) return false;
			if (!Objects.equals(newSDRIdentifier, _that.getNewSDRIdentifier())) return false;
			if (!Objects.equals(submittedForParty, _that.getSubmittedForParty())) return false;
			if (!Objects.equals(tradeLegTypes, _that.getTradeLegTypes())) return false;
			if (!ListEquals.listEquals(tradeParty1ReportingDestination, _that.getTradeParty1ReportingDestination())) return false;
			if (!ListEquals.listEquals(tradeParty2ReportingDestination, _that.getTradeParty2ReportingDestination())) return false;
			if (!Objects.equals(primaryAssetClass, _that.getPrimaryAssetClass())) return false;
			if (!Objects.equals(secondaryAssetClass, _that.getSecondaryAssetClass())) return false;
			if (!Objects.equals(comment1, _that.getComment1())) return false;
			if (!Objects.equals(messageID, _that.getMessageID())) return false;
			if (!Objects.equals(messageTypeTransaction, _that.getMessageTypeTransaction())) return false;
			if (!Objects.equals(messageTypePPD, _that.getMessageTypePPD())) return false;
			if (!Objects.equals(optionStyle, _that.getOptionStyle())) return false;
			if (!Objects.equals(optionType, _that.getOptionType())) return false;
			if (!Objects.equals(productID, _that.getProductID())) return false;
			if (!Objects.equals(tradeParty2ExecutionAgentID, _that.getTradeParty2ExecutionAgentID())) return false;
			if (!Objects.equals(tradeParty2ExecutionAgentIDType, _that.getTradeParty2ExecutionAgentIDType())) return false;
			if (!Objects.equals(tradeParty1ExecutionAgentID, _that.getTradeParty1ExecutionAgentID())) return false;
			if (!Objects.equals(tradeParty1ExecutionAgentIDType, _that.getTradeParty1ExecutionAgentIDType())) return false;
			if (!Objects.equals(tradeParty1TransactionID, _that.getTradeParty1TransactionID())) return false;
			if (!Objects.equals(versionTransaction, _that.getVersionTransaction())) return false;
			if (!Objects.equals(versionPPD, _that.getVersionPPD())) return false;
			if (!Objects.equals(leg1CommodityUnderlyerID, _that.getLeg1CommodityUnderlyerID())) return false;
			if (!Objects.equals(leg2CommodityUnderlyerID, _that.getLeg2CommodityUnderlyerID())) return false;
			if (!Objects.equals(leg1FloatingRateIndex, _that.getLeg1FloatingRateIndex())) return false;
			if (!Objects.equals(leg2FloatingRateIndex, _that.getLeg2FloatingRateIndex())) return false;
			if (!ListEquals.listEquals(underlyingAsset, _that.getUnderlyingAsset())) return false;
			if (!Objects.equals(underlyingAssetName, _that.getUnderlyingAssetName())) return false;
			if (!Objects.equals(settlementType, _that.getSettlementType())) return false;
			if (!Objects.equals(executionVenueID, _that.getExecutionVenueID())) return false;
			if (!Objects.equals(executionVenueIDType, _that.getExecutionVenueIDType())) return false;
			if (!ListEquals.listEquals(productGrade, _that.getProductGrade())) return false;
			if (!Objects.equals(deliveryLocation, _that.getDeliveryLocation())) return false;
			if (!Objects.equals(leg1SettlementPeriod, _that.getLeg1SettlementPeriod())) return false;
			if (!Objects.equals(loadType, _that.getLoadType())) return false;
			if (!Objects.equals(tradeParty1BrokerIDType, _that.getTradeParty1BrokerIDType())) return false;
			if (!Objects.equals(leg1CommodityInstrumentID, _that.getLeg1CommodityInstrumentID())) return false;
			if (!Objects.equals(leg2CommodityInstrumentID, _that.getLeg2CommodityInstrumentID())) return false;
			if (!Objects.equals(responsibleDataSubmitterIDType, _that.getResponsibleDataSubmitterIDType())) return false;
			if (!Objects.equals(responsibleDataSubmitterID, _that.getResponsibleDataSubmitterID())) return false;
			if (!Objects.equals(maturityDateOfTheUnderlying, _that.getMaturityDateOfTheUnderlying())) return false;
			if (!Objects.equals(corporateActionNewTradeParty1Lei, _that.getCorporateActionNewTradeParty1Lei())) return false;
			if (!ListEquals.listEquals(otherPaymentPayerIDType, _that.getOtherPaymentPayerIDType())) return false;
			if (!ListEquals.listEquals(otherPaymentReceiverIDType, _that.getOtherPaymentReceiverIDType())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (clearingVenueIDType != null ? clearingVenueIDType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (tradeParty1ClearingBrokerIDType != null ? tradeParty1ClearingBrokerIDType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (tradeParty1IDType != null ? tradeParty1IDType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (submittingPartyIDType != null ? submittingPartyIDType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (allocationType != null ? allocationType.hashCode() : 0);
			_result = 31 * _result + (usiID != null ? usiID.hashCode() : 0);
			_result = 31 * _result + (usiIDPrefix != null ? usiIDPrefix.hashCode() : 0);
			_result = 31 * _result + (newSDRIdentifier != null ? newSDRIdentifier.hashCode() : 0);
			_result = 31 * _result + (submittedForParty != null ? submittedForParty.hashCode() : 0);
			_result = 31 * _result + (tradeLegTypes != null ? tradeLegTypes.hashCode() : 0);
			_result = 31 * _result + (tradeParty1ReportingDestination != null ? tradeParty1ReportingDestination.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
			_result = 31 * _result + (tradeParty2ReportingDestination != null ? tradeParty2ReportingDestination.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
			_result = 31 * _result + (primaryAssetClass != null ? primaryAssetClass.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (secondaryAssetClass != null ? secondaryAssetClass.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (comment1 != null ? comment1.hashCode() : 0);
			_result = 31 * _result + (messageID != null ? messageID.hashCode() : 0);
			_result = 31 * _result + (messageTypeTransaction != null ? messageTypeTransaction.hashCode() : 0);
			_result = 31 * _result + (messageTypePPD != null ? messageTypePPD.hashCode() : 0);
			_result = 31 * _result + (optionStyle != null ? optionStyle.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (optionType != null ? optionType.hashCode() : 0);
			_result = 31 * _result + (productID != null ? productID.hashCode() : 0);
			_result = 31 * _result + (tradeParty2ExecutionAgentID != null ? tradeParty2ExecutionAgentID.hashCode() : 0);
			_result = 31 * _result + (tradeParty2ExecutionAgentIDType != null ? tradeParty2ExecutionAgentIDType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (tradeParty1ExecutionAgentID != null ? tradeParty1ExecutionAgentID.hashCode() : 0);
			_result = 31 * _result + (tradeParty1ExecutionAgentIDType != null ? tradeParty1ExecutionAgentIDType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (tradeParty1TransactionID != null ? tradeParty1TransactionID.hashCode() : 0);
			_result = 31 * _result + (versionTransaction != null ? versionTransaction.hashCode() : 0);
			_result = 31 * _result + (versionPPD != null ? versionPPD.hashCode() : 0);
			_result = 31 * _result + (leg1CommodityUnderlyerID != null ? leg1CommodityUnderlyerID.hashCode() : 0);
			_result = 31 * _result + (leg2CommodityUnderlyerID != null ? leg2CommodityUnderlyerID.hashCode() : 0);
			_result = 31 * _result + (leg1FloatingRateIndex != null ? leg1FloatingRateIndex.hashCode() : 0);
			_result = 31 * _result + (leg2FloatingRateIndex != null ? leg2FloatingRateIndex.hashCode() : 0);
			_result = 31 * _result + (underlyingAsset != null ? underlyingAsset.hashCode() : 0);
			_result = 31 * _result + (underlyingAssetName != null ? underlyingAssetName.hashCode() : 0);
			_result = 31 * _result + (settlementType != null ? settlementType.hashCode() : 0);
			_result = 31 * _result + (executionVenueID != null ? executionVenueID.hashCode() : 0);
			_result = 31 * _result + (executionVenueIDType != null ? executionVenueIDType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (productGrade != null ? productGrade.hashCode() : 0);
			_result = 31 * _result + (deliveryLocation != null ? deliveryLocation.hashCode() : 0);
			_result = 31 * _result + (leg1SettlementPeriod != null ? leg1SettlementPeriod.hashCode() : 0);
			_result = 31 * _result + (loadType != null ? loadType.hashCode() : 0);
			_result = 31 * _result + (tradeParty1BrokerIDType != null ? tradeParty1BrokerIDType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (leg1CommodityInstrumentID != null ? leg1CommodityInstrumentID.hashCode() : 0);
			_result = 31 * _result + (leg2CommodityInstrumentID != null ? leg2CommodityInstrumentID.hashCode() : 0);
			_result = 31 * _result + (responsibleDataSubmitterIDType != null ? responsibleDataSubmitterIDType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (responsibleDataSubmitterID != null ? responsibleDataSubmitterID.hashCode() : 0);
			_result = 31 * _result + (maturityDateOfTheUnderlying != null ? maturityDateOfTheUnderlying.hashCode() : 0);
			_result = 31 * _result + (corporateActionNewTradeParty1Lei != null ? corporateActionNewTradeParty1Lei.hashCode() : 0);
			_result = 31 * _result + (otherPaymentPayerIDType != null ? otherPaymentPayerIDType.hashCode() : 0);
			_result = 31 * _result + (otherPaymentReceiverIDType != null ? otherPaymentReceiverIDType.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "DTCCAdditionalFieldsBuilder {" +
				"clearingVenueIDType=" + this.clearingVenueIDType + ", " +
				"tradeParty1ClearingBrokerIDType=" + this.tradeParty1ClearingBrokerIDType + ", " +
				"tradeParty1IDType=" + this.tradeParty1IDType + ", " +
				"submittingPartyIDType=" + this.submittingPartyIDType + ", " +
				"allocationType=" + this.allocationType + ", " +
				"usiID=" + this.usiID + ", " +
				"usiIDPrefix=" + this.usiIDPrefix + ", " +
				"newSDRIdentifier=" + this.newSDRIdentifier + ", " +
				"submittedForParty=" + this.submittedForParty + ", " +
				"tradeLegTypes=" + this.tradeLegTypes + ", " +
				"tradeParty1ReportingDestination=" + this.tradeParty1ReportingDestination + ", " +
				"tradeParty2ReportingDestination=" + this.tradeParty2ReportingDestination + ", " +
				"primaryAssetClass=" + this.primaryAssetClass + ", " +
				"secondaryAssetClass=" + this.secondaryAssetClass + ", " +
				"comment1=" + this.comment1 + ", " +
				"messageID=" + this.messageID + ", " +
				"messageTypeTransaction=" + this.messageTypeTransaction + ", " +
				"messageTypePPD=" + this.messageTypePPD + ", " +
				"optionStyle=" + this.optionStyle + ", " +
				"optionType=" + this.optionType + ", " +
				"productID=" + this.productID + ", " +
				"tradeParty2ExecutionAgentID=" + this.tradeParty2ExecutionAgentID + ", " +
				"tradeParty2ExecutionAgentIDType=" + this.tradeParty2ExecutionAgentIDType + ", " +
				"tradeParty1ExecutionAgentID=" + this.tradeParty1ExecutionAgentID + ", " +
				"tradeParty1ExecutionAgentIDType=" + this.tradeParty1ExecutionAgentIDType + ", " +
				"tradeParty1TransactionID=" + this.tradeParty1TransactionID + ", " +
				"versionTransaction=" + this.versionTransaction + ", " +
				"versionPPD=" + this.versionPPD + ", " +
				"leg1CommodityUnderlyerID=" + this.leg1CommodityUnderlyerID + ", " +
				"leg2CommodityUnderlyerID=" + this.leg2CommodityUnderlyerID + ", " +
				"leg1FloatingRateIndex=" + this.leg1FloatingRateIndex + ", " +
				"leg2FloatingRateIndex=" + this.leg2FloatingRateIndex + ", " +
				"underlyingAsset=" + this.underlyingAsset + ", " +
				"underlyingAssetName=" + this.underlyingAssetName + ", " +
				"settlementType=" + this.settlementType + ", " +
				"executionVenueID=" + this.executionVenueID + ", " +
				"executionVenueIDType=" + this.executionVenueIDType + ", " +
				"productGrade=" + this.productGrade + ", " +
				"deliveryLocation=" + this.deliveryLocation + ", " +
				"leg1SettlementPeriod=" + this.leg1SettlementPeriod + ", " +
				"loadType=" + this.loadType + ", " +
				"tradeParty1BrokerIDType=" + this.tradeParty1BrokerIDType + ", " +
				"leg1CommodityInstrumentID=" + this.leg1CommodityInstrumentID + ", " +
				"leg2CommodityInstrumentID=" + this.leg2CommodityInstrumentID + ", " +
				"responsibleDataSubmitterIDType=" + this.responsibleDataSubmitterIDType + ", " +
				"responsibleDataSubmitterID=" + this.responsibleDataSubmitterID + ", " +
				"maturityDateOfTheUnderlying=" + this.maturityDateOfTheUnderlying + ", " +
				"corporateActionNewTradeParty1Lei=" + this.corporateActionNewTradeParty1Lei + ", " +
				"otherPaymentPayerIDType=" + this.otherPaymentPayerIDType + ", " +
				"otherPaymentReceiverIDType=" + this.otherPaymentReceiverIDType +
			'}';
		}
	}
}
