package drr.regulation.csa.rewrite.dtcc.reports;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.product.qualification.functions.Qualify_AssetClass_Commodity;
import cdm.product.qualification.functions.Qualify_AssetClass_Credit;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import cdm.product.qualification.functions.Qualify_AssetClass_ForeignExchange;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.ProductForEvent;
import javax.inject.Inject;


@ImplementedBy(DTCC_PrimaryAssetClassRule.DTCC_PrimaryAssetClassRuleDefault.class)
public abstract class DTCC_PrimaryAssetClassRule implements ReportFunction<TransactionReportInstruction, AssetClassEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected Qualify_AssetClass_Commodity qualify_AssetClass_Commodity;
	@Inject protected Qualify_AssetClass_Credit qualify_AssetClass_Credit;
	@Inject protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;
	@Inject protected Qualify_AssetClass_ForeignExchange qualify_AssetClass_ForeignExchange;
	@Inject protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public AssetClassEnum evaluate(TransactionReportInstruction input) {
		AssetClassEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract AssetClassEnum doEvaluate(TransactionReportInstruction input);

	public static class DTCC_PrimaryAssetClassRuleDefault extends DTCC_PrimaryAssetClassRule {
		@Override
		protected AssetClassEnum doEvaluate(TransactionReportInstruction input) {
			AssetClassEnum output = null;
			return assignOutput(output, input);
		}
		
		protected AssetClassEnum assignOutput(AssetClassEnum output, TransactionReportInstruction input) {
			final MapperS<Product> thenArg0 = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
			final MapperS<EconomicTerms> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(economicTermsForProduct.evaluate(item.get())));
			output = thenArg1
				.mapSingleToItem(item -> {
					final Boolean boolean0 = qualify_AssetClass_InterestRate.evaluate(item.get());
					if ((boolean0 == null ? false : boolean0)) {
						return MapperS.of(AssetClassEnum.INTEREST_RATE);
					}
					final Boolean boolean1 = qualify_AssetClass_Credit.evaluate(item.get());
					if ((boolean1 == null ? false : boolean1)) {
						return MapperS.of(AssetClassEnum.CREDIT);
					}
					final Boolean boolean2 = qualify_AssetClass_Equity.evaluate(item.get());
					if ((boolean2 == null ? false : boolean2)) {
						return MapperS.of(AssetClassEnum.EQUITY);
					}
					final Boolean boolean3 = qualify_AssetClass_Commodity.evaluate(item.get());
					if ((boolean3 == null ? false : boolean3)) {
						return MapperS.of(AssetClassEnum.COMMODITY);
					}
					final Boolean boolean4 = qualify_AssetClass_ForeignExchange.evaluate(item.get());
					if ((boolean4 == null ? false : boolean4)) {
						return MapperS.of(AssetClassEnum.FOREIGN_EXCHANGE);
					}
					return MapperS.<AssetClassEnum>ofNull();
				}).get();
			
			return output;
		}
	}
}
