package drr.regulation.csa.rewrite.dtcc.reports;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.ReportingSide;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.regulation.csa.rewrite.trade.functions.SupervisoryBodyForCSA;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(DTCC_TradeParty2ReportingDestinationRule.DTCC_TradeParty2ReportingDestinationRuleDefault.class)
public abstract class DTCC_TradeParty2ReportingDestinationRule implements ReportFunction<TransactionReportInstruction, List<SupervisoryBodyEnum>> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForCSA isAllowableActionForCSA;
	@Inject protected SupervisoryBodyForCSA supervisoryBodyForCSA;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<SupervisoryBodyEnum> evaluate(TransactionReportInstruction input) {
		List<SupervisoryBodyEnum> output = doEvaluate(input);
		
		return output;
	}

	protected abstract List<SupervisoryBodyEnum> doEvaluate(TransactionReportInstruction input);

	public static class DTCC_TradeParty2ReportingDestinationRuleDefault extends DTCC_TradeParty2ReportingDestinationRule {
		@Override
		protected List<SupervisoryBodyEnum> doEvaluate(TransactionReportInstruction input) {
			List<SupervisoryBodyEnum> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<SupervisoryBodyEnum> assignOutput(List<SupervisoryBodyEnum> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCSA.evaluate(item.get()));
			output = thenArg
				.mapSingleToList(transactionReportInstruction -> {
					final MapperC<PartyInformation> thenArg0 = thenArg.<ReportableInformation>map("getReportableInformation", _transactionReportInstruction -> _transactionReportInstruction.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation());
					final MapperC<PartyInformation> thenArg1 = thenArg0
						.filterItemNullSafe(item -> areEqual(item.<ReferenceWithMetaParty>map("getPartyReference", partyInformation -> partyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty0 -> referenceWithMetaParty0 == null ? null : referenceWithMetaParty0.getValue()), transactionReportInstruction.<ReportingSide>map("getReportingSide", _transactionReportInstruction -> _transactionReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingCounterparty", reportingSide -> reportingSide.getReportingCounterparty()).<Party>map("Type coercion", referenceWithMetaParty1 -> referenceWithMetaParty1 == null ? null : referenceWithMetaParty1.getValue()), CardinalityOperator.All).get());
					final MapperListOfLists<FieldWithMetaSupervisoryBodyEnum> thenArg2 = thenArg1
						.mapItemToList(item -> distinct(item.<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()).<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody())));
					final MapperC<FieldWithMetaSupervisoryBodyEnum> thenArg3 = thenArg2
						.flattenList();
					final MapperC<FieldWithMetaSupervisoryBodyEnum> thenArg4 = thenArg3
						.mapItem(item -> {
							if (notEqual(MapperC.<SupervisoryBodyEnum>of(supervisoryBodyForCSA.evaluate()), item.<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum0 -> fieldWithMetaSupervisoryBodyEnum0 == null ? null : fieldWithMetaSupervisoryBodyEnum0.getValue()), CardinalityOperator.All).and(notEqual(MapperC.<SupervisoryBodyEnum>of(MapperS.of(SupervisoryBodyEnum.CFTC), MapperS.of(SupervisoryBodyEnum.SEC)), item.<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum1 -> fieldWithMetaSupervisoryBodyEnum1 == null ? null : fieldWithMetaSupervisoryBodyEnum1.getValue()), CardinalityOperator.All)).getOrDefault(false)) {
								return item;
							}
							return MapperS.<FieldWithMetaSupervisoryBodyEnum>ofNull();
						});
					return distinct(thenArg4);
				}).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum.getValue()).getMulti();
			
			return output;
		}
	}
}
