package drr.regulation.csa.rewrite.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.Index;
import cdm.base.staticdata.asset.common.Loan;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.asset.common.metafields.FieldWithMetaProductIdentifier;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.observable.asset.Observable;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.Product;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetQuantityForConstituent.GetQuantityForConstituentDefault.class)
public abstract class GetQuantityForConstituent implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param constituent 
	* @param tradeLots 
	* @return result 
	*/
	public NonNegativeQuantitySchedule evaluate(Product constituent, List<? extends TradeLot> tradeLots) {
		NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder resultBuilder = doEvaluate(constituent, tradeLots);
		
		final NonNegativeQuantitySchedule result;
		if (resultBuilder == null) {
			result = null;
		} else {
			result = resultBuilder.build();
			objectValidator.validate(NonNegativeQuantitySchedule.class, result);
		}
		
		return result;
	}

	protected abstract NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(Product constituent, List<? extends TradeLot> tradeLots);

	protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> predicates(Product constituent, List<? extends TradeLot> tradeLots);

	public static class GetQuantityForConstituentDefault extends GetQuantityForConstituent {
		@Override
		protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(Product constituent, List<? extends TradeLot> tradeLots) {
			if (tradeLots == null) {
				tradeLots = Collections.emptyList();
			}
			NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder result = NonNegativeQuantitySchedule.builder();
			return assignOutput(result, constituent, tradeLots);
		}
		
		protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder assignOutput(NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder result, Product constituent, List<? extends TradeLot> tradeLots) {
			final MapperC<PriceQuantity> thenArg0 = MapperC.<TradeLot>of(tradeLots).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity())
				.filterItemNullSafe(item -> areEqual(item.<Observable>map("getObservable", priceQuantity -> priceQuantity.getObservable()).<FieldWithMetaProductIdentifier>mapC("getProductIdentifier", observable -> observable.getProductIdentifier()).<ProductIdentifier>map("Type coercion", fieldWithMetaProductIdentifier -> fieldWithMetaProductIdentifier.getValue()), predicates(constituent, tradeLots).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()), CardinalityOperator.All).get());
			final MapperListOfLists<FieldWithMetaNonNegativeQuantitySchedule> thenArg1 = thenArg0
				.mapItemToList(item -> item.<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()));
			final FieldWithMetaNonNegativeQuantitySchedule fieldWithMetaNonNegativeQuantitySchedule = MapperS.of(thenArg1
				.flattenList().get()).get();
			if (fieldWithMetaNonNegativeQuantitySchedule == null) {
				result = null;
			} else {
				result = toBuilder(fieldWithMetaNonNegativeQuantitySchedule.getValue());
			}
			
			return Optional.ofNullable(result)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperC<? extends ReferenceWithMetaProductIdentifier> predicates(Product constituent, List<? extends TradeLot> tradeLots) {
			if (exists(MapperS.of(constituent).<Security>map("getSecurity", product -> product.getSecurity())).getOrDefault(false)) {
				return MapperS.of(constituent).<Security>map("getSecurity", product -> product.getSecurity()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", security -> security.getProductIdentifier());
			}
			if (exists(MapperS.of(constituent).<Loan>map("getLoan", product -> product.getLoan())).getOrDefault(false)) {
				return MapperS.of(constituent).<Loan>map("getLoan", product -> product.getLoan()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", loan -> loan.getProductIdentifier());
			}
			if (exists(MapperS.of(constituent).<ReferenceWithMetaCommodity>map("getCommodity", product -> product.getCommodity())).getOrDefault(false)) {
				return MapperS.of(constituent).<ReferenceWithMetaCommodity>map("getCommodity", product -> product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier());
			}
			if (exists(MapperS.of(constituent).<Index>map("getIndex", product -> product.getIndex())).getOrDefault(false)) {
				return MapperS.of(constituent).<Index>map("getIndex", product -> product.getIndex()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", index -> index.getProductIdentifier());
			}
			return MapperC.<ReferenceWithMetaProductIdentifier>ofNull();
		}
	}
}
