package drr.regulation.csa.rewrite.margin.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.csa.rewrite.margin.CSAMarginReport;
import java.util.List;
import java.util.regex.Pattern;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkNumber;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkString;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class CSAMarginReportTypeFormatValidator implements Validator<CSAMarginReport> {

	private List<ComparisonResult> getComparisonResults(CSAMarginReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkString("counterparty1", o.getCounterparty1(), 0, empty(), of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), 
				checkString("counterparty2", o.getCounterparty2(), 20, of(72), of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), 
				checkString("counterparty2IdentifierSource", o.getCounterparty2IdentifierSource(), 1, of(4), empty()), 
				checkString("uniqueTransactionIdentifier", o.getUniqueTransactionIdentifier(), 1, of(52), of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), 
				checkNumber("initialMarginPostedByTheReportingCounterpartyPreHaircut", o.getInitialMarginPostedByTheReportingCounterpartyPreHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("initialMarginPostedByTheReportingCounterpartyPostHaircut", o.getInitialMarginPostedByTheReportingCounterpartyPostHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("initialMarginCollectedByTheReportingCounterpartyPreHaircut", o.getInitialMarginCollectedByTheReportingCounterpartyPreHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("initialMarginCollectedByTheReportingCounterpartyPostHaircut", o.getInitialMarginCollectedByTheReportingCounterpartyPostHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("variationMarginPostedByTheReportingCounterpartyPreHaircut", o.getVariationMarginPostedByTheReportingCounterpartyPreHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("variationMarginPostedByTheReportingCounterpartyPostHaircut", o.getVariationMarginPostedByTheReportingCounterpartyPostHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("variationMarginCollectedByTheReportingCounterpartyPreHaircut", o.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("variationMarginCollectedByTheReportingCounterpartyPostHaircut", o.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut(), of(25), of(5), empty(), empty()), 
				checkString("variationMarginCollateralPortfolioCode", o.getVariationMarginCollateralPortfolioCode(), 1, of(52), of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), 
				checkString("initialMarginCollateralPortfolioCode", o.getInitialMarginCollateralPortfolioCode(), 1, of(52), of(Pattern.compile("[a-zA-Z0-9]{1,52}")))
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSAMarginReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("CSAMarginReport", ValidationType.TYPE_FORMAT, "CSAMarginReport", path, "", res.getError());
				}
				return success("CSAMarginReport", ValidationType.TYPE_FORMAT, "CSAMarginReport", path, "");
			})
			.collect(toList());
	}

}
