package drr.regulation.csa.rewrite.margin.validation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.MarginActionEnum;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.csa.rewrite.margin.CSAMarginReport;
import drr.standards.iso.CollateralisationType3Code__1;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class CSAMarginReportValidator implements Validator<CSAMarginReport> {

	private List<ComparisonResult> getComparisonResults(CSAMarginReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("counterparty1", (String) o.getCounterparty1() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty2", (String) o.getCounterparty2() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty2IdentifierSource", (String) o.getCounterparty2IdentifierSource() != null ? 1 : 0, 1, 1), 
				checkCardinality("reportingTimestamp", (ZonedDateTime) o.getReportingTimestamp() != null ? 1 : 0, 1, 1), 
				checkCardinality("uniqueTransactionIdentifier", (String) o.getUniqueTransactionIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("submitterIdentifier", (String) o.getSubmitterIdentifier() != null ? 1 : 0, 1, 1), 
				checkCardinality("collateralisationCategory", (CollateralisationType3Code__1) o.getCollateralisationCategory() != null ? 1 : 0, 0, 1), 
				checkCardinality("portfolioContainingNonReportableComponentIndicator", (Boolean) o.getPortfolioContainingNonReportableComponentIndicator() != null ? 1 : 0, 1, 1), 
				checkCardinality("initialMarginPostedByTheReportingCounterpartyPreHaircut", (BigDecimal) o.getInitialMarginPostedByTheReportingCounterpartyPreHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginPostedByTheReportingCounterpartyPostHaircut", (BigDecimal) o.getInitialMarginPostedByTheReportingCounterpartyPostHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyOfInitialMarginPosted", (ISOCurrencyCodeEnum) o.getCurrencyOfInitialMarginPosted() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginCollectedByTheReportingCounterpartyPreHaircut", (BigDecimal) o.getInitialMarginCollectedByTheReportingCounterpartyPreHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginCollectedByTheReportingCounterpartyPostHaircut", (BigDecimal) o.getInitialMarginCollectedByTheReportingCounterpartyPostHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyOfInitialMarginCollected", (ISOCurrencyCodeEnum) o.getCurrencyOfInitialMarginCollected() != null ? 1 : 0, 0, 1), 
				checkCardinality("variationMarginPostedByTheReportingCounterpartyPreHaircut", (BigDecimal) o.getVariationMarginPostedByTheReportingCounterpartyPreHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("variationMarginPostedByTheReportingCounterpartyPostHaircut", (BigDecimal) o.getVariationMarginPostedByTheReportingCounterpartyPostHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyOfVariationMarginPosted", (ISOCurrencyCodeEnum) o.getCurrencyOfVariationMarginPosted() != null ? 1 : 0, 0, 1), 
				checkCardinality("variationMarginCollectedByTheReportingCounterpartyPreHaircut", (BigDecimal) o.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("variationMarginCollectedByTheReportingCounterpartyPostHaircut", (BigDecimal) o.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyOfVariationMarginCollected", (ISOCurrencyCodeEnum) o.getCurrencyOfVariationMarginCollected() != null ? 1 : 0, 0, 1), 
				checkCardinality("variationMarginCollateralPortfolioCode", (String) o.getVariationMarginCollateralPortfolioCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginCollateralPortfolioCode", (String) o.getInitialMarginCollateralPortfolioCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("eventTimestamp", (ZonedDateTime) o.getEventTimestamp() != null ? 1 : 0, 1, 1), 
				checkCardinality("actionType", (MarginActionEnum) o.getActionType() != null ? 1 : 0, 1, 1), 
				checkCardinality("tradeParty1IDType", (PartyIdentifierTypeEnum) o.getTradeParty1IDType() != null ? 1 : 0, 1, 1), 
				checkCardinality("submittingPartyIDType", (PartyIdentifierTypeEnum) o.getSubmittingPartyIDType() != null ? 1 : 0, 1, 1), 
				checkCardinality("usiID", (String) o.getUsiID() != null ? 1 : 0, 1, 1), 
				checkCardinality("usiIDPrefix", (String) o.getUsiIDPrefix() != null ? 1 : 0, 1, 1), 
				checkCardinality("tradeParty1ReportingDestination", (List<SupervisoryBodyEnum>) o.getTradeParty1ReportingDestination() == null ? 0 : o.getTradeParty1ReportingDestination().size(), 1, 0), 
				checkCardinality("comment1", (String) o.getComment1() != null ? 1 : 0, 1, 1), 
				checkCardinality("messageID", (String) o.getMessageID() != null ? 1 : 0, 1, 1), 
				checkCardinality("messageType", (String) o.getMessageType() != null ? 1 : 0, 1, 1), 
				checkCardinality("version", (String) o.getVersion() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSAMarginReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("CSAMarginReport", ValidationType.CARDINALITY, "CSAMarginReport", path, "", res.getError());
				}
				return success("CSAMarginReport", ValidationType.CARDINALITY, "CSAMarginReport", path, "");
			})
			.collect(toList());
	}

}
