package drr.regulation.csa.rewrite.trade;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.enrichment.common.EnrichmentData;
import drr.enrichment.common.EnrichmentData.EnrichmentDataBuilder;
import drr.enrichment.upi.AnnaDsbUpiRequestAndType;
import drr.enrichment.upi.AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder;
import drr.regulation.csa.rewrite.trade.CSANonReportable;
import drr.regulation.csa.rewrite.trade.CSANonReportable.CSANonReportableBuilder;
import drr.regulation.csa.rewrite.trade.CSANonReportable.CSANonReportableBuilderImpl;
import drr.regulation.csa.rewrite.trade.CSANonReportable.CSANonReportableImpl;
import drr.regulation.csa.rewrite.trade.meta.CSANonReportableMeta;
import drr.standards.iosco.upi.AnnaDsbInstrumentTypeEnum;
import drr.standards.iosco.upi.AnnaDsbNotionalScheduleEnum;
import drr.standards.iosco.upi.AnnaDsbUpiRecord;
import drr.standards.iosco.upi.AnnaDsbUpiRecord.AnnaDsbUpiRecordBuilder;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataType(value="CSANonReportable", builder=CSANonReportable.CSANonReportableBuilderImpl.class, version="6.0.0-dev.128")
@RuneDataType(value="CSANonReportable", model="drr", builder=CSANonReportable.CSANonReportableBuilderImpl.class, version="6.0.0-dev.128")
public interface CSANonReportable extends RosettaModelObject {

	CSANonReportableMeta metaData = new CSANonReportableMeta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Populated by pre-enrichment process
	 */
	EnrichmentData getEnrichment();
	AnnaDsbUpiRequestAndType getPreUpiData();
	AnnaDsbUpiRecord getPostUpiData();
	AnnaDsbInstrumentTypeEnum getInstrumentType();
	AnnaDsbNotionalScheduleEnum getNotionalSchedule();
	String getUnderlyingAssetType();
	String getReturnorPayoutTrigger();

	/*********************** Build Methods  ***********************/
	CSANonReportable build();
	
	CSANonReportable.CSANonReportableBuilder toBuilder();
	
	static CSANonReportable.CSANonReportableBuilder builder() {
		return new CSANonReportable.CSANonReportableBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends CSANonReportable> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends CSANonReportable> getType() {
		return CSANonReportable.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("enrichment"), processor, EnrichmentData.class, getEnrichment());
		processRosetta(path.newSubPath("preUpiData"), processor, AnnaDsbUpiRequestAndType.class, getPreUpiData());
		processRosetta(path.newSubPath("postUpiData"), processor, AnnaDsbUpiRecord.class, getPostUpiData());
		processor.processBasic(path.newSubPath("instrumentType"), AnnaDsbInstrumentTypeEnum.class, getInstrumentType(), this);
		processor.processBasic(path.newSubPath("notionalSchedule"), AnnaDsbNotionalScheduleEnum.class, getNotionalSchedule(), this);
		processor.processBasic(path.newSubPath("underlyingAssetType"), String.class, getUnderlyingAssetType(), this);
		processor.processBasic(path.newSubPath("returnorPayoutTrigger"), String.class, getReturnorPayoutTrigger(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface CSANonReportableBuilder extends CSANonReportable, RosettaModelObjectBuilder {
		EnrichmentData.EnrichmentDataBuilder getOrCreateEnrichment();
		@Override
		EnrichmentData.EnrichmentDataBuilder getEnrichment();
		AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder getOrCreatePreUpiData();
		@Override
		AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder getPreUpiData();
		AnnaDsbUpiRecord.AnnaDsbUpiRecordBuilder getOrCreatePostUpiData();
		@Override
		AnnaDsbUpiRecord.AnnaDsbUpiRecordBuilder getPostUpiData();
		CSANonReportable.CSANonReportableBuilder setEnrichment(EnrichmentData enrichment);
		CSANonReportable.CSANonReportableBuilder setPreUpiData(AnnaDsbUpiRequestAndType preUpiData);
		CSANonReportable.CSANonReportableBuilder setPostUpiData(AnnaDsbUpiRecord postUpiData);
		CSANonReportable.CSANonReportableBuilder setInstrumentType(AnnaDsbInstrumentTypeEnum instrumentType);
		CSANonReportable.CSANonReportableBuilder setNotionalSchedule(AnnaDsbNotionalScheduleEnum notionalSchedule);
		CSANonReportable.CSANonReportableBuilder setUnderlyingAssetType(String underlyingAssetType);
		CSANonReportable.CSANonReportableBuilder setReturnorPayoutTrigger(String returnorPayoutTrigger);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("enrichment"), processor, EnrichmentData.EnrichmentDataBuilder.class, getEnrichment());
			processRosetta(path.newSubPath("preUpiData"), processor, AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder.class, getPreUpiData());
			processRosetta(path.newSubPath("postUpiData"), processor, AnnaDsbUpiRecord.AnnaDsbUpiRecordBuilder.class, getPostUpiData());
			processor.processBasic(path.newSubPath("instrumentType"), AnnaDsbInstrumentTypeEnum.class, getInstrumentType(), this);
			processor.processBasic(path.newSubPath("notionalSchedule"), AnnaDsbNotionalScheduleEnum.class, getNotionalSchedule(), this);
			processor.processBasic(path.newSubPath("underlyingAssetType"), String.class, getUnderlyingAssetType(), this);
			processor.processBasic(path.newSubPath("returnorPayoutTrigger"), String.class, getReturnorPayoutTrigger(), this);
		}
		

		CSANonReportable.CSANonReportableBuilder prune();
	}

	/*********************** Immutable Implementation of CSANonReportable  ***********************/
	class CSANonReportableImpl implements CSANonReportable {
		private final EnrichmentData enrichment;
		private final AnnaDsbUpiRequestAndType preUpiData;
		private final AnnaDsbUpiRecord postUpiData;
		private final AnnaDsbInstrumentTypeEnum instrumentType;
		private final AnnaDsbNotionalScheduleEnum notionalSchedule;
		private final String underlyingAssetType;
		private final String returnorPayoutTrigger;
		
		protected CSANonReportableImpl(CSANonReportable.CSANonReportableBuilder builder) {
			this.enrichment = ofNullable(builder.getEnrichment()).map(f->f.build()).orElse(null);
			this.preUpiData = ofNullable(builder.getPreUpiData()).map(f->f.build()).orElse(null);
			this.postUpiData = ofNullable(builder.getPostUpiData()).map(f->f.build()).orElse(null);
			this.instrumentType = builder.getInstrumentType();
			this.notionalSchedule = builder.getNotionalSchedule();
			this.underlyingAssetType = builder.getUnderlyingAssetType();
			this.returnorPayoutTrigger = builder.getReturnorPayoutTrigger();
		}
		
		@Override
		@RosettaAttribute("enrichment")
		@RuneAttribute("enrichment")
		public EnrichmentData getEnrichment() {
			return enrichment;
		}
		
		@Override
		@RosettaAttribute("preUpiData")
		@RuneAttribute("preUpiData")
		public AnnaDsbUpiRequestAndType getPreUpiData() {
			return preUpiData;
		}
		
		@Override
		@RosettaAttribute("postUpiData")
		@RuneAttribute("postUpiData")
		public AnnaDsbUpiRecord getPostUpiData() {
			return postUpiData;
		}
		
		@Override
		@RosettaAttribute("instrumentType")
		@RuneAttribute("instrumentType")
		public AnnaDsbInstrumentTypeEnum getInstrumentType() {
			return instrumentType;
		}
		
		@Override
		@RosettaAttribute("notionalSchedule")
		@RuneAttribute("notionalSchedule")
		public AnnaDsbNotionalScheduleEnum getNotionalSchedule() {
			return notionalSchedule;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetType")
		@RuneAttribute("underlyingAssetType")
		public String getUnderlyingAssetType() {
			return underlyingAssetType;
		}
		
		@Override
		@RosettaAttribute("returnorPayoutTrigger")
		@RuneAttribute("returnorPayoutTrigger")
		public String getReturnorPayoutTrigger() {
			return returnorPayoutTrigger;
		}
		
		@Override
		public CSANonReportable build() {
			return this;
		}
		
		@Override
		public CSANonReportable.CSANonReportableBuilder toBuilder() {
			CSANonReportable.CSANonReportableBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(CSANonReportable.CSANonReportableBuilder builder) {
			ofNullable(getEnrichment()).ifPresent(builder::setEnrichment);
			ofNullable(getPreUpiData()).ifPresent(builder::setPreUpiData);
			ofNullable(getPostUpiData()).ifPresent(builder::setPostUpiData);
			ofNullable(getInstrumentType()).ifPresent(builder::setInstrumentType);
			ofNullable(getNotionalSchedule()).ifPresent(builder::setNotionalSchedule);
			ofNullable(getUnderlyingAssetType()).ifPresent(builder::setUnderlyingAssetType);
			ofNullable(getReturnorPayoutTrigger()).ifPresent(builder::setReturnorPayoutTrigger);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CSANonReportable _that = getType().cast(o);
		
			if (!Objects.equals(enrichment, _that.getEnrichment())) return false;
			if (!Objects.equals(preUpiData, _that.getPreUpiData())) return false;
			if (!Objects.equals(postUpiData, _that.getPostUpiData())) return false;
			if (!Objects.equals(instrumentType, _that.getInstrumentType())) return false;
			if (!Objects.equals(notionalSchedule, _that.getNotionalSchedule())) return false;
			if (!Objects.equals(underlyingAssetType, _that.getUnderlyingAssetType())) return false;
			if (!Objects.equals(returnorPayoutTrigger, _that.getReturnorPayoutTrigger())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (enrichment != null ? enrichment.hashCode() : 0);
			_result = 31 * _result + (preUpiData != null ? preUpiData.hashCode() : 0);
			_result = 31 * _result + (postUpiData != null ? postUpiData.hashCode() : 0);
			_result = 31 * _result + (instrumentType != null ? instrumentType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (notionalSchedule != null ? notionalSchedule.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (underlyingAssetType != null ? underlyingAssetType.hashCode() : 0);
			_result = 31 * _result + (returnorPayoutTrigger != null ? returnorPayoutTrigger.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CSANonReportable {" +
				"enrichment=" + this.enrichment + ", " +
				"preUpiData=" + this.preUpiData + ", " +
				"postUpiData=" + this.postUpiData + ", " +
				"instrumentType=" + this.instrumentType + ", " +
				"notionalSchedule=" + this.notionalSchedule + ", " +
				"underlyingAssetType=" + this.underlyingAssetType + ", " +
				"returnorPayoutTrigger=" + this.returnorPayoutTrigger +
			'}';
		}
	}

	/*********************** Builder Implementation of CSANonReportable  ***********************/
	class CSANonReportableBuilderImpl implements CSANonReportable.CSANonReportableBuilder {
	
		protected EnrichmentData.EnrichmentDataBuilder enrichment;
		protected AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder preUpiData;
		protected AnnaDsbUpiRecord.AnnaDsbUpiRecordBuilder postUpiData;
		protected AnnaDsbInstrumentTypeEnum instrumentType;
		protected AnnaDsbNotionalScheduleEnum notionalSchedule;
		protected String underlyingAssetType;
		protected String returnorPayoutTrigger;
		
		@Override
		@RosettaAttribute("enrichment")
		@RuneAttribute("enrichment")
		public EnrichmentData.EnrichmentDataBuilder getEnrichment() {
			return enrichment;
		}
		
		@Override
		public EnrichmentData.EnrichmentDataBuilder getOrCreateEnrichment() {
			EnrichmentData.EnrichmentDataBuilder result;
			if (enrichment!=null) {
				result = enrichment;
			}
			else {
				result = enrichment = EnrichmentData.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("preUpiData")
		@RuneAttribute("preUpiData")
		public AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder getPreUpiData() {
			return preUpiData;
		}
		
		@Override
		public AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder getOrCreatePreUpiData() {
			AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder result;
			if (preUpiData!=null) {
				result = preUpiData;
			}
			else {
				result = preUpiData = AnnaDsbUpiRequestAndType.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("postUpiData")
		@RuneAttribute("postUpiData")
		public AnnaDsbUpiRecord.AnnaDsbUpiRecordBuilder getPostUpiData() {
			return postUpiData;
		}
		
		@Override
		public AnnaDsbUpiRecord.AnnaDsbUpiRecordBuilder getOrCreatePostUpiData() {
			AnnaDsbUpiRecord.AnnaDsbUpiRecordBuilder result;
			if (postUpiData!=null) {
				result = postUpiData;
			}
			else {
				result = postUpiData = AnnaDsbUpiRecord.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("instrumentType")
		@RuneAttribute("instrumentType")
		public AnnaDsbInstrumentTypeEnum getInstrumentType() {
			return instrumentType;
		}
		
		@Override
		@RosettaAttribute("notionalSchedule")
		@RuneAttribute("notionalSchedule")
		public AnnaDsbNotionalScheduleEnum getNotionalSchedule() {
			return notionalSchedule;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetType")
		@RuneAttribute("underlyingAssetType")
		public String getUnderlyingAssetType() {
			return underlyingAssetType;
		}
		
		@Override
		@RosettaAttribute("returnorPayoutTrigger")
		@RuneAttribute("returnorPayoutTrigger")
		public String getReturnorPayoutTrigger() {
			return returnorPayoutTrigger;
		}
		
		@Override
		@RosettaAttribute("enrichment")
		@RuneAttribute("enrichment")
		public CSANonReportable.CSANonReportableBuilder setEnrichment(EnrichmentData _enrichment) {
			this.enrichment = _enrichment == null ? null : _enrichment.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("preUpiData")
		@RuneAttribute("preUpiData")
		public CSANonReportable.CSANonReportableBuilder setPreUpiData(AnnaDsbUpiRequestAndType _preUpiData) {
			this.preUpiData = _preUpiData == null ? null : _preUpiData.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("postUpiData")
		@RuneAttribute("postUpiData")
		public CSANonReportable.CSANonReportableBuilder setPostUpiData(AnnaDsbUpiRecord _postUpiData) {
			this.postUpiData = _postUpiData == null ? null : _postUpiData.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("instrumentType")
		@RuneAttribute("instrumentType")
		public CSANonReportable.CSANonReportableBuilder setInstrumentType(AnnaDsbInstrumentTypeEnum _instrumentType) {
			this.instrumentType = _instrumentType == null ? null : _instrumentType;
			return this;
		}
		
		@Override
		@RosettaAttribute("notionalSchedule")
		@RuneAttribute("notionalSchedule")
		public CSANonReportable.CSANonReportableBuilder setNotionalSchedule(AnnaDsbNotionalScheduleEnum _notionalSchedule) {
			this.notionalSchedule = _notionalSchedule == null ? null : _notionalSchedule;
			return this;
		}
		
		@Override
		@RosettaAttribute("underlyingAssetType")
		@RuneAttribute("underlyingAssetType")
		public CSANonReportable.CSANonReportableBuilder setUnderlyingAssetType(String _underlyingAssetType) {
			this.underlyingAssetType = _underlyingAssetType == null ? null : _underlyingAssetType;
			return this;
		}
		
		@Override
		@RosettaAttribute("returnorPayoutTrigger")
		@RuneAttribute("returnorPayoutTrigger")
		public CSANonReportable.CSANonReportableBuilder setReturnorPayoutTrigger(String _returnorPayoutTrigger) {
			this.returnorPayoutTrigger = _returnorPayoutTrigger == null ? null : _returnorPayoutTrigger;
			return this;
		}
		
		@Override
		public CSANonReportable build() {
			return new CSANonReportable.CSANonReportableImpl(this);
		}
		
		@Override
		public CSANonReportable.CSANonReportableBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CSANonReportable.CSANonReportableBuilder prune() {
			if (enrichment!=null && !enrichment.prune().hasData()) enrichment = null;
			if (preUpiData!=null && !preUpiData.prune().hasData()) preUpiData = null;
			if (postUpiData!=null && !postUpiData.prune().hasData()) postUpiData = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getEnrichment()!=null && getEnrichment().hasData()) return true;
			if (getPreUpiData()!=null && getPreUpiData().hasData()) return true;
			if (getPostUpiData()!=null && getPostUpiData().hasData()) return true;
			if (getInstrumentType()!=null) return true;
			if (getNotionalSchedule()!=null) return true;
			if (getUnderlyingAssetType()!=null) return true;
			if (getReturnorPayoutTrigger()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CSANonReportable.CSANonReportableBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			CSANonReportable.CSANonReportableBuilder o = (CSANonReportable.CSANonReportableBuilder) other;
			
			merger.mergeRosetta(getEnrichment(), o.getEnrichment(), this::setEnrichment);
			merger.mergeRosetta(getPreUpiData(), o.getPreUpiData(), this::setPreUpiData);
			merger.mergeRosetta(getPostUpiData(), o.getPostUpiData(), this::setPostUpiData);
			
			merger.mergeBasic(getInstrumentType(), o.getInstrumentType(), this::setInstrumentType);
			merger.mergeBasic(getNotionalSchedule(), o.getNotionalSchedule(), this::setNotionalSchedule);
			merger.mergeBasic(getUnderlyingAssetType(), o.getUnderlyingAssetType(), this::setUnderlyingAssetType);
			merger.mergeBasic(getReturnorPayoutTrigger(), o.getReturnorPayoutTrigger(), this::setReturnorPayoutTrigger);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CSANonReportable _that = getType().cast(o);
		
			if (!Objects.equals(enrichment, _that.getEnrichment())) return false;
			if (!Objects.equals(preUpiData, _that.getPreUpiData())) return false;
			if (!Objects.equals(postUpiData, _that.getPostUpiData())) return false;
			if (!Objects.equals(instrumentType, _that.getInstrumentType())) return false;
			if (!Objects.equals(notionalSchedule, _that.getNotionalSchedule())) return false;
			if (!Objects.equals(underlyingAssetType, _that.getUnderlyingAssetType())) return false;
			if (!Objects.equals(returnorPayoutTrigger, _that.getReturnorPayoutTrigger())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (enrichment != null ? enrichment.hashCode() : 0);
			_result = 31 * _result + (preUpiData != null ? preUpiData.hashCode() : 0);
			_result = 31 * _result + (postUpiData != null ? postUpiData.hashCode() : 0);
			_result = 31 * _result + (instrumentType != null ? instrumentType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (notionalSchedule != null ? notionalSchedule.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (underlyingAssetType != null ? underlyingAssetType.hashCode() : 0);
			_result = 31 * _result + (returnorPayoutTrigger != null ? returnorPayoutTrigger.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CSANonReportableBuilder {" +
				"enrichment=" + this.enrichment + ", " +
				"preUpiData=" + this.preUpiData + ", " +
				"postUpiData=" + this.postUpiData + ", " +
				"instrumentType=" + this.instrumentType + ", " +
				"notionalSchedule=" + this.notionalSchedule + ", " +
				"underlyingAssetType=" + this.underlyingAssetType + ", " +
				"returnorPayoutTrigger=" + this.returnorPayoutTrigger +
			'}';
		}
	}
}
